/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.common.collect.Lists;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.core.ChromaColour;
import io.github.moulberry.notenoughupdates.core.GlScissorStack;
import io.github.moulberry.notenoughupdates.core.GuiElement;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.miscfeatures.AhBzKeybind;
import io.github.moulberry.notenoughupdates.miscfeatures.BetterContainers;
import io.github.moulberry.notenoughupdates.miscfeatures.SlotLocking;
import io.github.moulberry.notenoughupdates.miscfeatures.StorageManager;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Vector2f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class StorageOverlay
extends GuiElement {
    public static final ResourceLocation[] STORAGE_PREVIEW_TEXTURES;
    private static final ResourceLocation[] STORAGE_TEXTURES;
    private static final ResourceLocation STORAGE_ICONS_TEXTURE;
    private static final ResourceLocation STORAGE_PANE_CTM_TEXTURE;
    private static final ResourceLocation[] NOT_RICKROLL_SEQ;
    private static final StorageOverlay INSTANCE;
    private static final String CHROMA_STR = "230:255:255:0:0";
    private static final ResourceLocation RES_ITEM_GLINT;
    private static final NEUManager manager;
    private final Set<Vector2f> enchantGlintRenderLocations = new HashSet<Vector2f>();
    private final GuiElementTextField searchBar = new GuiElementTextField("", 88, 10, 96);
    private final GuiElementTextField renameStorageField = new GuiElementTextField("", 100, 13, 2);
    private final int[][] isPaneCaches = new int[40][];
    private final int[][] ctmIndexCaches = new int[40][];
    private final LerpingInteger scroll = new LerpingInteger(0, 200);
    private Framebuffer framebuffer = null;
    private int editingNameId = -1;
    private int guiLeft;
    private int guiTop;
    private boolean fastRender = false;
    private int rollIndex = 0;
    private long millisAccumRoll = 0L;
    private long lastMillis = 0L;
    private int scrollVelocity = 0;
    private long lastScroll = 0L;
    private int desiredHeightSwitch = -1;
    private int desiredHeightMX = -1;
    private int desiredHeightMY = -1;
    private boolean dirty = false;
    private boolean allowTypingInSearchBar = true;
    private int scrollGrabOffset = -1;

    public static StorageOverlay getInstance() {
        return INSTANCE;
    }

    private static boolean shouldConnect(int paneIndex1, int paneIndex2) {
        if (paneIndex1 == 16 || paneIndex2 == 16) {
            return false;
        }
        if (paneIndex1 < 1 || paneIndex2 < 1) {
            return false;
        }
        return paneIndex1 == paneIndex2;
    }

    public static int getCTMIndex(StorageManager.StoragePage page, int index, int[] isPaneCache, int[] ctmIndexCache) {
        int ctmIndex;
        if (page.items[index] == null) {
            ctmIndexCache[index] = -1;
            return -1;
        }
        int paneType = StorageOverlay.getPaneType(page.items[index], index, isPaneCache);
        int upIndex = index - 9;
        int leftIndex = index % 9 > 0 ? index - 1 : -1;
        int rightIndex = index % 9 < 8 ? index + 1 : -1;
        int downIndex = index + 9;
        int upleftIndex = index % 9 > 0 ? index - 10 : -1;
        int uprightIndex = index % 9 < 8 ? index - 8 : -1;
        int downleftIndex = index % 9 > 0 ? index + 8 : -1;
        int downrightIndex = index % 9 < 8 ? index + 10 : -1;
        boolean up = upIndex >= 0 && upIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[upIndex], upIndex, isPaneCache), paneType);
        boolean left = leftIndex >= 0 && leftIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[leftIndex], leftIndex, isPaneCache), paneType);
        boolean down = downIndex >= 0 && downIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[downIndex], downIndex, isPaneCache), paneType);
        boolean right = rightIndex >= 0 && rightIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[rightIndex], rightIndex, isPaneCache), paneType);
        boolean upleft = upleftIndex >= 0 && upleftIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[upleftIndex], upleftIndex, isPaneCache), paneType);
        boolean upright = uprightIndex >= 0 && uprightIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[uprightIndex], uprightIndex, isPaneCache), paneType);
        boolean downleft = downleftIndex >= 0 && downleftIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[downleftIndex], downleftIndex, isPaneCache), paneType);
        boolean downright = downrightIndex >= 0 && downrightIndex < isPaneCache.length && StorageOverlay.shouldConnect(StorageOverlay.getPaneType(page.items[downrightIndex], downrightIndex, isPaneCache), paneType);
        ctmIndexCache[index] = ctmIndex = BetterContainers.getCTMIndex(up, right, down, left, upleft, upright, downright, downleft);
        return ctmIndex;
    }

    public static int getRGBFromPane(int paneType) {
        int rgb = -1;
        EnumChatFormatting formatting = EnumChatFormatting.WHITE;
        switch (paneType) {
            case 0: {
                formatting = EnumChatFormatting.WHITE;
                break;
            }
            case 1: {
                formatting = EnumChatFormatting.GOLD;
                break;
            }
            case 2: {
                formatting = EnumChatFormatting.LIGHT_PURPLE;
                break;
            }
            case 3: {
                formatting = EnumChatFormatting.BLUE;
                break;
            }
            case 4: {
                formatting = EnumChatFormatting.YELLOW;
                break;
            }
            case 5: {
                formatting = EnumChatFormatting.GREEN;
                break;
            }
            case 6: {
                rgb = -1033066;
                break;
            }
            case 7: {
                formatting = EnumChatFormatting.DARK_GRAY;
                break;
            }
            case 8: {
                formatting = EnumChatFormatting.GRAY;
                break;
            }
            case 9: {
                formatting = EnumChatFormatting.DARK_AQUA;
                break;
            }
            case 10: {
                formatting = EnumChatFormatting.DARK_PURPLE;
                break;
            }
            case 11: {
                formatting = EnumChatFormatting.DARK_BLUE;
                break;
            }
            case 12: {
                rgb = -6270419;
                break;
            }
            case 13: {
                formatting = EnumChatFormatting.DARK_GREEN;
                break;
            }
            case 14: {
                formatting = EnumChatFormatting.DARK_RED;
                break;
            }
            case 15: {
                rgb = 0;
                break;
            }
            case 16: {
                rgb = SpecialColour.specialToChromaRGB(CHROMA_STR);
            }
        }
        if (rgb != -1) {
            return rgb;
        }
        return 0xFF000000 | Minecraft.func_71410_x().field_71466_p.func_175064_b(formatting.toString().charAt(1));
    }

    public static int getPaneType(ItemStack stack, int index, int[] cache) {
        String internalName;
        if (cache != null && cache[index] != 0) {
            return cache[index];
        }
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes == 2) {
            if (cache != null) {
                cache[index] = -1;
            }
            return -1;
        }
        if (stack != null && (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150410_aZ)) && (internalName = manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName()) != null) {
            if (internalName.startsWith("STAINED_GLASS_PANE")) {
                if (cache != null) {
                    cache[index] = stack.func_77952_i() + 1;
                }
                return stack.func_77952_i() + 1;
            }
            if (internalName.startsWith("THIN_GLASS")) {
                if (cache != null) {
                    cache[index] = 17;
                }
                return 17;
            }
        }
        if (cache != null) {
            cache[index] = -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaximumScroll() {
        HashMap<Integer, Integer> hashMap = StorageManager.getInstance().storageConfig.displayToStorageIdMapRender;
        synchronized (hashMap) {
            int maxH = 0;
            for (int i = 0; i < 3; ++i) {
                int lastDisplayId = StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.size() - 1;
                int coords = (int)Math.ceil((float)lastDisplayId / 3.0f) * 3 + 1 + i;
                int h = this.getPageCoords((int)coords).y + this.scroll.getValue() - this.getStorageViewSize() - 14;
                if (h <= maxH) continue;
                maxH = h;
            }
            return maxH;
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void scrollToY(int y) {
        int maxY;
        int target = y;
        if (target < 0) {
            target = 0;
        }
        if (target > (maxY = this.getMaximumScroll())) {
            target = maxY;
        }
        float factor = (float)(this.scroll.getValue() - target) / (float)((double)(this.scroll.getValue() - y) + 1.0E-5);
        this.scroll.setTarget(target);
        this.scroll.setTimeToReachTarget(Math.min(200, Math.max(20, (int)(200.0f * factor))));
        this.scroll.resetTimer();
    }

    public void scrollToStorage(int displayId, boolean forceScroll) {
        if (displayId < 0) {
            return;
        }
        int y = this.getPageCoords((int)displayId).y - 17;
        if (y < 3) {
            this.scrollToY(y + this.scroll.getValue());
        } else {
            int storageViewSize = this.getStorageViewSize();
            int y2 = this.getPageCoords((int)(displayId + 3)).y - 17 - storageViewSize;
            if (y2 > 3) {
                if (forceScroll) {
                    this.scrollToY(y + this.scroll.getValue());
                } else {
                    this.scrollToY(y2 + this.scroll.getValue());
                }
            }
        }
    }

    private int getStorageViewSize() {
        return NotEnoughUpdates.INSTANCE.config.storageGUI.storageHeight;
    }

    private int getScrollBarHeight() {
        return this.getStorageViewSize() - 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        int itemX;
        int i;
        int rows;
        StorageManager.StoragePage page;
        int storageY;
        int storageX;
        IntPair coords;
        int storageId;
        int displayId;
        String stackDisplay;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest containerChest = (ContainerChest)guiChest.field_147002_h;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.scroll.tick();
        int displayStyle = NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle;
        ResourceLocation storageTexture = STORAGE_TEXTURES[displayStyle];
        ResourceLocation storagePreviewTexture = STORAGE_PREVIEW_TEXTURES[displayStyle];
        int textColour = 0x404040;
        int searchTextColour = 0xE0E0E0;
        if (displayStyle == 2) {
            textColour = 0;
            searchTextColour = 0xA0A0A0;
        } else if (displayStyle == 3) {
            textColour = 16501868;
        } else if (displayStyle == 0) {
            textColour = 0x909090;
            searchTextColour = 0xA0A0A0;
        }
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.useCustomTextColour) {
            textColour = ChromaColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.storageGUI.customTextColour);
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastMillis > 0L) {
            long deltaTime = currentTime - this.lastMillis;
            this.millisAccumRoll += deltaTime;
            this.rollIndex = (int)((long)this.rollIndex + this.millisAccumRoll / 100L);
            this.millisAccumRoll %= 100L;
        }
        this.lastMillis = currentTime;
        this.rollIndex %= NOT_RICKROLL_SEQ.length * 2;
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (stackOnMouse != null && ((stackDisplay = Utils.cleanColour(stackOnMouse.func_82833_r())).startsWith("Backpack Slot ") || stackDisplay.startsWith("Empty Backpack Slot ") || stackDisplay.startsWith("Ender Chest Page ") || stackDisplay.startsWith("Locked Backpack Slot "))) {
            stackOnMouse = null;
        }
        List<Object> tooltipToDisplay = null;
        int slotPreview = -1;
        int storageViewSize = this.getStorageViewSize();
        int sizeX = 540;
        int sizeY = 100 + storageViewSize;
        int searchNobX = 18;
        int itemHoverX = -1;
        int itemHoverY = -1;
        this.guiLeft = width / 2 - (sizeX - searchNobX) / 2;
        this.guiTop = height / 2 - sizeY / 2;
        if (displayStyle == 0) {
            BackgroundBlur.renderBlurredBackground(7.0f, width, height, this.guiLeft, this.guiTop, sizeX, storageViewSize);
            BackgroundBlur.renderBlurredBackground(7.0f, width, height, this.guiLeft + 5, this.guiTop + storageViewSize, sizeX - searchNobX - 10, sizeY - storageViewSize - 4);
        }
        Utils.drawGradientRect(0, 0, width, height, -1072689136, -804253680);
        GL11.glPushMatrix();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        boolean hoveringOtherBackpack = false;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(storageTexture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(0.0f, 0.0f, sizeX, 10.0f, 0.0f, (float)sizeX / 600.0f, 0.0f, 0.025f, 9728);
        Utils.drawTexturedRect(0.0f, 10.0f, sizeX, storageViewSize - 20, 0.0f, (float)sizeX / 600.0f, 0.025f, 0.235f, 9728);
        Utils.drawTexturedRect(0.0f, storageViewSize - 10, sizeX, 110.0f, 0.0f, (float)sizeX / 600.0f, 0.235f, 0.51f, 9728);
        int maxScroll = this.getMaximumScroll();
        if (this.scroll.getValue() > maxScroll) {
            this.scroll.setValue(maxScroll);
        }
        if (this.scroll.getValue() < 0) {
            this.scroll.setValue(0);
        }
        int scrollBarY = Math.round((float)(this.getScrollBarHeight() * this.scroll.getValue()) / (float)maxScroll);
        float uMin = this.scrollGrabOffset >= 0 ? 0.02f : 0.0f;
        Utils.drawTexturedRect(520.0f, 8 + scrollBarY, 12.0f, 15.0f, uMin, uMin + 0.02f, 0.625f, 0.6625f, 9728);
        int currentPage = StorageManager.getInstance().getCurrentPageId();
        boolean mouseInsideStorages = mouseY > this.guiTop + 3 && mouseY < this.guiTop + 3 + storageViewSize;
        boolean doItemRender = true;
        boolean doRenderFramebuffer = false;
        int startY = this.getPageCoords((int)0).y;
        if (OpenGlHelper.func_148822_b()) {
            int h;
            HashMap<Integer, Integer> hashMap = StorageManager.getInstance().storageConfig.displayToStorageIdMapRender;
            synchronized (hashMap) {
                int lastDisplayId = StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.size() - 1;
                int coords2 = (int)Math.ceil((float)lastDisplayId / 3.0f) * 3 + 3;
                h = this.getPageCoords((int)coords2).y + this.scroll.getValue();
            }
            int w = sizeX;
            if (this.framebuffer != null) {
                GlScissorStack.push(0, this.guiTop + 3, width, this.guiTop + 3 + storageViewSize, scaledResolution);
                GlStateManager.func_179126_j();
                GlStateManager.func_179109_b((float)0.0f, (float)startY, (float)107.0001f);
                this.framebuffer.func_147612_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                Utils.drawTexturedRect(0.0f, 0.0f, w, h, 0.0f, 1.0f, 1.0f, 0.0f, 9728);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                this.renderEnchOverlay(this.enchantGlintRenderLocations);
                GlStateManager.func_179109_b((float)0.0f, (float)(-startY), (float)-107.0001f);
                GlScissorStack.pop(scaledResolution);
            }
            if (this.dirty || this.framebuffer == null) {
                this.dirty = false;
                int fw = w * scaledResolution.func_78325_e();
                int fh = h * scaledResolution.func_78325_e();
                if (this.framebuffer == null) {
                    this.framebuffer = new Framebuffer(fw, fh, true);
                } else if (this.framebuffer.field_147621_c != fw || this.framebuffer.field_147618_d != fh) {
                    this.framebuffer.func_147613_a(fw, fh);
                }
                this.framebuffer.func_147614_f();
                this.framebuffer.func_147610_a(true);
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179096_D();
                GlStateManager.func_179130_a((double)0.0, (double)w, (double)h, (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-this.guiLeft), (float)(-this.guiTop - startY), (float)0.0f);
                doRenderFramebuffer = true;
            } else {
                doItemRender = false;
            }
        }
        if (doItemRender) {
            this.enchantGlintRenderLocations.clear();
            for (Map.Entry<Integer, Integer> entry : StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.entrySet()) {
                displayId = entry.getKey();
                storageId = entry.getValue();
                coords = this.getPageCoords(displayId);
                storageX = coords.x;
                storageY = coords.y;
                if (!doRenderFramebuffer && (coords.y - 11 > 3 + storageViewSize || coords.y + 90 < 3) || (page = StorageManager.getInstance().getPage(storageId, false)) == null || page.rows <= 0) continue;
                rows = page.rows;
                this.isPaneCaches[storageId] = new int[page.rows * 9];
                this.ctmIndexCaches[storageId] = new int[page.rows * 9];
                int[] nArray = this.isPaneCaches[storageId];
                int[] ctmIndexCache = this.ctmIndexCaches[storageId];
                for (int k = 0; k < rows * 9; ++k) {
                    int paneType;
                    ItemStack stack = storageId == currentPage ? containerChest.func_75139_a(k + 9).func_75211_c() : page.items[k];
                    int itemX2 = storageX + 1 + 18 * (k % 9);
                    int itemY = storageY + 1 + 18 * (k / 9);
                    if (stack != null && (paneType = StorageOverlay.getPaneType(stack, k, nArray)) > 0) {
                        GlStateManager.func_179118_c();
                        Gui.func_73734_a((int)(itemX2 - 1), (int)(itemY - 1), (int)(itemX2 + 17), (int)(itemY + 17), (int)0x1000000);
                        GlStateManager.func_179141_d();
                        int ctmIndex = StorageOverlay.getCTMIndex(page, k, nArray, ctmIndexCache);
                        int startCTMX = ctmIndex % 12 * 19;
                        int startCTMY = ctmIndex / 12 * 19;
                        ctmIndexCache[k] = ctmIndex;
                        if (paneType != 17) {
                            int rgb = StorageOverlay.getRGBFromPane(paneType - 1);
                            int a = rgb >> 24 & 0xFF;
                            int r = rgb >> 16 & 0xFF;
                            int g = rgb >> 8 & 0xFF;
                            int b = rgb & 0xFF;
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(STORAGE_PANE_CTM_TEXTURE);
                            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                            Utils.drawTexturedRect(itemX2 - 1, itemY - 1, 18.0f, 18.0f, (float)startCTMX / 227.0f, (float)(startCTMX + 18) / 227.0f, (float)startCTMY / 75.0f, (float)(startCTMY + 18) / 75.0f, 9728);
                            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
                            itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, itemX2, itemY, null);
                            GlStateManager.func_179140_f();
                        }
                        page.shouldDarkenIfNotSelected[k] = false;
                        continue;
                    }
                    page.shouldDarkenIfNotSelected[k] = true;
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)20.0f);
                    if (doRenderFramebuffer) {
                        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                        GL14.glBlendFuncSeparate((int)1, (int)0, (int)1, (int)0);
                        if (storageId == currentPage) {
                            Utils.hasEffectOverride = true;
                            GlStateManager.func_179109_b((float)(storageX - 7), (float)(storageY - 17 - 18), (float)0.0f);
                            ((AccessorGuiContainer)guiChest).doDrawSlot(containerChest.func_75139_a(k + 9));
                            GlStateManager.func_179109_b((float)(-storageX + 7), (float)(-storageY + 17 + 18), (float)0.0f);
                            Utils.hasEffectOverride = false;
                        } else {
                            Utils.drawItemStackWithoutGlint(stack, itemX2, itemY);
                        }
                        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                        if (stack != null && (stack.func_77962_s() || stack.func_77973_b() == Items.field_151134_bR)) {
                            this.enchantGlintRenderLocations.add(new Vector2f((float)itemX2, (float)(itemY - startY)));
                        }
                    } else if (storageId == currentPage) {
                        Utils.hasEffectOverride = true;
                        GlStateManager.func_179109_b((float)(storageX - 7), (float)(storageY - 17 - 18), (float)0.0f);
                        ((AccessorGuiContainer)guiChest).doDrawSlot(containerChest.func_75139_a(k + 9));
                        GlStateManager.func_179109_b((float)(-storageX + 7), (float)(-storageY + 17 + 18), (float)0.0f);
                        Utils.hasEffectOverride = false;
                    } else {
                        Utils.drawItemStack(stack, itemX2, itemY);
                    }
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-20.0f);
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179126_j();
            }
        }
        if (OpenGlHelper.func_148822_b() && doRenderFramebuffer) {
            GlStateManager.func_179121_F();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
        }
        GlScissorStack.push(0, this.guiTop + 3, width, this.guiTop + 3 + storageViewSize, scaledResolution);
        for (Map.Entry<Integer, Integer> entry : StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.entrySet()) {
            int h;
            int n;
            displayId = entry.getKey();
            storageId = entry.getValue();
            coords = this.getPageCoords(displayId);
            storageX = coords.x;
            storageY = coords.y;
            if (coords.y - 11 > 3 + storageViewSize || coords.y + 90 < 3) continue;
            page = StorageManager.getInstance().getPage(storageId, false);
            if (this.editingNameId == storageId) {
                int len2 = fontRendererObj.func_78256_a(this.renameStorageField.getTextDisplay()) + 10;
                this.renameStorageField.setSize(len2, 12);
                this.renameStorageField.render(storageX, storageY - 13);
            } else {
                String pageTitle = page != null && page.customTitle != null && !page.customTitle.isEmpty() ? Utils.chromaStringByColourCode(page.customTitle) : (entry.getValue() < 9 ? "Ender Chest Page " + (entry.getValue() + 1) : "Backpack Slot " + (storageId - 8));
                n = fontRendererObj.func_78256_a(pageTitle);
                if (mouseX >= this.guiLeft + storageX && mouseX <= this.guiLeft + storageX + n + 15 && mouseY >= this.guiTop + storageY - 14 && mouseY <= this.guiTop + storageY + 1) {
                    pageTitle = pageTitle + " \u270e";
                }
                fontRendererObj.func_78276_b(pageTitle, storageX, storageY - 11, textColour);
            }
            if (page == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(storageTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                h = 54;
                Utils.drawTexturedRect(storageX, storageY, 162.0f, h, 0.0f, 0.27f, 0.6625f, (float)(265 + h) / 400.0f, 9728);
                Gui.func_73734_a((int)storageX, (int)storageY, (int)(storageX + 162), (int)(storageY + h), (int)Integer.MIN_VALUE);
                if (storageId < 9) {
                    Utils.drawStringCenteredScaledMaxWidth("Locked Page", storageX + 81, storageY + h / 2, true, 150, 14240768);
                    continue;
                }
                Utils.drawStringCenteredScaledMaxWidth("Empty Backpack Slot", storageX + 81, storageY + h / 2, true, 150, 14240768);
                continue;
            }
            if (page.rows <= 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(storageTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                h = 54;
                Utils.drawTexturedRect(storageX, storageY, 162.0f, h, 0.0f, 0.27f, 0.6625f, (float)(265 + h) / 400.0f, 9728);
                Gui.func_73734_a((int)storageX, (int)storageY, (int)(storageX + 162), (int)(storageY + h), (int)Integer.MIN_VALUE);
                Utils.drawStringCenteredScaledMaxWidth("Click to load items", storageX + 81, storageY + h / 2, true, 150, 0xFFDF00);
                continue;
            }
            rows = page.rows;
            n = 162;
            int storageH = 18 * rows;
            GlStateManager.func_179126_j();
            boolean[] shouldLimitBorder = new boolean[rows * 9];
            boolean hasCaches = this.isPaneCaches[storageId] != null && this.isPaneCaches[storageId].length == rows * 9 && this.ctmIndexCaches[storageId] != null && this.ctmIndexCaches[storageId].length == rows * 9;
            int fancyPaneValue = NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes;
            if (fancyPaneValue == 0 || fancyPaneValue == 1) {
                for (int k = 0; k < rows * 9; ++k) {
                    ItemStack stack = page.items[k];
                    if (stack == null || !hasCaches) continue;
                    int itemX3 = storageX + 1 + 18 * (k % 9);
                    int itemY = storageY + 1 + 18 * (k / 9);
                    int[] isPaneCache = this.isPaneCaches[storageId];
                    int[] ctmIndexCache = this.ctmIndexCaches[storageId];
                    if (isPaneCache[k] == 17) {
                        int ctmIndex = StorageOverlay.getCTMIndex(page, k, isPaneCache, ctmIndexCache);
                        int startCTMX = ctmIndex % 12 * 19;
                        int startCTMY = ctmIndex / 12 * 19;
                        int rgb = StorageOverlay.getRGBFromPane(isPaneCache[k] - 1);
                        int a = rgb >> 24 & 0xFF;
                        int r = rgb >> 16 & 0xFF;
                        int g = rgb >> 8 & 0xFF;
                        int b = rgb & 0xFF;
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(STORAGE_PANE_CTM_TEXTURE);
                        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)110.0f);
                        Utils.drawTexturedRect(itemX3 - 1, itemY - 1, 18.0f, 18.0f, (float)startCTMX / 227.0f, (float)(startCTMX + 18) / 227.0f, (float)startCTMY / 75.0f, (float)(startCTMY + 18) / 75.0f, 9728);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-110.0f);
                        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
                        itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, itemX3, itemY, null);
                        GlStateManager.func_179126_j();
                        continue;
                    }
                    if (isPaneCache[k] >= 0) continue;
                    boolean hasConnection = false;
                    int upIndex = k - 9;
                    int leftIndex = k % 9 > 0 ? k - 1 : -1;
                    int rightIndex = k % 9 < 8 ? k + 1 : -1;
                    int downIndex = k + 9;
                    int[] indexArr = new int[]{rightIndex, downIndex, leftIndex, upIndex};
                    for (int j = 0; j < 4; ++j) {
                        boolean vertical;
                        int ctmIndex;
                        int type2;
                        int index = indexArr[j];
                        int n2 = type2 = index >= 0 && index < isPaneCache.length ? StorageOverlay.getPaneType(page.items[index], index, isPaneCache) : -1;
                        if (type2 <= 0 || (ctmIndex = StorageOverlay.getCTMIndex(page, index, isPaneCache, ctmIndexCache)) < 0) continue;
                        boolean horizontal = ctmIndex == 1 || ctmIndex == 2 || ctmIndex == 3;
                        boolean bl = vertical = ctmIndex == 12 || ctmIndex == 24 || ctmIndex == 36;
                        boolean renderConnection = k % 9 == 0 && index % 9 == 0 || k % 9 == 8 && index % 9 == 8 ? horizontal || vertical : (index == leftIndex || index == rightIndex ? horizontal : vertical);
                        if (!renderConnection) continue;
                        shouldLimitBorder[k] = true;
                        hasConnection = true;
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(STORAGE_PANE_CTM_TEXTURE);
                        int rgb = StorageOverlay.getRGBFromPane(type2 - 1);
                        int a = rgb >> 24 & 0xFF;
                        int r = rgb >> 16 & 0xFF;
                        int g = rgb >> 8 & 0xFF;
                        int b = rgb & 0xFF;
                        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)(itemX3 - 1 + 9), (float)(itemY - 1 + 9), (float)10.0f);
                        GlStateManager.func_179114_b((float)(j * 90), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179141_d();
                        GlStateManager.func_179140_f();
                        boolean horzFlip = false;
                        boolean vertFlip = false;
                        if (index == leftIndex) {
                            vertFlip = true;
                        } else if (index == downIndex) {
                            vertFlip = true;
                        }
                        GlStateManager.func_179126_j();
                        Utils.drawTexturedRect(0.0f, -9.0f, 8.0f, 18.0f, !horzFlip ? 0.92070484f : 0.9647577f, horzFlip ? 1.0f : 0.95594716f, !vertFlip ? 0.76f : 1.0f, vertFlip ? 0.76f : 1.0f, 9728);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)120.0f);
                        Utils.drawTexturedRect(8.0f, -9.0f, 10.0f, 18.0f, !horzFlip ? 0.95594716f : 0.92070484f, horzFlip ? 0.9647577f : 1.0f, !vertFlip ? 0.76f : 1.0f, vertFlip ? 0.76f : 1.0f, 9728);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-120.0f);
                        GlStateManager.func_179121_F();
                    }
                    if (!hasConnection) continue;
                    page.shouldDarkenIfNotSelected[k] = false;
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
                    Gui.func_73734_a((int)(itemX3 - 1), (int)(itemY - 1), (int)(itemX3 + 17), (int)(itemY + 17), (int)0x1000000);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
                    GlStateManager.func_179141_d();
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(storageTexture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(storageX, storageY, n, storageH, 0.0f, 0.27f, 0.6625f, (float)(265 + storageH) / 400.0f, 9728);
            boolean whiteOverlay = false;
            for (int k = 0; k < rows * 9; ++k) {
                boolean allowHover;
                ItemStack stack = page.items[k];
                int itemX4 = storageX + 1 + 18 * (k % 9);
                int itemY = storageY + 1 + 18 * (k / 9);
                if (!(this.searchBar.getText().isEmpty() || stack != null && manager.doesStackMatchSearch(stack, this.searchBar.getText()))) {
                    GlStateManager.func_179097_i();
                    Gui.func_73734_a((int)itemX4, (int)itemY, (int)(itemX4 + 16), (int)(itemY + 16), (int)Integer.MIN_VALUE);
                    GlStateManager.func_179126_j();
                }
                GlStateManager.func_179140_f();
                if (!mouseInsideStorages || mouseX < this.guiLeft + itemX4 || mouseX >= this.guiLeft + itemX4 + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                boolean bl = allowHover = fancyPaneValue != 1 && fancyPaneValue != 4 || !hasCaches || this.isPaneCaches[storageId][k] <= 0;
                if (storageId != StorageManager.getInstance().getCurrentPageId()) {
                    hoveringOtherBackpack = true;
                    whiteOverlay = stackOnMouse == null;
                } else if (stack == null || allowHover) {
                    itemHoverX = itemX4;
                    itemHoverY = itemY;
                }
                if (stack == null || !allowHover) continue;
                tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            GlStateManager.func_179097_i();
            if (storageId == currentPage) {
                if (this.isPaneCaches[storageId] != null && this.isPaneCaches[storageId].length == rows * 9 && this.ctmIndexCaches[storageId] != null && this.ctmIndexCaches[storageId].length == rows * 9) {
                    int x;
                    int index;
                    int y;
                    int[] isPaneCache = this.isPaneCaches[storageId];
                    int borderStartY = 0;
                    int borderEndY = storageH;
                    int borderStartX = 0;
                    int borderEndX = n;
                    boolean allChroma = true;
                    block35: for (y = 0; y < page.rows; ++y) {
                        for (int x2 = 0; x2 < 9; ++x2) {
                            index = x2 + y * 9;
                            if (isPaneCache[index] == 17) continue;
                            allChroma = false;
                            continue block35;
                        }
                    }
                    block37: for (y = 0; y < page.rows; ++y) {
                        for (int x3 = 0; x3 < 9; ++x3) {
                            index = x3 + y * 9;
                            if (isPaneCache[index] > 0 || shouldLimitBorder[index]) continue;
                            borderStartY = y * 18;
                            break block37;
                        }
                    }
                    block39: for (y = page.rows - 1; y >= 0; --y) {
                        for (int x4 = 0; x4 < 9; ++x4) {
                            index = x4 + y * 9;
                            if (isPaneCache[index] > 0 || shouldLimitBorder[index]) continue;
                            borderEndY = y * 18 + 18;
                            break block39;
                        }
                    }
                    block41: for (x = 0; x < 9; ++x) {
                        for (int y2 = 0; y2 < page.rows; ++y2) {
                            index = x + y2 * 9;
                            if (isPaneCache[index] > 0 || shouldLimitBorder[index]) continue;
                            borderStartX = x * 18;
                            break block41;
                        }
                    }
                    block43: for (x = 8; x >= 0; --x) {
                        for (int y3 = 0; y3 < page.rows; ++y3) {
                            index = x + y3 * 9;
                            if (isPaneCache[index] > 0 || shouldLimitBorder[index]) continue;
                            borderEndX = x * 18 + 18;
                            break block43;
                        }
                    }
                    int borderColour = ChromaColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedStorageColour);
                    Gui.func_73734_a((int)(storageX + borderStartX + 1), (int)(storageY + borderStartY), (int)(storageX + borderStartX), (int)(storageY + borderEndY), (int)borderColour);
                    Gui.func_73734_a((int)(storageX + borderEndX - 1), (int)(storageY + borderStartY), (int)(storageX + borderEndX), (int)(storageY + borderEndY), (int)borderColour);
                    Gui.func_73734_a((int)(storageX + borderStartX), (int)(storageY + borderStartY), (int)(storageX + borderEndX), (int)(storageY + borderStartY + 1), (int)borderColour);
                    Gui.func_73734_a((int)(storageX + borderStartX), (int)(storageY + borderEndY - 1), (int)(storageX + borderEndX), (int)(storageY + borderEndY), (int)borderColour);
                    if (allChroma) {
                        ResourceLocation loc = this.rollIndex < NOT_RICKROLL_SEQ.length ? NOT_RICKROLL_SEQ[this.rollIndex] : NOT_RICKROLL_SEQ[NOT_RICKROLL_SEQ.length * 2 - this.rollIndex - 1];
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(loc);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Utils.drawTexturedRect(storageX, storageY, n, storageH, 9729);
                    }
                } else {
                    int borderColour = ChromaColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedStorageColour);
                    Gui.func_73734_a((int)(storageX + 1), (int)storageY, (int)storageX, (int)(storageY + storageH), (int)borderColour);
                    Gui.func_73734_a((int)(storageX + n - 1), (int)storageY, (int)(storageX + n), (int)(storageY + storageH), (int)borderColour);
                    Gui.func_73734_a((int)storageX, (int)(storageY - 1), (int)(storageX + n), (int)storageY, (int)borderColour);
                    Gui.func_73734_a((int)storageX, (int)(storageY + storageH - 1), (int)(storageX + n), (int)(storageY + storageH), (int)borderColour);
                }
            } else if (whiteOverlay) {
                Gui.func_73734_a((int)storageX, (int)storageY, (int)(storageX + n), (int)(storageY + storageH), (int)-2130706433);
            } else if (page.rows <= 0) {
                Gui.func_73734_a((int)storageX, (int)storageY, (int)(storageX + n), (int)(storageY + storageH), (int)0x40000000);
            } else {
                for (int i2 = 0; i2 < page.rows * 9; ++i2) {
                    if (page.items[i2] != null && !page.shouldDarkenIfNotSelected[i2]) continue;
                    int x = storageX + 18 * (i2 % 9);
                    int y = storageY + 18 * (i2 / 9);
                    Gui.func_73734_a((int)x, (int)y, (int)(x + 18), (int)(y + 18), (int)0x40000000);
                }
            }
            GlStateManager.func_179126_j();
        }
        GlScissorStack.pop(scaledResolution);
        if (this.fastRender) {
            fontRendererObj.func_78276_b("Fast render and antialiasing do not work with Storage overlay.", sizeX / 2 - fontRendererObj.func_78256_a("Fast render and antialiasing do not work with Storage overlay.") / 2, -10, -65536);
        }
        if (StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.isEmpty() && this.searchBar.getText().isEmpty()) {
            Utils.drawStringScaledFillWidth("Please open /storage instead of /ec", sizeX / 2, sizeY / 3, false, -65536, sizeX - 30);
        }
        fontRendererObj.func_78276_b("Inventory", 180, storageViewSize + 6, textColour);
        this.searchBar.setCustomTextColour(searchTextColour);
        this.searchBar.render(252, storageViewSize + 5);
        ItemStack[] playerItems = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a;
        int inventoryStartIndex = containerChest.func_85151_d().func_70302_i_();
        GlStateManager.func_179126_j();
        for (i = 0; i < 9; ++i) {
            itemX = 181 + 18 * i;
            int itemY = storageViewSize + 76;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)173.0f, (float)(storageViewSize + 18 - (inventoryStartIndex / 9 * 18 + 31)), (float)0.0f);
            ((AccessorGuiContainer)guiChest).doDrawSlot((Slot)containerChest.field_75151_b.get(inventoryStartIndex + i));
            GlStateManager.func_179121_F();
            if (!(this.searchBar.getText().isEmpty() || playerItems[i] != null && manager.doesStackMatchSearch(playerItems[i], this.searchBar.getText()))) {
                GlStateManager.func_179097_i();
                Gui.func_73734_a((int)itemX, (int)itemY, (int)(itemX + 16), (int)(itemY + 16), (int)Integer.MIN_VALUE);
                GlStateManager.func_179126_j();
            }
            if (mouseX < this.guiLeft + itemX || mouseX >= this.guiLeft + itemX + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (playerItems[i] == null) continue;
            tooltipToDisplay = playerItems[i].func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        for (i = 0; i < 27; ++i) {
            itemX = 181 + 18 * (i % 9);
            int itemY = storageViewSize + 18 + 18 * (i / 9);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)173.0f, (float)(storageViewSize + 18 - (inventoryStartIndex / 9 * 18 + 31)), (float)0.0f);
            ((AccessorGuiContainer)guiChest).doDrawSlot((Slot)containerChest.field_75151_b.get(inventoryStartIndex + 9 + i));
            GlStateManager.func_179121_F();
            if (!(this.searchBar.getText().isEmpty() || playerItems[i + 9] != null && manager.doesStackMatchSearch(playerItems[i + 9], this.searchBar.getText()))) {
                GlStateManager.func_179097_i();
                Gui.func_73734_a((int)itemX, (int)itemY, (int)(itemX + 16), (int)(itemY + 16), (int)Integer.MIN_VALUE);
                GlStateManager.func_179126_j();
            }
            if (mouseX < this.guiLeft + itemX || mouseX >= this.guiLeft + itemX + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (playerItems[i + 9] == null) continue;
            tooltipToDisplay = playerItems[i + 9].func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        fontRendererObj.func_78276_b("Ender Chest Pages", 9, storageViewSize + 12, textColour);
        fontRendererObj.func_78276_b("Storage Pages", 9, storageViewSize + 44, textColour);
        if (StorageManager.getInstance().onStorageMenu) {
            for (i = 0; i < 9; ++i) {
                itemX = 10 + i * 18;
                int itemY = storageViewSize + 24;
                ItemStack stack = containerChest.func_85151_d().func_70301_a(i + 9);
                Utils.drawItemStack(stack, itemX, itemY);
                if (mouseX < this.guiLeft + itemX || mouseX >= this.guiLeft + itemX + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                itemHoverX = itemX;
                itemHoverY = itemY;
                if (stack == null) continue;
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.enderchestPreview) {
                    slotPreview = i;
                }
                tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            for (i = 0; i < 18; ++i) {
                itemX = 10 + 18 * (i % 9);
                int itemY = storageViewSize + 56 + 18 * (i / 9);
                ItemStack stack = containerChest.func_85151_d().func_70301_a(i + 27);
                Utils.drawItemStack(stack, itemX, itemY);
                if (mouseX < this.guiLeft + itemX || mouseX >= this.guiLeft + itemX + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                itemHoverX = itemX;
                itemHoverY = itemY;
                if (stack == null) continue;
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.backpackPreview) {
                    slotPreview = i + StorageManager.MAX_ENDER_CHEST_PAGES;
                }
                tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        } else {
            int itemY;
            for (i = 0; i < 9; ++i) {
                StorageManager.StoragePage page2 = StorageManager.getInstance().getPage(i, false);
                int itemX5 = 10 + i % 9 * 18;
                itemY = storageViewSize + 24 + i / 9 * 18;
                ItemStack stack = page2 != null && page2.backpackDisplayStack != null ? page2.backpackDisplayStack : StorageManager.LOCKED_ENDERCHEST_STACK;
                if (stack == null) continue;
                Utils.drawItemStack(stack, itemX5, itemY);
                if (mouseX < this.guiLeft + itemX5 || mouseX >= this.guiLeft + itemX5 + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                itemHoverX = itemX5;
                itemHoverY = itemY;
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.enderchestPreview) {
                    slotPreview = i;
                }
                tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            for (i = 0; i < 18; ++i) {
                StorageManager.StoragePage page3 = StorageManager.getInstance().getPage(i + StorageManager.MAX_ENDER_CHEST_PAGES, false);
                int itemX6 = 10 + i % 9 * 18;
                itemY = storageViewSize + 56 + i / 9 * 18;
                ItemStack stack = page3 != null && page3.backpackDisplayStack != null ? page3.backpackDisplayStack : StorageManager.getInstance().getMissingBackpackStack(i);
                if (stack == null) continue;
                Utils.drawItemStack(stack, itemX6, itemY);
                if (mouseX < this.guiLeft + itemX6 || mouseX >= this.guiLeft + itemX6 + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                itemHoverX = itemX6;
                itemHoverY = itemY;
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.backpackPreview) {
                    slotPreview = i + StorageManager.MAX_ENDER_CHEST_PAGES;
                }
                tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                if (StorageManager.getInstance().onStorageMenu) continue;
                ArrayList<String> tooltip = new ArrayList<String>();
                for (String string : tooltipToDisplay) {
                    tooltip.add(string.replace("Right-click to remove", "Click \"Edit\" to manage"));
                }
                tooltipToDisplay = tooltip;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(STORAGE_ICONS_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        block53: for (i = 0; i < 10; ++i) {
            int buttonX = 388 + i % 5 * 18;
            int buttonY = this.getStorageViewSize() + 35 + i / 5 * 18;
            float minU = (float)(i * 16) / 256.0f;
            float maxU = (float)(i * 16 + 16) / 256.0f;
            int vIndex = 0;
            block2 : switch (i) {
                case 2: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle;
                    break;
                }
                case 3: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.backpackPreview ? 1 : 0;
                    break;
                }
                case 4: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.enderchestPreview ? 1 : 0;
                    break;
                }
                case 5: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.masonryMode ? 1 : 0;
                    break;
                }
                case 6: {
                    int x = NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes;
                    switch (x) {
                        case 2: {
                            vIndex = 0;
                            break block2;
                        }
                        case 3: {
                            vIndex = 1;
                            break block2;
                        }
                        case 4: {
                            vIndex = 2;
                            break block2;
                        }
                    }
                    vIndex = x + 1;
                    break;
                }
                case 7: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.searchBarAutofocus ? 1 : 0;
                    break;
                }
                case 8: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.showEnchantGlint ? 1 : 0;
                }
            }
            Utils.drawTexturedRect(buttonX, buttonY, 16.0f, 16.0f, minU, maxU, (float)(vIndex * 16) / 256.0f, (float)(vIndex * 16 + 16) / 256.0f, 9728);
            if (mouseX < this.guiLeft + buttonX || mouseX >= this.guiLeft + buttonX + 18 || mouseY < this.guiTop + buttonY || mouseY >= this.guiTop + buttonY + 18) continue;
            switch (i) {
                case 0: {
                    tooltipToDisplay = this.createTooltip("Enable GUI", 0, "On", "Off");
                    continue block53;
                }
                case 1: {
                    int tooltipStorageHeight = this.desiredHeightSwitch != -1 ? this.desiredHeightSwitch : NotEnoughUpdates.INSTANCE.config.storageGUI.storageHeight;
                    tooltipToDisplay = this.createTooltip("Storage View Height", Math.round((float)(tooltipStorageHeight - 104) / 52.0f), "Tiny", "Small", "Medium", "Large", "Huge");
                    if (this.desiredHeightSwitch == -1) continue block53;
                    tooltipToDisplay.add("");
                    tooltipToDisplay.add(EnumChatFormatting.YELLOW + "* Move mouse to apply changes *");
                    continue block53;
                }
                case 2: {
                    tooltipToDisplay = this.createTooltip("Overlay Style", NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle, "Transparent", "Minecraft", "Dark", "Custom");
                    continue block53;
                }
                case 3: {
                    tooltipToDisplay = this.createTooltip("Backpack Preview", NotEnoughUpdates.INSTANCE.config.storageGUI.backpackPreview ? 0 : 1, "On", "Off");
                    continue block53;
                }
                case 4: {
                    tooltipToDisplay = this.createTooltip("Enderchest Preview", NotEnoughUpdates.INSTANCE.config.storageGUI.enderchestPreview ? 0 : 1, "On", "Off");
                    continue block53;
                }
                case 5: {
                    tooltipToDisplay = this.createTooltip("Compact Vertically", NotEnoughUpdates.INSTANCE.config.storageGUI.masonryMode ? 0 : 1, "On", "Off");
                    continue block53;
                }
                case 6: {
                    tooltipToDisplay = this.createTooltip("Fancy Glass Panes", NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes, "On", "Locked", "Off", "No connecting", "Locked & No connecting");
                    tooltipToDisplay.add(1, "\u00a7eReplace the glass pane textures");
                    tooltipToDisplay.add(2, "\u00a7ein your storage containers with");
                    tooltipToDisplay.add(3, "\u00a7ea fancy connected texture");
                    continue block53;
                }
                case 7: {
                    tooltipToDisplay = this.createTooltip("Search Bar Autofocus", NotEnoughUpdates.INSTANCE.config.storageGUI.searchBarAutofocus ? 0 : 1, "On", "Off");
                    continue block53;
                }
                case 8: {
                    tooltipToDisplay = this.createTooltip("Show Enchant Glint", NotEnoughUpdates.INSTANCE.config.storageGUI.showEnchantGlint ? 0 : 1, "On", "Off");
                    continue block53;
                }
                case 9: {
                    tooltipToDisplay = this.createTooltip("Disable optifine CIT", !NotEnoughUpdates.INSTANCE.config.storageGUI.disableCIT ? 0 : 1, "CIT Enabled", "CIT Disabled");
                }
            }
        }
        if (!StorageManager.getInstance().onStorageMenu) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(storageTexture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(135.0f, 41 + storageViewSize, 36.0f, 14.0f, 0.04f, 0.1f, 0.6275f, 0.6625f, 9728);
        }
        if (itemHoverX >= 0 && itemHoverY >= 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)itemHoverX, (int)itemHoverY, (int)(itemHoverX + 16), (int)(itemHoverY + 16), (int)-2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        this.allowTypingInSearchBar = false;
        if (stackOnMouse != null) {
            GlStateManager.func_179126_j();
            if (hoveringOtherBackpack) {
                Utils.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_180401_cv)), mouseX - 8, mouseY - 8);
            } else {
                Utils.drawItemStack(stackOnMouse, mouseX - 8, mouseY - 8);
            }
        } else if (slotPreview >= 0) {
            StorageManager.StoragePage page4 = StorageManager.getInstance().getPage(slotPreview, false);
            if (page4 != null && page4.rows > 0) {
                int rows2 = page4.rows;
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
                GlStateManager.func_179097_i();
                BackgroundBlur.renderBlurredBackground(7.0f, width, height, mouseX + 2, mouseY + 2, 172, 10 + 18 * rows2);
                Utils.drawGradientRect(mouseX + 2, mouseY + 2, mouseX + 174, mouseY + 12 + 18 * rows2, -1072689136, -804253680);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(storagePreviewTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(mouseX, mouseY, 176.0f, 7.0f, 0.0f, 1.0f, 0.0f, 0.21875f, 9728);
                for (int i3 = 0; i3 < rows2; ++i3) {
                    Utils.drawTexturedRect(mouseX, mouseY + 7 + 18 * i3, 176.0f, 18.0f, 0.0f, 1.0f, 0.21875f, 0.78125f, 9728);
                }
                Utils.drawTexturedRect(mouseX, mouseY + 7 + 18 * rows2, 176.0f, 7.0f, 0.0f, 1.0f, 0.78125f, 1.0f, 9728);
                GlStateManager.func_179126_j();
                for (int i2 = 0; i2 < rows2 * 9; ++i2) {
                    ItemStack stack = page4.items[i2];
                    if (stack == null) continue;
                    GlStateManager.func_179126_j();
                    Utils.drawItemStack(stack, mouseX + 8 + 18 * (i2 % 9), mouseY + 8 + 18 * (i2 / 9));
                    GlStateManager.func_179097_i();
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
            } else {
                Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1);
            }
        } else if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1);
        } else {
            this.allowTypingInSearchBar = true;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    private List<String> createTooltip(String title, int selectedOption, String ... options) {
        String selPrefix = EnumChatFormatting.DARK_AQUA + " \u25b6 ";
        String unselPrefix = EnumChatFormatting.GRAY.toString();
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == selectedOption ? selPrefix + options[i] : unselPrefix + options[i];
        }
        ArrayList list = Lists.newArrayList((Object[])options);
        list.add(0, "");
        list.add(0, EnumChatFormatting.GREEN + title);
        return list;
    }

    public IntPair getPageCoords(int displayId) {
        if (displayId < 0) {
            displayId = 0;
        }
        int y = NotEnoughUpdates.INSTANCE.config.storageGUI.masonryMode ? -this.scroll.getValue() + 18 + 108 * (displayId / 3) : -this.scroll.getValue() + 17 + 104 * (displayId / 3);
        for (int i = 0; i <= displayId - 3; i += 3) {
            int maxRows = 1;
            for (int j = i; j < i + 3; ++j) {
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.masonryMode && displayId % 3 != j % 3 || !StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.containsKey(j)) continue;
                int storageId = StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.get(j);
                StorageManager.StoragePage page = StorageManager.getInstance().getPage(storageId, false);
                maxRows = page == null || page.rows <= 0 ? Math.max(maxRows, 3) : Math.max(maxRows, page.rows);
            }
            y -= (5 - maxRows) * 18;
        }
        return new IntPair(8 + 172 * (displayId % 3), y);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        int delta;
        int i;
        int scrollBarY;
        int scrollMouseY;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return false;
        }
        int dWheel = Mouse.getEventDWheel();
        if (!(NotEnoughUpdates.INSTANCE.config.storageGUI.cancelScrollKey != 0 && KeybindHelper.isKeyDown(NotEnoughUpdates.INSTANCE.config.storageGUI.cancelScrollKey) || dWheel == 0)) {
            long currentTime;
            if (dWheel < 0) {
                dWheel = -1;
                if (this.scrollVelocity > 0) {
                    this.scrollVelocity = 0;
                }
            }
            if (dWheel > 0) {
                dWheel = 1;
                if (this.scrollVelocity < 0) {
                    this.scrollVelocity = 0;
                }
            }
            this.scrollVelocity = (currentTime = System.currentTimeMillis()) - this.lastScroll > 200L ? 0 : (int)((float)this.scrollVelocity / 1.3f);
            this.lastScroll = currentTime;
            this.scrollVelocity += dWheel * 10;
            this.scrollToY(this.scroll.getTarget() - this.scrollVelocity);
            return true;
        }
        if (Mouse.getEventButtonState()) {
            this.editingNameId = -1;
        }
        if (Mouse.getEventButton() == 0) {
            if (!Mouse.getEventButtonState()) {
                this.scrollGrabOffset = -1;
            } else if (mouseX >= this.guiLeft + 519 && mouseX <= this.guiLeft + 519 + 14 && mouseY >= this.guiTop + 8 && mouseY <= this.guiTop + 2 + this.getStorageViewSize() && (scrollMouseY = mouseY - (this.guiTop + 8)) >= (scrollBarY = Math.round((float)(this.getScrollBarHeight() * this.scroll.getValue()) / (float)this.getMaximumScroll())) && scrollMouseY < scrollBarY + 12) {
                this.scrollGrabOffset = scrollMouseY - scrollBarY;
            }
        }
        if (this.scrollGrabOffset >= 0 && Mouse.getEventButton() == -1 && !Mouse.getEventButtonState()) {
            scrollMouseY = mouseY - (this.guiTop + 8);
            scrollBarY = scrollMouseY - this.scrollGrabOffset;
            this.scrollToY(Math.round((float)(scrollBarY * this.getMaximumScroll()) / (float)this.getScrollBarHeight()));
            this.scroll.setTimeToReachTarget(10);
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int storageViewSize = this.getStorageViewSize();
        int sizeX = 540;
        int sizeY = 100 + storageViewSize;
        int searchNobX = 18;
        this.guiLeft = width / 2 - (sizeX - searchNobX) / 2;
        this.guiTop = height / 2 - sizeY / 2;
        if (Mouse.getEventButtonState() && !StorageManager.getInstance().onStorageMenu && mouseX > this.guiLeft + 171 - 36 && mouseX < this.guiLeft + 171 && mouseY > this.guiTop + 41 + storageViewSize && mouseY < this.guiTop + 41 + storageViewSize + 14) {
            NotEnoughUpdates.INSTANCE.sendChatMessage("/storage");
            this.searchBar.setFocus(false);
            return true;
        }
        if (Mouse.getEventButtonState()) {
            if (mouseX >= this.guiLeft + 252 && mouseX <= this.guiLeft + 252 + this.searchBar.getWidth() && mouseY >= this.guiTop + storageViewSize + 5 && mouseY <= this.guiTop + storageViewSize + 5 + this.searchBar.getHeight()) {
                if (this.searchBar.getFocus()) {
                    this.searchBar.mouseClicked(mouseX - this.guiLeft, mouseY - this.guiTop, Mouse.getEventButton());
                    StorageManager.getInstance().searchDisplay(this.searchBar.getText());
                    this.dirty = true;
                } else {
                    this.searchBar.setFocus(true);
                    if (Mouse.getEventButton() == 1) {
                        this.searchBar.setText("");
                        StorageManager.getInstance().searchDisplay(this.searchBar.getText());
                        this.dirty = true;
                    }
                }
            } else {
                this.searchBar.setFocus(false);
            }
        }
        if (mouseX > this.guiLeft + 181 && mouseX < this.guiLeft + 181 + 162 && mouseY > this.guiTop + storageViewSize + 18 && mouseY < this.guiTop + storageViewSize + 94) {
            if (Keyboard.isKeyDown((int)42)) {
                this.dirty = true;
            }
            return false;
        }
        if (mouseY > this.guiTop + 3 && mouseY < this.guiTop + storageViewSize + 3) {
            int currentPage = StorageManager.getInstance().getCurrentPageId();
            for (Map.Entry<Integer, Integer> entry : StorageManager.getInstance().storageConfig.displayToStorageIdMapRender.entrySet()) {
                int rows;
                IntPair pageCoords = this.getPageCoords(entry.getKey());
                if (pageCoords.y > storageViewSize + 3 || pageCoords.y + 90 < 3) continue;
                StorageManager.StoragePage page = StorageManager.getInstance().getPage(entry.getValue(), false);
                int n = page == null ? 3 : (rows = page.rows <= 0 ? 3 : page.rows);
                if (page != null) {
                    String pageTitle = page.customTitle != null && !page.customTitle.isEmpty() ? page.customTitle : (entry.getValue() < 9 ? "Ender Chest Page " + (entry.getValue() + 1) : "Backpack Slot " + (entry.getValue() - 8));
                    int titleLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(pageTitle);
                    if (mouseX >= this.guiLeft + pageCoords.x && mouseX <= this.guiLeft + pageCoords.x + titleLen + 15 && mouseY >= this.guiTop + pageCoords.y - 14 && mouseY <= this.guiTop + pageCoords.y + 1) {
                        if (Mouse.getEventButtonState() && (Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1)) {
                            if (this.editingNameId != entry.getValue()) {
                                this.editingNameId = entry.getValue();
                                if (!this.renameStorageField.getText().equalsIgnoreCase(pageTitle)) {
                                    this.renameStorageField.setText(pageTitle);
                                }
                            }
                            if (!this.renameStorageField.getFocus()) {
                                this.renameStorageField.setFocus(true);
                            } else {
                                this.renameStorageField.mouseClicked(mouseX - this.guiLeft, mouseY - this.guiTop, Mouse.getEventButton());
                            }
                        } else if (Mouse.getEventButton() < 0 && Mouse.isButtonDown((int)0)) {
                            this.renameStorageField.mouseClickMove(mouseX - this.guiLeft, mouseY - this.guiTop, 0, 0L);
                        }
                        return true;
                    }
                }
                if (mouseX <= this.guiLeft + pageCoords.x || mouseX >= this.guiLeft + pageCoords.x + 162 || mouseY <= this.guiTop + pageCoords.y || mouseY >= this.guiTop + pageCoords.y + rows * 18) continue;
                if (currentPage >= 0 && entry.getValue() == currentPage) {
                    this.dirty = true;
                    return false;
                }
                if (!Mouse.getEventButtonState() || Mouse.getEventButton() != 0 || Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() != null || page == null) continue;
                this.scrollToStorage(entry.getKey(), false);
                StorageManager.getInstance().sendToPage(entry.getValue());
                return true;
            }
        }
        for (i = 0; i < 10; ++i) {
            int buttonX = 388 + i % 5 * 18;
            int buttonY = this.getStorageViewSize() + 35 + i / 5 * 18;
            float minU = (float)(i * 16) / 256.0f;
            float maxU = (float)(i * 16 + 16) / 256.0f;
            int vIndex = 0;
            switch (i) {
                case 2: {
                    vIndex = NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle;
                }
            }
            Utils.drawTexturedRect(buttonX, buttonY, 16.0f, 16.0f, minU, maxU, (float)(vIndex * 16) / 256.0f, (float)(vIndex * 16 + 16) / 256.0f, 9728);
        }
        if (this.desiredHeightSwitch != -1 && Mouse.getEventButton() == -1 && !Mouse.getEventButtonState() && (delta = Math.abs(this.desiredHeightMX - mouseX) + Math.abs(this.desiredHeightMY - mouseY)) > 3) {
            NotEnoughUpdates.INSTANCE.config.storageGUI.storageHeight = this.desiredHeightSwitch;
            this.desiredHeightSwitch = -1;
        }
        if (Mouse.getEventButtonState() && mouseX >= this.guiLeft + 388 && mouseX < this.guiLeft + 388 + 90 && mouseY >= this.guiTop + storageViewSize + 35 && mouseY < this.guiTop + storageViewSize + 35 + 36) {
            int xN = mouseX - (this.guiLeft + 388);
            int yN = mouseY - (this.guiTop + storageViewSize + 35);
            int xIndex = xN / 18;
            int yIndex = yN / 18;
            int buttonIndex = xIndex + 5 * yIndex;
            switch (buttonIndex) {
                case 0: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.enableStorageGUI3 = false;
                    ChatComponentText storageMessage = new ChatComponentText(EnumChatFormatting.YELLOW + "[NEU] " + EnumChatFormatting.YELLOW + "You just disabled the custom storage gui, did you mean to do that? If not click this message to turn it back on.");
                    storageMessage.func_150255_a(Utils.createClickStyle(ClickEvent.Action.RUN_COMMAND, "/neuenablestorage"));
                    storageMessage.func_150255_a(storageMessage.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Click to enable the custom storage gui."))));
                    ChatComponentText storageChatMessage = new ChatComponentText("");
                    storageChatMessage.func_150257_a((IChatComponent)storageMessage);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)storageChatMessage);
                    break;
                }
                case 1: {
                    int size = this.desiredHeightSwitch != -1 ? this.desiredHeightSwitch : NotEnoughUpdates.INSTANCE.config.storageGUI.storageHeight;
                    int sizeIndex = Math.round((float)(size - 104) / 54.0f);
                    sizeIndex = Mouse.getEventButton() == 0 ? --sizeIndex : ++sizeIndex;
                    size = sizeIndex * 54 + 104;
                    if (size < 104) {
                        size = 312;
                    }
                    if (size > 320) {
                        size = 104;
                    }
                    this.desiredHeightMX = mouseX;
                    this.desiredHeightMY = mouseY;
                    this.desiredHeightSwitch = size;
                    break;
                }
                case 2: {
                    int displayStyle = NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle;
                    displayStyle = Mouse.getEventButton() == 0 ? ++displayStyle : --displayStyle;
                    if (displayStyle < 0) {
                        displayStyle = STORAGE_TEXTURES.length - 1;
                    }
                    if (displayStyle >= STORAGE_TEXTURES.length) {
                        displayStyle = 0;
                    }
                    NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle = displayStyle;
                    break;
                }
                case 3: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.backpackPreview = !NotEnoughUpdates.INSTANCE.config.storageGUI.backpackPreview;
                    break;
                }
                case 4: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.enderchestPreview = !NotEnoughUpdates.INSTANCE.config.storageGUI.enderchestPreview;
                    break;
                }
                case 5: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.masonryMode = !NotEnoughUpdates.INSTANCE.config.storageGUI.masonryMode;
                    break;
                }
                case 6: {
                    int fancyPanes = NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes;
                    fancyPanes = Mouse.getEventButton() == 0 ? ++fancyPanes : --fancyPanes;
                    if (fancyPanes < 0) {
                        fancyPanes = 4;
                    }
                    if (fancyPanes >= 5) {
                        fancyPanes = 0;
                    }
                    NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes = fancyPanes;
                    break;
                }
                case 7: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.searchBarAutofocus = !NotEnoughUpdates.INSTANCE.config.storageGUI.searchBarAutofocus;
                    break;
                }
                case 8: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.showEnchantGlint = !NotEnoughUpdates.INSTANCE.config.storageGUI.showEnchantGlint;
                    break;
                }
                case 9: {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.disableCIT = !NotEnoughUpdates.INSTANCE.config.storageGUI.disableCIT;
                }
            }
            this.dirty = true;
        }
        if (mouseX >= this.guiLeft + 10 && mouseX <= this.guiLeft + 171 && mouseY >= this.guiTop + storageViewSize + 23 && mouseY <= this.guiTop + storageViewSize + 91) {
            if (StorageManager.getInstance().onStorageMenu) {
                return false;
            }
            if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
                for (i = 0; i < 9; ++i) {
                    int storageId = i;
                    int displayId = StorageManager.getInstance().getDisplayIdForStorageIdRender(i);
                    StorageManager.StoragePage page = StorageManager.getInstance().getPage(storageId, false);
                    if (page == null) continue;
                    int itemX = 10 + i % 9 * 18;
                    int itemY = storageViewSize + 24 + i / 9 * 18;
                    if (mouseX < this.guiLeft + itemX || mouseX >= this.guiLeft + itemX + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                    StorageManager.getInstance().sendToPage(storageId);
                    this.scrollToStorage(displayId, true);
                    return true;
                }
                for (i = 0; i < 18; ++i) {
                    int storageId = i + StorageManager.MAX_ENDER_CHEST_PAGES;
                    int displayId = StorageManager.getInstance().getDisplayIdForStorageIdRender(i);
                    StorageManager.StoragePage page = StorageManager.getInstance().getPage(storageId, false);
                    if (page == null) continue;
                    int itemX = 10 + i % 9 * 18;
                    int itemY = storageViewSize + 56 + i / 9 * 18;
                    if (mouseX < this.guiLeft + itemX || mouseX >= this.guiLeft + itemX + 18 || mouseY < this.guiTop + itemY || mouseY >= this.guiTop + itemY + 18) continue;
                    StorageManager.getInstance().sendToPage(storageId);
                    this.scrollToStorage(displayId, true);
                    return true;
                }
            }
        }
        return true;
    }

    public void overrideIsMouseOverSlot(Slot slot, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (StorageManager.getInstance().shouldRenderStorageOverlayFast()) {
            boolean playerInv = slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by;
            int slotId = slot.getSlotIndex();
            int storageViewSize = this.getStorageViewSize();
            if (playerInv) {
                if (slotId < 9) {
                    int xN;
                    int xClicked;
                    if (mouseY >= this.guiTop + storageViewSize + 76 && mouseY <= this.guiTop + storageViewSize + 92 && (xClicked = (xN = mouseX - (this.guiLeft + 181)) / 18) == slotId) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                } else {
                    int xN = mouseX - (this.guiLeft + 181);
                    int yN = mouseY - (this.guiTop + storageViewSize + 18);
                    int xClicked = xN / 18;
                    int yClicked = yN / 18;
                    if (xClicked >= 0 && xClicked <= 8 && yClicked >= 0 && yClicked <= 2 && xClicked + yClicked * 9 + 9 == slotId) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                }
            } else if (StorageManager.getInstance().onStorageMenu) {
                if (slotId >= 9 && slotId < 18) {
                    int xN;
                    int xClicked;
                    if (mouseY >= this.guiTop + storageViewSize + 24 && mouseY < this.guiTop + storageViewSize + 24 + 18 && (xClicked = (xN = mouseX - (this.guiLeft + 10)) / 18) == slotId % 9) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                } else if (slotId >= 27 && slotId < 45) {
                    int xN = mouseX - (this.guiLeft + 10);
                    int yN = mouseY - (this.guiTop + storageViewSize + 56);
                    int xClicked = xN / 18;
                    int yClicked = yN / 18;
                    if (xClicked == slotId % 9 && yClicked >= 0 && yClicked == slotId / 9 - 3) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                }
            } else {
                int currentPage = StorageManager.getInstance().getCurrentPageId();
                int displayId = StorageManager.getInstance().getDisplayIdForStorageIdRender(currentPage);
                if (displayId >= 0) {
                    IntPair pageCoords = this.getPageCoords(displayId);
                    int xN = mouseX - (this.guiLeft + pageCoords.x);
                    int yN = mouseY - (this.guiTop + pageCoords.y);
                    int xClicked = xN / 18;
                    int yClicked = yN / 18;
                    if (xClicked >= 0 && xClicked <= 8 && yClicked >= 0 && yClicked <= 5 && xClicked + yClicked * 9 + 9 == slotId) {
                        int fancyPaneValue = NotEnoughUpdates.INSTANCE.config.storageGUI.fancyPanes;
                        if ((fancyPaneValue == 1 || fancyPaneValue == 4) && slot.func_75216_d() && StorageOverlay.getPaneType(slot.func_75211_c(), -1, null) > 0) {
                            cir.setReturnValue((Object)false);
                            return;
                        }
                        cir.setReturnValue((Object)true);
                        return;
                    }
                }
            }
            cir.setReturnValue((Object)false);
        }
    }

    public void clearSearch() {
        this.searchBar.setFocus(false);
        this.searchBar.setText("");
        StorageManager.getInstance().searchDisplay(this.searchBar.getText());
    }

    @Override
    public boolean keyboardInput() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return true;
        }
        GuiContainer container = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        int keyPressed = Keyboard.getEventKey();
        if (keyPressed == 1) {
            this.clearSearch();
            return false;
        }
        if (keyPressed == Minecraft.func_71410_x().field_71474_y.field_151447_Z.func_151463_i()) {
            return false;
        }
        if (keyPressed == Minecraft.func_71410_x().field_71474_y.field_152395_am.func_151463_i()) {
            return false;
        }
        if (!(this.searchBar.getFocus() || this.renameStorageField.getFocus() || keyPressed != StorageOverlay.manager.keybindViewRecipe.func_151463_i() && keyPressed != StorageOverlay.manager.keybindViewUsages.func_151463_i() && keyPressed != NotEnoughUpdates.INSTANCE.config.misc.openAHKeybind)) {
            for (Slot slot : container.field_147002_h.field_75151_b) {
                if (slot == null || !((AccessorGuiContainer)container).doIsMouseOverSlot(slot, mouseX, mouseY)) continue;
                ItemStack stack = slot.func_75211_c();
                String internalName = manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
                if (internalName == null) continue;
                if (keyPressed == StorageOverlay.manager.keybindViewRecipe.func_151463_i()) {
                    manager.displayGuiItemRecipeKeybind(internalName);
                }
                if (keyPressed == StorageOverlay.manager.keybindViewUsages.func_151463_i()) {
                    manager.displayGuiItemUsagesKeybind(internalName);
                }
                if (keyPressed != NotEnoughUpdates.INSTANCE.config.misc.openAHKeybind) continue;
                AhBzKeybind.onKeyPressed(stack);
            }
        }
        if (Keyboard.getEventKeyState()) {
            String prevText;
            if (NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking && KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockKey) && !this.searchBar.getFocus()) {
                for (Slot slot : container.field_147002_h.field_75151_b) {
                    if (slot == null || slot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by || !((AccessorGuiContainer)container).doIsMouseOverSlot(slot, mouseX, mouseY)) continue;
                    SlotLocking.getInstance().toggleLock(slot.getSlotIndex());
                    return true;
                }
            }
            if (this.editingNameId >= 0) {
                StorageManager.StoragePage page;
                if (keyPressed == 28) {
                    this.editingNameId = -1;
                    return true;
                }
                prevText = this.renameStorageField.getText();
                this.renameStorageField.setFocus(true);
                this.searchBar.setFocus(false);
                this.renameStorageField.keyTyped(Keyboard.getEventCharacter(), keyPressed);
                if (!prevText.equals(this.renameStorageField.getText()) && (page = StorageManager.getInstance().getPage(this.editingNameId, false)) != null) {
                    page.customTitle = this.renameStorageField.getText();
                }
            } else if (this.searchBar.getFocus() || this.allowTypingInSearchBar && NotEnoughUpdates.INSTANCE.config.storageGUI.searchBarAutofocus) {
                prevText = this.searchBar.getText();
                this.searchBar.setFocus(true);
                this.renameStorageField.setFocus(false);
                this.searchBar.keyTyped(Keyboard.getEventCharacter(), keyPressed);
                if (!prevText.equals(this.searchBar.getText())) {
                    StorageManager.getInstance().searchDisplay(this.searchBar.getText());
                    this.dirty = true;
                }
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.searchBarAutofocus && this.searchBar.getText().isEmpty()) {
                    this.searchBar.setFocus(false);
                }
            } else {
                return keyPressed != Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i();
            }
        }
        return true;
    }

    private void renderEnchOverlay(Set<Vector2f> locations) {
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.showEnchantGlint) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_ITEM_GLINT);
        }
        GL11.glPushMatrix();
        for (Vector2f loc : locations) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179109_b((float)loc.x, (float)loc.y, (float)0.0f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179143_c((int)514);
            GlStateManager.func_179112_b((int)768, (int)1);
            GL11.glBlendFunc((int)768, (int)1);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
            GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179131_c((float)0.5019608f, (float)0.2509804f, (float)0.8f, (float)1.0f);
            Utils.drawTexturedRectNoBlend(0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.0625f, 0.0f, 0.0625f, 9728);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
            GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179131_c((float)0.5019608f, (float)0.2509804f, (float)0.8f, (float)1.0f);
            Utils.drawTexturedRectNoBlend(0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.0625f, 0.0f, 0.0625f, 9728);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179101_C();
        GL11.glPopMatrix();
        GlStateManager.func_179144_i((int)0);
    }

    public void fastRenderCheck() {
        if (!OpenGlHelper.func_148822_b() && NotEnoughUpdates.INSTANCE.config.notifications.doFastRenderNotif && NotEnoughUpdates.INSTANCE.config.storageGUI.enableStorageGUI3) {
            this.fastRender = true;
            NotificationHandler.displayNotification(Lists.newArrayList((Object[])new String[]{"\u00a74Warning", "\u00a77Due to the way fast render and antialiasing work, they're not compatible with NEU.", "\u00a77Please disable fast render and antialiasing in your options under", "\u00a77ESC > Options > Video Settings > Performance > \u00a7cFast Render", "\u00a77ESC > Options > Video Settings > Quality > \u00a7cAntialiasing", "\u00a77This can't be fixed.", "\u00a77", "\u00a77Press X on your keyboard to close this notification"}), true, true);
            return;
        }
        this.fastRender = false;
    }

    static {
        int i;
        STORAGE_PREVIEW_TEXTURES = new ResourceLocation[4];
        STORAGE_TEXTURES = new ResourceLocation[4];
        STORAGE_ICONS_TEXTURE = new ResourceLocation("notenoughupdates:storage_gui/storage_icons.png");
        STORAGE_PANE_CTM_TEXTURE = new ResourceLocation("notenoughupdates:storage_gui/storage_gui_pane_ctm.png");
        NOT_RICKROLL_SEQ = new ResourceLocation[19];
        INSTANCE = new StorageOverlay();
        RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        manager = NotEnoughUpdates.INSTANCE.manager;
        for (i = 0; i < STORAGE_TEXTURES.length; ++i) {
            StorageOverlay.STORAGE_TEXTURES[i] = new ResourceLocation("notenoughupdates:storage_gui/storage_gui_" + i + ".png");
        }
        for (i = 0; i < STORAGE_PREVIEW_TEXTURES.length; ++i) {
            StorageOverlay.STORAGE_PREVIEW_TEXTURES[i] = new ResourceLocation("notenoughupdates:storage_gui/storage_preview_" + i + ".png");
        }
        for (i = 0; i < NOT_RICKROLL_SEQ.length; ++i) {
            StorageOverlay.NOT_RICKROLL_SEQ[i] = new ResourceLocation("notenoughupdates:storage_gui/we_do_a_little_rolling/" + i + ".jpg");
        }
    }

    private static class IntPair {
        int x;
        int y;

        public IntPair(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

