/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.itemcustomization;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GlScissorStack;
import io.github.moulberry.notenoughupdates.core.GuiElement;
import io.github.moulberry.notenoughupdates.core.GuiElementBoolean;
import io.github.moulberry.notenoughupdates.core.GuiElementColour;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingFloat;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.DyeMode;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.DyeType;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.GuiType;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizationUtils;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiItemCustomize
extends GuiScreen {
    private static final ResourceLocation PLUS = new ResourceLocation("notenoughupdates:itemcustomize/plus.png");
    private final ItemStack stack;
    ItemStack customItemStack;
    private final String itemUUID;
    private final GuiElementTextField textFieldRename = new GuiElementTextField("", 138, 20, 2);
    final GuiElementTextField textFieldCustomItem = new GuiElementTextField("", 180, 20, 2);
    final GuiElementTextField textFieldTickSpeed = new GuiElementTextField("", 180, 45, 18);
    private final GuiElementBoolean enchantGlintButton;
    private int renderHeight = 0;
    private final LerpingFloat enchantGlintCustomColourAnimation = new LerpingFloat(0.0f, 200);
    private boolean enchantGlint;
    String customGlintColour = null;
    String customLeatherColour = null;
    ArrayList<String> animatedLeatherColours = new ArrayList();
    int animatedDyeTicks = 2;
    DyeMode dyeMode = DyeMode.CYCLING;
    private int lastTicks = 2;
    boolean supportCustomLeatherColour;
    private String lastCustomItem = "";
    JsonObject animatedDyes = null;
    JsonObject staticDyes = null;
    JsonObject vanillaDyes = null;
    ArrayList<DyeType> dyes = new ArrayList();
    boolean repoError = false;
    private GuiElement editor = null;
    private GuiType guiType = GuiType.DEFAULT;
    int lastMouseScroll = 0;
    int noMouseScrollFrames;
    double scrollVelocity = 0.0;
    int pageScroll = 0;

    public GuiItemCustomize(ItemStack stack, String itemUUID) {
        DyeType staticHeader;
        this.stack = stack;
        this.itemUUID = itemUUID;
        this.customItemStack = ItemCustomizationUtils.copy(stack, this);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        boolean stackHasEffect = stack.func_77962_s() && !model.func_177553_d();
        ItemCustomizeManager.ItemData data = ItemCustomizeManager.getDataForItem(stack);
        if (data != null) {
            boolean bl = this.enchantGlint = data.overrideEnchantGlint ? data.enchantGlintValue : stackHasEffect;
            if (data.customName != null) {
                this.textFieldRename.setText(data.customName);
            }
            if (data.customItem != null && data.customItem.length() > 0) {
                this.textFieldCustomItem.setText(data.customItem);
            } else {
                this.textFieldCustomItem.setText(stack.func_77973_b().getRegistryName().replace("minecraft:", ""));
            }
            this.customGlintColour = data.customGlintColour;
            this.customLeatherColour = data.customLeatherColour;
            if (data.animatedLeatherColours != null) {
                this.animatedLeatherColours = new ArrayList<String>(Arrays.asList(data.animatedLeatherColours));
                if (data.animatedDyeTicks < 1) {
                    this.animatedDyeTicks = 1;
                    data.animatedDyeTicks = 1;
                } else {
                    this.animatedDyeTicks = data.animatedDyeTicks;
                }
                this.textFieldTickSpeed.setText("" + this.animatedDyeTicks);
                this.dyeMode = data.dyeMode;
            } else {
                this.animatedLeatherColours = new ArrayList();
                this.textFieldTickSpeed.setText("2");
            }
        } else {
            this.enchantGlint = stackHasEffect;
            this.textFieldCustomItem.setText(stack.func_77973_b().getRegistryName().replace("minecraft:", ""));
        }
        this.supportCustomLeatherColour = this.customItemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)this.customItemStack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
        this.enchantGlintCustomColourAnimation.setValue(this.enchantGlint ? 17.0f : 0.0f);
        this.enchantGlintButton = new GuiElementBoolean(0, 0, () -> this.enchantGlint, bool -> {
            this.enchantGlint = bool;
            this.updateData();
        });
        JsonObject dyesConst = Constants.DYES;
        if (dyesConst == null) {
            Utils.showOutdatedRepoNotification("dyes.json");
            this.repoError = true;
            return;
        }
        this.repoError = false;
        if (dyesConst.has("animated")) {
            this.animatedDyes = dyesConst.get("animated").getAsJsonObject();
            DyeType animatedHeader = new DyeType("Animated Dyes");
            this.dyes.add(animatedHeader);
            this.animatedDyes.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                JsonArray value = ((JsonElement)entry.getValue()).getAsJsonArray();
                DyeType dyeType = new DyeType(key, value);
                this.dyes.add(dyeType);
            });
        }
        if (dyesConst.has("static")) {
            this.staticDyes = dyesConst.get("static").getAsJsonObject();
            staticHeader = new DyeType("Static Dyes");
            this.dyes.add(staticHeader);
            this.staticDyes.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                String value = ((JsonElement)entry.getValue()).getAsString();
                DyeType dyeType = new DyeType(key, value);
                this.dyes.add(dyeType);
            });
        }
        if (dyesConst.has("vanilla")) {
            this.vanillaDyes = dyesConst.get("vanilla").getAsJsonObject();
            staticHeader = new DyeType("Vanilla Dyes");
            this.dyes.add(staticHeader);
            this.vanillaDyes.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                String value = ((JsonElement)entry.getValue()).getAsString();
                DyeType dyeType = new DyeType(key, value);
                this.dyes.add(dyeType);
            });
        }
    }

    public void func_146281_b() {
        this.updateData();
    }

    public void updateData() {
        ItemCustomizeManager.ItemData data = new ItemCustomizeManager.ItemData();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.stack);
        boolean stackHasEffect = this.stack.func_77962_s() && !model.func_177553_d();
        this.customItemStack = ItemCustomizationUtils.copy(this.stack, this);
        data.defaultItem = this.stack.func_77973_b().getRegistryName();
        if (this.enchantGlint != stackHasEffect) {
            data.overrideEnchantGlint = true;
            data.enchantGlintValue = this.enchantGlint;
        }
        data.customGlintColour = this.customGlintColour != null && !this.customGlintColour.equals(ItemCustomizeManager.DEFAULT_GLINT_COLOR) ? this.customGlintColour : (model.func_177553_d() && data.overrideEnchantGlint && data.enchantGlintValue ? ItemCustomizeManager.DEFAULT_GLINT_COLOR : null);
        data.customLeatherColour = this.customLeatherColour != null && (!(this.customItemStack.func_77973_b() instanceof ItemArmor) || !this.customLeatherColour.equals(ItemCustomizationUtils.getChromaStrFromLeatherColour(this))) ? this.customLeatherColour : null;
        if (!this.animatedLeatherColours.isEmpty()) {
            data.animatedLeatherColours = new String[this.animatedLeatherColours.size()];
            data.animatedLeatherColours = this.animatedLeatherColours.toArray(data.animatedLeatherColours);
            if (this.textFieldTickSpeed.getText().isEmpty()) {
                data.animatedDyeTicks = 2;
            } else {
                try {
                    int dyeTicks = Integer.parseInt(this.textFieldTickSpeed.getText());
                    data.animatedDyeTicks = Math.max(dyeTicks, 1);
                }
                catch (NumberFormatException e2) {
                    data.animatedDyeTicks = 2;
                }
            }
        }
        data.dyeMode = this.dyeMode;
        if (!this.textFieldRename.getText().isEmpty()) {
            NBTTagCompound nbttagcompound;
            data.customName = this.textFieldRename.getText();
            NBTTagCompound stackTagCompound = this.stack.func_77978_p();
            if (stackTagCompound != null && stackTagCompound.func_150297_b("display", 10) && (nbttagcompound = stackTagCompound.func_74775_l("display")).func_150297_b("Name", 8)) {
                int i;
                String name = nbttagcompound.func_74779_i("Name");
                char[] chars = name.toCharArray();
                for (i = 0; i < chars.length && chars[i] == '\u00a7'; i += 2) {
                }
                data.customNamePrefix = name.substring(0, i);
            }
        }
        if (!this.textFieldCustomItem.getText().isEmpty()) {
            data.customItem = this.textFieldCustomItem.getText();
        }
        ItemCustomizeManager.putItemData(this.itemUUID, data);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.supportCustomLeatherColour) {
            this.guiType = GuiType.DEFAULT;
        }
        this.drawScreenType(mouseX, mouseY, partialTicks, this.guiType);
    }

    private void drawScreenType(int mouseX, int mouseY, float partialTicks, GuiType type2) {
        if (type2 == GuiType.DEFAULT) {
            this.drawScreenDefault(mouseX, mouseY, partialTicks);
        } else if (type2 == GuiType.ANIMATED) {
            this.drawScreenAnimatedDyes(mouseX, mouseY, partialTicks);
        } else if (type2 == GuiType.HYPIXEL) {
            this.drawScreenHypixel(mouseX, mouseY, partialTicks);
        }
    }

    private void drawScreenDefault(int mouseX, int mouseY, float partialTicks) {
        int yTopStart;
        this.func_146276_q_();
        List<String> tooltipToDisplay = null;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int yTop = yTopStart = (scaledResolution.func_78328_b() - this.renderHeight) / 2;
        this.renderHeader(xCenter, yTop);
        ItemCustomizationUtils.renderTextBox(this.textFieldRename, "\u00a77Enter Custom Name...", xCenter - this.textFieldRename.getWidth() / 2 - 20, yTop += 14, 138);
        int yTopText = yTop;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.help);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int helpX = xCenter + this.textFieldRename.getWidth() / 2 - 5 + 10;
        Utils.drawTexturedRect(helpX, yTop, 20.0f, 20.0f, 9729);
        if (mouseX >= helpX && mouseX <= helpX + 20 && mouseY >= yTop && mouseY <= yTop + 20) {
            ItemCustomizationUtils.customizeColourGuide.set(7, Utils.chromaString("\u00b6z = Chroma"));
            tooltipToDisplay = ItemCustomizationUtils.customizeColourGuide;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ItemCustomizationUtils.RESET);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int resetX = xCenter + this.textFieldRename.getWidth() / 2 - 15;
        Utils.drawTexturedRect(resetX, yTop + 5, 10.0f, 11.0f, 9729);
        if (mouseX >= resetX && mouseX <= resetX + 10 && mouseY >= yTop && mouseY <= yTop + 20) {
            tooltipToDisplay = ItemCustomizationUtils.resetGuide;
        }
        ItemCustomizationUtils.renderPresetButtons(xCenter, yTop, ItemCustomizationUtils.validShareContents("NEUCUSTOMIZE"), true, "preset");
        this.renderBigStack(xCenter, yTop += 25);
        RenderUtils.drawFloatingRectDark(xCenter - 90, yTop += 115, 180, 20);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("Enchant Glint", xCenter - 85, yTop + 6, -8372020);
        this.enchantGlintButton.x = xCenter + 90 - 5 - 48;
        this.enchantGlintButton.y = yTop + 3;
        this.enchantGlintButton.render();
        yTop += 25;
        this.enchantGlintCustomColourAnimation.tick();
        if (this.enchantGlintCustomColourAnimation.getValue() > 0.0f) {
            int glintColour = ItemCustomizationUtils.getGlintColour(this);
            GlScissorStack.push(0, yTop -= 5, scaledResolution.func_78326_a(), scaledResolution.func_78328_b(), scaledResolution);
            GlStateManager.func_179109_b((float)0.0f, (float)(this.enchantGlintCustomColourAnimation.getValue() - 17.0f), (float)0.0f);
            ItemCustomizationUtils.renderColourBlob(xCenter, yTop, glintColour, "\u00a7a\u00a7lCustom Glint Colour", true, false);
            GlStateManager.func_179109_b((float)0.0f, (float)(-this.enchantGlintCustomColourAnimation.getValue() + 17.0f), (float)0.0f);
            GlScissorStack.pop(scaledResolution);
            yTop = (int)((float)yTop + (this.enchantGlintCustomColourAnimation.getValue() + 3.0f));
        }
        boolean bl = this.supportCustomLeatherColour = this.customItemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)this.customItemStack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
        if (this.supportCustomLeatherColour) {
            int leatherColour = ItemCustomizationUtils.getLeatherColour(this);
            String text = "\u00a7b\u00a7lCustom Leather Colour";
            boolean reset = true;
            if (!this.animatedLeatherColours.isEmpty()) {
                text = "\u00a7b\u00a7lOverridden by Animated";
                reset = false;
            }
            ItemCustomizationUtils.renderColourBlob(xCenter, yTop, leatherColour, text, reset, false);
            yTop += 20;
        }
        if (!this.lastCustomItem.equals(this.textFieldCustomItem.getText())) {
            this.updateData();
        }
        this.lastCustomItem = this.textFieldCustomItem.getText();
        int offset = 200;
        if (!this.supportCustomLeatherColour) {
            offset -= 20;
        }
        if (!this.enchantGlint) {
            offset -= 16;
        }
        ItemCustomizationUtils.renderTextBox(this.textFieldCustomItem, "\u00a77Enter Custom Item ID...", xCenter - this.textFieldCustomItem.getWidth() / 2 - 10 + 11, yTopText + offset, 180);
        List<String> animatedSkullHelp = ItemCustomizeManager.getAnimatedSkullHelp(this.textFieldCustomItem.getText());
        if (animatedSkullHelp != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.help);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int skullHelpX = xCenter + this.textFieldRename.getWidth() / 2;
            Utils.drawTexturedRect(skullHelpX, yTop - 1, 20.0f, 20.0f, 9729);
            if (mouseX >= helpX && mouseX <= skullHelpX + 20 && mouseY >= yTop && mouseY <= yTop + 20) {
                tooltipToDisplay = animatedSkullHelp;
            }
        }
        if (this.supportCustomLeatherColour) {
            ItemCustomizationUtils.renderFooter(xCenter, yTop += 25, this.guiType);
        }
        this.renderHeight = yTop - yTopStart;
        if (this.editor != null) {
            this.editor.render();
        }
        if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawScreenAnimatedDyes(int mouseX, int mouseY, float partialTicks) {
        int yTopStart;
        this.func_146276_q_();
        List<String> tooltipToDisplay = null;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int yTop = yTopStart = (scaledResolution.func_78328_b() - this.renderHeight) / 2;
        this.renderHeader(xCenter, yTop);
        ItemCustomizationUtils.renderPresetButtons(xCenter, yTop, ItemCustomizationUtils.validShareContents("NEUCUSTOMIZE"), true, "preset");
        ItemCustomizationUtils.renderPresetButtons(xCenter, yTop + 50, ItemCustomizationUtils.validShareContents("NEUANIMATED"), !this.animatedLeatherColours.isEmpty(), "animated");
        this.renderBigStack(xCenter, yTop += 14);
        int adjustedY = (yTop += 115) + this.pageScroll + 20;
        for (int i = 0; i < this.animatedLeatherColours.size(); ++i) {
            if (adjustedY + 20 * i < yTopStart + 130 || adjustedY + 20 * i >= yTopStart + this.guiScaleOffset() + 150) continue;
            int leatherColour = ItemCustomizationUtils.getLeatherColour(this.animatedLeatherColours.get(i));
            ItemCustomizationUtils.renderColourBlob(xCenter, yTop, leatherColour, "\u00a7b\u00a7lDye Colour " + (i + 1), false, true);
            yTop += 20;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PLUS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(xCenter + 90 - 12, yTop + 4, 10.0f, 10.0f, 9728);
        int xOffset = xCenter - this.textFieldCustomItem.getWidth() / 2 - 10 + 11;
        ItemCustomizationUtils.renderTextBox(this.textFieldTickSpeed, "\u00a77Speed...", xOffset, yTop, 45);
        if (mouseX >= xOffset && mouseX <= xOffset + this.textFieldTickSpeed.getWidth() && mouseY >= yTop && mouseY <= yTop + 20) {
            tooltipToDisplay = ItemCustomizationUtils.speedGuide;
        }
        Gui.func_73734_a((int)(xCenter - 40), (int)(yTop + 2), (int)(xCenter - 2), (int)(yTop + 19), (int)0x70000000);
        Gui.func_73734_a((int)(xCenter - 40), (int)(yTop + 2), (int)(xCenter - 2), (int)(yTop + 16), (int)-15724522);
        Gui.func_73734_a((int)(xCenter - 39), (int)(yTop + 3), (int)(xCenter - 3), (int)(yTop + 16), (int)-38571);
        Utils.renderShadowedString("\u00a7c\u00a7lClear", xCenter - 20, yTop + 6, xCenter * 2);
        String dyeModeText = this.dyeMode == DyeMode.CYCLING ? "\u00a7a\u00a7lCycling" : "\u00a7d\u00a7lGradient";
        int backgroundColour = this.dyeMode == DyeMode.CYCLING ? 720640 : 0xFF00EF;
        Gui.func_73734_a((int)(xCenter + 10), (int)(yTop + 2), (int)(xCenter + 68), (int)(yTop + 19), (int)0x70000000);
        Gui.func_73734_a((int)(xCenter + 10), (int)(yTop + 2), (int)(xCenter + 68), (int)(yTop + 16), (int)-15724522);
        Gui.func_73734_a((int)(xCenter + 11), (int)(yTop + 3), (int)(xCenter + 67), (int)(yTop + 16), (int)(0xFF000000 | backgroundColour));
        Utils.renderShadowedString(dyeModeText, xCenter + 39, yTop + 6, xCenter * 2);
        this.enchantGlintCustomColourAnimation.tick();
        ItemCustomizationUtils.renderFooter(xCenter, yTop += 25, this.guiType);
        try {
            if (this.lastTicks != Integer.parseInt(this.textFieldTickSpeed.getText())) {
                this.updateData();
            }
            this.lastTicks = Integer.parseInt(this.textFieldTickSpeed.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.renderHeight = yTop - yTopStart;
        if (this.editor != null) {
            this.editor.render();
        }
        if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
        }
        this.scrollScreen(this.animatedLeatherColours.size());
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawScreenHypixel(int mouseX, int mouseY, float partialTicks) {
        int yTopStart;
        this.func_146276_q_();
        List<String> tooltipToDisplay = null;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int yTop = yTopStart = (scaledResolution.func_78328_b() - this.renderHeight) / 2;
        this.renderHeader(xCenter, yTop);
        yTop += 14;
        if (this.repoError) {
            Utils.renderShadowedString("Repo Error", xCenter, yTop + 4, 180);
            ItemCustomizationUtils.renderFooter(xCenter, yTop += 15, this.guiType);
            this.renderHeight = yTop - yTopStart;
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        this.renderBigStack(xCenter, yTop);
        int adjustedY = (yTop += 115) + this.pageScroll + 20;
        for (int i = 0; i < this.dyes.size(); ++i) {
            if (adjustedY + 20 * i < yTopStart + 130 || adjustedY + 20 * i >= yTopStart + this.guiScaleOffset() + 150) continue;
            Color color = ItemCustomizationUtils.getColourFromHex(this.dyes.get((int)i).colour);
            JsonArray colours = this.dyes.get((int)i).colours;
            String itemId = this.dyes.get((int)i).itemId;
            String displayName = null;
            ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(itemId).resolveToItemStack();
            if (itemStack == null && (colours != null || this.dyes.get((int)i).colour != null)) {
                itemStack = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName("DYE_PURE_YELLOW").resolveToItemStack();
                displayName = itemId;
            }
            if (itemStack != null) {
                if (displayName == null) {
                    displayName = itemStack.func_82833_r();
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(xCenter - 89), (float)yTop, (float)0.0f);
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)1.0);
                Utils.drawItemStack(itemStack, 0, 0);
                GlStateManager.func_179121_F();
            }
            if (color == null && colours == null) {
                if (displayName == null) {
                    displayName = itemId;
                }
                Utils.renderShadowedString(displayName, xCenter, yTop + 4, 180);
            } else if (color == null && colours != null) {
                String colourHex = colours.get(Minecraft.func_71410_x().field_71439_g.field_70173_aa / this.animatedDyeTicks % colours.size()).getAsString();
                int colourFromHex = ItemCustomizationUtils.rgbToInt(ItemCustomizationUtils.getColourFromHex(colourHex));
                ItemCustomizationUtils.renderColourBlob(xCenter, yTop, colourFromHex, displayName, false, false);
            } else {
                int colour = ItemCustomizationUtils.rgbToInt(color);
                ItemCustomizationUtils.renderColourBlob(xCenter, yTop, colour, displayName, false, false);
            }
            yTop += 20;
        }
        int xOffset = xCenter - this.textFieldCustomItem.getWidth() / 2 - 10 + 11;
        ItemCustomizationUtils.renderTextBox(this.textFieldTickSpeed, "\u00a77Speed...", xOffset, yTop, 45);
        if (mouseX >= xOffset && mouseX <= xOffset + this.textFieldTickSpeed.getWidth() && mouseY >= yTop && mouseY <= yTop + 20) {
            tooltipToDisplay = ItemCustomizationUtils.speedGuide;
        }
        this.enchantGlintCustomColourAnimation.tick();
        ItemCustomizationUtils.renderFooter(xCenter, yTop += 25, this.guiType);
        try {
            if (this.lastTicks != Integer.parseInt(this.textFieldTickSpeed.getText())) {
                this.updateData();
            }
            this.lastTicks = Integer.parseInt(this.textFieldTickSpeed.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.renderHeight = yTop - yTopStart;
        if (this.editor != null) {
            this.editor.render();
        }
        if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
        }
        this.scrollScreen(this.dyes.size());
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void scrollScreen(int size) {
        this.scrollVelocity += (double)this.lastMouseScroll / 48.0;
        this.scrollVelocity *= 0.95;
        this.pageScroll += (int)this.scrollVelocity + this.lastMouseScroll / 24;
        ++this.noMouseScrollFrames;
        if (this.noMouseScrollFrames >= 100) {
            this.scrollVelocity *= 0.75;
        }
        if (this.pageScroll > 0) {
            this.pageScroll = 0;
        }
        this.pageScroll = MathHelper.func_76125_a((int)this.pageScroll, (int)(-(size * 20 - 20 - this.guiScaleOffset())), (int)0);
        this.lastMouseScroll = 0;
    }

    private int guiScaleOffset() {
        int scale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        if (scale == 0) {
            return 80;
        }
        if (scale == 1) {
            return 680;
        }
        if (scale == 2) {
            return 280;
        }
        if (scale == 3) {
            return 220;
        }
        return 80;
    }

    public void func_73876_c() {
        if (this.enchantGlint) {
            if (this.enchantGlintCustomColourAnimation.getTarget() != 17.0f) {
                this.enchantGlintCustomColourAnimation.setTarget(17.0f);
                this.enchantGlintCustomColourAnimation.resetTimer();
            }
        } else if (this.enchantGlintCustomColourAnimation.getTarget() != 0.0f) {
            this.enchantGlintCustomColourAnimation.setTarget(0.0f);
            this.enchantGlintCustomColourAnimation.resetTimer();
        }
        super.func_73876_c();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textFieldRename.getFocus()) {
            if (keyCode == 1) {
                this.textFieldRename.setFocus(false);
                return;
            }
            this.textFieldRename.keyTyped(typedChar, keyCode);
        }
        if (this.textFieldCustomItem.getFocus()) {
            this.updateData();
            if (keyCode == 1) {
                this.textFieldCustomItem.setFocus(false);
                return;
            }
            this.textFieldCustomItem.keyTyped(typedChar, keyCode);
        }
        if (this.textFieldTickSpeed.getFocus()) {
            this.updateData();
            if (keyCode == 1) {
                this.textFieldTickSpeed.setFocus(false);
                return;
            }
            this.textFieldTickSpeed.keyTyped(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146282_l() throws IOException {
        if (this.editor == null || !this.editor.keyboardInput()) {
            if (this.editor != null && Keyboard.getEventKeyState() && Keyboard.getEventKey() == 1) {
                this.editor = null;
            } else {
                super.func_146282_l();
            }
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.editor == null || !this.editor.mouseInput(mouseX, mouseY)) {
            super.func_146274_d();
            if (this.guiType == GuiType.DEFAULT) {
                this.enchantGlintButton.mouseInput(mouseX, mouseY);
            }
        }
        if (this.guiType != GuiType.DEFAULT && !Mouse.getEventButtonState() && Mouse.getEventDWheel() != 0) {
            this.lastMouseScroll = Mouse.getEventDWheel();
            this.noMouseScrollFrames = 0;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.textFieldRename.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.textFieldCustomItem.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.textFieldTickSpeed.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    private void mouseClickedType(int mouseX, int mouseY, int mouseButton, GuiType type2) throws IOException {
        if (type2 == GuiType.DEFAULT) {
            this.mouseClickedDefault(mouseX, mouseY, mouseButton);
        } else if (type2 == GuiType.ANIMATED) {
            this.mouseClickedAnimatedDyes(mouseX, mouseY, mouseButton);
        } else if (type2 == GuiType.HYPIXEL) {
            this.mouseClickedHypixel(mouseX, mouseY, mouseButton);
        }
    }

    private void mouseClickedDefault(int mouseX, int mouseY, int mouseButton) throws IOException {
        float buttonOffset;
        GuiType buttonClicked;
        int resetX;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int yTop = (scaledResolution.func_78328_b() - this.renderHeight) / 2;
        if (mouseX >= xCenter - this.textFieldRename.getWidth() / 2 - 10 && mouseX <= xCenter + this.textFieldRename.getWidth() / 2 - 10 && mouseY >= yTop + 14 && mouseY <= yTop + 14 + this.textFieldRename.getHeight()) {
            this.textFieldRename.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.textFieldRename.unfocus();
        }
        if (mouseX >= xCenter - 88 + 198 && mouseX <= xCenter + 88 + 105) {
            Gson gson = new Gson();
            ItemCustomizeManager.ItemData dataForItem = ItemCustomizeManager.getDataForItem(this.stack);
            if (mouseY >= yTop + 40 && mouseY <= yTop + 40 + 20) {
                if (dataForItem.customItem != null && dataForItem.customItem.equals(dataForItem.defaultItem.replace("minecraft:", ""))) {
                    dataForItem.customItem = null;
                }
                ItemCustomizationUtils.shareContents("NEUCUSTOMIZE", gson.toJson(dataForItem));
            } else if (mouseY >= yTop + 10 && mouseY <= yTop + 10 + 20 && ItemCustomizationUtils.validShareContents("NEUCUSTOMIZE")) {
                String shareJson = ItemCustomizationUtils.getShareFromClipboard("NEUCUSTOMIZE");
                ItemCustomizeManager.ItemData itemData = gson.fromJson(shareJson, ItemCustomizeManager.ItemData.class);
                itemData.defaultItem = dataForItem.defaultItem;
                ItemCustomizeManager.putItemData(this.itemUUID, itemData);
                NotEnoughUpdates.INSTANCE.openGui = new GuiItemCustomize(this.stack, this.itemUUID);
            }
        }
        if (mouseX >= (resetX = xCenter + this.textFieldRename.getWidth() / 2 - 15) && mouseX <= resetX + 10 && mouseY >= yTop + 15 && mouseY <= yTop + 25) {
            ItemCustomizeManager.putItemData(this.itemUUID, new ItemCustomizeManager.ItemData());
            NotEnoughUpdates.INSTANCE.openGui = new GuiItemCustomize(this.stack, this.itemUUID);
        }
        int offset = 200;
        if (!this.supportCustomLeatherColour) {
            offset -= 20;
        }
        if (!this.enchantGlint) {
            offset -= 18;
        }
        if (mouseX >= xCenter - this.textFieldCustomItem.getWidth() / 2 - 10 + 11 && mouseX <= xCenter + this.textFieldCustomItem.getWidth() / 2 - 10 + 11 && mouseY >= yTop + offset + 14 && mouseY <= yTop + offset + 14 + this.textFieldCustomItem.getHeight()) {
            this.textFieldCustomItem.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.textFieldCustomItem.unfocus();
        }
        if (this.enchantGlint && mouseX >= xCenter - 90 && mouseX <= xCenter + 90 && mouseY >= yTop + 174 && (float)mouseY <= (float)(yTop + 174) + this.enchantGlintCustomColourAnimation.getValue()) {
            if (mouseX >= xCenter + 90 - 12) {
                this.editor = null;
                this.customGlintColour = ItemCustomizeManager.DEFAULT_GLINT_COLOR;
                this.updateData();
            } else {
                this.editor = new GuiElementColour(mouseX, mouseY, () -> this.customGlintColour == null ? ItemCustomizeManager.DEFAULT_GLINT_COLOR : this.customGlintColour, colour -> {
                    this.customGlintColour = colour;
                    this.updateData();
                }, () -> {
                    this.editor = null;
                });
            }
        }
        float belowEnchGlint = (float)(yTop + 174) + this.enchantGlintCustomColourAnimation.getValue() + 5.0f;
        if (this.supportCustomLeatherColour && mouseX >= xCenter - 90 && mouseX <= xCenter + 90 && (float)mouseY >= belowEnchGlint && (float)mouseY <= belowEnchGlint + 15.0f) {
            if (mouseX >= xCenter + 90 - 12) {
                this.editor = null;
                this.customLeatherColour = null;
                this.updateData();
            } else if (this.animatedLeatherColours.isEmpty()) {
                this.editor = new GuiElementColour(mouseX, mouseY, () -> this.customLeatherColour == null ? ItemCustomizationUtils.getChromaStrFromLeatherColour(this) : this.customLeatherColour, colour -> {
                    this.customLeatherColour = colour;
                    this.updateData();
                }, () -> {
                    this.editor = null;
                }, false, true);
            } else {
                this.guiType = GuiType.ANIMATED;
            }
        }
        if (this.supportCustomLeatherColour && (buttonClicked = ItemCustomizationUtils.getButtonClicked(mouseX, mouseY, this.guiType, buttonOffset = (float)(yTop + 174) + this.enchantGlintCustomColourAnimation.getValue() + 5.0f + 45.0f)) != null) {
            this.guiType = buttonClicked;
            this.pageScroll = 0;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void mouseClickedAnimatedDyes(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiType buttonClicked;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int yTop = (scaledResolution.func_78328_b() - this.renderHeight) / 2;
        int topOffset = yTop + 129;
        float bottomOffset = yTop + this.renderHeight + 3;
        ArrayList<Integer> indexToRemove = new ArrayList<Integer>();
        int adjustedY = topOffset + this.pageScroll + 20;
        for (int i = 0; i < this.animatedLeatherColours.size(); ++i) {
            if (adjustedY + 20 * i < yTop + 130 || adjustedY + 20 * i >= yTop + this.guiScaleOffset() + 150) continue;
            if (this.supportCustomLeatherColour && mouseX >= xCenter - 90 && mouseX <= xCenter + 90 && mouseY >= topOffset && mouseY <= topOffset + 15) {
                int finalI = i;
                if (mouseX >= xCenter + 90 - 12) {
                    this.editor = null;
                    indexToRemove.add(i);
                    this.updateData();
                } else {
                    this.editor = new GuiElementColour(mouseX, mouseY, () -> {
                        String animatedColour = this.animatedLeatherColours.get(finalI);
                        return animatedColour == null ? ItemCustomizationUtils.getChromaStrFromLeatherColour(this) : animatedColour;
                    }, colour -> {
                        this.animatedLeatherColours.set(finalI, (String)colour);
                        this.updateData();
                    }, () -> {
                        this.editor = null;
                    }, false, true);
                }
            }
            topOffset += 20;
        }
        if (mouseX >= xCenter - 88 + 198 && mouseX <= xCenter + 88 + 105) {
            String shareJson;
            Gson gson = new Gson();
            ItemCustomizeManager.ItemData dataForItem = ItemCustomizeManager.getDataForItem(this.stack);
            if (mouseY >= yTop + 0 && mouseY <= yTop + 0 + 20) {
                if (ItemCustomizationUtils.validShareContents("NEUCUSTOMIZE")) {
                    shareJson = ItemCustomizationUtils.getShareFromClipboard("NEUCUSTOMIZE");
                    ItemCustomizeManager.ItemData itemData = gson.fromJson(shareJson, ItemCustomizeManager.ItemData.class);
                    itemData.defaultItem = dataForItem.defaultItem;
                    ItemCustomizeManager.putItemData(this.itemUUID, itemData);
                    NotEnoughUpdates.INSTANCE.openGui = new GuiItemCustomize(this.stack, this.itemUUID);
                }
            } else if (mouseY >= yTop + 20 && mouseY <= yTop + 20 + 20) {
                if (dataForItem.customItem != null && dataForItem.customItem.equals(dataForItem.defaultItem.replace("minecraft:", ""))) {
                    dataForItem.customItem = null;
                }
                ItemCustomizationUtils.shareContents("NEUCUSTOMIZE", gson.toJson(dataForItem));
            } else if (mouseY >= yTop + 45 && mouseY <= yTop + 45 + 20) {
                if (ItemCustomizationUtils.validShareContents("NEUANIMATED") && this.animatedLeatherColours != null) {
                    shareJson = ItemCustomizationUtils.getShareFromClipboard("NEUANIMATED");
                    DyeType dyeType = gson.fromJson(shareJson, DyeType.class);
                    if (dyeType.coloursArray != null) {
                        this.animatedDyeTicks = dyeType.ticks;
                        dataForItem.animatedDyeTicks = dyeType.ticks;
                        dataForItem.animatedLeatherColours = Arrays.copyOf(dyeType.coloursArray, dyeType.coloursArray.length);
                        this.animatedLeatherColours.clear();
                        this.animatedLeatherColours = new ArrayList<String>(Arrays.asList(dyeType.coloursArray));
                        dataForItem.animatedLeatherColours = (String[])Arrays.stream(dataForItem.animatedLeatherColours).filter(Objects::nonNull).toArray(String[]::new);
                        if (dyeType.dyeMode != null) {
                            this.dyeMode = dyeType.dyeMode;
                            dataForItem.dyeMode = dyeType.dyeMode;
                        } else {
                            this.dyeMode = DyeMode.CYCLING;
                            dataForItem.dyeMode = DyeMode.CYCLING;
                        }
                        ItemCustomizeManager.putItemData(this.itemUUID, dataForItem);
                        NotEnoughUpdates.INSTANCE.openGui = new GuiItemCustomize(this.stack, this.itemUUID);
                    }
                }
            } else if (mouseY >= yTop + 72 && mouseY <= yTop + 72 + 20) {
                ItemCustomizationUtils.shareContents("NEUANIMATED", gson.toJson(new DyeType(dataForItem.animatedLeatherColours, dataForItem.animatedDyeTicks, dataForItem.dyeMode)));
            }
        }
        if (this.supportCustomLeatherColour && mouseX >= xCenter - 90 && mouseX <= xCenter + 90 && mouseY >= topOffset && mouseY <= topOffset + 15 && mouseX >= xCenter + 90 - 12) {
            this.editor = null;
            if (!this.animatedLeatherColours.isEmpty()) {
                this.animatedLeatherColours.add(this.animatedLeatherColours.get(this.animatedLeatherColours.size() - 1));
            } else if (this.customLeatherColour != null) {
                this.animatedLeatherColours.add(this.customLeatherColour);
            } else {
                this.animatedLeatherColours.add(ItemCustomizationUtils.getChromaStrFromLeatherColour(this));
            }
            this.updateData();
            this.pageScroll = -(this.animatedLeatherColours.size() * 20 - 20 - this.guiScaleOffset());
        }
        if (mouseX >= xCenter - this.textFieldTickSpeed.getWidth() / 2 - 70 && mouseX <= xCenter + this.textFieldTickSpeed.getWidth() / 2 - 70 && mouseY >= topOffset && mouseY <= topOffset + this.textFieldTickSpeed.getHeight()) {
            this.textFieldTickSpeed.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.textFieldTickSpeed.unfocus();
        }
        for (Integer i : indexToRemove) {
            this.animatedLeatherColours.set(i, null);
        }
        this.animatedLeatherColours.removeAll(Collections.singleton(null));
        if (mouseX >= xCenter - 23 - 15 && mouseX <= xCenter + 11 - 15 && mouseY >= topOffset && mouseY <= topOffset + 20) {
            this.animatedLeatherColours.clear();
            this.updateData();
        }
        if (mouseX >= xCenter - 23 - 15 + 50 && mouseX <= xCenter + 11 - 15 + 70 && mouseY >= topOffset && mouseY <= topOffset + 20) {
            this.dyeMode = this.dyeMode == DyeMode.CYCLING ? DyeMode.GRADIENT : DyeMode.CYCLING;
            this.updateData();
        }
        if ((buttonClicked = ItemCustomizationUtils.getButtonClicked(mouseX, mouseY, this.guiType, bottomOffset)) != null) {
            this.guiType = buttonClicked;
            this.pageScroll = 0;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void mouseClickedHypixel(int mouseX, int mouseY, int mouseButton) throws IOException {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int xCenter = scaledResolution.func_78326_a() / 2;
        int yTop = (scaledResolution.func_78328_b() - this.renderHeight) / 2;
        int topOffset = yTop + 129;
        float bottomOffset = yTop + this.renderHeight + 3;
        int adjustedY = topOffset + this.pageScroll + 20;
        for (int i = 0; i < this.dyes.size(); ++i) {
            if (adjustedY + 20 * i < yTop + 130 || adjustedY + 20 * i >= yTop + this.guiScaleOffset() + 150) continue;
            if (this.supportCustomLeatherColour && mouseX >= xCenter - 90 && mouseX <= xCenter + 90 && mouseY >= topOffset && mouseY <= topOffset + 15) {
                if (this.dyes.get(i).hasAnimatedColour()) {
                    this.animatedLeatherColours.clear();
                    this.dyeMode = DyeMode.CYCLING;
                    for (JsonElement colour : this.dyes.get((int)i).colours) {
                        String string = colour.getAsString();
                        Color colourFromHex = ItemCustomizationUtils.getColourFromHex(string);
                        String special = SpecialColour.special(0, 0, colourFromHex.getRGB());
                        this.animatedLeatherColours.add(special);
                    }
                } else if (this.dyes.get(i).hasStaticColour()) {
                    String special;
                    this.dyeMode = DyeMode.CYCLING;
                    this.animatedLeatherColours.clear();
                    Color colourFromHex = ItemCustomizationUtils.getColourFromHex(this.dyes.get((int)i).colour);
                    this.customLeatherColour = special = SpecialColour.special(0, 0, colourFromHex.getRGB());
                }
                this.updateData();
            }
            topOffset += 20;
        }
        if (mouseX >= xCenter - this.textFieldTickSpeed.getWidth() / 2 - 70 && mouseX <= xCenter + this.textFieldTickSpeed.getWidth() / 2 - 70 && mouseY >= topOffset && mouseY <= topOffset + this.textFieldTickSpeed.getHeight()) {
            this.textFieldTickSpeed.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.textFieldTickSpeed.unfocus();
        }
        GuiType buttonClicked = ItemCustomizationUtils.getButtonClicked(mouseX, mouseY, this.guiType, bottomOffset);
        if (buttonClicked != null) {
            this.guiType = buttonClicked;
            this.pageScroll = 0;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.mouseClickedType(mouseX, mouseY, mouseButton, this.guiType);
    }

    public void renderHeader(int xCenter, int yTop) {
        RenderUtils.drawFloatingRectDark(xCenter - 100, yTop - 9, 200, this.renderHeight + 33);
        RenderUtils.drawFloatingRectDark(xCenter - 90, yTop - 5, 180, 14);
        Utils.renderShadowedString("\u00a75\u00a7lNEU Item Customizer", xCenter, yTop - 1, 180);
    }

    private void renderBigStack(int xCenter, int yTop) {
        RenderUtils.drawFloatingRectDark(xCenter - 90, yTop, 180, 110);
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(xCenter - 48), (float)(yTop + 7), (float)0.0f);
        GlStateManager.func_179152_a((float)6.0f, (float)6.0f, (float)1.0f);
        this.customItemStack = ItemCustomizationUtils.copy(this.stack, this);
        Utils.drawItemStack(this.customItemStack, 0, 0);
        GlStateManager.func_179121_F();
    }
}

