/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.repo;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.repo.MinionHelperRepoMinionLoader;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.loaders.repo.RecipeBuilder;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.CustomRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.CustomSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.NpcSource;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MinionHelperRepoLoader {
    private final MinionHelperManager manager;
    private boolean dirty = true;
    private int ticks = 0;
    private boolean readyToUse = false;
    private final MinionHelperRepoMinionLoader minionLoader;
    boolean errorWhileLoading = false;

    public MinionHelperRepoLoader(MinionHelperManager manager) {
        this.manager = manager;
        this.minionLoader = new MinionHelperRepoMinionLoader(this, manager);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRepoReload(RepositoryReloadEvent event) {
        this.setDirty();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.minionHelper.gui) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 5 != 0) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            this.load();
        }
    }

    void load() {
        this.errorWhileLoading = false;
        if (!this.createMinions()) {
            this.errorWhileLoading = true;
            return;
        }
        this.loadNpcData();
        this.minionLoader.loadMinionData();
        this.loadCustomSources();
        this.testForMissingData();
        this.manager.reloadData();
        this.readyToUse = true;
        if (this.errorWhileLoading) {
            Utils.showOutdatedRepoNotification("what ever the minion helper wants");
        }
    }

    private void loadCustomSources() {
        HashMap<String, String> customSource = new HashMap<String, String>();
        customSource.put("SNOW_GENERATOR_1", "Gifts");
        customSource.put("FLOWER_GENERATOR_1", "Dark Auction");
        customSource.put("REVENANT_GENERATOR_1", "Zombie Slayer");
        customSource.put("TARANTULA_GENERATOR_1", "Spider Slayer");
        for (Map.Entry entry : customSource.entrySet()) {
            String internalName = (String)entry.getKey();
            String sourceName = (String)entry.getValue();
            Minion minion = this.manager.getMinionById(internalName);
            if (minion == null) continue;
            this.manager.setCustomSource(minion, new CustomSource(sourceName));
        }
        this.manager.getMinionById("FLOWER_GENERATOR_1").getRequirements().add(new CustomRequirement("Buy a \u00a7cFlower Minion 1 \u00a77from Dark Auction"));
        this.manager.getMinionById("SNOW_GENERATOR_1").getRequirements().add(new CustomRequirement("Get a \u00a7cSnow Minion 1 \u00a77from opening gifts"));
    }

    private void loadNpcData() {
        TreeMap<String, JsonObject> itemInformation = NotEnoughUpdates.INSTANCE.manager.getItemInformation();
        for (Map.Entry<String, JsonObject> entry : itemInformation.entrySet()) {
            JsonObject jsonObject;
            String internalName = entry.getKey();
            if (!internalName.endsWith("_NPC") || !(jsonObject = entry.getValue()).has("recipes") || !jsonObject.has("displayname")) continue;
            String npcName = jsonObject.get("displayname").getAsString();
            if ((npcName = StringUtils.cleanColour(npcName)).contains(" (")) {
                npcName = npcName.split(" \\(")[0];
            }
            for (JsonElement element : jsonObject.get("recipes").getAsJsonArray()) {
                String result2;
                JsonObject object = element.getAsJsonObject();
                if (!object.has("type") || !object.get("type").getAsString().equals("npc_shop") || !object.has("result") || !(result2 = object.get("result").getAsString()).contains("_GENERATOR_")) continue;
                Minion minion = this.manager.getMinionById(result2);
                if (!object.has("cost")) continue;
                RecipeBuilder builder = new RecipeBuilder(this.manager);
                for (JsonElement costEntry : object.get("cost").getAsJsonArray()) {
                    String price = costEntry.getAsString();
                    builder.addLine(minion, price);
                }
                ArrayListMultimap<String, Integer> map2 = builder.getItems();
                int coins = 0;
                if (map2.containsKey((Object)"SKYBLOCK_COIN")) {
                    coins = (Integer)map2.get((Object)"SKYBLOCK_COIN").get(0);
                    map2.removeAll((Object)"SKYBLOCK_COIN");
                }
                minion.setMinionSource(new NpcSource(npcName, coins, builder.getItems()));
                minion.setParent(builder.getParent());
            }
        }
    }

    private boolean createMinions() {
        JsonObject misc = Constants.MISC;
        if (misc == null || !misc.has("minions")) {
            return false;
        }
        for (Map.Entry<String, JsonElement> entry : misc.get("minions").getAsJsonObject().entrySet()) {
            String internalName = entry.getKey();
            int maxTier = entry.getValue().getAsInt();
            for (int i = 0; i < maxTier; ++i) {
                int tier = i + 1;
                int minionXp = misc.has("minionXp") ? misc.get("minionXp").getAsJsonObject().get(tier + "").getAsInt() : 0;
                this.manager.createMinion(internalName + "_" + tier, tier, minionXp);
            }
        }
        return true;
    }

    private void testForMissingData() {
        for (Minion minion : this.manager.getAllMinions().values()) {
            if (minion.getMinionSource() == null) {
                this.errorWhileLoading = true;
                if (NotEnoughUpdates.INSTANCE.config.hidden.dev) {
                    Utils.addChatMessage("\u00a7c[NEU] The Minion '" + minion.getInternalName() + " has no source!");
                }
            }
            if (minion.getDisplayName() == null) {
                this.errorWhileLoading = true;
                if (NotEnoughUpdates.INSTANCE.config.hidden.dev) {
                    Utils.addChatMessage("\u00a7c[NEU] The Minion '" + minion.getInternalName() + " has no display name!");
                }
            }
            if (this.manager.getRequirementsManager().getRequirements(minion).isEmpty()) {
                this.errorWhileLoading = true;
                if (NotEnoughUpdates.INSTANCE.config.hidden.dev) {
                    Utils.addChatMessage("\u00a7c[NEU] The Minion '" + minion.getInternalName() + " has no requirements!");
                }
            }
            if (minion.getTier() <= 1 || minion.getParent() != null) continue;
            this.errorWhileLoading = true;
            if (!NotEnoughUpdates.INSTANCE.config.hidden.dev) continue;
            Utils.addChatMessage("\u00a7c[NEU] The Minion '" + minion.getInternalName() + " has parent!");
        }
    }

    public void setDirty() {
        this.dirty = true;
        this.readyToUse = false;
    }

    public boolean isReadyToUse() {
        return this.readyToUse;
    }
}

