/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;

public class MuseumPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_inventories = new ResourceLocation("notenoughupdates:pv_inventories.png");
    private static final ResourceLocation pv_museum = new ResourceLocation("notenoughupdates:pv_museum.png");
    private static final LinkedHashMap<String, ItemStack> museumCategories = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("weapons", Utils.createItemStack(Items.field_151048_u, EnumChatFormatting.GOLD + "Weapons", new String[0]));
            this.put("armor", Utils.createItemStack((Item)Items.field_151163_ad, EnumChatFormatting.GOLD + "Armor Sets", new String[0]));
            this.put("rarities", Utils.createSkull(EnumChatFormatting.GOLD + "Rarities", "b569ed03-94ae-3da9-a01d-9726633d5b8b", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODZhZGRiZDVkZWRhZDQwOTk5NDczYmU0YTdmNDhmNjIzNmE3OWEwZGNlOTcxYjVkYmQ3MzcyMDE0YWUzOTRkIn19fQ"));
            this.put("special", Utils.createItemStack(Items.field_151105_aU, EnumChatFormatting.GOLD + "Special Items", new String[0]));
        }
    };
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    private static String selectedMuseumCategory = "weapons";
    JsonObject museum = Constants.MUSEUM;
    int pageArrowsHeight = 34;
    int pages = 0;
    int onPage = 1;
    String currentItemSelected = null;
    JsonArray selectedItem = null;
    int overlay = new Color(0, 0, 0, 100).getRGB();
    private static final int searchBarSizeX = 120;
    private static final int searchBarSizeY = 20;

    public MuseumPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        this.getInstance().museumTextField.setSize(120, 20);
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_museum);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        SkyblockProfiles.SkyblockProfile.MuseumData museumData = selectedProfile.getMuseumData();
        long value = museumData.getValue();
        if (value == -2L) {
            String message = EnumChatFormatting.RED + "Museum API Disabled!";
            Utils.drawStringCentered(message, guiLeft + 250, guiTop + 101, true, 0);
            return;
        }
        if (value == -1L) {
            String message = EnumChatFormatting.YELLOW + "Museum Data Loading!";
            Utils.drawStringCentered(message, guiLeft + 250, guiTop + 101, true, 0);
            return;
        }
        if (value == -3L || this.museum == null) {
            String message = EnumChatFormatting.RED + "Missing Repo Data!";
            Utils.drawStringCentered(message, guiLeft + 250, guiTop + 101, true, 0);
            return;
        }
        this.getInstance().museumTextField.render(guiLeft + 251 - 60, guiTop + this.getInstance().sizeY - 26 - 20);
        int xIndex = 0;
        for (Map.Entry<String, ItemStack> entry : museumCategories.entrySet()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            if (entry.getKey().equals(selectedMuseumCategory)) {
                Utils.drawTexturedRect(guiLeft + 16 + 34 * xIndex, guiTop + 172, 20.0f, 20.0f, 0.078125f, 0.0f, 0.078125f, 0.0f, 9728);
                Utils.drawItemStackWithText(entry.getValue(), guiLeft + 19 + 34 * xIndex, guiTop + 175, "" + (xIndex + 1));
            } else {
                Utils.drawTexturedRect(guiLeft + 16 + 34 * xIndex, guiTop + 172, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
                Utils.drawItemStackWithText(entry.getValue(), guiLeft + 18 + 34 * xIndex, guiTop + 174, "" + (xIndex + 1));
            }
            ++xIndex;
        }
        Utils.renderAlignedString(EnumChatFormatting.GOLD + "Museum Value", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(value), guiLeft + 21, guiTop + 25, 114);
        int donated = museumData.getWeaponItems().size() + museumData.getArmorItems().size() + museumData.getRaritiesItems().size();
        Utils.renderAlignedString(EnumChatFormatting.BLUE + "Total Donations", EnumChatFormatting.WHITE + "" + donated, guiLeft + 21, guiTop + 45, 114);
        int maximum = this.getMaximum("total");
        this.getInstance().renderBar(guiLeft + 20, guiTop + 55, 116.0f, (float)donated / (float)maximum);
        donated = museumData.getWeaponItems().size();
        Utils.renderAlignedString(EnumChatFormatting.BLUE + "Weapons Donated", EnumChatFormatting.WHITE + "" + donated, guiLeft + 21, guiTop + 70, 114);
        maximum = this.getMaximum("weapons");
        this.getInstance().renderBar(guiLeft + 20, guiTop + 80, 116.0f, (float)donated / (float)maximum);
        donated = museumData.getArmorItems().size();
        Utils.renderAlignedString(EnumChatFormatting.BLUE + "Armor Donated", EnumChatFormatting.WHITE + "" + donated, guiLeft + 21, guiTop + 95, 114);
        maximum = this.getMaximum("armor");
        this.getInstance().renderBar(guiLeft + 20, guiTop + 105, 116.0f, (float)donated / (float)maximum);
        donated = museumData.getRaritiesItems().size();
        Utils.renderAlignedString(EnumChatFormatting.BLUE + "Rarities Donated", EnumChatFormatting.WHITE + "" + donated, guiLeft + 21, guiTop + 120, 114);
        maximum = this.getMaximum("rarities");
        this.getInstance().renderBar(guiLeft + 20, guiTop + 130, 116.0f, (float)donated / (float)maximum);
        donated = museumData.getSpecialItems().size();
        Utils.renderAlignedString(EnumChatFormatting.BLUE + "Special Items Donated", EnumChatFormatting.WHITE + String.valueOf(donated), guiLeft + 21, guiTop + 145, 114);
        Utils.drawStringCentered(museumCategories.get(selectedMuseumCategory).func_82833_r(), guiLeft + 251, guiTop + 14, true, 0x404040);
        if (this.pages == 0) {
            this.setPage(selectedMuseumCategory);
        }
        boolean leftHovered = false;
        boolean rightHovered = false;
        if (Mouse.isButtonDown((int)0) && mouseY > guiTop + this.pageArrowsHeight && mouseY < guiTop + this.pageArrowsHeight + 16 && mouseX > guiLeft + 251 - 12 && mouseX < guiLeft + 251 + 12) {
            if (mouseX < guiLeft + 251) {
                leftHovered = true;
            } else {
                rightHovered = true;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.resource_packs);
        if (this.onPage > 1) {
            Utils.drawTexturedRect(guiLeft + 251 - 12, guiTop + this.pageArrowsHeight, 12.0f, 16.0f, 0.11328125f, 0.20703125f, !leftHovered ? 0.0f : 0.125f, !leftHovered ? 0.125f : 0.25f, 9728);
        }
        if (this.onPage < this.pages && this.pages != 1) {
            Utils.drawTexturedRect(guiLeft + 251, guiTop + this.pageArrowsHeight, 12.0f, 16.0f, 0.01953125f, 0.11328125f, !rightHovered ? 0.0f : 0.125f, !rightHovered ? 0.125f : 0.25f, 9728);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
        int inventoryRows = 4;
        int invSizeY = inventoryRows * 18 + 17 + 7;
        int inventoryX = guiLeft + 251 - 88;
        int inventoryY = guiTop + 101 - invSizeY / 2;
        this.getInstance().func_73729_b(inventoryX, inventoryY, 0, 0, 176, inventoryRows * 18 + 17);
        this.getInstance().func_73729_b(inventoryX, inventoryY + inventoryRows * 18 + 17, 0, 215, 176, 7);
        JsonArray categoryItems = new JsonArray();
        Map<Object, Object> categoryDonated = new HashMap();
        switch (selectedMuseumCategory) {
            case "weapons": {
                categoryItems = this.museum.get("weapons").getAsJsonArray();
                categoryDonated = museumData.getWeaponItems();
                break;
            }
            case "armor": {
                categoryItems = this.museum.get("armor").getAsJsonArray();
                categoryDonated = museumData.getArmorItems();
                break;
            }
            case "rarities": {
                categoryItems = this.museum.get("rarities").getAsJsonArray();
                categoryDonated = museumData.getRaritiesItems();
                break;
            }
            case "special": {
                this.pages = (int)Math.ceil((double)donated / 28.0);
                if (this.pages == 0) {
                    this.pages = 1;
                }
                List<JsonArray> specialItems = museumData.getSpecialItems();
                int startIndex = (this.onPage - 1) * 28;
                int endIndex = Math.min(startIndex + 28, specialItems.size());
                int row = 0;
                int slot = 0;
                for (int i = startIndex; i < endIndex; ++i) {
                    JsonArray items2 = specialItems.get(i);
                    JsonObject item = (JsonObject)items2.get(0);
                    ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(item, false);
                    if (slot % 7 == 0 && slot > 1) {
                        slot = 0;
                        ++row;
                    }
                    int x = guiLeft + (inventoryX - guiLeft) + 8 + slot * 18 + 18;
                    int y = guiTop + 71 + row * 18;
                    ++slot;
                    if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
                        this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                        String itemID = item.get("internalname").getAsString();
                        if (Mouse.isButtonDown((int)0) && museumData.getSavedItems().containsKey(itemID)) {
                            this.selectedItem = items2;
                            this.currentItemSelected = itemID;
                        }
                    }
                    Utils.drawItemStack(stack, x, y);
                    this.highlightMatchingItem(stack, x, y);
                }
                break;
            }
        }
        if (categoryItems != null) {
            int row = 0;
            int slot = 0;
            int startIndex = (this.onPage - 1) * 28;
            int endIndex = Math.min(startIndex + 28, categoryItems.size());
            for (int i = startIndex; i < endIndex; ++i) {
                boolean actualItem = false;
                JsonElement donatedItem = categoryItems.get(i);
                String itemID = donatedItem.getAsString();
                if (slot % 7 == 0 && slot > 1) {
                    slot = 0;
                    ++row;
                }
                int x = guiLeft + (inventoryX - guiLeft) + 8 + slot * 18 + 18;
                int y = guiTop + 71 + row * 18;
                ++slot;
                JsonObject nameMappings = this.museum.get("armor_to_id").getAsJsonObject();
                String mappedName = itemID;
                if (nameMappings.has(itemID)) {
                    mappedName = nameMappings.get(itemID).getAsString();
                }
                String displayName = NotEnoughUpdates.INSTANCE.manager.getDisplayName(mappedName);
                ItemStack stack = Utils.createItemStack(Items.field_151100_aR, displayName, 8, EnumChatFormatting.RED + "Missing");
                JsonArray items3 = new JsonArray();
                if (categoryDonated.containsKey(itemID)) {
                    items3 = (JsonArray)categoryDonated.get(itemID);
                    JsonObject item = (JsonObject)items3.get(0);
                    if (!Objects.equals(item.get("internalname").getAsString(), "_")) {
                        actualItem = true;
                    }
                    stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(item, false);
                }
                if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
                    if (Mouse.isButtonDown((int)0) && museumData.getSavedItems().containsKey(itemID) && actualItem) {
                        this.selectedItem = items3;
                        this.currentItemSelected = itemID;
                    }
                    this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                }
                Utils.drawItemStack(stack, x, y);
                this.highlightMatchingItem(stack, x, y);
            }
        }
        if (this.currentItemSelected != null) {
            int size = this.selectedItem.size();
            int startX = guiLeft + 375 + 5;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_inventories);
            switch (size) {
                case 1: {
                    Utils.drawTexturedRect(guiLeft + 375, guiTop + 100, 26.0f, 32.0f, 0.7425743f, 1.0f, 0.6831683f, 1.0f, 9728);
                    break;
                }
                case 3: {
                    Utils.drawTexturedRect(guiLeft + 375, guiTop + 100, 26.0f, 68.0f, 0.7425743f, 1.0f, 0.0f, 0.6732673f, 9728);
                    break;
                }
                case 4: {
                    Utils.drawTexturedRect(guiLeft + 375, guiTop + 100, 26.0f, 86.0f, 0.46534654f, 0.7227723f, 0.0f, 0.85148513f, 9728);
                    break;
                }
                default: {
                    Utils.drawTexturedRect(guiLeft + 365, guiTop + 100, 45.0f, 86.0f, 0.0f, 0.44554454f, 0.0f, 0.85148513f, 9728);
                    startX = guiLeft + 365 + 5;
                }
            }
            int startY = guiTop + 100 + 8;
            int row = 0;
            int column = 0;
            boolean is_five = false;
            if (size == 5) {
                size = 8;
                is_five = true;
            }
            for (int i = 0; i < size; ++i) {
                ItemStack stack = new ItemStack(Blocks.field_180401_cv);
                if (!is_five || i < 5) {
                    JsonObject item = (JsonObject)this.selectedItem.get(i);
                    stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(item, false);
                }
                if (row % 4 == 0 && row > 1) {
                    column = 1;
                    row = 0;
                }
                int x = startX + column * 19;
                int y = startY + row * 18;
                Utils.drawItemStack(stack, x, y);
                if (!(mouseX < x || mouseX > x + 16 || mouseY < y || mouseY > y + 16 || is_five && i >= 5)) {
                    this.getInstance().tooltipToDisplay = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                }
                ++row;
            }
            Pair<Long, Boolean> itemData = museumData.getSavedItems().get(this.currentItemSelected);
            String donationStatus = (Boolean)itemData.getRight() != false ? EnumChatFormatting.YELLOW + "Borrowing" : EnumChatFormatting.GREEN + "In Museum";
            String donationTime = Utils.timeSinceMillisecond((Long)itemData.getLeft());
            Utils.drawStringCentered(EnumChatFormatting.BLUE + "Donated", guiLeft + 391, guiTop + 35, true, 0x404040);
            Utils.drawStringCentered(EnumChatFormatting.WHITE + donationTime, guiLeft + 391, guiTop + 47, true, 0x404040);
            Utils.drawStringCentered(EnumChatFormatting.BLUE + "Currently", guiLeft + 391, guiTop + 70, true, 0x404040);
            Utils.drawStringCentered(donationStatus, guiLeft + 391, guiTop + 82, true, 0x404040);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        int xIndex = 0;
        for (Map.Entry<String, ItemStack> entry : museumCategories.entrySet()) {
            if (mouseX > guiLeft + 16 + 34 * xIndex && mouseX < guiLeft + 16 + 34 * xIndex + 20 && mouseY > guiTop + 172 && mouseY < guiTop + 172 + 20) {
                this.setPage(entry.getKey());
                Utils.playPressSound();
                return;
            }
            ++xIndex;
        }
        if (mouseY > guiTop + this.pageArrowsHeight && mouseY < guiTop + this.pageArrowsHeight + 16 && mouseX > guiLeft + 251 - 12 && mouseX < guiLeft + 251 + 12) {
            if (mouseX < guiLeft + 251) {
                if (this.onPage > 1) {
                    --this.onPage;
                }
            } else if (this.onPage < this.pages) {
                ++this.onPage;
            }
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        switch (keyCode) {
            case 2: 
            case 79: {
                this.setPage("weapons");
                break;
            }
            case 3: 
            case 80: {
                this.setPage("armor");
                break;
            }
            case 4: 
            case 81: {
                this.setPage("rarities");
                break;
            }
            case 5: 
            case 75: {
                this.setPage("special");
                break;
            }
            default: {
                this.getInstance().museumTextField.keyTyped(typedChar, keyCode);
                return;
            }
        }
        Utils.playPressSound();
        this.getInstance().museumTextField.keyTyped(typedChar, keyCode);
    }

    private void setPage(String pageName) {
        selectedMuseumCategory = pageName;
        this.onPage = 1;
        this.pages = (int)Math.ceil((double)this.getMaximum(pageName) / 28.0);
    }

    private int getMaximum(String name) {
        JsonObject maxValues;
        if (this.museum != null && this.museum.has("max_values") && (maxValues = this.museum.get("max_values").getAsJsonObject()).has(name)) {
            return maxValues.get(name).getAsInt();
        }
        return 1;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        this.getInstance().museumTextField.setSize(120, 20);
        if (mouseX > guiLeft + 251 - 60 && mouseX < guiLeft + 251 + 60 && mouseY > guiTop + this.getInstance().sizeY - 26 - 20 && mouseY < guiTop + this.getInstance().sizeY - 26) {
            this.getInstance().museumTextField.mouseClicked(mouseX, mouseY, mouseButton);
            this.getInstance().playerNameTextField.otherComponentClick();
            return true;
        }
        return false;
    }

    private void highlightMatchingItem(ItemStack stack, int x, int y) {
        if (!(this.getInstance().museumTextField.getText() == null || this.getInstance().museumTextField.getText().isEmpty() || stack != null && NotEnoughUpdates.INSTANCE.manager.doesStackMatchSearch(stack, this.getInstance().museumTextField.getText()))) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
            GuiScreen.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)this.overlay);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
        }
    }
}

