/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.util.UrsaClient;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ProfileViewer {
    private static final LinkedHashMap<String, ItemStack> skillToSkillDisplayMap = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("taming", Utils.createItemStack(Items.field_151063_bx, EnumChatFormatting.LIGHT_PURPLE + "Taming", new String[0]));
            this.put("mining", Utils.createItemStack(Items.field_151050_s, EnumChatFormatting.GRAY + "Mining", new String[0]));
            this.put("foraging", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150345_g), EnumChatFormatting.DARK_GREEN + "Foraging", new String[0]));
            this.put("enchanting", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150381_bn), EnumChatFormatting.GREEN + "Enchanting", new String[0]));
            this.put("carpentry", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150462_ai), EnumChatFormatting.DARK_RED + "Carpentry", new String[0]));
            this.put("farming", Utils.createItemStack(Items.field_151013_M, EnumChatFormatting.YELLOW + "Farming", new String[0]));
            this.put("combat", Utils.createItemStack(Items.field_151052_q, EnumChatFormatting.RED + "Combat", new String[0]));
            this.put("fishing", Utils.createItemStack((Item)Items.field_151112_aM, EnumChatFormatting.AQUA + "Fishing", new String[0]));
            this.put("alchemy", Utils.createItemStack(Items.field_151067_bt, EnumChatFormatting.BLUE + "Alchemy", new String[0]));
            this.put("runecrafting", Utils.createItemStack(Items.field_151064_bs, EnumChatFormatting.DARK_PURPLE + "Runecrafting", new String[0]));
            this.put("social", Utils.createItemStack(Items.field_151166_bC, EnumChatFormatting.DARK_GREEN + "Social", new String[0]));
            this.put("zombie", Utils.createItemStack(Items.field_151078_bh, EnumChatFormatting.GOLD + "Rev Slayer", new String[0]));
            this.put("spider", Utils.createItemStack(Items.field_151070_bp, EnumChatFormatting.GOLD + "Tara Slayer", new String[0]));
            this.put("wolf", Utils.createItemStack(Items.field_151103_aS, EnumChatFormatting.GOLD + "Sven Slayer", new String[0]));
            this.put("enderman", Utils.createItemStack(Items.field_151079_bi, EnumChatFormatting.GOLD + "Ender Slayer", new String[0]));
            this.put("blaze", Utils.createItemStack(Items.field_151072_bj, EnumChatFormatting.GOLD + "Blaze Slayer", new String[0]));
            this.put("vampire", Utils.createItemStack(Items.field_151137_ax, EnumChatFormatting.GOLD + "Vampire Slayer", new String[0]));
        }
    };
    private static final ItemStack CAT_FARMING = Utils.createItemStack(Items.field_151013_M, EnumChatFormatting.YELLOW + "Farming", new String[0]);
    private static final ItemStack CAT_MINING = Utils.createItemStack(Items.field_151050_s, EnumChatFormatting.GRAY + "Mining", new String[0]);
    private static final ItemStack CAT_COMBAT = Utils.createItemStack(Items.field_151052_q, EnumChatFormatting.RED + "Combat", new String[0]);
    private static final ItemStack CAT_FORAGING = Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150345_g), EnumChatFormatting.DARK_GREEN + "Foraging", new String[0]);
    private static final ItemStack CAT_FISHING = Utils.createItemStack((Item)Items.field_151112_aM, EnumChatFormatting.AQUA + "Fishing", new String[0]);
    private static final ItemStack CAT_RIFT = Utils.createItemStack((Block)Blocks.field_150391_bh, EnumChatFormatting.DARK_PURPLE + "Rift", new String[0]);
    private static final LinkedHashMap<ItemStack, List<String>> collectionCatToCollectionMap = new LinkedHashMap<ItemStack, List<String>>(){
        {
            this.put(CAT_FARMING, Utils.createList("WHEAT", "CARROT_ITEM", "POTATO_ITEM", "PUMPKIN", "MELON", "SEEDS", "MUSHROOM_COLLECTION", "INK_SACK:3", "CACTUS", "SUGAR_CANE", "FEATHER", "LEATHER", "PORK", "RAW_CHICKEN", "MUTTON", "RABBIT", "NETHER_STALK"));
            this.put(CAT_MINING, Utils.createList("COBBLESTONE", "COAL", "IRON_INGOT", "GOLD_INGOT", "DIAMOND", "INK_SACK:4", "EMERALD", "REDSTONE", "QUARTZ", "OBSIDIAN", "GLOWSTONE_DUST", "GRAVEL", "ICE", "NETHERRACK", "SAND", "ENDER_STONE", null, "MITHRIL_ORE", "HARD_STONE", "GEMSTONE_COLLECTION", "MYCEL", "SAND:1", "SULPHUR_ORE", "GLACITE", "TUNGSTEN", "UMBER"));
            this.put(CAT_COMBAT, Utils.createList("ROTTEN_FLESH", "BONE", "STRING", "SPIDER_EYE", "SULPHUR", "ENDER_PEARL", "GHAST_TEAR", "SLIME_BALL", "BLAZE_ROD", "MAGMA_CREAM", null, null, null, null, "CHILI_PEPPER"));
            this.put(CAT_FORAGING, Utils.createList("LOG", "LOG:1", "LOG:2", "LOG_2:1", "LOG_2", "LOG:3", null));
            this.put(CAT_FISHING, Utils.createList("RAW_FISH", "RAW_FISH:1", "RAW_FISH:2", "RAW_FISH:3", "PRISMARINE_SHARD", "PRISMARINE_CRYSTALS", "CLAY_BALL", "WATER_LILY", "INK_SACK", "SPONGE", "MAGMA_FISH"));
            this.put(CAT_RIFT, Utils.createList("AGARICUS_CAP", "CADUCOUS_STEM", "HALF_EATEN_CARROT", "HEMOVIBE", "METAL_HEART", "WILTED_BERBERIS", "TIMITE"));
        }
    };
    private static final LinkedHashMap<ItemStack, List<String>> collectionCatToMinionMap = new LinkedHashMap<ItemStack, List<String>>(){
        {
            this.put(CAT_FARMING, Utils.createList("WHEAT", "CARROT", "POTATO", "PUMPKIN", "MELON", null, "MUSHROOM", "COCOA", "CACTUS", "SUGAR_CANE", "CHICKEN", "COW", "PIG", null, "SHEEP", "RABBIT", "NETHER_WARTS"));
            this.put(CAT_MINING, Utils.createList("COBBLESTONE", "COAL", "IRON", "GOLD", "DIAMOND", "LAPIS", "EMERALD", "REDSTONE", "QUARTZ", "OBSIDIAN", "GLOWSTONE", "GRAVEL", "ICE", null, "SAND", "ENDER_STONE", "SNOW", "MITHRIL", "HARD_STONE", null, "MYCELIUM", "RED_SAND", null, null, null, null));
            this.put(CAT_COMBAT, Utils.createList("ZOMBIE", "SKELETON", "SPIDER", "CAVESPIDER", "CREEPER", "ENDERMAN", "GHAST", "SLIME", "BLAZE", "MAGMA_CUBE", "REVENANT", "TARANTULA", "VOIDLING", "INFERNO"));
            this.put(CAT_FORAGING, Utils.createList("OAK", "SPRUCE", "BIRCH", "DARK_OAK", "ACACIA", "JUNGLE", "FLOWER"));
            this.put(CAT_FISHING, Utils.createList("FISHING", null, null, null, null, null, "CLAY", null, null, null));
            this.put(CAT_RIFT, Utils.createList(null, null, null, "VAMPIRE"));
        }
    };
    private static final LinkedHashMap<String, ItemStack> collectionToCollectionDisplayMap = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("WHEAT", Utils.createItemStack(Items.field_151015_O, EnumChatFormatting.YELLOW + "Wheat", new String[0]));
            this.put("CARROT_ITEM", Utils.createItemStack(Items.field_151172_bF, EnumChatFormatting.YELLOW + "Carrot", new String[0]));
            this.put("POTATO_ITEM", Utils.createItemStack(Items.field_151174_bG, EnumChatFormatting.YELLOW + "Potato", new String[0]));
            this.put("PUMPKIN", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150423_aK), EnumChatFormatting.YELLOW + "Pumpkin", new String[0]));
            this.put("MELON", Utils.createItemStack(Items.field_151127_ba, EnumChatFormatting.YELLOW + "Melon", new String[0]));
            this.put("SEEDS", Utils.createItemStack(Items.field_151014_N, EnumChatFormatting.YELLOW + "Seeds", new String[0]));
            this.put("MUSHROOM_COLLECTION", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150337_Q), EnumChatFormatting.YELLOW + "Mushroom", new String[0]));
            this.put("INK_SACK:3", Utils.createItemStack(Items.field_151100_aR, EnumChatFormatting.YELLOW + "Cocoa Beans", 3, new String[0]));
            this.put("CACTUS", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150434_aF), EnumChatFormatting.YELLOW + "Cactus", new String[0]));
            this.put("SUGAR_CANE", Utils.createItemStack(Items.field_151120_aE, EnumChatFormatting.YELLOW + "Sugar Cane", new String[0]));
            this.put("FEATHER", Utils.createItemStack(Items.field_151008_G, EnumChatFormatting.YELLOW + "Feather", new String[0]));
            this.put("LEATHER", Utils.createItemStack(Items.field_151116_aA, EnumChatFormatting.YELLOW + "Leather", new String[0]));
            this.put("PORK", Utils.createItemStack(Items.field_151147_al, EnumChatFormatting.YELLOW + "Raw Porkchop", new String[0]));
            this.put("RAW_CHICKEN", Utils.createItemStack(Items.field_151076_bf, EnumChatFormatting.YELLOW + "Raw Chicken", new String[0]));
            this.put("MUTTON", Utils.createItemStack(Items.field_179561_bm, EnumChatFormatting.YELLOW + "Mutton", new String[0]));
            this.put("RABBIT", Utils.createItemStack(Items.field_179558_bo, EnumChatFormatting.YELLOW + "Raw Rabbit", new String[0]));
            this.put("NETHER_STALK", Utils.createItemStack(Items.field_151075_bm, EnumChatFormatting.YELLOW + "Nether Wart", new String[0]));
            this.put("COBBLESTONE", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), EnumChatFormatting.GRAY + "Cobblestone", new String[0]));
            this.put("COAL", Utils.createItemStack(Items.field_151044_h, EnumChatFormatting.GRAY + "Coal", new String[0]));
            this.put("IRON_INGOT", Utils.createItemStack(Items.field_151042_j, EnumChatFormatting.GRAY + "Iron Ingot", new String[0]));
            this.put("GOLD_INGOT", Utils.createItemStack(Items.field_151043_k, EnumChatFormatting.GRAY + "Gold Ingot", new String[0]));
            this.put("DIAMOND", Utils.createItemStack(Items.field_151045_i, EnumChatFormatting.GRAY + "Diamond", new String[0]));
            this.put("INK_SACK:4", Utils.createItemStack(Items.field_151100_aR, EnumChatFormatting.GRAY + "Lapis Lazuli", 4, new String[0]));
            this.put("EMERALD", Utils.createItemStack(Items.field_151166_bC, EnumChatFormatting.GRAY + "Emerald", new String[0]));
            this.put("REDSTONE", Utils.createItemStack(Items.field_151137_ax, EnumChatFormatting.GRAY + "Redstone", new String[0]));
            this.put("QUARTZ", Utils.createItemStack(Items.field_151128_bU, EnumChatFormatting.GRAY + "Nether Quartz", new String[0]));
            this.put("OBSIDIAN", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z), EnumChatFormatting.GRAY + "Obsidian", new String[0]));
            this.put("GLOWSTONE_DUST", Utils.createItemStack(Items.field_151114_aO, EnumChatFormatting.GRAY + "Glowstone Dust", new String[0]));
            this.put("GRAVEL", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), EnumChatFormatting.GRAY + "Gravel", new String[0]));
            this.put("ICE", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150432_aD), EnumChatFormatting.GRAY + "Ice", new String[0]));
            this.put("NETHERRACK", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150424_aL), EnumChatFormatting.GRAY + "Netherrack", new String[0]));
            this.put("SAND", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), EnumChatFormatting.GRAY + "Sand", new String[0]));
            this.put("ENDER_STONE", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150377_bs), EnumChatFormatting.GRAY + "End Stone", new String[0]));
            this.put("MITHRIL_ORE", Utils.createItemStack(Items.field_179563_cD, EnumChatFormatting.GRAY + "Mithril", new String[0]));
            this.put("HARD_STONE", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150348_b), EnumChatFormatting.GRAY + "Hard Stone", new String[0]));
            this.put("GEMSTONE_COLLECTION", Utils.createSkull(EnumChatFormatting.GRAY + "Gemstone", "e942eb66-a350-38e5-aafa-0dfc3e17b4ac", "ewogICJ0aW1lc3RhbXAiIDogMTYxODA4Mzg4ODc3MSwKICAicHJvZmlsZUlkIiA6ICJjNTBhZmE4YWJlYjk0ZTQ1OTRiZjFiNDI1YTk4MGYwMiIsCiAgInByb2ZpbGVOYW1lIiA6ICJUd29FQmFlIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2FhYzE1ZjZmY2YyY2U5NjNlZjRjYTcxZjFhODY4NWFkYjk3ZWI3NjllMWQxMTE5NGNiYmQyZTk2NGE4ODk3OGMiCiAgICB9CiAgfQp9"));
            this.put("MYCEL", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150391_bh), EnumChatFormatting.GRAY + "Mycelium", new String[0]));
            this.put("SAND:1", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), EnumChatFormatting.GRAY + "Red Sand", 1, new String[0]));
            this.put("SULPHUR_ORE", Utils.createItemStack(Items.field_151114_aO, EnumChatFormatting.GRAY + "Sulphur", new String[0]));
            this.put("GLACITE", Utils.createItemStack(Blocks.field_150403_cj, EnumChatFormatting.GRAY + "Glacite", new String[0]));
            this.put("TUNGSTEN", Utils.createSkull(EnumChatFormatting.GRAY + "Tungsten", "b0ac8270-ac1b-325c-9e2c-e679e0f48684", "ewogICJ0aW1lc3RhbXAiIDogMTcwODkxNDY4MjE4MCwKICAicHJvZmlsZUlkIiA6ICJiZDNhNWRmY2ZkZjg0NDczOTViZDJiZmUwNGY0YzAzMiIsCiAgInByb2ZpbGVOYW1lIiA6ICJwcmVja3Jhc25vIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Q4MTFmM2U3MjNiYmQ0NjM5M2Y4YWFkODU1NmIxZGY4ZWQzM2Y1NTliZTgyN2Y0N2ZlNzM2ZjcwNGMzNTU4NmUiCiAgICB9CiAgfQp9"));
            this.put("UMBER", Utils.createSkull(EnumChatFormatting.GRAY + "Umber", "bfb54c8e-93b8-3196-841c-5c8892d59f10", "ewogICJ0aW1lc3RhbXAiIDogMTcwODkxOTkzMjc2MSwKICAicHJvZmlsZUlkIiA6ICJiMmM5ZTUyZjNhODU0YzQ4YmJjMmMwM2JjM2U0NzdiMiIsCiAgInByb2ZpbGVOYW1lIiA6ICJJU05FRVpFREFUWU9VIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2I1NjViNWFhODNkNGFhN2Y3YWYyMmRjMTI3MWIyZjBiMjc0NDFmOWFjMTQ5NWY2YjQ2NTNjZjY4ZGZiMTA1ZWYiCiAgICB9CiAgfQp9"));
            this.put("ROTTEN_FLESH", Utils.createItemStack(Items.field_151078_bh, EnumChatFormatting.RED + "Rotten Flesh", new String[0]));
            this.put("BONE", Utils.createItemStack(Items.field_151103_aS, EnumChatFormatting.RED + "Bone", new String[0]));
            this.put("STRING", Utils.createItemStack(Items.field_151007_F, EnumChatFormatting.RED + "String", new String[0]));
            this.put("SPIDER_EYE", Utils.createItemStack(Items.field_151070_bp, EnumChatFormatting.RED + "Spider Eye", new String[0]));
            this.put("SULPHUR", Utils.createItemStack(Items.field_151016_H, EnumChatFormatting.RED + "Gunpowder", new String[0]));
            this.put("ENDER_PEARL", Utils.createItemStack(Items.field_151079_bi, EnumChatFormatting.RED + "Ender Pearl", new String[0]));
            this.put("GHAST_TEAR", Utils.createItemStack(Items.field_151073_bk, EnumChatFormatting.RED + "Ghast Tear", new String[0]));
            this.put("SLIME_BALL", Utils.createItemStack(Items.field_151123_aH, EnumChatFormatting.RED + "Slimeball", new String[0]));
            this.put("BLAZE_ROD", Utils.createItemStack(Items.field_151072_bj, EnumChatFormatting.RED + "Blaze Rod", new String[0]));
            this.put("MAGMA_CREAM", Utils.createItemStack(Items.field_151064_bs, EnumChatFormatting.RED + "Magma Cream", new String[0]));
            this.put("CHILI_PEPPER", Utils.createSkull(EnumChatFormatting.RED + "Chili Pepper", "3d47abaa-b40b-3826-b20c-d83a7f053bd9", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjg1OWM4ZGYxMTA5YzA4YTc1NjI3NWYxZDI4ODdjMjc0ODA0OWZlMzM4Nzc3NjlhN2I0MTVkNTZlZGE0NjlkOCJ9fX0"));
            this.put("LOG", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), EnumChatFormatting.DARK_GREEN + "Oak Wood", new String[0]));
            this.put("LOG:1", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), EnumChatFormatting.DARK_GREEN + "Spruce Wood", 1, new String[0]));
            this.put("LOG:2", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), EnumChatFormatting.DARK_GREEN + "Birch Wood", 2, new String[0]));
            this.put("LOG_2:1", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150363_s), EnumChatFormatting.DARK_GREEN + "Dark Oak Wood", 1, new String[0]));
            this.put("LOG_2", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150363_s), EnumChatFormatting.DARK_GREEN + "Acacia Wood", new String[0]));
            this.put("LOG:3", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), EnumChatFormatting.DARK_GREEN + "Jungle Wood", 3, new String[0]));
            this.put("RAW_FISH", Utils.createItemStack(Items.field_151115_aP, EnumChatFormatting.AQUA + "Raw Fish", new String[0]));
            this.put("RAW_FISH:1", Utils.createItemStack(Items.field_151115_aP, EnumChatFormatting.AQUA + "Raw Salmon", 1, new String[0]));
            this.put("RAW_FISH:2", Utils.createItemStack(Items.field_151115_aP, EnumChatFormatting.AQUA + "Clownfish", 2, new String[0]));
            this.put("RAW_FISH:3", Utils.createItemStack(Items.field_151115_aP, EnumChatFormatting.AQUA + "Pufferfish", 3, new String[0]));
            this.put("PRISMARINE_SHARD", Utils.createItemStack(Items.field_179562_cC, EnumChatFormatting.AQUA + "Prismarine Shard", new String[0]));
            this.put("PRISMARINE_CRYSTALS", Utils.createItemStack(Items.field_179563_cD, EnumChatFormatting.AQUA + "Prismarine Crystals", new String[0]));
            this.put("CLAY_BALL", Utils.createItemStack(Items.field_151119_aD, EnumChatFormatting.AQUA + "Clay", new String[0]));
            this.put("WATER_LILY", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150392_bi), EnumChatFormatting.AQUA + "Lily Pad", new String[0]));
            this.put("INK_SACK", Utils.createItemStack(Items.field_151100_aR, EnumChatFormatting.AQUA + "Ink Sac", new String[0]));
            this.put("SPONGE", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150360_v), EnumChatFormatting.AQUA + "Sponge", new String[0]));
            this.put("MAGMA_FISH", Utils.createSkull(EnumChatFormatting.AQUA + "Magmafish", "5c53195c-5b98-3476-9731-c32647b22723", "ewogICJ0aW1lc3RhbXAiIDogMTY0MjQ4ODA3MDY2NiwKICAicHJvZmlsZUlkIiA6ICIzNDkxZjJiOTdjMDE0MWE2OTM2YjFjMjJhMmEwMGZiNyIsCiAgInByb2ZpbGVOYW1lIiA6ICJKZXNzc3N1aGgiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjU2YjU5NTViMjk1NTIyYzk2ODk0ODE5NjBjMDFhOTkyY2ExYzc3NTRjZjRlZTMxM2M4ZGQwYzM1NmQzMzVmIgogICAgfQogIH0KfQ"));
            this.put("AGARICUS_CAP", Utils.createSkull(EnumChatFormatting.DARK_PURPLE + "Agaricus Cap", "43e884b2-633e-3c87-b601-62d18c11683f", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNlMGEyMzBhY2Q2NDM2YWJjODZmMTNiZTcyZTliYTk0NTM3ZWU1NGYwMzI1YmI4NjI1NzdhMWUwNjJmMzcifX19"));
            this.put("CADUCOUS_STEM", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150398_cm), EnumChatFormatting.DARK_PURPLE + "Caducous Stem", 4, new String[0]));
            this.put("HALF_EATEN_CARROT", Utils.createItemStack(Items.field_151172_bF, EnumChatFormatting.DARK_PURPLE + "Half-Eaten Carrot", new String[0]));
            this.put("HEMOVIBE", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150450_ax), EnumChatFormatting.DARK_PURPLE + "Hemovibe", new String[0]));
            this.put("METAL_HEART", Utils.createSkull(EnumChatFormatting.DARK_PURPLE + "Living Metal Heart", "c678b8cc-c130-31d1-baf3-14660f8ef742", "ewogICJ0aW1lc3RhbXAiIDogMTY3NjQ3NjQ1NjcyNywKICAicHJvZmlsZUlkIiA6ICI5MGQ1NDY0OGEzNWE0YmExYTI2Yjg1YTg4NTU4OGJlOSIsCiAgInByb2ZpbGVOYW1lIiA6ICJFdW4wbWlhIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2YwMjc4ZWU1M2E1M2I3NzMzYzdiODQ1MmZjZjc5NGRmYmZiYzNiMDMyZTc1MGE2OTkzNTczYjViZDAyOTkxMzUiLAogICAgICAibWV0YWRhdGEiIDogewogICAgICAgICJtb2RlbCIgOiAic2xpbSIKICAgICAgfQogICAgfQogIH0KfQ"));
            this.put("WILTED_BERBERIS", Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150330_I), EnumChatFormatting.DARK_PURPLE + "Wilted Berberis", new String[0]));
            this.put("TIMITE", Utils.createSkull(EnumChatFormatting.DARK_PURPLE + "Timite", "268a3d23-43c7-3f4e-9c25-14c314e7126b", "ewogICJ0aW1lc3RhbXAiIDogMTcyNTMyNTgwNDE0MywKICAicHJvZmlsZUlkIiA6ICIxMTM1Njg1ZTk3ZGE0ZjYyYTliNDQ3MzA0NGFiZjQ0MSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNYXJpb1dsZXMiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDIxNzdhYzk5N2ZmOTcwOTAwY2QxNzkyN2ZiMzFjNGUyMGZhYzI2MzY0OWIxYjU1ODU1NWJjYzZmMGQ1YjVkZCIKICAgIH0KICB9Cn0="));
        }
    };
    private static final AtomicBoolean updatingResourceCollection = new AtomicBoolean(false);
    private static JsonObject resourceCollection = null;
    private final HashMap<String, JsonObject> uuidToHypixelProfile = new HashMap();
    private final NEUManager manager;
    private final HashMap<String, SkyblockProfiles> uuidToSkyblockProfiles = new HashMap();
    final HashMap<String, String> nameToUuid = new HashMap();

    public ProfileViewer(NEUManager manager) {
        this.manager = manager;
    }

    public static JsonObject getOrLoadCollectionsResource() {
        if (resourceCollection != null) {
            return resourceCollection;
        }
        if (updatingResourceCollection.get()) {
            return null;
        }
        updatingResourceCollection.set(true);
        NotEnoughUpdates.INSTANCE.manager.apiUtils.newAnonymousHypixelApiRequest("resources/skyblock/collections").requestJson().thenAccept(jsonObject -> {
            updatingResourceCollection.set(false);
            if (jsonObject != null && jsonObject.has("success") && jsonObject.get("success").getAsBoolean()) {
                resourceCollection = jsonObject.get("collections").getAsJsonObject();
            }
        });
        return null;
    }

    public void putNameUuid(String name, String uuid) {
        this.nameToUuid.put(name, uuid);
    }

    public void getPlayerUUID(String name, Consumer<String> uuidCallback) {
        String nameLower = name.toLowerCase(Locale.ROOT);
        if (this.nameToUuid.containsKey(nameLower)) {
            uuidCallback.accept(this.nameToUuid.get(nameLower));
            return;
        }
        this.manager.apiUtils.request().url("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + nameLower).requestJson().thenAccept(jsonObject -> {
            if (jsonObject.has("id") && jsonObject.get("id").isJsonPrimitive() && jsonObject.get("id").getAsJsonPrimitive().isString()) {
                String uuid = jsonObject.get("id").getAsString();
                this.nameToUuid.put(nameLower, uuid);
                uuidCallback.accept(uuid);
                return;
            }
            uuidCallback.accept(null);
        });
    }

    public void loadPlayerByName(String name, Consumer<SkyblockProfiles> callback) {
        String nameLower = name.toLowerCase(Locale.ROOT);
        if (this.nameToUuid.containsKey(nameLower) && this.nameToUuid.get(nameLower) == null) {
            callback.accept(null);
            return;
        }
        this.getPlayerUUID(nameLower, uuid -> {
            this.nameToUuid.put(nameLower, (String)uuid);
            if (uuid == null) {
                callback.accept(null);
            } else {
                if (!this.uuidToHypixelProfile.containsKey(uuid)) {
                    this.manager.ursaClient.get(UrsaClient.player(Utils.parseDashlessUUID(uuid))).thenAccept(playerJson -> {
                        if (playerJson != null && playerJson.has("success") && playerJson.get("success").getAsBoolean() && playerJson.get("player").isJsonObject()) {
                            this.uuidToHypixelProfile.put((String)uuid, playerJson.get("player").getAsJsonObject());
                        }
                    });
                }
                callback.accept(this.getOrLoadSkyblockProfiles((String)uuid, ignored -> {}));
            }
        });
    }

    public SkyblockProfiles getOrLoadSkyblockProfiles(String uuid, Consumer<SkyblockProfiles> callback) {
        SkyblockProfiles profile;
        if (this.uuidToSkyblockProfiles.containsKey(uuid)) {
            this.uuidToSkyblockProfiles.get(uuid).resetCache();
        }
        if ((profile = this.uuidToSkyblockProfiles.computeIfAbsent(uuid, key -> new SkyblockProfiles(this, uuid))).getNameToProfile() != null) {
            callback.accept(profile);
        } else {
            profile.getOrLoadSkyblockProfiles(() -> callback.accept(profile));
        }
        return profile;
    }

    public static LinkedHashMap<String, ItemStack> getSkillToSkillDisplayMap() {
        return skillToSkillDisplayMap;
    }

    public static LinkedHashMap<ItemStack, List<String>> getCollectionCatToCollectionMap() {
        return collectionCatToCollectionMap;
    }

    public static LinkedHashMap<ItemStack, List<String>> getCollectionCatToMinionMap() {
        return collectionCatToMinionMap;
    }

    public static LinkedHashMap<String, ItemStack> getCollectionToCollectionDisplayMap() {
        return collectionToCollectionDisplayMap;
    }

    public HashMap<String, JsonObject> getUuidToHypixelProfile() {
        return this.uuidToHypixelProfile;
    }

    public NEUManager getManager() {
        return this.manager;
    }

    public static class Level {
        public float level = 0.0f;
        public float maxXpForLevel = 0.0f;
        public boolean maxed = false;
        public int maxLevel;
        public float totalXp;
    }
}

