/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import io.github.moulberry.notenoughupdates.ItemPriceInformation;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class EssenceUpgrades
implements NeuRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/essence_upgrades_tall.png");
    private static final List<RenderLocation> buttonLocations = new ArrayList<RenderLocation>(){
        {
            this.add(new RenderLocation(20, 20));
            this.add(new RenderLocation(40, 20));
            this.add(new RenderLocation(60, 20));
            this.add(new RenderLocation(80, 20));
            this.add(new RenderLocation(100, 20));
            this.add(new RenderLocation(120, 20));
            this.add(new RenderLocation(140, 20));
            this.add(new RenderLocation(10, 40));
            this.add(new RenderLocation(30, 40));
            this.add(new RenderLocation(50, 40));
            this.add(new RenderLocation(70, 40));
            this.add(new RenderLocation(90, 40));
            this.add(new RenderLocation(110, 40));
            this.add(new RenderLocation(130, 40));
            this.add(new RenderLocation(150, 40));
        }
    };
    private static final List<RenderLocation> slotLocations = new ArrayList<RenderLocation>(){
        {
            this.add(new RenderLocation(20, 60));
            this.add(new RenderLocation(45, 60));
            this.add(new RenderLocation(70, 60));
            this.add(new RenderLocation(20, 85));
            this.add(new RenderLocation(45, 85));
            this.add(new RenderLocation(70, 85));
            this.add(new RenderLocation(20, 110));
            this.add(new RenderLocation(45, 110));
            this.add(new RenderLocation(70, 110));
        }
    };
    private static final Pattern loreStatPattern = Pattern.compile("^.+: \u00a7.\\+(?<value>[\\d.]+).*$");
    private final Ingredient output;
    private final ItemStack initialItemStack;
    private final Map<Integer, TierUpgrade> tierUpgradeMap;
    private final int amountOfTiers;
    private int selectedTier;
    private final List<ItemRequirement> catacombsItemRequirements;
    private static final int outputX = 124;
    private static final int outputY = 66;
    private List<RecipeSlot> slots;
    private GuiItemRecipe guiItemRecipe;

    public EssenceUpgrades(Ingredient output, Map<Integer, TierUpgrade> tierUpgradeMap, List<ItemRequirement> catacombsItemRequirements) {
        this.output = output;
        this.tierUpgradeMap = tierUpgradeMap;
        this.catacombsItemRequirements = catacombsItemRequirements;
        this.initialItemStack = output.getItemStack().func_77946_l();
        this.selectedTier = this.amountOfTiers = tierUpgradeMap.keySet().size();
        this.slots = new ArrayList<RecipeSlot>();
    }

    @Nullable
    public static NeuRecipe parseFromEssenceCostEntry(Map.Entry<String, JsonElement> entry) {
        NEUManager manager = NotEnoughUpdates.INSTANCE.manager;
        if (!manager.isValidInternalName(entry.getKey())) {
            System.err.println("Invalid internalname: " + entry.getKey());
            return null;
        }
        String internalName = entry.getKey();
        JsonObject jsonObject = entry.getValue().getAsJsonObject();
        Gson gson = new Gson();
        Ingredient output = new Ingredient(manager, internalName);
        if (!jsonObject.has("type")) {
            System.err.println("Invalid essence entry for: " + internalName);
            System.err.println("Missing: Essence type");
            return null;
        }
        String essenceType = jsonObject.get("type").getAsString();
        HashMap<Integer, TierUpgrade> upgradeMap = new HashMap<Integer, TierUpgrade>();
        for (Map.Entry<String, JsonElement> entries : jsonObject.entrySet()) {
            if (StringUtils.isNumeric(entries.getKey())) {
                int tier = Integer.parseInt(entries.getKey());
                int essenceCost = Integer.parseInt(entries.getValue().getAsString());
                upgradeMap.put(tier, new TierUpgrade(tier, essenceType, essenceCost, null));
                continue;
            }
            if (!entries.getKey().equals("items")) continue;
            for (Map.Entry<String, JsonElement> requiredItems : entries.getValue().getAsJsonObject().entrySet()) {
                Integer tier = Integer.parseInt(requiredItems.getKey());
                HashMap<String, Integer> items2 = new HashMap<String, Integer>();
                for (JsonElement element : requiredItems.getValue().getAsJsonArray()) {
                    String itemString = element.getAsString();
                    int colon = itemString.indexOf(58);
                    if (colon == -1) continue;
                    String amount = itemString.substring(colon + 1);
                    String requiredItem = itemString.substring(0, colon);
                    items2.put(requiredItem, Integer.parseInt(amount));
                }
                ((TierUpgrade)upgradeMap.get(tier)).itemsRequired = items2;
            }
        }
        ArrayList<ItemRequirement> catacombsItemRequirements = new ArrayList<ItemRequirement>(1);
        if (jsonObject.has("catacombs_requirements")) {
            JsonArray requirements = jsonObject.getAsJsonArray("catacombs_requirements");
            for (JsonElement requirement : requirements) {
                catacombsItemRequirements.add(gson.fromJson(requirement, ItemRequirement.class));
            }
        }
        return new EssenceUpgrades(output, upgradeMap, catacombsItemRequirements);
    }

    private List<RecipeSlot> buildSlotList() {
        ItemStack essenceItemStack;
        NEUManager manager = NotEnoughUpdates.INSTANCE.manager;
        ArrayList<RecipeSlot> slotList = new ArrayList<RecipeSlot>();
        String internalName = this.output.getInternalItemId();
        if (internalName == null) {
            return slotList;
        }
        List<String> lore = ItemUtils.getLore(this.initialItemStack);
        ArrayList<String> newLore = new ArrayList<String>();
        for (String loreEntry : lore) {
            Matcher matcher = loreStatPattern.matcher(loreEntry);
            if (matcher.matches()) {
                String valueString = matcher.group("value");
                if (valueString == null) {
                    newLore.add(loreEntry);
                    continue;
                }
                float value = Float.parseFloat(valueString);
                int matchStart = matcher.start("value");
                float newValue = value * (1.0f + (float)this.selectedTier / 50.0f);
                StringBuilder newLine = new StringBuilder(loreEntry.substring(0, matchStart) + String.format("%.1f", Float.valueOf(newValue)));
                if (loreEntry.length() - 1 > matcher.end("value")) {
                    newLine.append(loreEntry, matcher.end("value"), loreEntry.length() - 1);
                }
                newLore.add(newLine.toString());
                continue;
            }
            newLore.add(loreEntry);
        }
        for (ItemRequirement requirement : this.catacombsItemRequirements) {
            String loreEntry = requirement.buildLoreLine();
            List<String> lines = Arrays.asList(loreEntry.split("\n"));
            newLore.addAll(newLore.size() - 2, lines);
        }
        ItemUtils.setLore(this.output.getItemStack(), newLore);
        this.output.getItemStack().func_151001_c(this.initialItemStack.func_82833_r() + " " + Utils.getStarsString(this.selectedTier));
        slotList.add(new RecipeSlot(124, 66, this.output.getItemStack()));
        TierUpgrade tierUpgrade = this.tierUpgradeMap.get(this.selectedTier);
        if (tierUpgrade == null) {
            return slotList;
        }
        String essenceInternalName = "ESSENCE_" + tierUpgrade.getEssenceType().toUpperCase(Locale.ROOT);
        if (manager.isValidInternalName(essenceInternalName) && (essenceItemStack = manager.createItemResolutionQuery().withKnownInternalName(essenceInternalName).resolveToItemStack()) != null) {
            essenceItemStack = essenceItemStack.func_77946_l();
            essenceItemStack.func_151001_c(EnumChatFormatting.AQUA + StringUtils.formatNumber(tierUpgrade.getEssenceRequired()) + " " + EnumChatFormatting.DARK_GRAY + tierUpgrade.getEssenceType() + " Essence");
            essenceItemStack.func_77978_p().func_74768_a(ItemPriceInformation.STACKSIZE_OVERRIDE, tierUpgrade.getEssenceRequired());
            RenderLocation renderLocation = slotLocations.get(0);
            slotList.add(new RecipeSlot(renderLocation.getX() + 1, renderLocation.getY() + 1, essenceItemStack));
        }
        int i = 1;
        if (tierUpgrade.getItemsRequired() != null) {
            for (Map.Entry<String, Integer> requiredItem : tierUpgrade.getItemsRequired().entrySet()) {
                RenderLocation renderLocation;
                ItemStack itemStack;
                if (requiredItem.getKey().equals("SKYBLOCK_COIN")) {
                    Ingredient ingredient = Ingredient.coinIngredient(manager, requiredItem.getValue());
                    itemStack = ingredient.getItemStack();
                } else {
                    itemStack = manager.createItemResolutionQuery().withKnownInternalName(requiredItem.getKey()).resolveToItemStack();
                    if (itemStack != null) {
                        itemStack.field_77994_a = requiredItem.getValue();
                    }
                }
                if (itemStack == null || (renderLocation = slotLocations.get(i++)) == null) continue;
                slotList.add(new RecipeSlot(renderLocation.getX() + 1, renderLocation.getY() + 1, itemStack));
            }
        }
        return slotList;
    }

    private void drawSlot(int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        Utils.drawTexturedRect(x, y, 18.0f, 18.0f, 0.6875f, 0.7578125f, 0.0f, 0.0703125f);
    }

    private void drawButton(int x, int y, boolean selected) {
        if (selected) {
            Utils.drawTexturedRect(x, y, 16.0f, 16.0f, 0.6875f, 0.75f, 0.1328125f, 0.1953125f);
        } else {
            Utils.drawTexturedRect(x, y, 16.0f, 16.0f, 0.6875f, 0.75f, 0.0703125f, 0.1328125f);
        }
    }

    private void drawButtons(int mouseX, int mouseY) {
        for (int i = 0; i < this.amountOfTiers; ++i) {
            if (i >= buttonLocations.size()) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "[NEU] Error: Item has more than " + buttonLocations.size() + " possible star upgrades"));
                break;
            }
            RenderLocation buttonLocation = buttonLocations.get(i);
            int x = this.guiItemRecipe.guiLeft + buttonLocation.getX();
            int y = this.guiItemRecipe.guiTop + buttonLocation.getY();
            if (Mouse.getEventButtonState() && Utils.isWithinRect(mouseX, mouseY, x, y, 16, 16)) {
                this.selectedTier = i + 1;
                this.slots = this.buildSlotList();
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawButton(x, y, i + 1 == this.selectedTier);
            Utils.drawStringCentered(String.valueOf(i + 1), x + 8, y + 9, false, 2969596);
        }
    }

    private void drawSlots(int amount) {
        for (int i = 0; i < amount - 1; ++i) {
            RenderLocation renderLocation = slotLocations.get(i);
            if (renderLocation == null || this.guiItemRecipe == null) continue;
            this.drawSlot(this.guiItemRecipe.guiLeft + renderLocation.getX(), this.guiItemRecipe.guiTop + renderLocation.getY());
        }
    }

    @Override
    public void drawExtraInfo(GuiItemRecipe gui, int mouseX, int mouseY) {
        this.guiItemRecipe = gui;
        if (this.slots.isEmpty()) {
            this.slots = this.buildSlotList();
        }
        this.drawButtons(mouseX, mouseY);
    }

    @Override
    public void drawExtraBackground(GuiItemRecipe gui, int mouseX, int mouseY) {
        this.drawSlots(this.slots.size());
    }

    @Override
    public void handleKeyboardInput() {
        if (Keyboard.isRepeatEvent()) {
            return;
        }
        if (Keyboard.isKeyDown((int)203) && this.selectedTier > 1) {
            --this.selectedTier;
            this.slots = this.buildSlotList();
        } else if (Keyboard.isKeyDown((int)205) && this.selectedTier < this.amountOfTiers) {
            ++this.selectedTier;
            this.slots = this.buildSlotList();
        } else if (Keyboard.isKeyDown((int)11) || Keyboard.isKeyDown((int)82)) {
            this.selectedTier = this.selectedTier < this.amountOfTiers ? ++this.selectedTier : 1;
        }
        char pressedKey = Keyboard.getEventCharacter();
        if (Character.isDigit(pressedKey) && (pressedKey = (char)(pressedKey - 48)) > '\u0000' && pressedKey <= this.amountOfTiers) {
            this.selectedTier = pressedKey;
            this.slots = this.buildSlotList();
        }
    }

    @Override
    public Set<Ingredient> getIngredients() {
        return Collections.singleton(this.output);
    }

    @Override
    public Set<Ingredient> getOutputs() {
        return Collections.singleton(this.output);
    }

    @Override
    public List<RecipeSlot> getSlots() {
        return this.slots;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.ESSENCE_UPGRADES;
    }

    @Override
    public boolean hasVariableCost() {
        return false;
    }

    @Override
    @Nullable
    public JsonObject serialize() {
        return null;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    public static class TierUpgrade {
        private final int tier;
        private final String essenceType;
        private final int essenceRequired;
        private Map<String, Integer> itemsRequired;

        public TierUpgrade(int tier, String essenceType, int essenceRequired, Map<String, Integer> itemsRequired) {
            this.tier = tier;
            this.essenceType = essenceType;
            this.essenceRequired = essenceRequired;
            this.itemsRequired = itemsRequired;
        }

        public int getTier() {
            return this.tier;
        }

        public String getEssenceType() {
            return this.essenceType;
        }

        public int getEssenceRequired() {
            return this.essenceRequired;
        }

        public Map<String, Integer> getItemsRequired() {
            return this.itemsRequired;
        }
    }

    private static class RenderLocation {
        private final int x;
        private final int y;

        public RenderLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class ItemRequirement {
        private String type;
        @SerializedName(value="dungeon_type")
        private String dungeonType;
        private int level;

        public String buildLoreLine() {
            String line;
            if (this.type.equals("DUNGEON_SKILL")) {
                String readableDungeonType = WordUtils.capitalizeFully((String)this.dungeonType);
                line = "\u00a77\u00a74\u2763 \u00a7cRequires " + readableDungeonType + " Skill " + EnumChatFormatting.GREEN + this.level + "\n" + EnumChatFormatting.RED + "while in The " + readableDungeonType + ".";
            } else {
                line = "Unexpected Requirement: " + this.type;
            }
            return line;
        }

        public String getType() {
            return this.type;
        }

        public String getDungeonType() {
            return this.dungeonType;
        }

        public int getLevel() {
            return this.level;
        }

        public void setType(String type2) {
            this.type = type2;
        }

        public void setDungeonType(String dungeonType) {
            this.dungeonType = dungeonType;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }
}

