/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.miscgui.GuiNavigation;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class ItemShopRecipe
implements NeuRecipe {
    public static ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/item_shop_recipe.png");
    private static final int SLOT_IMAGE_U = 176;
    private static final int SLOT_IMAGE_V = 0;
    private static final int SLOT_IMAGE_SIZE = 18;
    public static final int RESULT_SLOT_Y = 66;
    public static final int RESULT_SLOT_X = 124;
    public static final int BUTTON_X = 130;
    public static final int BUTTON_Y = 16;
    private static final int COST_SLOT_X = 30;
    private static final int COST_SLOT_SPACING = 6;
    private static final int ROW_SPACING = 18;
    private final List<Ingredient> cost;
    private final Ingredient result;
    private boolean selected;
    private final Ingredient npcIngredient;
    private final boolean hasWaypoint;
    private final JsonObject npcObject;

    public ItemShopRecipe(Ingredient npcIngredient, List<Ingredient> cost, Ingredient result2, JsonObject npcObject) {
        this.npcIngredient = npcIngredient;
        this.cost = cost;
        this.result = result2;
        this.npcObject = npcObject;
        this.hasWaypoint = NotEnoughUpdates.INSTANCE.navigation.isValidWaypoint(npcObject);
    }

    @Override
    public Set<Ingredient> getCatalystItems() {
        return Sets.newHashSet((Object[])new Ingredient[]{this.npcIngredient});
    }

    @Override
    public Set<Ingredient> getIngredients() {
        return new HashSet<Ingredient>(this.cost);
    }

    @Override
    public Set<Ingredient> getOutputs() {
        return Sets.newHashSet((Object[])new Ingredient[]{this.result});
    }

    @Override
    public List<RecipeSlot> getSlots() {
        ArrayList<RecipeSlot> slots = new ArrayList<RecipeSlot>();
        int i = 0;
        int colCount = this.cost.size() / 4;
        int startX = 30 - 8 * (colCount - 1);
        int rowSize = this.cost.size();
        if (rowSize > 4) {
            rowSize = 4;
        }
        int startY = 74 - (18 * rowSize + 6 * (rowSize - 1)) / 2;
        for (Ingredient ingredient : this.cost) {
            slots.add(new RecipeSlot(startX + i / 4 * 18 + 1, startY + i % 4 * 24 + 1, ingredient.getItemStack(), ingredient.getCount()));
            ++i;
        }
        slots.add(new RecipeSlot(124, 66, this.result.getItemStack()));
        return slots;
    }

    @Override
    public void drawExtraBackground(GuiItemRecipe gui, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        int colCount = this.cost.size() / 4;
        int startX = 30 - 8 * (colCount - 1);
        int rowSize = this.cost.size();
        if (rowSize > 4) {
            rowSize = 4;
        }
        int startY = 74 - (18 * rowSize + 6 * (rowSize - 1)) / 2;
        for (int i = 0; i < this.cost.size(); ++i) {
            gui.func_73729_b(gui.guiLeft + startX + i / 4 * 18, gui.guiTop + startY + i % 4 * 24, 176, 0, 18, 18);
        }
        if (!this.hasWaypoint) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiNavigation.BACKGROUND);
        this.selected = this.npcIngredient.getInternalItemId().equals(NotEnoughUpdates.INSTANCE.navigation.getInternalname());
        gui.func_73729_b(gui.guiLeft + 130, gui.guiTop + 16, this.selected ? 182 : 182, this.selected ? 34 : 3, 26, 26);
    }

    @Override
    public void mouseClicked(GuiItemRecipe gui, int mouseX, int mouseY, int mouseButton) {
        if (this.hasWaypoint && Utils.isWithinRect(mouseX - gui.guiLeft, mouseY - gui.guiTop, 130, 16, 26, 26)) {
            boolean shiftPressed;
            boolean bl = shiftPressed = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
            if (this.selected && !shiftPressed) {
                NotEnoughUpdates.INSTANCE.navigation.untrackWaypoint();
            } else {
                NotEnoughUpdates.INSTANCE.navigation.trackWaypoint(this.npcIngredient.getInternalItemId());
                if (shiftPressed) {
                    NotEnoughUpdates.INSTANCE.navigation.useWarpCommand();
                }
            }
            Utils.playPressSound();
            this.selected = !this.selected;
        }
    }

    @Override
    public String getTitle() {
        return this.npcObject.get("displayname").getAsString();
    }

    @Override
    public RecipeType getType() {
        return RecipeType.NPC_SHOP;
    }

    @Override
    public boolean hasVariableCost() {
        return false;
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "npc_shop");
        jsonObject.addProperty("result", this.result.serialize());
        jsonObject.add("cost", JsonUtils.transformListToJsonArray(this.cost, costItem -> new JsonPrimitive(costItem.serialize())));
        return jsonObject;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    public static NeuRecipe parseItemRecipe(NEUManager neuManager, JsonObject recipe, JsonObject outputItemJson) {
        return new ItemShopRecipe(new Ingredient(neuManager, outputItemJson.get("internalname").getAsString()), JsonUtils.transformJsonArrayToList(recipe.getAsJsonArray("cost"), it -> new Ingredient(neuManager, it.getAsString())), new Ingredient(neuManager, recipe.get("result").getAsString()), outputItemJson);
    }
}

