/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;

public class VillagerTradeRecipe
implements NeuRecipe {
    public static final int COST_SLOT_X = 52;
    public static final int COST_SLOT_Y = 66;
    public static final int RESULT_SLOT_Y = 66;
    public static final int RESULT_SLOT_X = 124;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/villager_recipe_tall.png");
    private final Ingredient result;
    private final Ingredient cost;
    private final int minCost;
    private final int maxCost;

    public VillagerTradeRecipe(Ingredient result2, Ingredient cost, int minCost, int maxCost) {
        this.result = result2;
        this.cost = cost;
        this.minCost = minCost;
        this.maxCost = maxCost;
    }

    public VillagerTradeRecipe(Ingredient result2, Ingredient cost) {
        this(result2, cost, -1, -1);
    }

    @Override
    public boolean hasVariableCost() {
        return this.minCost != -1 && this.maxCost != -1;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.TRADE;
    }

    @Override
    public Set<Ingredient> getIngredients() {
        return Sets.newHashSet((Object[])new Ingredient[]{this.cost});
    }

    @Override
    public Set<Ingredient> getOutputs() {
        return Sets.newHashSet((Object[])new Ingredient[]{this.result});
    }

    @Override
    public List<RecipeSlot> getSlots() {
        return Arrays.asList(new RecipeSlot(52, 66, this.cost.getItemStack()), new RecipeSlot(124, 66, this.result.getItemStack()));
    }

    @Override
    public boolean shouldUseForCraftCost() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return SBInfo.getInstance().getCurrentMode() == SBInfo.Gamemode.STRANDED || NotEnoughUpdates.INSTANCE.config.hidden.dev;
    }

    @Override
    public void drawExtraInfo(GuiItemRecipe gui, int mouseX, int mouseY) {
        if (this.hasVariableCost()) {
            Utils.drawStringCenteredScaledMaxWidth(this.minCost + " - " + this.maxCost, gui.guiLeft + 50, gui.guiTop + 90, false, 75, 0xFF00FF);
        }
    }

    @Override
    public void drawExtraBackground(GuiItemRecipe gui, int mouseX, int mouseY) {
        GuiInventory.func_147046_a((int)(gui.guiLeft + 90), (int)(gui.guiTop + 100), (int)30, (float)(gui.guiLeft - mouseX + 110), (float)(gui.guiTop + 60 - mouseY), (EntityLivingBase)Holder.DEMO_ENTITY);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "trade");
        jsonObject.addProperty("result", this.result.serialize());
        jsonObject.addProperty("cost", this.cost.serialize());
        if (this.minCost > 0) {
            jsonObject.addProperty("min", this.minCost);
        }
        if (this.maxCost > 0) {
            jsonObject.addProperty("max", this.maxCost);
        }
        return jsonObject;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    public static VillagerTradeRecipe parseStaticRecipe(NEUManager manager, JsonObject recipe, JsonObject result2) {
        return new VillagerTradeRecipe(new Ingredient(manager, recipe.get("result").getAsString()), new Ingredient(manager, recipe.get("cost").getAsString()), recipe.has("min") ? recipe.get("min").getAsInt() : -1, recipe.has("max") ? recipe.get("max").getAsInt() : -1);
    }

    private static class Holder {
        private static final GameProfile DREAM_PROFILE = new GameProfile(UUID.fromString("ec70bcaf-702f-4bb8-b48d-276fa52a780c"), "Dream");
        private static final EntityLivingBase DEMO_DREAM = new AbstractClientPlayer(null, DREAM_PROFILE){

            protected NetworkPlayerInfo func_175155_b() {
                return new NetworkPlayerInfo(DREAM_PROFILE){

                    public ResourceLocation func_178837_g() {
                        return new ResourceLocation("notenoughupdates", "dreamskin.png");
                    }
                };
            }
        };
        private static final EntityLivingBase DEMO_VILLAGER = new EntityVillager(null);
        private static final EntityLivingBase DEMO_ENTITY = Holder.isAprilFirst() ? DEMO_DREAM : DEMO_VILLAGER;

        private Holder() {
        }

        private static boolean isAprilFirst() {
            Calendar cal = Calendar.getInstance();
            return cal.get(5) == 1 && cal.get(2) == 3;
        }
    }
}

