/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.listener.ItemTooltipListener;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    private static final Gson smallPrintingGson = new Gson();
    private static final DecimalFormat decimalFormatter = new DecimalFormat("#,###,###.###");

    public static ItemStack createSkullItemStack(String displayName, String uuid, String skinAbsoluteUrl) {
        JsonObject object = new JsonObject();
        JsonObject textures = new JsonObject();
        JsonObject skin = new JsonObject();
        skin.addProperty("url", skinAbsoluteUrl);
        textures.add("SKIN", skin);
        object.add("textures", textures);
        String json = smallPrintingGson.toJson(object);
        return Utils.createSkull(displayName, uuid, Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8)));
    }

    public static ItemStack getCoinItemStack(double coinAmount) {
        String uuid = "2070f6cb-f5db-367a-acd0-64d39a7e5d1b";
        String texture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTM4MDcxNzIxY2M1YjRjZDQwNmNlNDMxYTEzZjg2MDgzYTg5NzNlMTA2NGQyZjg4OTc4Njk5MzBlZTZlNTIzNyJ9fX0=";
        if (coinAmount >= 100000.0) {
            uuid = "94fa2455-2881-31fe-bb4e-e3e24d58dbe3";
            texture = "eyJ0aW1lc3RhbXAiOjE2MzU5NTczOTM4MDMsInByb2ZpbGVJZCI6ImJiN2NjYTcxMDQzNDQ0MTI4ZDMwODllMTNiZGZhYjU5IiwicHJvZmlsZU5hbWUiOiJsYXVyZW5jaW8zMDMiLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2M5Yjc3OTk5ZmVkM2EyNzU4YmZlYWYwNzkzZTUyMjgzODE3YmVhNjQwNDRiZjQzZWYyOTQzM2Y5NTRiYjUyZjYiLCJtZXRhZGF0YSI6eyJtb2RlbCI6InNsaW0ifX19fQo=";
        }
        if (coinAmount >= 1.0E7) {
            uuid = "0af8df1f-098c-3b72-ac6b-65d65fd0b668";
            texture = "ewogICJ0aW1lc3RhbXAiIDogMTYzNTk1NzQ4ODQxNywKICAicHJvZmlsZUlkIiA6ICJmNThkZWJkNTlmNTA0MjIyOGY2MDIyMjExZDRjMTQwYyIsCiAgInByb2ZpbGVOYW1lIiA6ICJ1bnZlbnRpdmV0YWxlbnQiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2I5NTFmZWQ2YTdiMmNiYzIwMzY5MTZkZWM3YTQ2YzRhNTY0ODE1NjRkMTRmOTQ1YjZlYmMwMzM4Mjc2NmQzYiIsCiAgICAgICJtZXRhZGF0YSIgOiB7CiAgICAgICAgIm1vZGVsIiA6ICJzbGltIgogICAgICB9CiAgICB9CiAgfQp9";
        }
        ItemStack skull = Utils.createSkull("\u00a7r\u00a76" + StringUtils.formatNumber(coinAmount) + " Coins", uuid, texture);
        NBTTagCompound extraAttributes = skull.func_77978_p().func_74775_l("ExtraAttributes");
        extraAttributes.func_74778_a("id", "SKYBLOCK_COIN");
        skull.func_77978_p().func_74782_a("ExtraAttributes", (NBTBase)extraAttributes);
        return skull;
    }

    public static ItemStack createQuestionMarkSkull(String label) {
        return Utils.createSkull(label, "00000000-0000-0000-0000-000000000000", "bc8ea1f51f253ff5142ca11ae45193a4ad8c3ab5e9c6eec8ba7a4fcb7bac40");
    }

    public static NBTTagCompound getOrCreateTag(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p();
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        is.func_77982_d(nbtTagCompound);
        return nbtTagCompound;
    }

    public static void appendLore(ItemStack is, List<String> moreLore) {
        NBTTagCompound tagCompound = is.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagCompound display = tagCompound.func_74775_l("display");
        NBTTagList lore = display.func_150295_c("Lore", 8);
        for (String s : moreLore) {
            lore.func_74742_a((NBTBase)new NBTTagString(s));
        }
        display.func_74782_a("Lore", (NBTBase)lore);
        tagCompound.func_74782_a("display", (NBTBase)display);
        is.func_77982_d(tagCompound);
    }

    public static void setLore(ItemStack is, List<String> newLore) {
        NBTTagCompound tagCompound = is.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagCompound display = tagCompound.func_74775_l("display");
        NBTTagList lore = new NBTTagList();
        for (String s : newLore) {
            lore.func_74742_a((NBTBase)new NBTTagString(s));
        }
        display.func_74782_a("Lore", (NBTBase)lore);
        tagCompound.func_74782_a("display", (NBTBase)display);
        is.func_77982_d(tagCompound);
    }

    @NotNull
    public static @NotNull List<@NotNull String> getLore(@Nullable ItemStack is) {
        if (is == null) {
            return new ArrayList<String>();
        }
        return ItemUtils.getLore(is.func_77978_p());
    }

    @NotNull
    public static @NotNull List<@NotNull String> getLore(@Nullable NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList tagList = tagCompound.func_74775_l("display").func_150295_c("Lore", 8);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            list.add(tagList.func_150307_f(i));
        }
        return list;
    }

    @Nullable
    public static String getDisplayName(@Nullable ItemStack itemStack) {
        if (null == itemStack) {
            return null;
        }
        return ItemUtils.getDisplayName(itemStack.func_77978_p());
    }

    @Nullable
    public static String getDisplayName(@Nullable NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        String string = compound.func_74775_l("display").func_74779_i("Name");
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String fixEnchantId(String enchId, boolean useId) {
        if (Constants.ENCHANTS != null && Constants.ENCHANTS.has("enchant_mapping_id") && Constants.ENCHANTS.has("enchant_mapping_item")) {
            JsonArray mappingFrom = Constants.ENCHANTS.getAsJsonArray("enchant_mapping_" + (useId ? "id" : "item"));
            JsonArray mappingTo = Constants.ENCHANTS.getAsJsonArray("enchant_mapping_" + (useId ? "item" : "id"));
            for (int i = 0; i < mappingFrom.size(); ++i) {
                if (!mappingFrom.get(i).getAsString().equals(enchId)) continue;
                return mappingTo.get(i).getAsString();
            }
        }
        return enchId;
    }

    public static <T> void modifyReplacement(Map<String, String> baseValues, Map<String, T> modifiers, BiFunction<String, T, String> mapper) {
        if (modifiers == null || baseValues == null) {
            return;
        }
        for (Map.Entry<String, T> modifier : modifiers.entrySet()) {
            String baseValue = baseValues.get(modifier.getKey());
            if (baseValue == null) continue;
            try {
                baseValues.put(modifier.getKey(), mapper.apply(baseValue, (String)modifier.getValue()));
            }
            catch (Exception e2) {
                System.out.println("Exception during replacement mapping: ");
                e2.printStackTrace();
            }
        }
    }

    public static String applyReplacements(Map<String, String> replacements, String text) {
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            String search = "{" + replacement.getKey() + "}";
            text = text.replace(search, replacement.getValue());
        }
        return text;
    }

    @NotNull
    public static NBTTagCompound getExtraAttributes(ItemStack itemStack) {
        NBTTagCompound tag = ItemUtils.getOrCreateTag(itemStack);
        NBTTagCompound extraAttributes = tag.func_74775_l("ExtraAttributes");
        tag.func_74782_a("ExtraAttributes", (NBTBase)extraAttributes);
        return extraAttributes;
    }

    public static ItemStack createPetItemstackFromPetInfo(PetInfoOverlay.Pet currentPet) {
        NBTTagCompound tag;
        if (currentPet == null) {
            ItemStack stack = ItemUtils.createQuestionMarkSkull(EnumChatFormatting.RED + "Unknown Pet");
            ItemUtils.appendLore(stack, Arrays.asList("\u00a7cNull Pet", "", "\u00a7cIf you expected it to be there please send a message in", "\u00a7c\u00a7l#neu-support \u00a7r\u00a7con \u00a7l" + Utils.getDiscordInvite()));
            return stack;
        }
        String petname = currentPet.petType;
        String tier = Utils.getRarityFromInt(currentPet.rarity.petId).toUpperCase(Locale.ROOT);
        String heldItem = currentPet.petItem;
        String skin = currentPet.skin;
        JsonObject heldItemJson = heldItem == null ? null : NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(heldItem);
        String petId = currentPet.getPetId(false);
        float exp2 = currentPet.petLevel.getExpTotal();
        PetLeveling.PetLevel levelObj = PetLeveling.getPetLevelingForPet(petname, PetInfoOverlay.Rarity.valueOf(tier)).getPetLevel(exp2);
        int level = levelObj.getCurrentLevel();
        ItemStack petItemstack = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(petId).resolveToItemStack(false);
        if (petItemstack == null) {
            petItemstack = ItemUtils.createQuestionMarkSkull(EnumChatFormatting.RED + "Unknown Pet");
            ItemUtils.appendLore(petItemstack, Arrays.asList("\u00a7cThis pet is not saved in the repository", "", "\u00a7cIf you expected it to be there please send a message in", "\u00a7c\u00a7l#neu-support \u00a7r\u00a7con \u00a7l" + Utils.getDiscordInvite()));
        }
        HashMap<String, String> replacements = NotEnoughUpdates.INSTANCE.manager.getPetLoreReplacements(petname, tier, MathHelper.func_76141_d((float)level));
        if (heldItem != null) {
            ItemUtils.modifyReplacement(replacements, (Map)GuiProfileViewer.PET_STAT_BOOSTS.get(heldItem), (original, modifier) -> "" + MathHelper.func_76141_d((float)(Float.parseFloat(original) + modifier.floatValue())));
            ItemUtils.modifyReplacement(replacements, (Map)GuiProfileViewer.PET_STAT_BOOSTS_MULT.get(heldItem), (original, modifier) -> "" + MathHelper.func_76141_d((float)(Float.parseFloat(original) * modifier.floatValue())));
        }
        if ((tag = ItemUtils.getOrCreateTag(petItemstack)).func_150297_b("display", 10)) {
            NBTTagCompound displayTag = tag.func_74775_l("display");
            if (displayTag.func_150297_b("Lore", 9)) {
                JsonObject petSkin;
                ArrayList<String> newLore = new ArrayList<String>();
                NBTTagList lore = displayTag.func_150295_c("Lore", 8);
                int secondLastBlankLine = -1;
                int lastBlankLine = -1;
                for (int j = 0; j < lore.func_74745_c(); ++j) {
                    String line = lore.func_150307_f(j);
                    if (line.trim().isEmpty()) {
                        secondLastBlankLine = lastBlankLine;
                        lastBlankLine = j;
                    }
                    line = ItemUtils.applyReplacements(replacements, line);
                    newLore.add(line);
                }
                if (skin != null && (petSkin = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName("PET_SKIN_" + skin).resolveToItemListJson()) != null) {
                    try {
                        NBTTagCompound nbt = JsonToNBT.func_180713_a((String)petSkin.get("nbttag").getAsString());
                        tag.func_74782_a("SkullOwner", nbt.func_74781_a("SkullOwner"));
                        String name = petSkin.get("displayname").getAsString();
                        if (name != null) {
                            name = Utils.cleanColour(name);
                            newLore.set(0, (String)newLore.get(0) + ", " + name);
                        }
                    }
                    catch (NBTException e2) {
                        e2.printStackTrace();
                    }
                }
                for (int i = 0; i < newLore.size(); ++i) {
                    String cleaned = Utils.cleanColour((String)newLore.get(i));
                    if (!cleaned.startsWith("Right-click to add this pet to")) continue;
                    if (heldItem == null) {
                        newLore.remove(i + 2);
                    }
                    newLore.remove(i + 1);
                    newLore.remove(i);
                    secondLastBlankLine = i - 1;
                    break;
                }
                if (secondLastBlankLine != -1) {
                    ArrayList<String> petItemLore = new ArrayList<String>();
                    if (heldItem != null) {
                        if (heldItemJson == null) {
                            petItemLore.add(EnumChatFormatting.RED + "Could not find held item in repo!");
                        } else {
                            petItemLore.add(EnumChatFormatting.GOLD + "Held Item: " + heldItemJson.get("displayname").getAsString());
                            List<String> heldItemLore = JsonUtils.getJsonArrayOrEmpty(heldItemJson, "lore", JsonElement::getAsString);
                            int blanks = 0;
                            for (String heldItemLoreLine : heldItemLore) {
                                if (heldItemLoreLine.trim().isEmpty()) {
                                    ++blanks;
                                    continue;
                                }
                                if (blanks == 2) {
                                    petItemLore.add(heldItemLoreLine);
                                    continue;
                                }
                                if (blanks <= 2) continue;
                                break;
                            }
                        }
                    }
                    if (currentPet.candyUsed > 0) {
                        if (petItemLore.size() > 0) {
                            petItemLore.add("");
                        }
                        petItemLore.add("\u00a7a(" + currentPet.candyUsed + "/10) Pet Candy Used");
                        if (heldItem == null) {
                            petItemLore.add("");
                        }
                    }
                    newLore.addAll(secondLastBlankLine + 1, petItemLore);
                }
                NBTTagList temp = new NBTTagList();
                for (String loreLine : newLore) {
                    temp.func_74742_a((NBTBase)new NBTTagString(loreLine));
                }
                displayTag.func_74782_a("Lore", (NBTBase)temp);
            }
            if (displayTag.func_150297_b("Name", 8)) {
                String displayName = displayTag.func_74779_i("Name");
                displayName = ItemUtils.applyReplacements(replacements, displayName);
                displayTag.func_74782_a("Name", (NBTBase)new NBTTagString(displayName));
            }
            tag.func_74782_a("display", (NBTBase)displayTag);
        }
        NBTTagCompound extraAttributes = new NBTTagCompound();
        JsonObject petInfo = new JsonObject();
        if (tag.func_150297_b("ExtraAttributes", 10) && (extraAttributes = tag.func_74775_l("ExtraAttributes")).func_150297_b("petInfo", 8)) {
            petInfo = new JsonParser().parse(extraAttributes.func_74779_i("petInfo")).getAsJsonObject();
        }
        petInfo.addProperty("exp", Float.valueOf(exp2));
        petInfo.addProperty("tier", tier);
        petInfo.addProperty("type", petname);
        if (heldItem != null) {
            petInfo.addProperty("heldItem", heldItem);
        }
        if (skin != null) {
            petInfo.addProperty("skin", skin);
        }
        extraAttributes.func_74778_a("petInfo", petInfo.toString());
        tag.func_74782_a("ExtraAttributes", (NBTBase)extraAttributes);
        petItemstack.func_77982_d(tag);
        return petItemstack;
    }

    public static ItemStack petToolTipXPExtendPetOverlay(ItemStack stack) {
        NBTTagList lore;
        NBTTagCompound display;
        NBTTagCompound tag;
        NBTTagCompound nBTTagCompound = tag = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
        if (tag.func_150297_b("display", 10) && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9) && ItemTooltipListener.petToolTipRegex.matcher(Utils.cleanColour((lore = display.func_150295_c("Lore", 8)).func_150307_f(0))).matches() && lore.func_74745_c() > 7) {
            PetInfoOverlay.Pet pet = PetInfoOverlay.getPetFromStack(stack.func_77978_p());
            if (pet == null) {
                return stack;
            }
            PetLeveling.PetLevel petLevel = pet.petLevel;
            if (petLevel == null) {
                return stack;
            }
            NBTTagList newLore = new NBTTagList();
            int maxLvl = 100;
            if (Constants.PETS != null && Constants.PETS.has("custom_pet_leveling") && Constants.PETS.getAsJsonObject("custom_pet_leveling").has(pet.petType.toUpperCase(Locale.ROOT)) && Constants.PETS.getAsJsonObject("custom_pet_leveling").getAsJsonObject(pet.petType.toUpperCase(Locale.ROOT)).has("max_level")) {
                maxLvl = Constants.PETS.getAsJsonObject("custom_pet_leveling").getAsJsonObject(pet.petType.toUpperCase(Locale.ROOT)).get("max_level").getAsInt();
            }
            for (int i = 0; i < lore.func_74745_c(); ++i) {
                if (i == lore.func_74745_c() - 2) {
                    newLore.func_74742_a((NBTBase)new NBTTagString(""));
                    if (petLevel.getCurrentLevel() >= maxLvl) {
                        newLore.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "MAX LEVEL"));
                    } else {
                        double levelPercent = (double)Math.round(petLevel.getPercentageToNextLevel() * 1000.0f) / 10.0;
                        newLore.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.GRAY + "Progress to Level " + (petLevel.getCurrentLevel() + 1) + ": " + EnumChatFormatting.YELLOW + levelPercent + "%"));
                        StringBuilder sb = new StringBuilder();
                        for (int j = 0; j < 20; ++j) {
                            if ((double)j < levelPercent / 5.0) {
                                sb.append(EnumChatFormatting.DARK_GREEN);
                            } else {
                                sb.append(EnumChatFormatting.WHITE);
                            }
                            sb.append(EnumChatFormatting.BOLD + "" + EnumChatFormatting.STRIKETHROUGH + " ");
                        }
                        newLore.func_74742_a((NBTBase)new NBTTagString(sb.toString()));
                        newLore.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.GRAY + "EXP: " + EnumChatFormatting.YELLOW + decimalFormatter.format(petLevel.getExpInCurrentLevel()) + EnumChatFormatting.GOLD + "/" + EnumChatFormatting.YELLOW + decimalFormatter.format(petLevel.getExpRequiredForNextLevel())));
                    }
                }
                newLore.func_74742_a(lore.func_179238_g(i));
            }
            display.func_74782_a("Lore", (NBTBase)newLore);
            tag.func_74782_a("display", (NBTBase)display);
        }
        stack.func_77982_d(tag);
        return stack;
    }

    public static boolean isSoulbound(ItemStack item) {
        return ItemUtils.getLore(item).stream().anyMatch(line -> line.equals("\u00a78\u00a7l* \u00a78Co-op Soulbound \u00a78\u00a7l*") || line.equals("\u00a78\u00a7l* Soulbound \u00a78\u00a7l*"));
    }

    public static String fixDraconicId(String id) {
        if (id.equals("ASPECT_OF_THE_DRAGONS")) {
            return "ASPECT_OF_THE_DRAGON";
        }
        if (id.equals("ENDER_HELMET")) {
            return "END_HELMET";
        }
        if (id.equals("ENDER_CHESTPLATE")) {
            return "END_CHESTPLATE";
        }
        if (id.equals("ENDER_LEGGINGS")) {
            return "END_LEGGINGS";
        }
        if (id.equals("ENDER_BOOTS")) {
            return "END_BOOTS";
        }
        return id;
    }

    public static ItemStack createItemStackFromId(String id, String displayname) {
        Item item = Item.func_111206_d((String)id);
        if (item == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(item);
        itemStack.func_151001_c(displayname);
        return itemStack;
    }
}

