/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TitleUtil {
    private static final TitleUtil INSTANCE = new TitleUtil();
    private String title = null;
    private long titleLifetime = 0L;
    private int color = 0xFF0000;

    public static TitleUtil getInstance() {
        return INSTANCE;
    }

    public void createTitle(String title, int ticks, int color) {
        this.title = title;
        this.titleLifetime = System.nanoTime() + (long)ticks * 50000000L;
        this.color = color;
    }

    private void renderTitles(ScaledResolution scaledResolution) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || !NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        int scaledWidth = scaledResolution.func_78326_a();
        int scaledHeight = scaledResolution.func_78328_b();
        if (this.title != null) {
            float scale;
            int stringWidth = mc.field_71466_p.func_78256_a(this.title);
            if ((float)stringWidth * (scale = 4.0f) > (float)scaledWidth * 0.9f) {
                scale = (float)scaledWidth * 0.9f / (float)stringWidth;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(scaledWidth / 2), (float)(scaledHeight / 2), (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            mc.field_71466_p.func_175065_a(this.title, (float)(-mc.field_71466_p.func_78256_a(this.title)) / 2.0f, -20.0f, this.color, true);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderHUD(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (System.nanoTime() >= this.titleLifetime) {
            this.titleLifetime = 0L;
            this.title = null;
        }
        this.renderTitles(event.resolution);
    }
}

