/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.Nullable;

public class XPInformation {
    private static final XPInformation INSTANCE = new XPInformation();
    private final HashMap<String, SkillInfo> skillInfoMap = new HashMap();
    public HashMap<String, Float> updateWithPercentage = new HashMap();
    public HashMap<String, Float> increment = new HashMap();
    private static final Splitter SPACE_SPLITTER = Splitter.on((String)"  ").omitEmptyStrings().trimResults();
    private static final Pattern SKILL_PATTERN = Pattern.compile("\\+(\\d+(?:,\\d+)*(?:\\.\\d+)?) (.+) \\((\\d+(?:,\\d+)*(?:\\.\\d+)?)/(\\d+(?:,\\d+)*(?:\\.\\d+)?)\\)");
    private static final Pattern SKILL_PATTERN_MULTIPLIER = Pattern.compile("\\+(\\d+(?:,\\d+)*(?:\\.\\d+)?) (.+) \\((\\d+(?:,\\d+)*(?:\\.\\d+)?)/(\\d+(?:k|m|b))\\)");
    private static final Pattern SKILL_PATTERN_PERCENTAGE = Pattern.compile("\\+(\\d+(?:,\\d+)*(?:\\.\\d+)?) (.+) \\((\\d\\d?(?:\\.\\d\\d?)?)%\\)");
    private Set<String> failedSkills = new HashSet<String>();
    private String lastActionBar = null;
    private Pattern tablistSkillPattern = Pattern.compile(" (?<type>[^ ]+) (?<level>\\d+): (?:(?<percentage>\\d+(\\.\\d+)?)%|(?<amount>[0-9,]+(\\.\\d+)?)/.*|(?<max>MAX))");

    public static XPInformation getInstance() {
        return INSTANCE;
    }

    public HashMap<String, SkillInfo> getSkillInfoMap() {
        return this.skillInfoMap;
    }

    @Nullable
    public SkillInfo getSkillInfo(String skillName) {
        return this.getSkillInfo(skillName, false);
    }

    @Nullable
    public SkillInfo getSkillInfo(String skillName, boolean isHighlyInterested) {
        SkillInfo obj = this.skillInfoMap.get(skillName.toLowerCase(Locale.ROOT));
        if (isHighlyInterested && this.failedSkills.contains(skillName.toLowerCase(Locale.ROOT))) {
            TablistAPI.getWidgetLines(TablistAPI.WidgetNames.SKILLS);
        }
        return obj;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (event.type != 2) {
            return;
        }
        JsonObject leveling = Constants.LEVELING;
        if (leveling == null) {
            return;
        }
        String actionBar = StringUtils.cleanColour(event.message.func_150260_c());
        if (this.lastActionBar != null && this.lastActionBar.equalsIgnoreCase(actionBar)) {
            return;
        }
        this.lastActionBar = actionBar;
        List components = SPACE_SPLITTER.splitToList((CharSequence)actionBar);
        for (String component : components) {
            String currentXpS;
            String skillS;
            Matcher matcher = SKILL_PATTERN.matcher(component);
            if (matcher.matches()) {
                skillS = matcher.group(2);
                currentXpS = matcher.group(3).replace(",", "");
                String maxXpS = matcher.group(4).replace(",", "");
                float currentXp = Float.parseFloat(currentXpS);
                float maxXp = Float.parseFloat(maxXpS);
                SkillInfo skillInfo = new SkillInfo();
                skillInfo.currentXp = currentXp;
                skillInfo.currentXpMax = maxXp;
                skillInfo.totalXp = currentXp;
                JsonArray levelingArray = leveling.getAsJsonArray("leveling_xp");
                for (int i = 0; i < levelingArray.size(); ++i) {
                    float cap = levelingArray.get(i).getAsFloat();
                    if (maxXp > 0.0f && maxXp <= cap) break;
                    skillInfo.totalXp += (double)cap;
                    ++skillInfo.level;
                }
                this.skillInfoMap.put(skillS.toLowerCase(Locale.ROOT), skillInfo);
                return;
            }
            matcher = SKILL_PATTERN_PERCENTAGE.matcher(component);
            if (matcher.matches()) {
                skillS = matcher.group(2);
                String xpPercentageS = matcher.group(3).replace(",", "");
                float xpPercentage = Float.parseFloat(xpPercentageS);
                if (this.updateWithPercentage.containsKey(skillS.toLowerCase(Locale.ROOT))) {
                    this.failedSkills.add(skillS.toLowerCase(Locale.ROOT));
                }
                this.updateWithPercentage.put(skillS.toLowerCase(Locale.ROOT), Float.valueOf(xpPercentage));
                this.increment.put(skillS.toLowerCase(Locale.ROOT), Float.valueOf(Float.parseFloat(matcher.group(1).replace(",", ""))));
                continue;
            }
            matcher = SKILL_PATTERN_MULTIPLIER.matcher(component);
            if (!matcher.matches()) continue;
            skillS = matcher.group(2);
            currentXpS = matcher.group(3).replace(",", "");
            String maxXpS = matcher.group(4).replace(",", "");
            float maxMult = 1.0f;
            if (maxXpS.endsWith("k")) {
                maxMult = 1000.0f;
                maxXpS = maxXpS.substring(0, maxXpS.length() - 1);
            } else if (maxXpS.endsWith("m")) {
                maxMult = 1000000.0f;
                maxXpS = maxXpS.substring(0, maxXpS.length() - 1);
            } else if (maxXpS.endsWith("b")) {
                maxMult = 1.0E9f;
                maxXpS = maxXpS.substring(0, maxXpS.length() - 1);
            }
            float currentXp = Float.parseFloat(currentXpS);
            float maxXp = Float.parseFloat(maxXpS) * maxMult;
            SkillInfo skillInfo = new SkillInfo();
            skillInfo.currentXp = currentXp;
            skillInfo.currentXpMax = maxXp;
            skillInfo.totalXp = currentXp;
            JsonArray levelingArray = leveling.getAsJsonArray("leveling_xp");
            for (int i = 0; i < levelingArray.size(); ++i) {
                float cap = levelingArray.get(i).getAsFloat();
                if (maxXp > 0.0f && maxXp <= cap) break;
                skillInfo.totalXp += (double)cap;
                ++skillInfo.level;
            }
            this.skillInfoMap.put(skillS.toLowerCase(Locale.ROOT), skillInfo);
            return;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        List<String> widgetLines = TablistAPI.getOptionalWidgetLines(TablistAPI.WidgetNames.SKILLS);
        for (String widgetLine : widgetLines) {
            Matcher matcher = this.tablistSkillPattern.matcher(Utils.cleanColour(widgetLine));
            if (!matcher.matches()) continue;
            String type2 = matcher.group("type");
            assert (type2 != null);
            int level = Integer.parseInt(matcher.group("level"));
            String percentage = matcher.group("percentage");
            Double percentageAsNumber = percentage != null ? Double.valueOf(Double.parseDouble(percentage) / 100.0) : null;
            String amount = matcher.group("amount");
            Double amountAsNumber = amount != null ? Double.valueOf(Double.parseDouble(amount.replace(",", ""))) : null;
            boolean isMax = matcher.group("max") != null;
            this.updateLevel(type2.toLowerCase(Locale.ROOT), level);
        }
    }

    public void updateLevel(String skill, int level) {
        if (this.updateWithPercentage.containsKey(skill)) {
            JsonObject leveling = Constants.LEVELING;
            if (leveling == null) {
                return;
            }
            SkillInfo newSkillInfo = new SkillInfo();
            newSkillInfo.totalXp = 0.0;
            newSkillInfo.level = level;
            JsonArray levelingArray = leveling.getAsJsonArray("leveling_xp");
            for (int i = 0; i < levelingArray.size(); ++i) {
                float cap = levelingArray.get(i).getAsFloat();
                if (i == level) {
                    newSkillInfo.currentXp += (double)(this.updateWithPercentage.get(skill).floatValue() / 100.0f * cap);
                    newSkillInfo.totalXp += newSkillInfo.currentXp;
                    newSkillInfo.currentXpMax = cap;
                    break;
                }
                newSkillInfo.totalXp += (double)cap;
            }
            SkillInfo oldSkillInfo = this.skillInfoMap.get(skill.toLowerCase(Locale.ROOT));
            float inc = this.increment.getOrDefault(skill.toLowerCase(Locale.ROOT), Float.valueOf(0.0f)).floatValue();
            if (oldSkillInfo != null && oldSkillInfo.totalXp + (double)inc > newSkillInfo.totalXp && oldSkillInfo.totalXp - (double)(inc * 5.0f) < newSkillInfo.totalXp) {
                SkillInfo incrementedSkillInfo = new SkillInfo();
                incrementedSkillInfo.totalXp = oldSkillInfo.totalXp + (double)inc;
                boolean isNotLevelUp = oldSkillInfo.currentXp + (double)inc < oldSkillInfo.currentXpMax;
                incrementedSkillInfo.level = isNotLevelUp ? oldSkillInfo.level : oldSkillInfo.level + 1;
                incrementedSkillInfo.currentXp = isNotLevelUp ? oldSkillInfo.currentXp + (double)inc : oldSkillInfo.currentXp + (double)inc - oldSkillInfo.currentXpMax;
                incrementedSkillInfo.currentXpMax = incrementedSkillInfo.level < levelingArray.size() && incrementedSkillInfo.level >= 0 ? (double)levelingArray.get(incrementedSkillInfo.level).getAsFloat() : 0.0;
                this.skillInfoMap.put(skill.toLowerCase(Locale.ROOT), incrementedSkillInfo);
            } else {
                this.skillInfoMap.put(skill.toLowerCase(Locale.ROOT), newSkillInfo);
            }
            this.failedSkills.remove(skill.toLowerCase(Locale.ROOT));
        }
        this.updateWithPercentage.clear();
    }

    public static class SkillInfo {
        public int level;
        public double totalXp;
        public double currentXp;
        public double currentXpMax;
        public boolean fromApi = false;
    }
}

