/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.http.content;

import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.ContentTypesKt;
import gg.skytils.ktor.http.HttpStatusCode;
import gg.skytils.ktor.http.content.OutgoingContent;
import gg.skytils.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0017\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lgg/skytils/ktor/http/content/TextContent;", "Lgg/skytils/ktor/http/content/OutgoingContent$ByteArrayContent;", "", "bytes", "()[B", "", "toString", "()Ljava/lang/String;", "[B", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "Lgg/skytils/ktor/http/ContentType;", "contentType", "Lgg/skytils/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "Lgg/skytils/ktor/http/HttpStatusCode;", "status", "Lgg/skytils/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "text", "Ljava/lang/String;", "getText", "<init>", "(Ljava/lang/String;Lio/ktor/http/ContentType;Lio/ktor/http/HttpStatusCode;)V", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nTextContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextContent.kt\nio/ktor/http/content/TextContent\n+ 2 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n1#1,29:1\n8#2,3:30\n*S KotlinDebug\n*F\n+ 1 TextContent.kt\nio/ktor/http/content/TextContent\n*L\n20#1:30,3\n*E\n"})
public final class TextContent
extends OutgoingContent.ByteArrayContent {
    @NotNull
    private final String text;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final HttpStatusCode status;
    @NotNull
    private final byte[] bytes;

    /*
     * WARNING - void declaration
     */
    public TextContent(@NotNull String text2, @NotNull ContentType contentType2, @Nullable HttpStatusCode status) {
        byte[] byArray;
        void $this$toByteArray$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.text = text2;
        this.contentType = contentType2;
        this.status = status;
        String string = this.text;
        Charset charset = ContentTypesKt.charset(this.getContentType());
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        Charset charset$iv = charset;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, (CharSequence)$this$toByteArray$iv, 0, $this$toByteArray$iv.length());
        }
        this.bytes = byArray;
    }

    public /* synthetic */ TextContent(String string, ContentType contentType2, HttpStatusCode httpStatusCode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            httpStatusCode = null;
        }
        this(string, contentType2, httpStatusCode);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public Long getContentLength() {
        return this.bytes.length;
    }

    @Override
    @NotNull
    public byte[] bytes() {
        return this.bytes;
    }

    @NotNull
    public String toString() {
        return "TextContent[" + this.getContentType() + "] \"" + StringsKt.take((String)this.text, (int)30) + '\"';
    }
}

