/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.network.tls.cipher;

import gg.skytils.ktor.network.tls.CipherSuite;
import gg.skytils.ktor.network.tls.KeysKt;
import gg.skytils.ktor.network.tls.TLSException;
import gg.skytils.ktor.network.tls.TLSRecord;
import gg.skytils.ktor.network.tls.cipher.CipherKt;
import gg.skytils.ktor.network.tls.cipher.CipherUtilsKt;
import gg.skytils.ktor.network.tls.cipher.TLSCipher;
import gg.skytils.ktor.util.CryptoKt;
import gg.skytils.ktor.utils.io.core.BytePacketBuilder;
import gg.skytils.ktor.utils.io.core.ByteReadPacket;
import gg.skytils.ktor.utils.io.core.Output;
import gg.skytils.ktor.utils.io.core.OutputKt;
import gg.skytils.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010)\u001a\u00020(\u0012\u0006\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\u00020\r*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u001eR\u0014\u0010&\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010!R\u0014\u0010'\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010$R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lgg/skytils/ktor/network/tls/cipher/CBCCipher;", "Lgg/skytils/ktor/network/tls/cipher/TLSCipher;", "Lgg/skytils/ktor/network/tls/TLSRecord;", "record", "decrypt", "(Lgg/skytils/ktor/network/tls/TLSRecord;)Lgg/skytils/ktor/network/tls/TLSRecord;", "encrypt", "", "content", "prepareMac", "(Lgg/skytils/ktor/network/tls/TLSRecord;[B)[B", "", "macOffset", "", "validateMac", "(Lgg/skytils/ktor/network/tls/TLSRecord;[BI)V", "paddingStart", "validatePadding", "([BI)V", "Lgg/skytils/ktor/utils/io/core/BytePacketBuilder;", "writePadding", "(Lgg/skytils/ktor/utils/io/core/BytePacketBuilder;)V", "", "inputCounter", "J", "keyMaterial", "[B", "outputCounter", "Ljavax/crypto/Cipher;", "receiveCipher", "Ljavax/crypto/Cipher;", "Ljavax/crypto/spec/SecretKeySpec;", "receiveKey", "Ljavax/crypto/spec/SecretKeySpec;", "Ljavax/crypto/Mac;", "receiveMac", "Ljavax/crypto/Mac;", "sendCipher", "sendKey", "sendMac", "Lgg/skytils/ktor/network/tls/CipherSuite;", "suite", "Lgg/skytils/ktor/network/tls/CipherSuite;", "<init>", "(Lio/ktor/network/tls/CipherSuite;[B)V", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nCBCCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CBCCipher.kt\nio/ktor/network/tls/cipher/CBCCipher\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,126:1\n12#2,11:127\n12#2,11:138\n*S KotlinDebug\n*F\n+ 1 CBCCipher.kt\nio/ktor/network/tls/cipher/CBCCipher\n*L\n35#1:127,11\n62#1:138,11\n*E\n"})
public final class CBCCipher
implements TLSCipher {
    @NotNull
    private final CipherSuite suite;
    @NotNull
    private final byte[] keyMaterial;
    @NotNull
    private final Cipher sendCipher;
    @NotNull
    private final SecretKeySpec sendKey;
    @NotNull
    private final Mac sendMac;
    @NotNull
    private final Cipher receiveCipher;
    @NotNull
    private final SecretKeySpec receiveKey;
    @NotNull
    private final Mac receiveMac;
    private long inputCounter;
    private long outputCounter;

    public CBCCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial2) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)keyMaterial2, (String)"keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial2;
        Cipher cipher2 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher2);
        this.sendCipher = cipher2;
        this.sendKey = KeysKt.clientKey(this.keyMaterial, this.suite);
        Mac mac = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull((Object)mac);
        this.sendMac = mac;
        Cipher cipher3 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher3);
        this.receiveCipher = cipher3;
        this.receiveKey = KeysKt.serverKey(this.keyMaterial, this.suite);
        Mac mac2 = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull((Object)mac2);
        this.receiveMac = mac2;
    }

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.sendCipher.init(1, (Key)this.sendKey, new IvParameterSpec(CryptoKt.generateNonce(this.suite.getFixedIvLength())));
        byte[] content2 = StringsKt.readBytes$default(record.getPacket(), 0, 1, null);
        byte[] macBytes = this.prepareMac(record, content2);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$encrypt_u24lambda_u240 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully$default((Output)$this$encrypt_u24lambda_u240, content2, 0, 0, 6, null);
            OutputKt.writeFully$default((Output)$this$encrypt_u24lambda_u240, macBytes, 0, 0, 6, null);
            this.writePadding($this$encrypt_u24lambda_u240);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encryptionData = byteReadPacket;
        ByteReadPacket packet2 = CipherUtilsKt.cipherLoop(encryptionData, this.sendCipher, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ CBCCipher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$cipherLoop) {
                Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"$this$cipherLoop");
                Output output2 = $this$cipherLoop;
                byte[] byArray = CBCCipher.access$getSendCipher$p(this.this$0).getIV();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sendCipher.iv");
                OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
            }
        }));
        return new TLSRecord(record.getType(), null, packet2, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        ByteReadPacket packet2 = record.getPacket();
        byte[] serverIV = StringsKt.readBytes(packet2, this.suite.getFixedIvLength());
        this.receiveCipher.init(2, (Key)this.receiveKey, new IvParameterSpec(serverIV));
        byte[] content2 = StringsKt.readBytes$default(CipherUtilsKt.cipherLoop$default(packet2, this.receiveCipher, null, 2, null), 0, 1, null);
        int paddingLength = content2[content2.length - 1] & 0xFF;
        int paddingStart = content2.length - paddingLength - 1;
        int macStart = paddingStart - this.suite.getMacStrengthInBytes();
        this.validatePadding(content2, paddingStart);
        this.validateMac(record, content2, macStart);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$decrypt_u24lambda_u241 = builder$iv;
            boolean bl = false;
            OutputKt.writeFully((Output)$this$decrypt_u24lambda_u241, content2, 0, macStart);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket decryptedContent = byteReadPacket;
        return new TLSRecord(record.getType(), record.getVersion(), decryptedContent);
    }

    private final byte[] prepareMac(TLSRecord record, byte[] content2) {
        byte[] byArray;
        this.sendMac.reset();
        this.sendMac.init(KeysKt.clientMacKey(this.keyMaterial, this.suite));
        byte[] it = byArray = new byte[13];
        boolean bl = false;
        CipherKt.set(it, 0, this.outputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)content2.length);
        byte[] header = byArray;
        ++this.outputCounter;
        this.sendMac.update(header);
        byte[] byArray2 = this.sendMac.doFinal(content2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"sendMac.doFinal(content)");
        return byArray2;
    }

    private final void writePadding(BytePacketBuilder $this$writePadding) {
        int lastBlockSize = ($this$writePadding.getSize() + 1) % this.sendCipher.getBlockSize();
        byte paddingSize = (byte)(this.sendCipher.getBlockSize() - lastBlockSize);
        int n = paddingSize + 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            $this$writePadding.writeByte(paddingSize);
        }
    }

    private final void validatePadding(byte[] content2, int paddingStart) {
        int padding = content2[content2.length - 1] & 0xFF;
        int n = content2.length;
        for (int i2 = paddingStart; i2 < n; ++i2) {
            int n2 = content2[i2] & 0xFF;
            if (padding == n2) continue;
            throw new TLSException("Padding invalid: expected " + padding + ", actual " + n2, null, 2, null);
        }
    }

    private final void validateMac(TLSRecord record, byte[] content2, int macOffset) {
        byte[] byArray;
        this.receiveMac.reset();
        this.receiveMac.init(KeysKt.serverMacKey(this.keyMaterial, this.suite));
        byte[] it = byArray = new byte[13];
        boolean bl = false;
        CipherKt.set(it, 0, this.inputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)macOffset);
        byte[] header = byArray;
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        this.receiveMac.update(header);
        this.receiveMac.update(content2, 0, macOffset);
        byte[] byArray2 = this.receiveMac.doFinal();
        Intrinsics.checkNotNull((Object)byArray2);
        byte[] expectedMac = byArray2;
        byte[] actual = ArraysKt.sliceArray((byte[])content2, (IntRange)RangesKt.until((int)macOffset, (int)(macOffset + this.suite.getMacStrengthInBytes())));
        if (!MessageDigest.isEqual(expectedMac, actual)) {
            throw new TLSException("Failed to verify MAC content", null, 2, null);
        }
    }

    public static final /* synthetic */ Cipher access$getSendCipher$p(CBCCipher $this) {
        return $this.sendCipher;
    }
}

