/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils;

import gg.essential.universal.UDesktop;
import gg.skytils.skytilsmod.Reference;
import gg.skytils.skytilsmod.tweaker.TweakerUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import org.apache.logging.log4j.LogManager;

public class EssentialPlatformSetup {
    private static final String[] dataURLCandidates = new String[]{System.getProperty("skytils.dataURL"), Reference.dataUrl, "https://skytilsmod-data.pages.dev/", "https://cdn.jsdelivr.net/gh/Skytils/SkytilsMod-Data@main/", "https://mirror.ghproxy.com/https://raw.githubusercontent.com/Skytils/SkytilsMod-Data/main/"};

    private static boolean trySetDataUrl(String url2) {
        if (url2 == null) {
            return false;
        }
        try {
            return TweakerUtil.makeRequest(url2 + "CANYOUSEEME").contains("YOUCANSEEME");
        }
        catch (Exception e) {
            LogManager.getLogger().error("Failed to contact url " + url2);
            return false;
        }
    }

    public static void setup() throws Throwable {
        for (String url2 : dataURLCandidates) {
            if (!EssentialPlatformSetup.trySetDataUrl(url2)) continue;
            Reference.dataUrl = url2;
            break;
        }
        LogManager.getLogger().info("Data URL: {}", new Object[]{Reference.dataUrl});
        try {
            if (Integer.parseInt(TweakerUtil.makeRequest(Reference.dataUrl + "api/version").trim()) > 7) {
                JButton btn = new JButton("Open Website");
                btn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            UDesktop.browse((URI)URI.create("https://skytils.gg"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                JButton openModFolder = new JButton("Open Mod Folder");
                openModFolder.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            UDesktop.open((File)new File("./mods"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                TweakerUtil.showMessage("<html><p>Your version of Skytils (1.11.0) requires a<br>mandatory update before you can play!<br>Please download the latest version,<br>join the Discord for support.<br></p></html>", btn, openModFolder);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }
}

