/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils;

import java.text.DecimalFormat;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u001d\n\u0002\u0010\n\n\u0002\b\u0011\u0018\u0000 @2\u00020\u0001:\u0001@B\u0011\b\u0016\u0012\u0006\u0010=\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010&B\t\b\u0016\u00a2\u0006\u0004\b>\u0010?J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\"\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u000eR\"\u0010\u001c\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\n\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\"\u0010\u001f\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\"\u0010\"\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010\u0004\"\u0004\b%\u0010&R\"\u0010'\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u0014\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010\u0018R\"\u0010*\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010\u0014\u001a\u0004\b+\u0010\u0016\"\u0004\b,\u0010\u0018R\"\u0010-\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010\u0014\u001a\u0004\b.\u0010\u0016\"\u0004\b/\u0010\u0018R\"\u00101\u001a\u0002008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\"\u00107\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u0010\u0014\u001a\u0004\b8\u0010\u0016\"\u0004\b9\u0010\u0018R\"\u0010:\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010\n\u001a\u0004\b;\u0010\f\"\u0004\b<\u0010\u000e\u00a8\u0006A"}, d2={"Lgg/skytils/skytilsmod/utils/NtpMessage;", "", "", "toByteArray", "()[B", "", "toString", "()Ljava/lang/String;", "", "leapIndicator", "B", "getLeapIndicator", "()B", "setLeapIndicator", "(B)V", "mode", "getMode", "setMode", "", "originateTimestamp", "D", "getOriginateTimestamp", "()D", "setOriginateTimestamp", "(D)V", "pollInterval", "getPollInterval", "setPollInterval", "precision", "getPrecision", "setPrecision", "receiveTimestamp", "getReceiveTimestamp", "setReceiveTimestamp", "referenceIdentifier", "[B", "getReferenceIdentifier", "setReferenceIdentifier", "([B)V", "referenceTimestamp", "getReferenceTimestamp", "setReferenceTimestamp", "rootDelay", "getRootDelay", "setRootDelay", "rootDispersion", "getRootDispersion", "setRootDispersion", "", "stratum", "S", "getStratum", "()S", "setStratum", "(S)V", "transmitTimestamp", "getTransmitTimestamp", "setTransmitTimestamp", "version", "getVersion", "setVersion", "array", "<init>", "()V", "Companion", "SkytilsMod"})
public final class NtpMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private byte leapIndicator;
    private byte version;
    private byte mode;
    private short stratum;
    private byte pollInterval;
    private byte precision;
    private double rootDelay;
    private double rootDispersion;
    @NotNull
    private byte[] referenceIdentifier;
    private double referenceTimestamp;
    private double originateTimestamp;
    private double receiveTimestamp;
    private double transmitTimestamp;
    private static final long DAYS = 25567L;
    private static final long SECS = 2208988800L;
    @NotNull
    private static final String dtf = "%1$ta, %1$td %1$tb %1$tY, %1$tI:%1$tm:%1$tS.%1$tL %1$tp %1$tZ";

    public final byte getLeapIndicator() {
        return this.leapIndicator;
    }

    public final void setLeapIndicator(byte by) {
        this.leapIndicator = by;
    }

    public final byte getVersion() {
        return this.version;
    }

    public final void setVersion(byte by) {
        this.version = by;
    }

    public final byte getMode() {
        return this.mode;
    }

    public final void setMode(byte by) {
        this.mode = by;
    }

    public final short getStratum() {
        return this.stratum;
    }

    public final void setStratum(short s2) {
        this.stratum = s2;
    }

    public final byte getPollInterval() {
        return this.pollInterval;
    }

    public final void setPollInterval(byte by) {
        this.pollInterval = by;
    }

    public final byte getPrecision() {
        return this.precision;
    }

    public final void setPrecision(byte by) {
        this.precision = by;
    }

    public final double getRootDelay() {
        return this.rootDelay;
    }

    public final void setRootDelay(double d) {
        this.rootDelay = d;
    }

    public final double getRootDispersion() {
        return this.rootDispersion;
    }

    public final void setRootDispersion(double d) {
        this.rootDispersion = d;
    }

    @NotNull
    public final byte[] getReferenceIdentifier() {
        return this.referenceIdentifier;
    }

    public final void setReferenceIdentifier(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.referenceIdentifier = byArray;
    }

    public final double getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    public final void setReferenceTimestamp(double d) {
        this.referenceTimestamp = d;
    }

    public final double getOriginateTimestamp() {
        return this.originateTimestamp;
    }

    public final void setOriginateTimestamp(double d) {
        this.originateTimestamp = d;
    }

    public final double getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public final void setReceiveTimestamp(double d) {
        this.receiveTimestamp = d;
    }

    public final double getTransmitTimestamp() {
        return this.transmitTimestamp;
    }

    public final void setTransmitTimestamp(double d) {
        this.transmitTimestamp = d;
    }

    public NtpMessage(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.version = (byte)3;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.referenceIdentifier = byArray;
        this.leapIndicator = (byte)(array[0] >> 6 & 3);
        this.version = (byte)(array[0] >> 3 & 7);
        this.mode = (byte)(array[0] & 7);
        this.stratum = Companion.unsignedByteToShort(array[1]);
        this.pollInterval = array[2];
        this.precision = array[3];
        this.rootDelay = (double)array[4] * 256.0 + (double)Companion.unsignedByteToShort(array[5]) + (double)Companion.unsignedByteToShort(array[6]) / 256.0 + (double)Companion.unsignedByteToShort(array[7]) / 65536.0;
        this.rootDispersion = (double)Companion.unsignedByteToShort(array[8]) * 256.0 + (double)Companion.unsignedByteToShort(array[9]) + (double)Companion.unsignedByteToShort(array[10]) / 256.0 + (double)Companion.unsignedByteToShort(array[11]) / 65536.0;
        this.referenceIdentifier[0] = array[12];
        this.referenceIdentifier[1] = array[13];
        this.referenceIdentifier[2] = array[14];
        this.referenceIdentifier[3] = array[15];
        this.referenceTimestamp = Companion.decodeTimestamp(array, 16);
        this.originateTimestamp = Companion.decodeTimestamp(array, 24);
        this.receiveTimestamp = Companion.decodeTimestamp(array, 32);
        this.transmitTimestamp = Companion.decodeTimestamp(array, 40);
    }

    public NtpMessage() {
        this.version = (byte)3;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.referenceIdentifier = byArray;
        this.mode = (byte)3;
        this.transmitTimestamp = Companion.now();
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] p = new byte[48];
        p[0] = (byte)(this.leapIndicator << 6 | this.version << 3 | this.mode);
        p[1] = (byte)this.stratum;
        p[2] = this.pollInterval;
        p[3] = this.precision;
        int l = (int)(this.rootDelay * 65536.0);
        p[4] = (byte)(l >> 24 & 0xFF);
        p[5] = (byte)(l >> 16 & 0xFF);
        p[6] = (byte)(l >> 8 & 0xFF);
        p[7] = (byte)(l & 0xFF);
        long ul = (long)(this.rootDispersion * 65536.0);
        p[8] = (byte)(ul >> 24 & 0xFFL);
        p[9] = (byte)(ul >> 16 & 0xFFL);
        p[10] = (byte)(ul >> 8 & 0xFFL);
        p[11] = (byte)(ul & 0xFFL);
        p[12] = this.referenceIdentifier[0];
        p[13] = this.referenceIdentifier[1];
        p[14] = this.referenceIdentifier[2];
        p[15] = this.referenceIdentifier[3];
        Companion.encodeTimestamp(p, 16, this.referenceTimestamp);
        Companion.encodeTimestamp(p, 24, this.originateTimestamp);
        Companion.encodeTimestamp(p, 32, this.receiveTimestamp);
        Companion.encodeTimestamp(p, 40, this.transmitTimestamp);
        return p;
    }

    @NotNull
    public String toString() {
        String string = new DecimalFormat("0.#E0").format(Math.pow(2.0, this.precision));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String precisionStr = string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("|Leap indicator: ").append(this.leapIndicator).append("\n                  |Version: ").append(this.version).append("\n                  |Mode: ").append(this.mode).append("\n                  |Stratum: ").append(this.stratum).append("\n                  |Poll: ").append(this.pollInterval).append("\n                  |Precision: ").append(this.precision).append(" (").append(precisionStr).append(" seconds)\n                  |Root delay: ").append(new DecimalFormat("0.00").format(this.rootDelay * (double)1000)).append(" ms\n                  |Root dispersion: ").append(new DecimalFormat("0.00").format(this.rootDispersion * (double)1000)).append(" ms\n                  |Reference identifier: ").append(Companion.referenceIdentifierToString(this.referenceIdentifier, this.stratum, this.version)).append("\n                  |Reference timestamp: ").append(Companion.timestampToString(this.referenceTimestamp)).append("\n                  |Originate timestamp: ");
        stringBuilder.append(Companion.timestampToString(this.originateTimestamp)).append("\n                  |Receive timestamp:   ").append(Companion.timestampToString(this.receiveTimestamp)).append("\n                  |Transmit timestamp:  ").append(Companion.timestampToString(this.transmitTimestamp));
        return StringsKt.trimMargin$default((String)stringBuilder.toString(), null, (int)1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0014\u0010#\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lgg/skytils/skytilsmod/utils/NtpMessage$Companion;", "", "", "array", "", "pointer", "", "decodeTimestamp", "([BI)D", "timestamp", "", "encodeTimestamp", "([BID)V", "", "ms", "", "millisToDate", "(J)Ljava/lang/String;", "now", "()D", "ref", "", "stratum", "", "version", "referenceIdentifierToString", "([BSB)Ljava/lang/String;", "timestampToString", "(D)Ljava/lang/String;", "b", "unsignedByteToShort", "(B)S", "DAYS", "J", "SECS", "dtf", "Ljava/lang/String;", "<init>", "()V", "SkytilsMod"})
    public static final class Companion {
        private Companion() {
        }

        public final double now() {
            return (double)System.currentTimeMillis() / 1000.0 + (double)2208988800L;
        }

        public final short unsignedByteToShort(byte b) {
            return (b & 0x80) == 128 ? (short)(128 + (b & 0x7F)) : (short)b;
        }

        public final double decodeTimestamp(@NotNull byte[] array, int pointer) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            double r = 0.0;
            for (int i2 = 0; i2 < 8; ++i2) {
                r += (double)this.unsignedByteToShort(array[pointer + i2]) * Math.pow(2.0, (3 - i2) * 8);
            }
            return r;
        }

        public final void encodeTimestamp(@NotNull byte[] array, int pointer, double timestamp) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            double timestamp2 = timestamp;
            for (int i2 = 0; i2 < 8; ++i2) {
                double base = Math.pow(2.0, (3 - i2) * 8);
                array[pointer + i2] = (byte)(timestamp2 / base);
                timestamp2 -= (double)this.unsignedByteToShort(array[pointer + i2]) * base;
            }
            array[7] = (byte)(Math.random() * 255.0);
        }

        @NotNull
        public final String timestampToString(double timestamp) {
            return timestamp == 0.0 ? "0" : this.millisToDate(Math.round(1000.0 * (timestamp - (double)2208988800L)));
        }

        @NotNull
        public final String millisToDate(long ms) {
            String string = NtpMessage.dtf;
            Object[] objectArray = new Object[]{ms};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        @NotNull
        public final String referenceIdentifierToString(@NotNull byte[] ref, short stratum, byte version2) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            if (stratum == 0 || stratum == 1) {
                return new String(ref, Charsets.UTF_8);
            }
            if (version2 == 3) {
                return "" + this.unsignedByteToShort(ref[0]) + '.' + this.unsignedByteToShort(ref[1]) + '.' + this.unsignedByteToShort(ref[2]) + '.' + this.unsignedByteToShort(ref[3]);
            }
            if (version2 == 4) {
                return "" + ((double)this.unsignedByteToShort(ref[0]) / 256.0 + (double)this.unsignedByteToShort(ref[1]) / 65536.0 + (double)this.unsignedByteToShort(ref[2]) / 1.6777216E7 + (double)this.unsignedByteToShort(ref[3]) / 4.294967296E9);
            }
            return "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

