/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.openpgp.PGPException;

public class PGPPad {
    private PGPPad() {
    }

    public static byte[] padSessionData(byte[] byArray) {
        return PGPPad.padSessionData(byArray, true);
    }

    public static byte[] padSessionData(byte[] byArray, boolean bl) {
        int n = byArray.length;
        int n2 = (n >>> 3) + 1 << 3;
        if (bl) {
            n2 = Math.max(40, n2);
        }
        int n3 = n2 - n;
        byte by = (byte)n3;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        for (int j = n; j < n2; ++j) {
            byArray2[j] = by;
        }
        return byArray2;
    }

    public static byte[] unpadSessionData(byte[] byArray) throws PGPException {
        int n = byArray.length;
        byte by = byArray[n - 1];
        int n2 = by & 0xFF;
        int n3 = n - n2;
        int n4 = n3 - 1;
        int n5 = 0;
        for (int j = 0; j < n; ++j) {
            int n6 = n4 - j >> 31;
            n5 |= (by ^ byArray[j]) & n6;
        }
        n5 |= n & 7;
        if ((n5 |= 40 - n >> 31) != 0) {
            throw new PGPException("bad padding found in session data");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }
}

