/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider2) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider2));
        this.keyConverter.setProvider(provider2);
        this.digestCalculatorProviderBuilder.setProvider(provider2);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.digestCalculatorProviderBuilder.setProvider(string);
        return this;
    }

    @Override
    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new JcaPGPContentVerifierBuilder(n, n2);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        @Override
        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            final Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            final PGPDigestCalculator pGPDigestCalculator = JcaPGPContentVerifierBuilderProvider.this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
            final PublicKey publicKey = JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey);
            try {
                signature.initVerify(publicKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key.", invalidKeyException);
            }
            return new PGPContentVerifier(){
                private final boolean isEdDsa;
                {
                    this.isEdDsa = JcaPGPContentVerifierBuilder.this.keyAlgorithm == 22 || JcaPGPContentVerifierBuilder.this.keyAlgorithm == 28 || JcaPGPContentVerifierBuilder.this.keyAlgorithm == 27;
                }

                @Override
                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                @Override
                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                @Override
                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                @Override
                public boolean verify(byte[] byArray) {
                    try {
                        int n;
                        if (publicKey instanceof RSAPublicKey && byArray.length < (n = (((RSAPublicKey)publicKey).getModulus().bitLength() + 7) / 8)) {
                            byte[] byArray2 = new byte[n];
                            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
                            return signature.verify(byArray2);
                        }
                        if (this.isEdDsa) {
                            signature.update(pGPDigestCalculator.getDigest());
                            return signature.verify(byArray);
                        }
                        return signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + signatureException.getMessage(), signatureException);
                    }
                }

                @Override
                public OutputStream getOutputStream() {
                    if (this.isEdDsa) {
                        return pGPDigestCalculator.getOutputStream();
                    }
                    return OutputStreamFactory.createStream((Signature)signature);
                }
            };
        }
    }
}

