/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.permission;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.permission.PermissionResult;
import org.incendo.cloud.permission.PredicatePermission;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
final class WrappingPredicatePermission<C>
implements PredicatePermission<C> {
    private final CloudKey<Void> key;
    private final Predicate<C> predicate;

    WrappingPredicatePermission(@NonNull CloudKey<Void> key2, @NonNull Predicate<C> predicate) {
        this.key = key2;
        this.predicate = predicate;
    }

    @Override
    public @NonNull PermissionResult testPermission(@NonNull C sender) {
        return PermissionResult.of(this.predicate.test(sender), this);
    }

    @Override
    public @NonNull CloudKey<Void> key() {
        return this.key;
    }

    public String toString() {
        return this.key.name();
    }
}

