/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.suggestion;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.CommandTree;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandContextFactory;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.services.State;
import org.incendo.cloud.setting.ManagerSetting;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionFactory;
import org.incendo.cloud.suggestion.SuggestionMapper;
import org.incendo.cloud.suggestion.Suggestions;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
public final class DelegatingSuggestionFactory<C, S extends Suggestion>
implements SuggestionFactory<C, S> {
    private final List<S> singleEmptySuggestion;
    private final CommandManager<C> commandManager;
    private final CommandTree<C> commandTree;
    private final CommandContextFactory<C> contextFactory;
    private final ExecutionCoordinator<C> executionCoordinator;
    private final SuggestionMapper<S> mapper;

    public DelegatingSuggestionFactory(@NonNull CommandManager<C> commandManager, @NonNull CommandTree<C> commandTree, @NonNull CommandContextFactory<C> contextFactory, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SuggestionMapper<S> mapper) {
        this.commandManager = commandManager;
        this.commandTree = commandTree;
        this.contextFactory = contextFactory;
        this.executionCoordinator = executionCoordinator;
        this.mapper = mapper;
        this.singleEmptySuggestion = Collections.singletonList(mapper.map(Suggestion.suggestion("")));
    }

    @Override
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull CommandContext<C> context, @NonNull String input2) {
        return this.suggestFromTree(context, input2);
    }

    @Override
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull C sender, @NonNull String input2) {
        return this.suggest((C)this.contextFactory.create(true, sender), input2);
    }

    @Override
    public <S2 extends Suggestion> @NonNull SuggestionFactory<C, S2> mapped(@NonNull SuggestionMapper<S2> mapper) {
        return new DelegatingSuggestionFactory<C, S2>(this.commandManager, this.commandTree, this.contextFactory, this.executionCoordinator, this.mapper.then(mapper));
    }

    private @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggestFromTree(@NonNull CommandContext<C> context, @NonNull String input2) {
        @NonNull CommandInput commandInput = CommandInput.of(input2);
        context.store("__raw_input__", commandInput.copy());
        if (this.commandManager.preprocessContext(context, commandInput) != State.ACCEPTED) {
            if (this.commandManager.settings().get(ManagerSetting.FORCE_SUGGESTION)) {
                return CompletableFuture.completedFuture(Suggestions.create(context, this.singleEmptySuggestion, commandInput));
            }
            return CompletableFuture.completedFuture(Suggestions.create(context, Collections.emptyList(), commandInput));
        }
        return this.executionCoordinator.coordinateSuggestions(this.commandTree, context, commandInput, this.mapper).thenApply(suggestions -> {
            if (this.commandManager.settings().get(ManagerSetting.FORCE_SUGGESTION) && suggestions.list().isEmpty()) {
                return Suggestions.create(suggestions.commandContext(), this.singleEmptySuggestion, commandInput);
            }
            return suggestions;
        });
    }
}

