/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.curio.CurioItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class MaxCloakItem
extends CurioItem {
    private static final String TAG_DEFENCE_COOLDOWN = "preventDeath";

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.skillcloaks.max_cloak"));
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack stack) {
        return 1;
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        return 1;
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.getWearer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            if (!player.f_19853_.f_46443_ && data.m_128451_(TAG_DEFENCE_COOLDOWN) > 0) {
                int totalSecs = data.m_128451_(TAG_DEFENCE_COOLDOWN) / 20;
                int mins = totalSecs % 3600 / 60;
                int secs = totalSecs % 60;
                if (mins > 0) {
                    player.m_5661_((Component)new TextComponent("Defence Cloak is still on cooldown for: " + mins + "m " + secs + "s"), true);
                } else {
                    player.m_5661_((Component)new TextComponent("Defence Cloak is still on cooldown for: " + secs + "s"), true);
                }
                player.m_6330_(SoundEvents.f_12217_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        result.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, new ResourceLocation("skillcloaks", "max_cloak_knockback_resistance").toString(), 1.0, AttributeModifier.Operation.ADDITION));
        return result;
    }
}

