/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.api.util.NonnullType;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.Submap;

@ParametersAreNonnullByDefault
public class Quad {
    @Deprecated
    public static final ISubmap TOP_LEFT = Submap.X2[0][0];
    @Deprecated
    public static final ISubmap TOP_RIGHT = Submap.X2[0][1];
    @Deprecated
    public static final ISubmap BOTTOM_LEFT = Submap.X2[1][0];
    @Deprecated
    public static final ISubmap BOTTOM_RIGHT = Submap.X2[1][1];
    private static final TextureAtlasSprite BASE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
    private final Vector3f[] vertPos;
    private final Vec2[] vertUv;
    private UVs uvs;
    private final Builder builder;
    private final int blocklight;
    private final int skylight;

    private Quad(Vector3f[] verts, Vec2[] uvs, Builder builder, TextureAtlasSprite sprite) {
        this(verts, uvs, builder, sprite, 0, 0);
    }

    @Deprecated
    private Quad(Vector3f[] verts, Vec2[] uvs, Builder builder, TextureAtlasSprite sprite, boolean fullbright) {
        this(verts, uvs, builder, sprite, fullbright ? 15 : 0, fullbright ? 15 : 0);
    }

    private Quad(Vector3f[] verts, Vec2[] uvs, Builder builder, TextureAtlasSprite sprite, int blocklight, int skylight) {
        this.vertPos = verts;
        this.vertUv = uvs;
        this.builder = builder;
        this.uvs = new UVs(sprite, uvs);
        this.blocklight = blocklight;
        this.skylight = skylight;
    }

    @Deprecated
    private Quad(Vector3f[] verts, UVs uvs, Builder builder) {
        this(verts, uvs.vectorize(), builder, uvs.getSprite());
    }

    @Deprecated
    private Quad(Vector3f[] verts, UVs uvs, Builder builder, boolean fullbright) {
        this(verts, uvs.vectorize(), builder, uvs.getSprite(), fullbright);
    }

    private Quad(Vector3f[] verts, UVs uvs, Builder builder, int blocklight, int skylight) {
        this(verts, uvs.vectorize(), builder, uvs.getSprite(), blocklight, skylight);
    }

    public Vector3f getVert(int index) {
        return this.vertPos[index % 4].m_122281_();
    }

    public Quad withVert(int index, Vector3f vert) {
        Preconditions.checkElementIndex((int)index, (int)4, (String)"Vertex index out of range!");
        Vector3f[] newverts = new Vector3f[4];
        System.arraycopy(this.vertPos, 0, newverts, 0, newverts.length);
        newverts[index] = vert;
        return new Quad(newverts, this.getUvs(), this.builder, this.blocklight, this.skylight);
    }

    public Vec2 getUv(int index) {
        return new Vec2(this.vertUv[index % 4].f_82470_, this.vertUv[index % 4].f_82471_);
    }

    public Quad withUv(int index, Vec2 uv) {
        Preconditions.checkElementIndex((int)index, (int)4, (String)"UV index out of range!");
        Vec2[] newuvs = new Vec2[4];
        System.arraycopy(this.getUvs().vectorize(), 0, newuvs, 0, newuvs.length);
        newuvs[index] = uv;
        return new Quad(this.vertPos, new UVs(newuvs), this.builder, this.blocklight, this.skylight);
    }

    public void compute() {
    }

    public Quad[] subdivide(int count) {
        if (count == 1) {
            return new Quad[]{this};
        }
        if (count != 4) {
            throw new UnsupportedOperationException();
        }
        ArrayList rects = Lists.newArrayList();
        Pair<Quad, Quad> firstDivide = this.divide(false);
        Pair<Quad, Quad> secondDivide = ((Quad)firstDivide.getLeft()).divide(true);
        rects.add((Quad)secondDivide.getLeft());
        if (firstDivide.getRight() != null) {
            Pair<Quad, Quad> thirdDivide = ((Quad)firstDivide.getRight()).divide(true);
            rects.add((Quad)thirdDivide.getLeft());
            rects.add((Quad)thirdDivide.getRight());
        } else {
            rects.add(null);
            rects.add(null);
        }
        rects.add((Quad)secondDivide.getRight());
        return rects.toArray(new Quad[rects.size()]);
    }

    private Pair<@NonnullType Quad, Quad> divide(boolean vertical) {
        float max;
        float min;
        UVs uvs = this.getUvs().normalize();
        if (vertical) {
            min = uvs.minV;
            max = uvs.maxV;
        } else {
            min = uvs.minU;
            max = uvs.maxU;
        }
        if ((double)min < 0.5 && (double)max > 0.5) {
            UVs first = new UVs(vertical ? uvs.minU : 0.5f, vertical ? 0.5f : uvs.minV, uvs.maxU, uvs.maxV, uvs.getSprite());
            UVs second = new UVs(uvs.minU, uvs.minV, vertical ? uvs.maxU : 0.5f, vertical ? 0.5f : uvs.maxV, uvs.getSprite());
            int firstIndex = 0;
            for (int i = 0; i < this.vertUv.length; ++i) {
                if (this.vertUv[i].f_82471_ != this.getUvs().minV || this.vertUv[i].f_82470_ != this.getUvs().minU) continue;
                firstIndex = i;
                break;
            }
            float f = (0.5f - min) / (max - min);
            Vector3f[] firstQuad = new Vector3f[4];
            Vector3f[] secondQuad = new Vector3f[4];
            for (int i = 0; i < 4; ++i) {
                int idx = (firstIndex + i) % 4;
                firstQuad[i] = this.vertPos[idx].m_122281_();
                secondQuad[i] = this.vertPos[idx].m_122281_();
            }
            int i1 = 0;
            int i2 = vertical ? 1 : 3;
            int j1 = vertical ? 3 : 1;
            int j2 = 2;
            firstQuad[i1].setX(Quad.lerp(firstQuad[i1].m_122239_(), firstQuad[i2].m_122239_(), f));
            firstQuad[i1].setY(Quad.lerp(firstQuad[i1].m_122260_(), firstQuad[i2].m_122260_(), f));
            firstQuad[i1].setZ(Quad.lerp(firstQuad[i1].m_122269_(), firstQuad[i2].m_122269_(), f));
            firstQuad[j1].setX(Quad.lerp(firstQuad[j1].m_122239_(), firstQuad[j2].m_122239_(), f));
            firstQuad[j1].setY(Quad.lerp(firstQuad[j1].m_122260_(), firstQuad[j2].m_122260_(), f));
            firstQuad[j1].setZ(Quad.lerp(firstQuad[j1].m_122269_(), firstQuad[j2].m_122269_(), f));
            secondQuad[i2].setX(Quad.lerp(secondQuad[i1].m_122239_(), secondQuad[i2].m_122239_(), f));
            secondQuad[i2].setY(Quad.lerp(secondQuad[i1].m_122260_(), secondQuad[i2].m_122260_(), f));
            secondQuad[i2].setZ(Quad.lerp(secondQuad[i1].m_122269_(), secondQuad[i2].m_122269_(), f));
            secondQuad[j2].setX(Quad.lerp(secondQuad[j1].m_122239_(), secondQuad[j2].m_122239_(), f));
            secondQuad[j2].setY(Quad.lerp(secondQuad[j1].m_122260_(), secondQuad[j2].m_122260_(), f));
            secondQuad[j2].setZ(Quad.lerp(secondQuad[j1].m_122269_(), secondQuad[j2].m_122269_(), f));
            Quad q1 = new Quad(firstQuad, first.relativize(), this.builder, this.blocklight, this.skylight);
            Quad q2 = new Quad(secondQuad, second.relativize(), this.builder, this.blocklight, this.skylight);
            return Pair.of((Object)q1, (Object)q2);
        }
        return Pair.of((Object)this, null);
    }

    public static float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }

    public static float normalize(float min, float max, float x) {
        return (x - min) / (max - min);
    }

    public Quad rotate(int amount) {
        int i;
        Vec2[] uvs = new Vec2[4];
        TextureAtlasSprite s = this.getUvs().getSprite();
        for (i = 0; i < 4; ++i) {
            Vec2 normalized = new Vec2(Quad.normalize(s.m_118409_(), s.m_118410_(), this.vertUv[i].f_82470_), Quad.normalize(s.m_118411_(), s.m_118412_(), this.vertUv[i].f_82471_));
            uvs[i] = switch (amount) {
                case 1 -> new Vec2(normalized.f_82471_, 1.0f - normalized.f_82470_);
                case 2 -> new Vec2(1.0f - normalized.f_82470_, 1.0f - normalized.f_82471_);
                case 3 -> new Vec2(1.0f - normalized.f_82471_, normalized.f_82470_);
                default -> new Vec2(normalized.f_82470_, normalized.f_82471_);
            };
        }
        for (i = 0; i < uvs.length; ++i) {
            uvs[i] = new Vec2(Quad.lerp(s.m_118409_(), s.m_118410_(), uvs[i].f_82470_), Quad.lerp(s.m_118411_(), s.m_118412_(), uvs[i].f_82471_));
        }
        return new Quad(this.vertPos, uvs, this.builder, this.getUvs().getSprite(), this.blocklight, this.skylight);
    }

    public Quad derotate() {
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            if (!(this.vertUv[i].f_82470_ <= this.getUvs().minU) || !(this.vertUv[i].f_82471_ <= this.getUvs().minV)) continue;
            start = i;
            break;
        }
        Vec2[] uvs = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = this.vertUv[(i + start) % 4];
        }
        return new Quad(this.vertPos, uvs, this.builder, this.getUvs().getSprite(), this.blocklight, this.skylight);
    }

    public Quad setLight(int blocklight, int skylight) {
        return new Quad(this.vertPos, this.uvs, this.builder, Math.max(this.blocklight, blocklight), Math.max(this.skylight, skylight));
    }

    public BakedQuad rebake() {
        VertexFormat format = this.builder.vertexFormat;
        BakedQuadBuilder builder = new BakedQuadBuilder();
        builder.setQuadOrientation(this.builder.quadOrientation);
        builder.setQuadTint(this.builder.quadTint);
        builder.setApplyDiffuseLighting(this.builder.applyDiffuseLighting);
        builder.setTexture(this.uvs.getSprite());
        for (int v = 0; v < 4; ++v) {
            block5: for (int i = 0; i < format.m_86023_().size(); ++i) {
                VertexFormatElement ele = (VertexFormatElement)format.m_86023_().get(i);
                switch (ele.m_86048_()) {
                    case POSITION: {
                        Vector3f p = this.vertPos[v];
                        builder.put(i, new float[]{p.m_122239_(), p.m_122260_(), p.m_122269_(), 1.0f});
                        continue block5;
                    }
                    case UV: {
                        if (ele.m_86049_() == 2) {
                            builder.put(i, new float[]{(float)this.blocklight * 32.0f / 65535.0f, (float)this.skylight * 32.0f / 65535.0f});
                            continue block5;
                        }
                        if (ele.m_86049_() == 0) {
                            Vec2 uv = this.vertUv[v];
                            builder.put(i, new float[]{uv.f_82470_, uv.f_82471_});
                            continue block5;
                        }
                    }
                    default: {
                        builder.put(i, (float[])this.builder.data.get((Object)ele).get(v));
                    }
                }
            }
        }
        return builder.build();
    }

    public Quad transformUVs(TextureAtlasSprite sprite) {
        return this.transformUVs(sprite, CTMLogic.FULL_TEXTURE.normalize());
    }

    public Quad transformUVs(TextureAtlasSprite sprite, ISubmap submap) {
        return new Quad(this.vertPos, this.getUvs().transform(sprite, submap), this.builder, this.blocklight, this.skylight);
    }

    public Quad grow() {
        return new Quad(this.vertPos, this.getUvs().normalizeQuadrant(), this.builder, this.blocklight, this.skylight);
    }

    @Deprecated
    public Quad setFullbright(boolean fullbright) {
        if (this.blocklight == 15 != fullbright || this.skylight == 15 != fullbright) {
            return new Quad(this.vertPos, this.getUvs(), this.builder, fullbright);
        }
        return this;
    }

    public static Quad from(BakedQuad baked) {
        Builder b = new Builder(DefaultVertexFormat.f_85811_, baked.m_173410_());
        baked.pipe((IVertexConsumer)b);
        return b.build();
    }

    public String toString() {
        return "Quad(vertPos=" + Arrays.deepToString(this.vertPos) + ", vertUv=" + Arrays.deepToString(this.vertUv) + ")";
    }

    public UVs getUvs() {
        return this.uvs;
    }

    public static class Builder
    implements IVertexConsumer {
        private final VertexFormat vertexFormat;
        private final TextureAtlasSprite sprite;
        private int quadTint = -1;
        private Direction quadOrientation;
        private boolean applyDiffuseLighting;
        private ListMultimap<VertexFormatElement, float[]> data = MultimapBuilder.hashKeys().arrayListValues().build();

        public void put(int element, float ... data) {
            if (data == null) {
                return;
            }
            float[] copy = new float[data.length];
            System.arraycopy(data, 0, copy, 0, data.length);
            VertexFormatElement ele = (VertexFormatElement)this.vertexFormat.m_86023_().get(element);
            this.data.put((Object)ele, (Object)copy);
        }

        public Quad build() {
            Vector3f[] verts = (Vector3f[])this.fromData(this.data.get((Object)DefaultVertexFormat.f_85804_), 3);
            Vec2[] uvs = (Vec2[])this.fromData(this.data.get((Object)DefaultVertexFormat.f_85806_), 2);
            return new Quad(verts, uvs, this, this.getSprite());
        }

        private <T> T[] fromData(List<float[]> data, int size) {
            Vec2[] ret = size == 2 ? new Vec2[data.size()] : new Vector3f[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                ret[i] = size == 2 ? new Vec2(data.get(i)[0], data.get(i)[1]) : new Vector3f(data.get(i)[0], data.get(i)[1], data.get(i)[2]);
            }
            return ret;
        }

        public void setTexture(@Nullable TextureAtlasSprite texture) {
        }

        public Builder(VertexFormat vertexFormat, TextureAtlasSprite sprite) {
            this.vertexFormat = vertexFormat;
            this.sprite = sprite;
        }

        public VertexFormat getVertexFormat() {
            return this.vertexFormat;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public void setQuadTint(int quadTint) {
            this.quadTint = quadTint;
        }

        public void setQuadOrientation(Direction quadOrientation) {
            this.quadOrientation = quadOrientation;
        }

        public void setApplyDiffuseLighting(boolean applyDiffuseLighting) {
            this.applyDiffuseLighting = applyDiffuseLighting;
        }
    }

    public class UVs {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private final TextureAtlasSprite sprite;
        private final Vec2[] data;

        private UVs(Vec2 ... data) {
            this(BASE, data);
        }

        private UVs(TextureAtlasSprite sprite, Vec2 ... data) {
            this.data = data;
            this.sprite = sprite;
            float minU = Float.MAX_VALUE;
            float minV = Float.MAX_VALUE;
            float maxU = 0.0f;
            float maxV = 0.0f;
            for (Vec2 v : data) {
                minU = Math.min(minU, v.f_82470_);
                minV = Math.min(minV, v.f_82471_);
                maxU = Math.max(maxU, v.f_82470_);
                maxV = Math.max(maxV, v.f_82471_);
            }
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public UVs(float minU, float minV, float maxU, float maxV, TextureAtlasSprite sprite) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.sprite = sprite;
            this.data = this.vectorize();
        }

        public UVs transform(TextureAtlasSprite other, ISubmap submap) {
            UVs normal = this.normalize();
            submap = submap.normalize();
            float width = normal.maxU - normal.minU;
            float height = normal.maxV - normal.minV;
            float minU = submap.getXOffset();
            float minV = submap.getYOffset();
            float maxU = (minU += normal.minU * submap.getWidth()) + width * submap.getWidth();
            float maxV = (minV += normal.minV * submap.getHeight()) + height * submap.getHeight();
            return new UVs(other, new Vec2(this.data[0].f_82470_ == this.minU ? minU : maxU, this.data[0].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[1].f_82470_ == this.minU ? minU : maxU, this.data[1].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[2].f_82470_ == this.minU ? minU : maxU, this.data[2].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[3].f_82470_ == this.minU ? minU : maxU, this.data[3].f_82471_ == this.minV ? minV : maxV)).relativize();
        }

        UVs normalizeQuadrant() {
            UVs normal = this.normalize();
            int quadrant = normal.getQuadrant();
            float minUInterp = quadrant == 1 || quadrant == 2 ? 0.5f : 0.0f;
            float minVInterp = quadrant < 2 ? 0.5f : 0.0f;
            float maxUInterp = quadrant == 0 || quadrant == 3 ? 0.5f : 1.0f;
            float maxVInterp = quadrant > 1 ? 0.5f : 1.0f;
            normal = new UVs(this.sprite, this.normalize(new Vec2(minUInterp, minVInterp), new Vec2(maxUInterp, maxVInterp), normal.vectorize()));
            return normal.relativize();
        }

        public UVs normalize() {
            Vec2 min = new Vec2(this.sprite.m_118409_(), this.sprite.m_118411_());
            Vec2 max = new Vec2(this.sprite.m_118410_(), this.sprite.m_118412_());
            return new UVs(this.sprite, this.normalize(min, max, this.data));
        }

        public UVs relativize() {
            return this.relativize(this.sprite);
        }

        public UVs relativize(TextureAtlasSprite sprite) {
            Vec2 min = new Vec2(sprite.m_118409_(), sprite.m_118411_());
            Vec2 max = new Vec2(sprite.m_118410_(), sprite.m_118412_());
            return new UVs(sprite, this.lerp(min, max, this.data));
        }

        public Vec2[] vectorize() {
            Vec2[] vec2Array;
            if (this.data == null) {
                Vec2[] vec2Array2 = new Vec2[4];
                vec2Array2[0] = new Vec2(this.minU, this.minV);
                vec2Array2[1] = new Vec2(this.minU, this.maxV);
                vec2Array2[2] = new Vec2(this.maxU, this.maxV);
                vec2Array = vec2Array2;
                vec2Array2[3] = new Vec2(this.maxU, this.minV);
            } else {
                vec2Array = this.data;
            }
            return vec2Array;
        }

        private Vec2[] normalize(Vec2 min, Vec2 max, Vec2 ... vecs) {
            Vec2[] ret = new Vec2[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.normalize(min, max, vecs[i]);
            }
            return ret;
        }

        private Vec2 normalize(Vec2 min, Vec2 max, Vec2 vec) {
            return new Vec2(Quad.normalize(min.f_82470_, max.f_82470_, vec.f_82470_), Quad.normalize(min.f_82471_, max.f_82471_, vec.f_82471_));
        }

        private Vec2[] lerp(Vec2 min, Vec2 max, Vec2 ... vecs) {
            Vec2[] ret = new Vec2[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.lerp(min, max, vecs[i]);
            }
            return ret;
        }

        private Vec2 lerp(Vec2 min, Vec2 max, Vec2 vec) {
            return new Vec2(Quad.lerp(min.f_82470_, max.f_82470_, vec.f_82470_), Quad.lerp(min.f_82471_, max.f_82471_, vec.f_82471_));
        }

        public int getQuadrant() {
            if (this.maxU <= 0.5f) {
                if (this.maxV <= 0.5f) {
                    return 3;
                }
                return 0;
            }
            if (this.maxV <= 0.5f) {
                return 2;
            }
            return 1;
        }

        public String toString() {
            return "Quad.UVs(minU=" + this.getMinU() + ", minV=" + this.getMinV() + ", maxU=" + this.getMaxU() + ", maxV=" + this.getMaxV() + ", sprite=" + this.getSprite() + ", data=" + Arrays.deepToString(this.data) + ")";
        }

        public float getMinU() {
            return this.minU;
        }

        public float getMinV() {
            return this.minV;
        }

        public float getMaxU() {
            return this.maxU;
        }

        public float getMaxV() {
            return this.maxV;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }
    }

    public static final class Vertex {
        private final Vector3f pos;
        private final Vec2 uvs;

        public Vertex(Vector3f pos, Vec2 uvs) {
            this.pos = pos;
            this.uvs = uvs;
        }

        public Vector3f getPos() {
            return this.pos;
        }

        public Vec2 getUvs() {
            return this.uvs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)o;
            Vector3f this$pos = this.getPos();
            Vector3f other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            Vec2 this$uvs = this.getUvs();
            Vec2 other$uvs = other.getUvs();
            return !(this$uvs == null ? other$uvs != null : !this$uvs.equals(other$uvs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Vector3f $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            Vec2 $uvs = this.getUvs();
            result = result * 59 + ($uvs == null ? 43 : $uvs.hashCode());
            return result;
        }

        public String toString() {
            return "Quad.Vertex(pos=" + this.getPos() + ", uvs=" + this.getUvs() + ")";
        }
    }
}

