/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.common.BlendCache;
import fionathemortal.betterbiomeblend.common.BlendChunk;
import fionathemortal.betterbiomeblend.common.ColorCaching;
import fionathemortal.betterbiomeblend.common.CustomColorResolverCompatibility;
import fionathemortal.betterbiomeblend.common.cache.BiomeCache;
import fionathemortal.betterbiomeblend.common.cache.ColorCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientWorld
extends Level {
    @Shadow
    private final Object2ObjectArrayMap<ColorResolver, BlockTintCache> f_104558_ = new Object2ObjectArrayMap();
    @Unique
    public final BlendCache betterBiomeBlend$blendColorCache = new BlendCache(2048);
    @Unique
    public final ColorCache betterBiomeBlend$chunkColorCache = new ColorCache(512);
    @Unique
    public final BiomeCache betterBiomeBlend$chunkBiomeCache = new BiomeCache(32);
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalWaterChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalGrassChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalFoliageChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalGenericChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });

    protected MixinClientWorld(WritableLevelData p_46450_, ResourceKey<Level> p_46451_, Holder<DimensionType> p_46452_, Supplier<ProfilerFiller> p_46453_, boolean p_46454_, boolean p_46455_, long p_46456_) {
        super(p_46450_, p_46451_, p_46452_, p_46453_, p_46454_, p_46455_, p_46456_);
    }

    @Inject(method={"clearTintCaches"}, at={@At(value="HEAD")})
    public void onClearColorCaches(CallbackInfo ci) {
        this.betterBiomeBlend$blendColorCache.invalidateAll();
        this.betterBiomeBlend$chunkColorCache.invalidateAll();
        this.betterBiomeBlend$chunkBiomeCache.invalidateAll();
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    public void onOnChunkLoaded(ChunkPos chunkPos, CallbackInfo ci) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        this.betterBiomeBlend$blendColorCache.invalidateChunk(chunkX, chunkZ);
        this.betterBiomeBlend$chunkColorCache.invalidateSmallNeighborhood(chunkX, chunkZ);
        this.betterBiomeBlend$chunkBiomeCache.invalidateSmallNeighborhood(chunkX, chunkZ);
    }

    @Overwrite
    public int m_6171_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        ThreadLocal<BlendChunk> threadLocalChunk;
        int colorType;
        if (colorResolverIn == BiomeColors.f_108789_) {
            colorType = 0;
            threadLocalChunk = this.betterBiomeBlend$threadLocalGrassChunk;
        } else if (colorResolverIn == BiomeColors.f_108791_) {
            colorType = 1;
            threadLocalChunk = this.betterBiomeBlend$threadLocalWaterChunk;
        } else if (colorResolverIn == BiomeColors.f_108790_) {
            colorType = 2;
            threadLocalChunk = this.betterBiomeBlend$threadLocalFoliageChunk;
        } else {
            colorType = CustomColorResolverCompatibility.getColorType(colorResolverIn);
            threadLocalChunk = this.betterBiomeBlend$threadLocalGenericChunk;
        }
        int x = blockPosIn.m_123341_();
        int y = blockPosIn.m_123342_();
        int z = blockPosIn.m_123343_();
        int chunkX = x >> 4;
        int chunkY = y >> 4;
        int chunkZ = z >> 4;
        BlendChunk chunk = ColorCaching.getThreadLocalChunk(threadLocalChunk, chunkX, chunkY, chunkZ, colorType);
        if (chunk == null) {
            chunk = ColorCaching.getBlendedColorChunk(this, colorResolverIn, colorType, chunkX, chunkY, chunkZ, this.betterBiomeBlend$blendColorCache, this.betterBiomeBlend$chunkColorCache, this.betterBiomeBlend$chunkBiomeCache);
            ColorCaching.setThreadLocalChunk(threadLocalChunk, chunk, this.betterBiomeBlend$blendColorCache);
        }
        int result = chunk.getColor(x, y, z);
        return result;
    }

    public ColorCache getColorCache() {
        return this.betterBiomeBlend$chunkColorCache;
    }

    public BiomeCache getBiomeCache() {
        return this.betterBiomeBlend$chunkBiomeCache;
    }
}

