/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.events.server;

import io.github.kosmx.emotes.api.events.impl.Event;
import io.github.kosmx.emotes.api.events.impl.EventResult;
import io.github.kosmx.emotes.common.emote.EmoteData;
import java.util.UUID;

public final class ServerEmoteEvents {
    public static final Event<EmoteVerifier> EMOTE_VERIFICATION = new Event<EmoteVerifier>(EmoteVerifier.class, listeners -> (emote, userID) -> {
        for (EmoteVerifier listener : listeners) {
            EventResult result = listener.verify(emote, userID);
            if (result != EventResult.FAIL && result != EventResult.CONSUME) continue;
            return result;
        }
        return EventResult.PASS;
    });
    public static final Event<EmotePlayEvent> EMOTE_PLAY = new Event<EmotePlayEvent>(EmotePlayEvent.class, listeners -> (emote, userID) -> {
        for (EmotePlayEvent listener : listeners) {
            listener.onEmotePlay(emote, userID);
        }
    });
    public static final Event<EmoteStopEvent> EMOTE_STOP_BY_USER = new Event<EmoteStopEvent>(EmoteStopEvent.class, listeners -> (emoteID, userID) -> {
        for (EmoteStopEvent listener : listeners) {
            listener.onStopEmote(emoteID, userID);
        }
    });

    @FunctionalInterface
    public static interface EmoteStopEvent {
        public void onStopEmote(UUID var1, UUID var2);
    }

    @FunctionalInterface
    public static interface EmotePlayEvent {
        public void onEmotePlay(EmoteData var1, UUID var2);
    }

    @FunctionalInterface
    public static interface EmoteVerifier {
        public EventResult verify(EmoteData var1, UUID var2);
    }
}

