/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.emote;

import io.github.kosmx.emotes.common.emote.EmoteFormat;
import io.github.kosmx.emotes.common.opennbs.NBS;
import io.github.kosmx.emotes.common.tools.Ease;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class EmoteData
implements Supplier<UUID> {
    public static final StateCollection.State EMPTY_STATE = new StateCollection.State("empty", 0.0f, 0.0f, false);
    public final int beginTick;
    public final int endTick;
    public final int stopTick;
    public final boolean isInfinite;
    public final int returnToTick;
    public final HashMap<String, StateCollection> bodyParts;
    @Deprecated
    public final StateCollection head;
    @Deprecated
    public final StateCollection body;
    @Deprecated
    public final StateCollection rightArm;
    @Deprecated
    public final StateCollection leftArm;
    @Deprecated
    public final StateCollection rightLeg;
    @Deprecated
    public final StateCollection leftLeg;
    @Deprecated
    public final StateCollection rightItem;
    @Deprecated
    public final StateCollection leftItem;
    @Deprecated
    public final StateCollection torso;
    public final boolean isEasingBefore;
    public final boolean nsfw;
    private final UUID uuid;
    public final boolean isUUIDGenerated;
    @Nullable
    public final String name;
    @Nullable
    public final String description;
    @Nullable
    public final String author;
    @Nullable
    public NBS song;
    public static float staticThreshold = 8.0f;
    public final EmoteFormat emoteFormat;
    @Nullable
    public ByteBuffer iconData;
    public boolean isBuiltin = false;

    private EmoteData(int beginTick, int endTick, int stopTick, boolean isInfinite, int returnToTick, HashMap<String, StateCollection> bodyParts, boolean isEasingBefore, boolean nsfw, UUID uuid, @Nullable String name, @Nullable String description, @Nullable String author, EmoteFormat emoteFormat, ByteBuffer iconData, NBS song) {
        this.beginTick = Math.max(beginTick, 0);
        this.name = name;
        this.description = description;
        this.author = author;
        this.endTick = Math.max(beginTick + 1, endTick);
        this.stopTick = stopTick <= endTick ? endTick + 3 : stopTick;
        this.isInfinite = isInfinite;
        this.returnToTick = returnToTick;
        this.bodyParts = bodyParts;
        this.isEasingBefore = isEasingBefore;
        this.nsfw = nsfw;
        if (uuid == null) {
            this.isUUIDGenerated = true;
            uuid = this.generateUuid();
        } else {
            this.isUUIDGenerated = false;
        }
        this.uuid = uuid;
        this.emoteFormat = emoteFormat;
        this.iconData = iconData;
        this.song = song;
        this.head = bodyParts.get("head");
        this.body = bodyParts.get("body");
        this.rightArm = bodyParts.get("rightArm");
        this.leftArm = bodyParts.get("leftArm");
        this.rightLeg = bodyParts.get("rightLeg");
        this.leftLeg = bodyParts.get("leftLeg");
        this.rightItem = bodyParts.get("rightItem");
        this.leftItem = bodyParts.get("leftItem");
        this.torso = bodyParts.get("torso");
        assert (emoteFormat != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmoteData)) {
            return false;
        }
        EmoteData emoteData = (EmoteData)o;
        if (this.beginTick != emoteData.beginTick) {
            return false;
        }
        if (this.endTick != emoteData.endTick) {
            return false;
        }
        if (this.stopTick != emoteData.stopTick) {
            return false;
        }
        if (this.isInfinite != emoteData.isInfinite) {
            return false;
        }
        if (this.returnToTick != emoteData.returnToTick) {
            return false;
        }
        if (this.isEasingBefore != emoteData.isEasingBefore) {
            return false;
        }
        if (!Objects.equals(this.iconData, emoteData.iconData)) {
            return false;
        }
        return this.bodyParts.equals(emoteData.bodyParts);
    }

    public int hashCode() {
        int result = this.beginTick;
        result = 31 * result + this.endTick;
        result = 31 * result + this.stopTick;
        result = 31 * result + (this.isInfinite ? 1 : 0);
        result = 31 * result + this.returnToTick;
        result = 31 * result + (this.isEasingBefore ? 1 : 0);
        result = 31 * result + this.bodyParts.hashCode();
        return result;
    }

    private UUID generateUuid() {
        int result = this.beginTick;
        result = 31 * result + this.endTick;
        result = 31 * result + this.stopTick;
        result = 31 * result + (this.isInfinite ? 1 : 0);
        result = 31 * result + this.returnToTick;
        result = 31 * result + (this.isEasingBefore ? 1 : 0);
        long dataHash = result * 31 + this.bodyParts.hashCode();
        long nameHash = this.name == null ? 0L : (long)this.name.hashCode();
        long descHash = this.description == null ? 0L : (long)this.description.hashCode();
        long authHash = result * 31 + (this.author == null ? 0 : this.author.hashCode());
        return new UUID(dataHash << (int)(32L + nameHash), descHash << (int)(32L + authHash));
    }

    public EmoteData copy() {
        return this.mutableCopy().build();
    }

    public EmoteBuilder mutableCopy() {
        HashMap<String, StateCollection> newParts = new HashMap<String, StateCollection>();
        for (Map.Entry<String, StateCollection> part : this.bodyParts.entrySet()) {
            newParts.put(part.getKey(), part.getValue().copy());
        }
        return new EmoteBuilder(this.beginTick, this.endTick, this.stopTick, this.isInfinite, this.returnToTick, newParts, this.isEasingBefore, this.nsfw, this.uuid, this.name, this.description, this.author, this.emoteFormat, this.iconData, this.song);
    }

    public boolean isPlayingAt(int tick) {
        return this.isInfinite || tick < this.stopTick && tick > 0;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public UUID get() {
        return this.uuid;
    }

    public int getLength() {
        return this.stopTick;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public String toString() {
        return "EmoteBuilder{uuid=" + this.uuid + ", length=" + this.getLength() + ", song=" + this.song + '}';
    }

    public static class StateCollection {
        @Deprecated
        public final String name;
        public final State x;
        public final State y;
        public final State z;
        public final State pitch;
        public final State yaw;
        public final State roll;
        @Nullable
        public final State bend;
        @Nullable
        public final State bendDirection;
        public final boolean isBendable;

        public StateCollection(float x, float y, float z, float pitch, float yaw, float roll, String name, float translationThreshold, boolean bendable) {
            this.name = name;
            this.x = new State("x", x, translationThreshold, false);
            this.y = new State("y", y, translationThreshold, false);
            this.z = new State("z", z, translationThreshold, false);
            this.pitch = new State("pitch", pitch, 0.0f, true);
            this.yaw = new State("yaw", yaw, 0.0f, true);
            this.roll = new State("roll", roll, 0.0f, true);
            if (bendable) {
                this.bendDirection = new State("axis", 0.0f, 0.0f, true);
                this.bend = new State("bend", 0.0f, 0.0f, true);
            } else {
                this.bend = null;
                this.bendDirection = null;
            }
            this.isBendable = bendable;
        }

        public StateCollection(StateCollection stateCollection) {
            this.name = stateCollection.name;
            this.x = stateCollection.x.copy();
            this.y = stateCollection.y.copy();
            this.z = stateCollection.z.copy();
            this.pitch = stateCollection.pitch.copy();
            this.yaw = stateCollection.yaw.copy();
            this.roll = stateCollection.roll.copy();
            this.isBendable = stateCollection.isBendable;
            if (stateCollection.isBendable) {
                this.bendDirection = stateCollection.bendDirection.copy();
                this.bend = stateCollection.bend.copy();
            } else {
                this.bend = null;
                this.bendDirection = null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateCollection)) {
                return false;
            }
            StateCollection that = (StateCollection)o;
            if (this.isBendable != that.isBendable) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (!this.x.equals(that.x)) {
                return false;
            }
            if (!this.y.equals(that.y)) {
                return false;
            }
            if (!this.z.equals(that.z)) {
                return false;
            }
            if (!this.pitch.equals(that.pitch)) {
                return false;
            }
            if (!this.yaw.equals(that.yaw)) {
                return false;
            }
            if (!this.roll.equals(that.roll)) {
                return false;
            }
            if (this.bend != null ? !this.bend.equals(that.bend) : that.bend != null) {
                return false;
            }
            return this.bendDirection != null ? this.bendDirection.equals(that.bendDirection) : that.bendDirection == null;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.x.hashCode();
            result = 31 * result + this.y.hashCode();
            result = 31 * result + this.z.hashCode();
            result = 31 * result + this.pitch.hashCode();
            result = 31 * result + this.yaw.hashCode();
            result = 31 * result + this.roll.hashCode();
            result = 31 * result + (this.bend != null ? this.bend.hashCode() : 0);
            result = 31 * result + (this.bendDirection != null ? this.bendDirection.hashCode() : 0);
            result = 31 * result + (this.isBendable ? 1 : 0);
            return result;
        }

        public void fullyEnablePart(boolean always) {
            if (always || this.x.isEnabled || this.y.isEnabled || this.z.isEnabled || this.pitch.isEnabled || this.yaw.isEnabled || this.roll.isEnabled || this.isBendable && (this.bend.isEnabled || this.bendDirection.isEnabled)) {
                this.x.isEnabled = true;
                this.y.isEnabled = true;
                this.z.isEnabled = true;
                this.pitch.isEnabled = true;
                this.yaw.isEnabled = true;
                this.roll.isEnabled = true;
                if (this.isBendable) {
                    this.bend.isEnabled = true;
                    this.bendDirection.isEnabled = true;
                }
            }
        }

        protected void optimize(boolean isLooped, int ret) {
            this.x.optimize(isLooped, ret);
            this.y.optimize(isLooped, ret);
            this.z.optimize(isLooped, ret);
            this.pitch.optimize(isLooped, ret);
            this.yaw.optimize(isLooped, ret);
            this.roll.optimize(isLooped, ret);
            if (this.isBendable) {
                this.bend.optimize(isLooped, ret);
                this.bendDirection.optimize(isLooped, ret);
            }
        }

        public StateCollection copy() {
            return new StateCollection(this);
        }

        public static class State {
            public final float defaultValue;
            public final float threshold;
            public final List<KeyFrame> keyFrames = new ArrayList<KeyFrame>();
            public final String name;
            private final boolean isAngle;
            public boolean isEnabled = false;

            public State(State state) {
                this.defaultValue = state.defaultValue;
                this.threshold = state.threshold;
                this.keyFrames.addAll(state.keyFrames);
                this.name = state.name;
                this.isAngle = state.isAngle;
                this.isEnabled = state.isEnabled;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof State)) {
                    return false;
                }
                State state = (State)o;
                if (Float.compare(state.defaultValue, this.defaultValue) != 0) {
                    return false;
                }
                if (this.isAngle != state.isAngle) {
                    return false;
                }
                if (!this.keyFrames.equals(state.keyFrames)) {
                    return false;
                }
                if (this.isEnabled != state.isEnabled) {
                    return false;
                }
                return Objects.equals(this.name, state.name);
            }

            public int hashCode() {
                int result = this.defaultValue != 0.0f ? Float.floatToIntBits(this.defaultValue) : 0;
                result = 31 * result + this.keyFrames.hashCode();
                result = 31 * result + (this.isAngle ? 1 : 0);
                return result;
            }

            private State(String name, float defaultValue, float threshold, boolean isAngle) {
                this.defaultValue = defaultValue;
                this.threshold = threshold;
                this.name = name;
                this.isAngle = isAngle;
            }

            public int length() {
                return this.keyFrames.size();
            }

            public int findAtTick(int tick) {
                int i = -1;
                while (this.keyFrames.size() > i + 1 && this.keyFrames.get((int)(i + 1)).tick <= tick) {
                    ++i;
                }
                return i;
            }

            public boolean addKeyFrame(int tick, float value, Ease ease, int rotate, boolean degrees) {
                if (degrees && this.isAngle) {
                    value *= (float)Math.PI / 180;
                }
                boolean bl = this.addKeyFrame(new KeyFrame(tick, value, ease));
                if (this.isAngle && rotate != 0) {
                    bl = this.addKeyFrame(new KeyFrame(tick, (float)((double)value + Math.PI * 2 * (double)rotate), ease)) && bl;
                }
                return bl;
            }

            public boolean addKeyFrame(int tick, float value, Ease ease) {
                if (Float.isNaN(value)) {
                    throw new IllegalArgumentException("value can't be NaN");
                }
                return this.addKeyFrame(new KeyFrame(tick, value, ease));
            }

            private boolean addKeyFrame(KeyFrame keyFrame) {
                this.isEnabled = true;
                int i = this.findAtTick(keyFrame.tick) + 1;
                this.keyFrames.add(i, keyFrame);
                return this.isAngle || !(Math.abs(this.defaultValue - keyFrame.value) > this.threshold);
            }

            public void replace(KeyFrame keyFrame, int pos) {
                this.keyFrames.remove(pos);
                this.keyFrames.add(pos, keyFrame);
            }

            public void replaceEase(int pos, Ease ease) {
                KeyFrame original = this.keyFrames.get(pos);
                this.replace(new KeyFrame(original.tick, original.value, ease), pos);
            }

            protected void optimize(boolean isLooped, int returnToTick) {
                for (int i = 1; i < this.keyFrames.size() - 1; ++i) {
                    if (this.keyFrames.get((int)(i - 1)).value != this.keyFrames.get((int)i).value || this.keyFrames.size() <= i + 1 || this.keyFrames.get((int)i).value != this.keyFrames.get((int)(i + 1)).value || isLooped && this.keyFrames.get((int)(i - 1)).tick < returnToTick && this.keyFrames.get((int)i).tick >= returnToTick) continue;
                    this.keyFrames.remove(i--);
                }
            }

            public State copy() {
                return new State(this);
            }
        }
    }

    public static class EmoteBuilder {
        public final StateCollection head;
        public final StateCollection body;
        public final StateCollection rightArm;
        public final StateCollection leftArm;
        public final StateCollection rightLeg;
        public final StateCollection leftLeg;
        public final StateCollection leftItem;
        public final StateCollection rightItem;
        public final StateCollection torso;
        public boolean isEasingBefore = false;
        public boolean nsfw = false;
        private final HashMap<String, StateCollection> bodyParts = new HashMap();
        @Nullable
        public UUID uuid = null;
        public int beginTick = 0;
        public int endTick;
        public int stopTick = 0;
        public boolean isLooped = false;
        public int returnTick;
        final EmoteFormat emoteEmoteFormat;
        private final float validationThreshold;
        public String name = null;
        @Nullable
        public String description = null;
        @Nullable
        public String author = null;
        @Nullable
        public NBS song = null;
        @Nullable
        public ByteBuffer iconData;

        public EmoteBuilder(EmoteFormat source) {
            this(staticThreshold, source);
        }

        public EmoteBuilder(float validationThreshold, EmoteFormat emoteFormat) {
            this.validationThreshold = validationThreshold;
            this.head = new StateCollection(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "head", validationThreshold, false);
            this.body = new StateCollection(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "body", validationThreshold / 8.0f, true);
            this.rightArm = new StateCollection(-5.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, "rightArm", validationThreshold, true);
            this.leftArm = new StateCollection(5.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, "leftArm", validationThreshold, true);
            this.leftLeg = new StateCollection(1.9f, 12.0f, 0.1f, 0.0f, 0.0f, 0.0f, "leftLeg", validationThreshold, true);
            this.rightLeg = new StateCollection(-1.9f, 12.0f, 0.1f, 0.0f, 0.0f, 0.0f, "rightLeg", validationThreshold, true);
            this.leftItem = new StateCollection(1.9f, 12.0f, 0.1f, 0.0f, 0.0f, 0.0f, "leftItem", validationThreshold, false);
            this.rightItem = new StateCollection(-1.9f, 12.0f, 0.1f, 0.0f, 0.0f, 0.0f, "rightItem", validationThreshold, false);
            this.torso = new StateCollection(-1.9f, 12.0f, 0.1f, 0.0f, 0.0f, 0.0f, "torso", validationThreshold, true);
            this.bodyParts.put("head", this.head);
            this.bodyParts.put("body", this.body);
            this.bodyParts.put("rightArm", this.rightArm);
            this.bodyParts.put("rightLeg", this.rightLeg);
            this.bodyParts.put("leftArm", this.leftArm);
            this.bodyParts.put("leftLeg", this.leftLeg);
            this.bodyParts.put("leftItem", this.leftItem);
            this.bodyParts.put("rightItem", this.rightItem);
            this.bodyParts.put("torso", this.torso);
            this.emoteEmoteFormat = emoteFormat;
        }

        private EmoteBuilder(int beginTick, int endTick, int stopTick, boolean isInfinite, int returnToTick, HashMap<String, StateCollection> bodyParts, boolean isEasingBefore, boolean nsfw, @Nullable UUID uuid, @Nullable String name, @Nullable String description, @Nullable String author, EmoteFormat emoteFormat, @Nullable ByteBuffer iconData, @Nullable NBS song) {
            this.validationThreshold = staticThreshold;
            this.bodyParts.putAll(bodyParts);
            this.head = bodyParts.get("head");
            this.body = bodyParts.get("body");
            this.rightArm = bodyParts.get("rightArm");
            this.rightLeg = bodyParts.get("rightLeg");
            this.leftArm = bodyParts.get("leftArm");
            this.leftLeg = bodyParts.get("leftLeg");
            this.leftItem = bodyParts.get("leftItem");
            this.rightItem = bodyParts.get("rightItem");
            this.torso = bodyParts.get("torso");
            this.beginTick = beginTick;
            this.endTick = endTick;
            this.stopTick = stopTick;
            this.isLooped = isInfinite;
            this.returnTick = returnToTick;
            this.isEasingBefore = isEasingBefore;
            this.nsfw = nsfw;
            this.uuid = uuid;
            this.name = name;
            this.description = description;
            this.author = author;
            this.emoteEmoteFormat = emoteFormat;
            this.iconData = iconData;
            this.song = song;
        }

        public EmoteBuilder setDescription(String s) {
            this.description = s;
            return this;
        }

        public EmoteBuilder setName(String s) {
            this.name = s;
            return this;
        }

        public EmoteBuilder setAuthor(String s) {
            this.author = s;
            return this;
        }

        public StateCollection getOrCreateNewPart(String name, float x, float y, float z, float pitch, float yaw, float roll, boolean bendable) {
            if (!this.bodyParts.containsKey(name)) {
                this.bodyParts.put(name, new StateCollection(x, y, z, pitch, yaw, roll, name, this.validationThreshold, bendable));
            }
            return this.bodyParts.get(name);
        }

        @Nullable
        public StateCollection getPart(String name) {
            return this.bodyParts.get(name);
        }

        public EmoteBuilder fullyEnableParts() {
            for (Map.Entry<String, StateCollection> part : this.bodyParts.entrySet()) {
                part.getValue().fullyEnablePart(false);
            }
            return this;
        }

        public EmoteBuilder optimizeEmote() {
            for (Map.Entry<String, StateCollection> part : this.bodyParts.entrySet()) {
                part.getValue().optimize(this.isLooped, this.returnTick);
            }
            return this;
        }

        public EmoteData build() {
            return new EmoteData(this.beginTick, this.endTick, this.stopTick, this.isLooped, this.returnTick, this.bodyParts, this.isEasingBefore, this.nsfw, this.uuid, this.name, this.description, this.author, this.emoteEmoteFormat, this.iconData, this.song);
        }

        public EmoteBuilder setUuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }
    }

    @Immutable
    public static class KeyFrame {
        public final int tick;
        public final float value;
        public final Ease ease;

        public KeyFrame(int tick, float value, Ease ease) {
            this.tick = tick;
            this.value = value;
            this.ease = ease;
        }

        public boolean equals(Object other) {
            if (other instanceof KeyFrame) {
                return ((KeyFrame)other).ease == this.ease && ((KeyFrame)other).tick == this.tick && ((KeyFrame)other).value == this.value;
            }
            return super.equals(other);
        }

        public KeyFrame(int tick, float value) {
            this(tick, value, Ease.INOUTSINE);
        }

        public int hashCode() {
            int result = this.tick;
            result = 31 * result + Float.hashCode(this.value);
            result = 31 * result + this.ease.getId();
            return result;
        }
    }
}

