/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.emote.EmoteFormat;
import io.github.kosmx.emotes.common.network.PacketTask;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;

public final class NetData {
    public PacketTask purpose = PacketTask.UNKNOWN;
    public float threshold;
    @Nullable
    public UUID stopEmoteID = null;
    @Nullable
    public EmoteData emoteData = null;
    private EmoteData.EmoteBuilder emoteBuilder = null;
    public int tick = 0;
    public boolean valid;
    public boolean wasEmoteData = false;
    public boolean writeSong = true;
    public boolean versionsUpdated = false;
    public HashMap<Byte, Byte> versions;
    @Nullable
    public UUID player = null;
    public boolean isForced = false;
    public int sizeLimit = Short.MAX_VALUE;

    public EmoteData.EmoteBuilder getEmoteBuilder() {
        if (this.emoteBuilder == null) {
            this.emoteBuilder = new EmoteData.EmoteBuilder(this.threshold, EmoteFormat.BINARY);
        }
        return this.emoteBuilder;
    }

    public boolean prepareAndValidate() {
        if (this.emoteBuilder != null) {
            if (this.emoteData != null) {
                return false;
            }
            if (!this.wasEmoteData) {
                return false;
            }
            this.emoteData = this.emoteBuilder.build();
        }
        if (this.purpose == PacketTask.UNKNOWN) {
            return false;
        }
        if (this.purpose == PacketTask.STOP && this.stopEmoteID == null) {
            return false;
        }
        if (this.purpose == PacketTask.STREAM && this.emoteData == null) {
            return false;
        }
        if (this.purpose == PacketTask.CONFIG && !this.versionsUpdated) {
            return false;
        }
        return this.emoteData == null || this.stopEmoteID == null;
    }

    public NetData copy() {
        NetData data = new NetData();
        data.purpose = this.purpose;
        data.threshold = this.threshold;
        data.stopEmoteID = this.stopEmoteID;
        data.emoteData = this.emoteData;
        data.tick = this.tick;
        data.valid = this.valid;
        data.versionsUpdated = this.versionsUpdated;
        data.versions = this.versions;
        data.player = this.player;
        data.sizeLimit = this.sizeLimit;
        data.isForced = this.isForced;
        return data;
    }

    public String toString() {
        return "NetData{purpose=" + (Object)((Object)this.purpose) + ", threshold=" + this.threshold + ", stopEmoteID=" + this.stopEmoteID + ", emoteData=" + this.emoteData + ", startingAt=" + this.tick + ", player=" + this.player + '}';
    }
}

