/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.quarktool;

import io.github.kosmx.emotes.common.quarktool.Move;
import io.github.kosmx.emotes.common.quarktool.Pause;
import io.github.kosmx.emotes.common.quarktool.Pauseable;
import io.github.kosmx.emotes.common.quarktool.Playable;
import io.github.kosmx.emotes.common.quarktool.QuarkParsingError;
import io.github.kosmx.emotes.common.quarktool.QuarkReader;
import io.github.kosmx.emotes.common.quarktool.Repeat;
import io.github.kosmx.emotes.common.quarktool.Yoyo;
import io.github.kosmx.emotes.common.tools.Ease;
import io.github.kosmx.emotes.common.tools.Easing;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Section
implements Playable {
    public boolean isForward = true;
    public final List<Playable> elements = new ArrayList<Playable>();
    private final boolean isParallel;
    private int line;
    @Nullable
    private Playable moveOperator;

    public Section(QuarkReader animData, int line, List<List<String>> text) throws QuarkParsingError {
        this.line = line;
        this.isParallel = text.get(line).get(1).equals("parallel");
        while (true) {
            ++this.line;
            if (this.line >= text.size()) {
                throw new QuarkParsingError();
            }
            if (text.get(this.line).size() == 0 || text.get(this.line).get(0).charAt(0) == '#') continue;
            String id = text.get(this.line).get(0);
            List<String> block = text.get(this.line);
            if (id.equals("end")) {
                return;
            }
            if (id.equals("section")) {
                Section section = new Section(animData, this.line, text);
                Playable moveOp = section.getMoveOperator();
                if (moveOp == null) {
                    this.elements.add(section);
                } else {
                    this.elements.add(moveOp);
                }
                this.line = section.getLine();
                continue;
            }
            if (id.equals("move")) {
                try {
                    int pos = block.size() - 3;
                    if (block.size() < 4) {
                        throw new QuarkParsingError();
                    }
                    Ease ease = block.size() == 5 ? Easing.easeFromString(block.get(4)) : (block.size() == 8 || block.size() == 7 && block.get(5).equals("pause") ? Easing.easeFromString(block.get(4)) : Ease.INOUTQUAD);
                    Move move = new Move(animData.getPFromStr(block.get(1)), Float.parseFloat(block.get(3)), (int)((double)Integer.parseInt(block.get(2)) * 0.02), ease);
                    switch (block.get(pos)) {
                        case "repeat": {
                            this.elements.add(new Repeat(move, (int)((double)Integer.parseInt(block.get(pos + 2)) * 0.02), Integer.parseInt(block.get(pos + 1))));
                            break;
                        }
                        case "yoyo": {
                            this.elements.add(new Yoyo(move, (int)((double)Integer.parseInt(block.get(pos + 2)) * 0.02), Integer.parseInt(block.get(pos + 1))));
                            break;
                        }
                        case "pause": {
                            this.elements.add(new Pauseable(move, (int)((double)Integer.parseInt(block.get(pos + 1)) * 0.02)));
                            break;
                        }
                        default: {
                            this.elements.add(move);
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new QuarkParsingError("While trying to add move, error has happened: " + e.getMessage(), this.line);
                }
            }
            if (id.equals("repeat")) {
                try {
                    this.setMoveOperator(new Repeat(this, (int)((double)Integer.parseInt(block.get(2)) * 0.02), Integer.parseInt(block.get(1))));
                }
                catch (NumberFormatException e) {
                    throw new QuarkParsingError("While trying to add repeat, error has happened: " + e.getMessage(), this.line);
                }
            }
            if (id.equals("yoyo")) {
                try {
                    this.setMoveOperator(new Yoyo(this, (int)((double)Integer.parseInt(block.get(2)) * 0.02), Integer.parseInt(block.get(1))));
                }
                catch (NumberFormatException e) {
                    throw new QuarkParsingError("While trying to add yoyo, error has happened: " + e.getMessage(), this.line);
                }
            }
            if (id.equals("pause")) {
                try {
                    this.elements.add(new Pause((int)((double)Integer.parseInt(block.get(1)) * 0.02)));
                }
                catch (NumberFormatException e) {
                    throw new QuarkParsingError("While trying to add yoyo, error has happened: " + e.getMessage(), this.line);
                }
            }
            if (!id.equals("reset")) break;
        }
        throw new QuarkParsingError();
    }

    public void setMoveOperator(Playable object) throws QuarkParsingError {
        if (this.moveOperator != null) {
            throw new QuarkParsingError();
        }
        this.moveOperator = object;
    }

    public int getLine() {
        return this.line;
    }

    private int playObject(Playable object, int time) throws QuarkParsingError {
        return this.isForward ? object.playForward(time) : object.playBackward(time);
    }

    private int play(int time) throws QuarkParsingError {
        if (this.isParallel) {
            return this.playParallel(time);
        }
        return this.playSequel(time);
    }

    @Nullable
    public Playable getMoveOperator() {
        return this.moveOperator;
    }

    @Override
    public int playForward(int time) throws QuarkParsingError {
        this.isForward = true;
        return this.play(time);
    }

    @Override
    public int playBackward(int time) throws QuarkParsingError {
        this.isForward = false;
        return this.play(time);
    }

    private int playParallel(int time) throws QuarkParsingError {
        int length = time;
        for (Playable object : this.elements) {
            int t = this.isForward ? object.playForward(time) : object.playBackward(time);
            if (t <= length) continue;
            length = t;
        }
        return length;
    }

    private int playSequel(int time) throws QuarkParsingError {
        int i;
        int t = time;
        int n = i = this.isForward ? 0 : this.elements.size() - 1;
        while (i >= 0) {
            if (i >= this.elements.size()) {
                return t;
            }
            t = this.playObject(this.elements.get(i), t);
            i += this.isForward ? 1 : -1;
        }
        return t;
    }
}

