/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.tools;

import io.github.kosmx.emotes.common.tools.Vec3d;
import io.github.kosmx.emotes.common.tools.Vector3;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Vec3f
extends Vector3<Float> {
    public static final Vec3f ZERO = new Vec3f(0.0f, 0.0f, 0.0f);

    public Vec3f(float x, float y, float z) {
        super(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
    }

    public double squaredDistanceTo(Vec3d vec3d) {
        double a = (double)((Float)this.x).floatValue() - (Double)vec3d.x;
        double b = (double)((Float)this.y).floatValue() - (Double)vec3d.y;
        double c = (double)((Float)this.z).floatValue() - (Double)vec3d.z;
        return a * a + b * b + c * c;
    }

    public Vec3f scale(float scalar) {
        return new Vec3f(((Float)this.getX()).floatValue() * scalar, ((Float)this.getY()).floatValue() * scalar, ((Float)this.getZ()).floatValue() * scalar);
    }

    public Vec3f add(Vec3f other) {
        return new Vec3f(((Float)this.getX()).floatValue() + ((Float)other.getX()).floatValue(), ((Float)this.getY()).floatValue() + ((Float)other.getY()).floatValue(), ((Float)this.getZ()).floatValue() + ((Float)other.getZ()).floatValue());
    }

    public float dotProduct(Vec3f other) {
        return ((Float)this.getX()).floatValue() * ((Float)other.getX()).floatValue() + ((Float)this.getY()).floatValue() * ((Float)other.getY()).floatValue() + ((Float)this.getZ()).floatValue() * ((Float)other.getZ()).floatValue();
    }

    public Vec3f crossProduct(Vec3f other) {
        return new Vec3f(((Float)this.getY()).floatValue() * ((Float)other.getZ()).floatValue() - ((Float)this.getZ()).floatValue() * ((Float)other.getY()).floatValue(), ((Float)this.getZ()).floatValue() * ((Float)other.getX()).floatValue() - ((Float)this.getX()).floatValue() * ((Float)other.getZ()).floatValue(), ((Float)this.getX()).floatValue() * ((Float)other.getY()).floatValue() - ((Float)this.getY()).floatValue() * ((Float)other.getX()).floatValue());
    }

    public Vec3f subtract(Vec3f rhs) {
        return this.add(rhs.scale(-1.0f));
    }

    public double distanceTo(Vec3d vec3d) {
        return Math.sqrt(this.squaredDistanceTo(vec3d));
    }
}

