/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.playerAnim.layered;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.tools.Vec3f;
import io.github.kosmx.playerAnim.TransformType;
import io.github.kosmx.playerAnim.layered.IAnimation;
import java.util.ArrayList;
import java.util.List;

public class AnimationStack
implements IAnimation {
    private final List<Pair<Integer, IAnimation>> layers = new ArrayList<Pair<Integer, IAnimation>>();

    @Override
    public boolean isActive() {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            layer.getRight().tick();
        }
    }

    @Override
    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            value0 = layer.getRight().get3DTransform(modelName, type, tickDelta, value0);
        }
        return value0;
    }

    @Override
    public void setupAnim(float tickDelta) {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            layer.getRight().setupAnim(tickDelta);
        }
    }

    public void addAnimLayer(int priority, IAnimation layer) {
        for (int search = 0; this.layers.size() > search && this.layers.get(search).getLeft() < search; ++search) {
        }
        this.layers.add(new Pair<Integer, IAnimation>(priority, layer));
    }

    public boolean removeLayer(IAnimation layer) {
        return this.layers.removeIf(integerIAnimationPair -> integerIAnimationPair.getRight() == layer);
    }

    public boolean removeLayer(int layerLevel) {
        return this.layers.removeIf(integerIAnimationPair -> (Integer)integerIAnimationPair.getLeft() == layerLevel);
    }
}

