/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier;

import java.util.Arrays;
import java.util.Map;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.projectbrazier.experimental_features.builtin_mixed_model.BuiltinMixedModel;
import net.dark_roleplay.projectbrazier.experimental_features.selective_item_block.SelectiveBlockItem;
import net.dark_roleplay.projectbrazier.experimental_features.selective_item_block.SelectiveBlockItemListeners;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlockEntities;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlocks;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierContainers;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierEntities;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierItems;
import net.dark_roleplay.projectbrazier.feature_client.blockentityrenderers.BarrelBlockEntityRenderer;
import net.dark_roleplay.projectbrazier.feature_client.blockentityrenderers.ZiplineBlockEntityRenderer;
import net.dark_roleplay.projectbrazier.feature_client.entity_renderers.SittableEntityRenderer;
import net.dark_roleplay.projectbrazier.feature_client.entity_renderers.ZiplineEntityRenderer;
import net.dark_roleplay.projectbrazier.feature_client.listeners.ResourceReloadUtil;
import net.dark_roleplay.projectbrazier.feature_client.listeners.TertiaryInteractionListener;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.axis_connected_models.AxisConnectedModel;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.block_specific.roof_model_loader.RoofModelLoader;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.emissive.EmissiveModel;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.pane_connected_model.PaneCornerModel;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.quality_model.QualityModelLoader;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.simple_pane_conneted_model.SimplePaneConnectedModel;
import net.dark_roleplay.projectbrazier.feature_client.registrars.BrazierKeybinds;
import net.dark_roleplay.projectbrazier.feature_client.screens.GeneralContainerScreen;
import net.dark_roleplay.projectbrazier.util.MaterialRegistryObject;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

public class ProjectBrazierClient {
    public static void modConstructor() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ProjectBrazierClient::setupClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ProjectBrazierClient::registerModelLoaders);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ResourceReloadUtil::registerReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(TertiaryInteractionListener::renderBlockOverlay);
        MinecraftForge.EVENT_BUS.addListener(TertiaryInteractionListener::renderGameOverlay);
        MinecraftForge.EVENT_BUS.addListener(TertiaryInteractionListener::renderWorldLastEvent);
        MinecraftForge.EVENT_BUS.addListener(SelectiveBlockItemListeners::renderGameOverlay);
        MinecraftForge.EVENT_BUS.addListener(SelectiveBlockItemListeners::keyInput);
        MinecraftForge.EVENT_BUS.addListener(SelectiveBlockItemListeners::mouseScroll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ProjectBrazierClient::registerBlockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ProjectBrazierClient::registerItemColors);
    }

    public static void setupClientStuff(FMLClientSetupEvent event) {
        BrazierKeybinds.registerKeybinds(event);
        ProjectBrazierClient.registerRenderLayers();
        ItemProperties.register((Item)((Item)BrazierItems.ROPE.get()), (ResourceLocation)new ResourceLocation("projectbrazier", "stack_size"), (stack, level, entity, val) -> stack.m_41613_());
        MenuScreens.m_96206_((MenuType)((MenuType)BrazierContainers.GENERAL_CONTAINER.get()), GeneralContainerScreen::new);
    }

    public static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "emissive"), (IModelLoader)new EmissiveModel.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "quality_model"), (IModelLoader)new QualityModelLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "roof"), (IModelLoader)new RoofModelLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "simple_pane_connected_model"), (IModelLoader)new SimplePaneConnectedModel.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "axis_connected_model"), (IModelLoader)new AxisConnectedModel.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "builtin_mixed"), (IModelLoader)new BuiltinMixedModel.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("projectbrazier", "pane_corner_model"), (IModelLoader)new PaneCornerModel.Loader());
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("projectbrazier", "entity/zipline_handle"));
        ProjectBrazierClient.registerItemOverrides();
    }

    public static void registerRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.CLAY_IN_GRASSY_DIRT.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.GLIMMERTAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.CAULIFLOWER.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.WHITE_CABBAGE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.HANGING_HORN.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.IRON_BRAZIER_COAL.get()), (T layer) -> layer == RenderType.m_110463_() || layer == RenderType.m_110451_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.IRON_FIRE_BOWL.get()), (T layer) -> layer == RenderType.m_110463_() || layer == RenderType.m_110451_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.SOUL_IRON_BRAZIER_COAL.get()), (T layer) -> layer == RenderType.m_110463_() || layer == RenderType.m_110451_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrazierBlocks.SOUL_IRON_FIRE_BOWL.get()), (T layer) -> layer == RenderType.m_110463_() || layer == RenderType.m_110451_());
        MaterialRegistryObject[] cutouts = new MaterialRegistryObject[]{BrazierBlocks.FLOWER_BARRELS, BrazierBlocks.FLOWER_BUCKET, BrazierBlocks.HOLLOW_LOG, BrazierBlocks.STRIPPED_HOLLOW_LOG, BrazierBlocks.WOOD_LATTICE_1, BrazierBlocks.WOOD_LATTICE_1_C, BrazierBlocks.WOOD_LATTICE_2, BrazierBlocks.WOOD_LATTICE_2_C, BrazierBlocks.WOOD_LATTICE_3, BrazierBlocks.WOOD_LATTICE_3_C, BrazierBlocks.WOOD_LATTICE_4, BrazierBlocks.WOOD_LATTICE_4_C, BrazierBlocks.WOOD_LATTICE_5, BrazierBlocks.WOOD_LATTICE_5_C};
        Arrays.stream(cutouts).flatMap(b -> b.values().stream()).map(b -> ((RegistryObject)b).get()).forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)b), (RenderType)RenderType.m_110457_()));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BrazierBlockEntities.BARREL_BLOCK_ENTITY.get()), BarrelBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BrazierBlockEntities.ZIPLINE_ANCHOR.get()), ZiplineBlockEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrazierEntities.SITTABLE.get()), SittableEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrazierEntities.ZIPLINE.get()), ZiplineEntityRenderer::new);
    }

    private static void setRenderLayer(RenderType type, Map<MargMaterial, RegistryObject<Block>> ... materialBlockObjects) {
        for (Map<MargMaterial, RegistryObject<Block>> materialBlocks : materialBlockObjects) {
            for (RegistryObject<Block> blockObj : materialBlocks.values()) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)blockObj.get()), (RenderType)type);
            }
        }
    }

    private static void setRenderLayer(RenderType type, RegistryObject<Block> ... blockObjects) {
        for (RegistryObject<Block> blockObj : blockObjects) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)blockObj.get()), (RenderType)type);
        }
    }

    public static void registerItemOverrides() {
        ItemProperties.register((Item)((Item)BrazierItems.STONE_ARROW_SLIT.get()), (ResourceLocation)new ResourceLocation("projectbrazier", "variant"), (stack, world, entity, val) -> {
            if (entity != null && entity instanceof Player) {
                return ((SelectiveBlockItem)stack.m_41720_()).getCurrentIndex(((Player)entity).m_36316_());
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)BrazierItems.DEEPSLATE_ARROW_SLIT.get()), (ResourceLocation)new ResourceLocation("projectbrazier", "variant"), (stack, world, entity, val) -> {
            if (entity != null && entity instanceof Player) {
                return ((SelectiveBlockItem)stack.m_41720_()).getCurrentIndex(((Player)entity).m_36316_());
            }
            return 0.0f;
        });
    }

    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().m_92689_((stack, random) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, (BlockAndTintGetter)null, (BlockPos)null, random);
        }, new ItemLike[]{(ItemLike)BrazierBlocks.CLAY_IN_GRASSY_DIRT.get()});
    }

    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().m_92589_((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)BrazierBlocks.GLIMMERTAIL.get()});
        event.getBlockColors().m_92589_((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)BrazierBlocks.CLAY_IN_GRASSY_DIRT.get()});
    }
}

