/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.datagen.woods;

import net.dark_roleplay.projectbrazier.datagen.woods.WoodGeneratorData;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="projectbrazier")
public class WoodDataGenerator
extends BlockStateProvider {
    private static final String MODID = "projectbrazier";
    private static final ResourceLocation CUBE_COLUMN = new ResourceLocation("minecraft", "block/cube_column");
    private static final ResourceLocation CUBE_ALL = new ResourceLocation("minecraft", "block/cube_all");

    public WoodDataGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, MODID, exFileHelper);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        event.getGenerator().m_123914_((DataProvider)new WoodDataGenerator(event.getGenerator(), event.getExistingFileHelper()));
    }

    protected void registerStatesAndModels() {
        this.generateWoods("apple", new WoodGeneratorData(BrazierBlocks.APPLE_LOG, BrazierBlocks.STRIPPED_APPLE_LOG, BrazierBlocks.APPLE_PLANK, BrazierBlocks.APPLE_WOOD, BrazierBlocks.STRIPPED_APPLE_WOOD));
        this.generateWoods("orange", new WoodGeneratorData(BrazierBlocks.ORANGE_LOG, BrazierBlocks.STRIPPED_ORANGE_LOG, BrazierBlocks.ORANGE_PLANK, BrazierBlocks.ORANGE_WOOD, BrazierBlocks.STRIPPED_ORANGE_WOOD));
    }

    private void generateWoods(String woodType, WoodGeneratorData data) {
        this.generateAxisColumn(data.getLog(), woodType + "_log", "woods/" + woodType);
        this.generateAxisColumn(data.getWood(), woodType + "_wood", "woods/" + woodType, woodType + "_log", woodType + "_log");
        this.generateAxisColumn(data.getStrippedLog(), "stripped_" + woodType + "_log", "woods/" + woodType);
        this.generateAllSidedBlock(data.getPlanks(), woodType + "_planks", "woods/" + woodType, woodType + "_planks");
        this.generateAxisColumn(data.getStrippedWood(), "stripped_" + woodType + "_wood", "woods/" + woodType, "stripped_" + woodType + "_log", "stripped_" + woodType + "_log");
    }

    private void generateAllSidedBlock(Block block, String assetName, String originPath, String textureName) {
        BlockModelBuilder allSidedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("projectbrazier:block/" + originPath + "/" + assetName)).parent((ModelFile)this.models().getExistingFile(CUBE_ALL))).texture("all", new ResourceLocation(MODID, "block/" + originPath + "/" + textureName));
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block);
        stateBuilder.addModels(stateBuilder.partialState(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)allSidedModel, 0, 0, false, 1)});
        ItemModelBuilder plankItem = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("projectbrazier:item/" + block.getRegistryName().m_135815_())).parent((ModelFile)allSidedModel);
    }

    private void generateAxisColumn(Block block, String assetName, String basePath) {
        this.generateAxisColumn(block, assetName, basePath, assetName, assetName + "_top");
    }

    private void generateAxisColumn(Block block, String assetName, String basePath, String sideTexture) {
        this.generateAxisColumn(block, assetName, basePath, sideTexture, sideTexture + "_top");
    }

    private void generateAxisColumn(Block block, String assetName, String basePath, String sideTexture, String endTexture) {
        BlockModelBuilder logModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("projectbrazier:block/" + basePath + "/" + assetName)).parent((ModelFile)this.models().getExistingFile(CUBE_COLUMN))).texture("end", new ResourceLocation(MODID, "block/" + basePath + "/" + endTexture))).texture("side", new ResourceLocation(MODID, "block/" + basePath + "/" + sideTexture));
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block);
        stateBuilder.addModels(stateBuilder.partialState().with((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X), new ConfiguredModel[]{new ConfiguredModel((ModelFile)logModel, 90, 90, false, 1)}).addModels(stateBuilder.partialState().with((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), new ConfiguredModel[]{new ConfiguredModel((ModelFile)logModel, 0, 0, false, 1)}).addModels(stateBuilder.partialState().with((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z), new ConfiguredModel[]{new ConfiguredModel((ModelFile)logModel, 90, 0, false, 1)});
        ItemModelBuilder logItem = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("projectbrazier:item/" + block.getRegistryName().m_135815_())).parent((ModelFile)logModel);
    }
}

