/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.colliders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dark_roleplay.justutilities.physics.collision.CollisionChecker;
import net.dark_roleplay.justutilities.physics.collision.CollissionInformation;
import net.dark_roleplay.justutilities.physics.collision.IBoundingBox;
import net.dark_roleplay.justutilities.physics.collision.OrientedBB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ColliderDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private OrientedBB boxA = new OrientedBB(new AABB(-0.5, 0.0, -0.5, 0.5, 2.0, 0.5), new Vec3(0.0, 0.0, 1.0));
    private OrientedBB boxB = new OrientedBB(new AABB(-2.5, -1.0, 0.0, 2.5, 0.0, 9.0), new Vec3(0.0, 0.0, 0.0));
    private double dir = 0.01;

    public void m_7790_(PoseStack poseStack, MultiBufferSource bufferSource, double p_113509_, double p_113510_, double p_113511_) {
        int color;
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-p_113509_, -p_113510_, -p_113511_);
        float delta = (float)(Minecraft.m_91087_().f_91073_.m_46467_() % 200L + 1L) / 200.0f;
        float delta2 = (float)(Minecraft.m_91087_().f_91073_.m_46467_() % 50L + 1L) / 50.0f;
        float delta3 = (float)(Minecraft.m_91087_().f_91073_.m_46467_() % 25L + 1L) / 25.0f;
        this.boxB.rotate((float)this.dir, 0.0f, 0.0f);
        if (this.boxB.getRotX() > 0.0f) {
            this.dir = -0.5;
        } else if (this.boxB.getRotX() < -90.0f) {
            this.dir = 0.5;
        }
        this.boxA.setPos(new Vec3(0.0, 0.0, 0.0));
        long start = System.nanoTime();
        CollissionInformation collision = CollisionChecker.checkCollision(this.boxA, this.boxB);
        int n = color = collision != null ? -16776961 : 65535;
        if (collision != null) {
            Vec3 axis = collision.axis().m_82541_().m_82542_(collision.distance(), collision.distance(), collision.distance());
            this.boxA.move(axis);
            this.renderOverlap(poseStack, vertexconsumer, collision);
        }
        this.renderBB(poseStack, vertexconsumer, this.boxA, -65281);
        this.renderBB(poseStack, vertexconsumer, this.boxB, color);
        poseStack.m_85849_();
    }

    private void renderBB(PoseStack poseStack, VertexConsumer vc, IBoundingBox box, int color) {
        Vec3[] verts = box.getVerts();
        this.renderEdge(poseStack, vc, verts[0], verts[1], color);
        this.renderEdge(poseStack, vc, verts[2], verts[3], color);
        this.renderEdge(poseStack, vc, verts[4], verts[5], color);
        this.renderEdge(poseStack, vc, verts[6], verts[7], color);
        this.renderEdge(poseStack, vc, verts[0], verts[2], color);
        this.renderEdge(poseStack, vc, verts[1], verts[3], color);
        this.renderEdge(poseStack, vc, verts[4], verts[6], color);
        this.renderEdge(poseStack, vc, verts[5], verts[7], color);
        this.renderEdge(poseStack, vc, verts[0], verts[4], color);
        this.renderEdge(poseStack, vc, verts[1], verts[5], color);
        this.renderEdge(poseStack, vc, verts[2], verts[6], color);
        this.renderEdge(poseStack, vc, verts[3], verts[7], color);
    }

    private void renderOverlap(PoseStack poseStack, VertexConsumer cons, CollissionInformation collissionInformation) {
        Vec3 axis = collissionInformation.axis().m_82541_();
        Vec3 dist = axis.m_82542_(collissionInformation.distance(), collissionInformation.distance(), collissionInformation.distance());
        cons.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_85977_(poseStack.m_85850_().m_85864_(), (float)dist.f_82479_, (float)dist.f_82480_, (float)dist.f_82481_).m_5752_();
        cons.m_85982_(poseStack.m_85850_().m_85861_(), (float)dist.f_82479_, (float)dist.f_82480_, (float)dist.f_82481_).m_6122_(255, 255, 255, 255).m_85977_(poseStack.m_85850_().m_85864_(), (float)(-dist.f_82479_), (float)(-dist.f_82480_), (float)(-dist.f_82481_)).m_5752_();
    }

    private void renderEdge(PoseStack poseStack, VertexConsumer cons, Vec3 a, Vec3 b, int color) {
        cons.m_85982_(poseStack.m_85850_().m_85861_(), (float)a.f_82479_, (float)a.f_82480_, (float)a.f_82481_).m_6122_(color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF).m_85977_(poseStack.m_85850_().m_85864_(), (float)(b.f_82479_ - a.f_82479_), (float)(b.f_82480_ - a.f_82480_), (float)(b.f_82481_ - a.f_82481_)).m_5752_();
        cons.m_85982_(poseStack.m_85850_().m_85861_(), (float)b.f_82479_, (float)b.f_82480_, (float)b.f_82481_).m_6122_(color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF).m_85977_(poseStack.m_85850_().m_85864_(), (float)(a.f_82479_ - b.f_82479_), (float)(a.f_82480_ - b.f_82480_), (float)(a.f_82481_ - b.f_82481_)).m_5752_();
    }
}

