/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blocks;

import net.dark_roleplay.projectbrazier.feature.blockentities.HangingItemBlockEntity;
import net.dark_roleplay.projectbrazier.feature.blocks.templates.WallHFacedDecoBlock;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlockEntities;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlocks;
import net.dark_roleplay.projectbrazier.util.Inventories;
import net.dark_roleplay.projectbrazier.util.blocks.BrazierStateProperties;
import net.dark_roleplay.projectbrazier.util.capabilities.ItemHandlerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class HangingItemBlock
extends WallHFacedDecoBlock
implements EntityBlock {
    public static final BooleanProperty HIDDEN_LEVER = BrazierStateProperties.HIDDEN_LEVER;
    private final int power;

    public HangingItemBlock(BlockBehaviour.Properties props, String shapeName, int power) {
        super(props, shapeName);
        this.power = power;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)HIDDEN_LEVER, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HIDDEN_LEVER});
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_7500_()) {
            this.setItemStack(world, pos, state, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        ItemStack result = Inventories.givePlayerItem(player, this.getItemStack((BlockGetter)world, pos, state), hand, true);
        if (result.m_41619_()) {
            this.setItemStack(world, pos, state, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)HIDDEN_LEVER);
    }

    @Deprecated
    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return !this.m_7899_(state) ? 0 : this.power;
    }

    @Deprecated
    public int m_6376_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return !this.m_7899_(state) ? 0 : (state.m_61143_((Property)HORIZONTAL_FACING) == side ? this.power : 0);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            ItemHandlerUtil.dropContainerItems(world, pos);
        }
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            if (((Boolean)state.m_61143_((Property)HIDDEN_LEVER)).booleanValue()) {
                this.updateNeighbors(state, world, pos);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_142300_(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122424_()), (Block)this);
    }

    public ItemStack setItemStack(Level world, BlockPos pos, BlockState state, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof HangingItemBlockEntity)) {
            return stack;
        }
        LazyOptional inventory = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!inventory.isPresent()) {
            return stack;
        }
        IItemHandler handler = (IItemHandler)inventory.orElse(null);
        if (handler == null) {
            return stack;
        }
        ItemStack old = handler.getStackInSlot(0);
        if (stack.m_41619_()) {
            BlockState state2 = (BlockState)((BlockState)((Block)BrazierBlocks.NAIL.get()).m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)))).m_61124_((Property)HIDDEN_LEVER, (Comparable)((Boolean)state.m_61143_((Property)HIDDEN_LEVER)));
            world.m_46597_(pos, state2);
            return old;
        }
        return handler.insertItem(0, stack, false);
    }

    public ItemStack getItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof HangingItemBlockEntity)) {
            return ItemStack.f_41583_;
        }
        LazyOptional inventory = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!inventory.isPresent()) {
            return ItemStack.f_41583_;
        }
        IItemHandler handler = (IItemHandler)inventory.orElse(null);
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        return handler.getStackInSlot(0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BrazierBlockEntities.SINGLE_ITEM_STORAGE.get()).m_155264_(pos, state);
    }
}

