/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.block_pos;

import net.dark_roleplay.projectbrazier.util.block_pos.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class SelectionRegion
implements INBTSerializable<CompoundTag> {
    private BlockPos start;
    private BlockPos target;
    private int width;
    private int height;
    private int length;

    public SelectionRegion() {
    }

    public SelectionRegion(BlockPos start, BlockPos target) {
        this.setRegion(start, target);
    }

    public void calcSize() {
        if (this.start == null || this.target == null) {
            return;
        }
        this.width = this.target.m_123341_() - this.start.m_123341_() + 1;
        this.height = this.target.m_123342_() - this.start.m_123342_() + 1;
        this.length = this.target.m_123343_() - this.start.m_123343_() + 1;
    }

    public BlockPos getStart() {
        return this.start;
    }

    public void setStart(BlockPos start) {
        this.start = start;
        this.calcSize();
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public void setTarget(BlockPos target) {
        this.target = target;
        this.calcSize();
    }

    public void setRegion(BlockPos posA, BlockPos posB) {
        if (posA != null && posB != null) {
            this.start = BlockPosUtil.getMin(posA, posB);
            this.target = BlockPosUtil.getMax(posA, posB);
            this.calcSize();
        } else if (posA != null) {
            this.start = posA;
        } else if (posB != null) {
            this.target = posB;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.start != null) {
            tag.m_128365_("S", (Tag)NbtUtils.m_129224_((BlockPos)this.start));
        }
        if (this.target != null) {
            tag.m_128365_("T", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("S")) {
            this.start = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("S"));
        }
        if (nbt.m_128441_("T")) {
            this.target = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("T"));
        }
        this.calcSize();
    }
}

