/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackGraphPacket;
import com.simibubi.create.content.logistics.trains.TrackGraphRollCallPacket;
import com.simibubi.create.content.logistics.trains.TrackGraphSyncPacket;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.EdgeGroupColor;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroupPacket;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class TrackGraphSync {
    List<TrackGraphPacket> queuedPackets = new ArrayList<TrackGraphPacket>();
    int rollCallIn;
    private TrackGraphSyncPacket currentGraphSyncPacket;

    public void serverTick() {
        this.flushGraphPacket();
        if (!this.queuedPackets.isEmpty()) {
            for (TrackGraphPacket packet : this.queuedPackets) {
                if (!packet.packetDeletesGraph && !Create.RAILWAYS.trackNetworks.containsKey(packet.graphId)) continue;
                AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
                this.rollCallIn = 3;
            }
            this.queuedPackets.clear();
        }
        if (this.rollCallIn <= 0) {
            return;
        }
        --this.rollCallIn;
        if (this.rollCallIn > 0) {
            return;
        }
        this.sendRollCall();
    }

    public void nodeAdded(TrackGraph graph, TrackNode node) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.addedNodes.put(node.getNetId(), Pair.of(node.getLocation(), node.getNormal()));
    }

    public void edgeAdded(TrackGraph graph, TrackNode node1, TrackNode node2, TrackEdge edge) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.addedEdges.add(Pair.of(Couple.create(node1.getNetId(), node2.getNetId()), edge.getTurn()));
    }

    public void pointAdded(TrackGraph graph, TrackEdgePoint point) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.addedEdgePoints.add(point);
    }

    public void pointRemoved(TrackGraph graph, TrackEdgePoint point) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.removedEdgePoints.add(point.getId());
    }

    public void nodeRemoved(TrackGraph graph, TrackNode node) {
        this.flushGraphPacket(graph);
        int nodeId = node.getNetId();
        if (this.currentGraphSyncPacket.addedNodes.remove(nodeId) == null) {
            this.currentGraphSyncPacket.removedNodes.add(nodeId);
        }
        this.currentGraphSyncPacket.addedEdges.removeIf(pair -> {
            Couple ids = (Couple)pair.getFirst();
            return (Integer)ids.getFirst() == nodeId || (Integer)ids.getSecond() == nodeId;
        });
    }

    public void graphSplit(TrackGraph graph, Set<TrackGraph> additional) {
        this.flushGraphPacket(graph);
        additional.forEach(rg -> this.currentGraphSyncPacket.splitSubGraphs.put((Integer)rg.nodesById.keySet().stream().findFirst().get(), Pair.of(rg.netId, rg.id)));
    }

    public void graphRemoved(TrackGraph graph) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.packetDeletesGraph = true;
    }

    public void sendEdgeGroups(List<UUID> ids, List<EdgeGroupColor> colors, ServerPlayer player) {
        AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SignalEdgeGroupPacket(ids, colors, true));
    }

    public void edgeGroupCreated(UUID id, EdgeGroupColor color) {
        AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new SignalEdgeGroupPacket(id, color));
    }

    public void edgeGroupRemoved(UUID id) {
        AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new SignalEdgeGroupPacket((List<UUID>)ImmutableList.of((Object)id), Collections.emptyList(), false));
    }

    public void edgeDataChanged(TrackGraph graph, TrackNode node1, TrackNode node2, TrackEdge edge) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.syncEdgeData(node1, node2, edge);
    }

    public void edgeDataChanged(TrackGraph graph, TrackNode node1, TrackNode node2, TrackEdge edge, TrackEdge edge2) {
        this.flushGraphPacket(graph);
        this.currentGraphSyncPacket.syncEdgeData(node1, node2, edge);
        this.currentGraphSyncPacket.syncEdgeData(node2, node1, edge2);
    }

    public void sendFullGraphTo(TrackGraph graph, ServerPlayer player) {
        TrackGraphSyncPacket currentPacket;
        TrackGraphSyncPacket packet = new TrackGraphSyncPacket(graph.id, graph.netId);
        packet.fullWipe = true;
        int sent = 0;
        for (TrackNode trackNode : graph.nodes.values()) {
            currentPacket = packet;
            currentPacket.addedNodes.put(trackNode.getNetId(), Pair.of(trackNode.getLocation(), trackNode.getNormal()));
            if (sent++ < 1000) continue;
            sent = 0;
            packet = this.flushAndCreateNew(graph, player, packet);
        }
        for (TrackNode trackNode : graph.nodes.values()) {
            currentPacket = packet;
            if (!graph.connectionsByNode.containsKey(trackNode)) continue;
            graph.connectionsByNode.get(trackNode).forEach((node2, edge) -> {
                Couple<Integer> key = Couple.create(node.getNetId(), node2.getNetId());
                currentPacket.addedEdges.add(Pair.of(key, edge.getTurn()));
                currentPacket.syncEdgeData(node, (TrackNode)node2, (TrackEdge)edge);
            });
            if (sent++ < 1000) continue;
            sent = 0;
            packet = this.flushAndCreateNew(graph, player, packet);
        }
        for (EdgePointType edgePointType : EdgePointType.TYPES.values()) {
            for (TrackEdgePoint point : graph.getPoints(edgePointType)) {
                packet.addedEdgePoints.add(point);
                if (sent++ < 1000) continue;
                sent = 0;
                packet = this.flushAndCreateNew(graph, player, packet);
            }
        }
        if (sent > 0) {
            this.flushAndCreateNew(graph, player, packet);
        }
    }

    private void sendRollCall() {
        AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new TrackGraphRollCallPacket());
    }

    private TrackGraphSyncPacket flushAndCreateNew(TrackGraph graph, ServerPlayer player, TrackGraphSyncPacket packet) {
        AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        packet = new TrackGraphSyncPacket(graph.id, graph.netId);
        return packet;
    }

    private void flushGraphPacket() {
        this.flushGraphPacket(null, 0);
    }

    private void flushGraphPacket(TrackGraph graph) {
        this.flushGraphPacket(graph.id, graph.netId);
    }

    private void flushGraphPacket(@Nullable UUID graphId, int netId) {
        if (this.currentGraphSyncPacket != null) {
            if (this.currentGraphSyncPacket.graphId.equals(graphId)) {
                return;
            }
            this.queuedPackets.add(this.currentGraphSyncPacket);
            this.currentGraphSyncPacket = null;
        }
        if (graphId != null) {
            this.currentGraphSyncPacket = new TrackGraphSyncPacket(graphId, netId);
        }
    }
}

