/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.eclectic.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class MindLanternBlock
extends LanternBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");

    public MindLanternBlock(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON});
        super.m_7926_(builder);
    }

    private boolean playerHasInsomnia(Player player) {
        ServerStatsCounter serverstatscounter = ((ServerPlayer)player).m_8951_();
        return serverstatscounter.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)) >= 72000;
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)f_153459_, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)f_153460_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
            boolean insom = false;
            if (!context.m_43725_().m_5776_()) {
                insom = this.playerHasInsomnia(context.m_43723_());
            }
            return (BlockState)blockstate.m_61124_((Property)ON, (Comparable)Boolean.valueOf(context.m_43725_().m_46472_().equals((Object)Level.f_46430_) || insom));
        }
        return null;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!level.m_5776_()) {
            if (player.m_21120_(hand).m_150930_(Items.f_42545_) && !level.m_46472_().equals((Object)Level.f_46429_)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(true)), 2);
                return InteractionResult.CONSUME;
            }
            if (!level.m_46472_().equals((Object)Level.f_46429_) && !level.m_46472_().equals((Object)Level.f_46430_)) {
                ServerStatsCounter serverstatscounter = ((ServerPlayer)player).m_8951_();
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(this.playerHasInsomnia(player))), 2);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ON) != false ? 13 : 5;
    }
}

