/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.BlockInfo;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRamp;

@OnlyIn(value=Dist.CLIENT)
public class PlacementOverlay {
    private static final ModelBlockRenderer RENDERER = new ModelBlockRenderer(Minecraft.m_91087_().m_91298_());
    private static IModelData DEFAULT;
    private static IModelData ON_RAMP;
    private static IModelData ON_FLOOR;

    @SubscribeEvent
    public void drawBlockHighlightEvent(DrawSelectionEvent.HighlightBlock event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
            return;
        }
        if (this.isHoldingWrench((Player)player) && event.getTarget() != null) {
            Level world = player.m_20193_();
            BlockInfo info = new BlockInfo(world, event.getTarget());
            if (!info.state.m_60795_() && world.m_6857_().m_61937_(info.pos)) {
                this.renderOverlay((Player)player, world, info, event.getPartialTicks(), event.getPoseStack(), event.getMultiBufferSource(), event.getCamera().m_90583_());
            }
        }
    }

    private boolean isHoldingWrench(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!ToolHelper.isWrench((ItemStack)player.m_21120_(hand))) continue;
            return true;
        }
        return false;
    }

    private static Vec3 getRenderVector(BlockPos pos, Vec3 projectedView) {
        return new Vec3((double)pos.m_123341_() - projectedView.f_82479_, (double)pos.m_123342_() - projectedView.f_82480_, (double)pos.m_123343_() - projectedView.f_82481_);
    }

    private void renderOverlay(Player player, Level world, BlockInfo info, float partialTicks, PoseStack matrixStack, MultiBufferSource buffers, Vec3 projectedView) {
        boolean isGlowstone;
        ItemStack mainHand = player.m_21205_();
        EnumPlatformType hoveredPlatformType = null;
        if (info.block instanceof BlockPlatformBase) {
            hoveredPlatformType = ((BlockPlatformBase)info.block).getPlatformType();
        }
        if (!mainHand.m_41619_() && hoveredPlatformType == EnumPlatformType.FRAME && ((isGlowstone = TagHelper.isItemInTag((ItemStack)mainHand, (String)"forge:dusts/glowstone")) || EnumTorchType.isTorchItem(mainHand.m_41720_()))) {
            boolean doDraw;
            EnumTorchType torch = TileHelper.getTorch(TileHelper.getPlatformTile((BlockGetter)world, info.pos));
            boolean bl = torch != null && (torch == EnumTorchType.NONE ? !isGlowstone : !torch.isUpgrade() && isGlowstone) ? true : (doDraw = false);
            if (doDraw) {
                double height = info.face.m_122421_() == Direction.AxisDirection.NEGATIVE ? -0.01 : 16.01;
                this.renderBrazier(matrixStack, buffers.m_6299_((RenderType)RenderType.f_110371_), PlacementOverlay.getRenderVector(info.pos, projectedView), info.face, height, isGlowstone);
                if (isGlowstone) {
                    return;
                }
            }
        }
        if (!mainHand.m_41619_() && mainHand.m_41720_() instanceof ItemBlockPlatform) {
            TileEntityPlatformBase tile;
            ItemBlockPlatform itemBlockPlatform = (ItemBlockPlatform)mainHand.m_41720_();
            EnumPlatformType platformType = itemBlockPlatform.getPlatformType();
            BlockPos placePos = world.m_8055_(info.pos).m_60767_().m_76336_() ? info.pos : info.pos.m_142300_(info.face);
            BlockState renderState = null;
            IModelData modelData = null;
            if (platformType.isAddon() && hoveredPlatformType != null && !hoveredPlatformType.isAddon() && (tile = TileHelper.getPlatformTile((BlockGetter)world, info.pos)) != null && BlockPlatformBase.canPlaceRailOn(tile.m_58900_(), (LevelReader)world, info.pos, tile) && tile.getRailType() == null && (tile instanceof TileEntityPlatformFlat || player.f_19853_.m_8055_(placePos.m_7494_()).m_60767_().m_76336_())) {
                placePos = tile instanceof TileEntityPlatformFlat ? info.pos : info.pos.m_7494_();
                BlockPlatformBase addon = (BlockPlatformBase)Values.blocksPlatform.get((Object)platformType);
                renderState = addon.m_49966_();
                renderState = (BlockState)renderState.m_61124_((Property)BlockPlatformBase.FACING, (Comparable)((Direction)tile.m_58900_().m_61143_((Property)BlockPlatformBase.FACING)));
                renderState = BlockPlatformBase.getStateWithPlatformSubType(renderState, EnumSubType.byName(((BlockPlatformBase)info.block).getPlatformSubType(info.state).getStyle()));
                modelData = this.getModelData(tile instanceof TileEntityPlatformRamp, tile instanceof TileEntityPlatformFloor);
            }
            if (renderState == null && world.m_8055_(placePos).m_60767_().m_76336_()) {
                renderState = itemBlockPlatform.m_40614_().m_5573_((BlockPlaceContext)new UseContext(player, mainHand, Function.rayTrace((Entity)player, (double)(player.m_150110_().f_35937_ ? 5.0 : 4.0), (float)partialTicks)));
                modelData = this.getModelData(false, false);
            }
            if (renderState != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                Vec3 renderPos = PlacementOverlay.getRenderVector(placePos, projectedView);
                matrixStack.m_85836_();
                matrixStack.m_85837_(renderPos.f_82479_, renderPos.f_82480_, renderPos.f_82481_);
                RENDERER.renderModel(matrixStack.m_85850_(), buffers.m_6299_(Sheets.m_110792_()), renderState, dispatcher.m_110910_(renderState), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, modelData);
                matrixStack.m_85849_();
                return;
            }
        }
        if (hoveredPlatformType != null) {
            Direction side;
            boolean rotate = hoveredPlatformType == EnumPlatformType.FRAME || !player.m_6047_();
            Direction direction = side = !hoveredPlatformType.isAddon() || info.face == Direction.DOWN ? info.face : Direction.UP;
            double height = side.m_122421_() == Direction.AxisDirection.NEGATIVE ? -0.01 : (side == Direction.UP && hoveredPlatformType == EnumPlatformType.FLAT ? 2.01 : 16.01);
            this.renderWrenchAction(matrixStack, buffers.m_6299_((RenderType)RenderType.f_110371_), PlacementOverlay.getRenderVector(info.pos, projectedView), side, height, rotate);
        }
    }

    private IModelData getModelData(boolean onRamp, boolean onFloor) {
        IModelData modelData;
        IModelData iModelData = onFloor ? ON_FLOOR : (modelData = onRamp ? ON_RAMP : DEFAULT);
        if (modelData == null) {
            CompoundTag nbtTag = new CompoundTag();
            nbtTag.m_128379_("linkedToRamp", onRamp);
            nbtTag.m_128379_("linkedToFloor", onFloor);
            modelData = new ModelDataMap.Builder().withInitial(ModelProperties.NBTProperty, (Object)nbtTag).build();
            if (onFloor) {
                ON_FLOOR = modelData;
            } else if (onRamp) {
                ON_RAMP = modelData;
            } else {
                DEFAULT = modelData;
            }
        }
        return modelData;
    }

    private void renderBrazier(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, Direction side, double height, boolean isUpgrade) {
        if (isUpgrade) {
            double offset = side.m_122434_() == Direction.Axis.Y ? 1.5 : 0.0;
            this.addSidedLine(matrixStack, renderer, pos, 7.0, height, offset + 6.0, 8.0, height, offset + 5.0, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.0, height, offset + 6.0, 8.0, height, offset + 5.0, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.0, height, offset + 6.5, 8.0, height, offset + 5.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.0, height, offset + 6.5, 8.0, height, offset + 5.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.5, height, offset + 6.5, 8.5, height, offset + 6.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.5, height, offset + 7.0, 8.5, height, offset + 7.0, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.5, height, offset + 7.5, 8.5, height, offset + 7.5, side);
        } else {
            this.addBox(matrixStack, renderer, pos, 5.0, 9.0, 5.0, 11.0, 9.5, 11.0, false);
            this.addBox(matrixStack, renderer, pos, 7.5, 7.0, 5.0, 8.5, 9.0, 6.0, false);
            this.addBox(matrixStack, renderer, pos, 7.5, 7.0, 10.0, 8.5, 9.0, 11.0, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 7.0, 7.5, 6.0, 9.0, 8.5, false);
            this.addBox(matrixStack, renderer, pos, 10.0, 7.0, 7.5, 11.0, 9.0, 8.5, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 4.4, 5.0, 10.3, 4.6, 5.0, 8.9, 7.8, 5.0, 8.5, 7.7, 11.0, 9.8, 4.4, 11.0, 10.3, 4.6, 11.0, 8.9, 7.8, 11.0, 8.5, 7.7, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 4.4, 5.0, 10.3, 4.6, 5.0, 8.9, 7.8, 5.0, 8.5, 7.7, 11.0, 9.8, 4.4, 11.0, 10.3, 4.6, 11.0, 8.9, 7.8, 11.0, 8.5, 7.7, true);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 11.6, 5.0, 10.3, 11.4, 5.0, 8.9, 8.2, 5.0, 8.5, 8.3, 11.0, 9.8, 11.6, 11.0, 10.3, 11.4, 11.0, 8.9, 8.2, 11.0, 8.5, 8.3, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 11.6, 5.0, 10.3, 11.4, 5.0, 8.9, 8.2, 5.0, 8.5, 8.3, 11.0, 9.8, 11.6, 11.0, 10.3, 11.4, 11.0, 8.9, 8.2, 11.0, 8.5, 8.3, true);
        }
    }

    private void renderWrenchAction(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, Direction side, double height, boolean rotate) {
        if (!rotate || side.m_122434_() == Direction.Axis.Y) {
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 6.5, 3.5, height, 4.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 4.5, 4.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 4.5, height, 3.5, 6.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 5.5, height, 2.5, 6.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 3.5, 5.5, height, 4.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 9.5, 12.5, height, 11.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 11.5, 11.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 11.5, height, 12.5, 9.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 10.5, height, 11.5, 9.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 12.5, 10.5, height, 13.5, side);
        }
        if (rotate) {
            if (side.m_122434_() != Direction.Axis.Y) {
                this.addSidedLine(matrixStack, renderer, pos, 4.0, height, 8.0, 4.0, height, 7.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 5.0, height, 7.0, 4.0, height, 7.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 4.0, height, 7.0, 5.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 5.0, height, 8.0, 7.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 9.7, height, 7.3, 9.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 9.7, height, 8.7, 9.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 9.0, height, 8.0, 11.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 11.0, height, 8.0, 12.0, height, 7.0, side);
            } else {
                this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 3.5, 11.5, height, 3.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 11.5, height, 3.5, 12.5, height, 4.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 4.5, 12.5, height, 6.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 11.5, height, 5.5, 12.5, height, 6.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 6.5, 13.5, height, 5.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 12.5, 4.5, height, 12.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 4.5, height, 12.5, 3.5, height, 11.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 11.5, 3.5, height, 9.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 2.5, height, 10.5, 3.5, height, 9.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 9.5, 4.5, height, 10.5, side);
            }
        } else {
            this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 3.5, 12.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 3.5, 12.5, height, 6.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 6.5, 9.5, height, 6.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 6.5, 9.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 9.5, 6.5, height, 9.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 9.5, 6.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 12.5, 3.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 12.5, 3.5, height, 9.5, side);
        }
    }

    private void addBox(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double x5, double y5, double z5, double x6, double y6, double z6, double x7, double y7, double z7, double x8, double y8, double z8, boolean rotate) {
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y2, z2, x3, y3, z3, rotate);
        this.addLine(matrixStack, renderer, pos, x3, y3, z3, x4, y4, z4, rotate);
        this.addLine(matrixStack, renderer, pos, x4, y4, z4, x1, y1, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x5, y5, z5, x6, y6, z6, rotate);
        this.addLine(matrixStack, renderer, pos, x6, y6, z6, x7, y7, z7, rotate);
        this.addLine(matrixStack, renderer, pos, x7, y7, z7, x8, y8, z8, rotate);
        this.addLine(matrixStack, renderer, pos, x8, y8, z8, x5, y5, z5, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x5, y5, z5, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y2, z2, x6, y6, z6, rotate);
        this.addLine(matrixStack, renderer, pos, x3, y3, z3, x7, y7, z7, rotate);
        this.addLine(matrixStack, renderer, pos, x4, y4, z4, x8, y8, z8, rotate);
    }

    private void addBox(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, double x1, double y1, double z1, double x2, double y2, double z2, boolean rotate) {
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y1, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z2, x2, y1, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x1, y1, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y1, z1, x2, y1, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y2, z1, x2, y2, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y2, z2, x2, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y2, z1, x1, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y2, z1, x2, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x1, y2, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z2, x1, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y1, z1, x2, y2, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y1, z2, x2, y2, z2, rotate);
    }

    private void addPlane(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, double pt1, double pt2, double pt3, double pt4, Direction.Axis axis, double com, boolean rotate) {
        switch (axis) {
            case X: {
                this.addLine(matrixStack, renderer, pos, com, pt1, pt2, com, pt3, pt2, rotate);
                this.addLine(matrixStack, renderer, pos, com, pt1, pt4, com, pt3, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, com, pt1, pt2, com, pt1, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, com, pt3, pt2, com, pt3, pt4, rotate);
                break;
            }
            case Y: {
                this.addLine(matrixStack, renderer, pos, pt1, com, pt2, pt3, com, pt2, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, com, pt4, pt3, com, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, com, pt2, pt1, com, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, pt3, com, pt2, pt3, com, pt4, rotate);
                break;
            }
            case Z: {
                this.addLine(matrixStack, renderer, pos, pt1, pt2, com, pt3, pt2, com, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, pt4, com, pt3, pt4, com, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, pt2, com, pt1, pt4, com, rotate);
                this.addLine(matrixStack, renderer, pos, pt3, pt2, com, pt3, pt4, com, rotate);
            }
        }
    }

    private void addSidedLine(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, double x1, double y1, double z1, double x2, double y2, double z2, Direction facing) {
        switch (facing) {
            case DOWN: {
                this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y2, z2, false);
                break;
            }
            case UP: {
                this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y2, z2, false);
                break;
            }
            case NORTH: {
                this.addLine(matrixStack, renderer, pos, 16.0 - x1, 16.0 - z1, y1, 16.0 - x2, 16.0 - z2, y2, false);
                break;
            }
            case SOUTH: {
                this.addLine(matrixStack, renderer, pos, x1, 16.0 - z1, y1, x2, 16.0 - z2, y2, false);
                break;
            }
            case WEST: {
                this.addLine(matrixStack, renderer, pos, y1, 16.0 - z1, x1, y2, 16.0 - z2, x2, false);
                break;
            }
            case EAST: {
                this.addLine(matrixStack, renderer, pos, y1, 16.0 - z1, 16.0 - x1, y2, 16.0 - z2, 16.0 - x2, false);
            }
        }
    }

    private void addLine(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, double x1, double y1, double z1, double x2, double y2, double z2, boolean rotate) {
        this.add(matrixStack, renderer, pos, x1, y1, z1, rotate);
        this.add(matrixStack, renderer, pos, x2, y2, z2, rotate);
    }

    private void add(PoseStack matrixStack, VertexConsumer renderer, Vec3 pos, double x, double y, double z, boolean rotate) {
        PoseStack.Pose matrix4f = matrixStack.m_85850_();
        y = y == 0.0 ? 0.01 : (y == 16.0 ? 15.99 : y);
        float posX = (float)((rotate ? z : x) * 0.0625);
        float posY = (float)(y * 0.0625);
        float posZ = (float)((rotate ? x : z) * 0.0625);
        renderer.m_85982_(matrix4f.m_85861_(), (float)pos.m_7096_() + posX, (float)pos.m_7098_() + posY, (float)pos.m_7094_() + posZ).m_85950_(1.0f, 0.0f, 0.0f, 0.5f).m_85977_(matrix4f.m_85864_(), posX, posY, posZ).m_5752_();
    }
}

