/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.Function;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TileEntityPlatformFrame
extends TileEntityPlatformBase {
    private EnumTorchType torch = EnumTorchType.NONE;

    public TileEntityPlatformFrame(BlockPos pos, BlockState state) {
        super(Values.tilePlatformFrame, pos, state);
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.m_128344_("torch", (byte)this.torch.ordinal());
    }

    @Override
    protected void processNBT(CompoundTag nbtTag) {
        super.processNBT(nbtTag);
        this.torch = EnumTorchType.byIndex(nbtTag.m_128445_("torch"));
    }

    protected void processNBT_SyncOnly(CompoundTag nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        Function.updateLighting((BlockEntity)this);
    }

    public EnumTorchType getTorch() {
        return this.torch;
    }

    public boolean setTorch(EnumTorchType torch) {
        if (torch != null && torch != EnumTorchType.NONE) {
            this.torch = torch;
            return true;
        }
        return false;
    }

    public void removeTorch() {
        switch (this.torch) {
            case GLOWSTONE: {
                this.torch = EnumTorchType.LIGHT;
                return;
            }
            case LAMP_OFF: {
                this.torch = EnumTorchType.REDSTONE_ON;
                return;
            }
            case LAMP_ON: {
                this.torch = EnumTorchType.REDSTONE_OFF;
                return;
            }
        }
        this.torch = EnumTorchType.NONE;
    }

    @Override
    public void addExtraDrops(List<ItemStack> drops) {
        super.addExtraDrops(drops);
        if (this.torch != null && this.torch != EnumTorchType.NONE) {
            drops.add(this.torch.getItemStack());
            if (this.torch.isUpgrade()) {
                drops.add(this.torch.getBaseItemStack());
            }
        }
    }
}

