/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.loader;

import com.google.common.io.Closeables;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import snownee.kiwi.loader.DevEnvAnnotatedTypeLoader;
import snownee.kiwi.loader.KiwiConfiguration;
import snownee.kiwi.loader.Platform;

public class AnnotatedTypeLoader
implements Supplier<KiwiConfiguration> {
    public final String modId;

    public AnnotatedTypeLoader(String modId) {
        this.modId = modId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KiwiConfiguration get() {
        Map properties = ModList.get().getModContainerById(this.modId).map(ModContainer::getModInfo).map(IModInfo::getModProperties).orElse(Collections.EMPTY_MAP);
        boolean useJson = properties.getOrDefault("kiwiJsonMap", Platform.isProduction());
        if (!useJson) {
            return new DevEnvAnnotatedTypeLoader(this.modId).get();
        }
        String name = "/%s.kiwi.json".formatted(this.modId);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (is == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(is);
        try {
            KiwiConfiguration kiwiConfiguration = (KiwiConfiguration)new Gson().fromJson((Reader)isr, KiwiConfiguration.class);
            return kiwiConfiguration;
        }
        finally {
            Closeables.closeQuietly((Reader)isr);
        }
    }
}

