/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.util.Optional;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CMUnbindSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.m_82127_((String)"unbind").requires(cs -> cs.m_6761_(ServerConfig.rebindLevel()));
        subRoot.then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(CMUnbindSubcommand::doUnbind));
        return subRoot;
    }

    private static int doUnbind(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactDim == null) {
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.LEVEL_NOT_FOUND));
        }
        BlockPos rebindingMachine = BlockPosArgument.m_118242_(ctx, (String)"pos");
        BlockEntity blockEntity = level.m_7702_(rebindingMachine);
        if (!(blockEntity instanceof CompactMachineBlockEntity)) {
            CompactMachines.LOGGER.error("Refusing to rebind block at {}; block has invalid machine data.", (Object)rebindingMachine);
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.NOT_A_MACHINE_BLOCK));
        }
        CompactMachineBlockEntity machine = (CompactMachineBlockEntity)blockEntity;
        machine.getConnectedRoom().ifPresentOrElse(currentRoom -> {
            TunnelConnectionGraph currentRoomTunnels = TunnelConnectionGraph.forRoom(compactDim, currentRoom);
            Optional<BlockPos> firstTunnel = currentRoomTunnels.getConnections(machine.getLevelPosition()).findFirst();
            firstTunnel.ifPresent(ft -> {
                throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.NO_REBIND_TUNNEL_PRESENT, ft));
            });
            machine.disconnect();
        }, () -> {
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.MACHINE_NOT_BOUND, rebindingMachine.m_123344_()));
        });
        return 0;
    }
}

