/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.EnumMachinePlayersBreakHandling;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.location.PreciseDimensionalPosition;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.machine.CompactMachineItem;
import dev.compactmods.machines.machine.graph.DimensionMachineGraph;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.room.history.PlayerRoomHistoryItem;
import dev.compactmods.machines.room.menu.MachineRoomMenu;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class CompactMachineBlock
extends Block
implements EntityBlock {
    private final RoomSize size;

    public CompactMachineBlock(RoomSize size, BlockBehaviour.Properties props) {
        super(props);
        this.size = size;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        CompactMachineBlockEntity tile = (CompactMachineBlockEntity)worldIn.m_7702_(pos);
        float normalHardness = super.m_5880_(state, player, worldIn, pos);
        if (tile == null) {
            return normalHardness;
        }
        boolean hasPlayers = tile.hasPlayersInside();
        if (hasPlayers) {
            EnumMachinePlayersBreakHandling hand = (EnumMachinePlayersBreakHandling)((Object)ServerConfig.MACHINE_PLAYER_BREAK_HANDLING.get());
            switch (hand) {
                case UNBREAKABLE: {
                    return 0.0f;
                }
                case OWNER: {
                    Optional<UUID> ownerUUID = tile.getOwnerUUID();
                    return ownerUUID.map(uuid -> Float.valueOf(player.m_142081_() == uuid ? normalHardness : 0.0f)).orElse(Float.valueOf(normalHardness)).floatValue();
                }
                case ANYONE: {
                    return normalHardness;
                }
            }
        }
        return normalHardness;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block changedBlock, BlockPos changedPos, boolean isMoving) {
        super.m_6861_(state, world, pos, changedBlock, changedPos, isMoving);
        if (world.f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockEntity blockEntity = serverWorld.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity machine = (CompactMachineBlockEntity)blockEntity;
            ServerLevel compactWorld = serverWorld.m_142572_().m_129880_(Registration.COMPACT_DIMENSION);
            if (compactWorld == null) {
                CompactMachines.LOGGER.warn("Warning: Compact Dimension was null! Cannot fetch internal state for machine neighbor change listener.");
            }
        }
    }

    public static Block getBySize(RoomSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case RoomSize.TINY -> (Block)Registration.MACHINE_BLOCK_TINY.get();
            case RoomSize.SMALL -> (Block)Registration.MACHINE_BLOCK_SMALL.get();
            case RoomSize.NORMAL -> (Block)Registration.MACHINE_BLOCK_NORMAL.get();
            case RoomSize.LARGE -> (Block)Registration.MACHINE_BLOCK_LARGE.get();
            case RoomSize.GIANT -> (Block)Registration.MACHINE_BLOCK_GIANT.get();
            case RoomSize.MAXIMUM -> (Block)Registration.MACHINE_BLOCK_MAXIMUM.get();
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        Block given = CompactMachineBlock.getBySize(this.size);
        ItemStack stack = new ItemStack((ItemLike)given, 1);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            tile.getConnectedRoom().ifPresent(room -> CompactMachineItem.setRoom(stack, room));
        }
        return stack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            if (worldIn instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)worldIn;
                if (!stack.m_41782_()) {
                    return;
                }
                CompoundTag nbt = stack.m_41783_();
                if (nbt == null) {
                    return;
                }
                CompactMachineItem.getRoom(stack).ifPresent(room -> {
                    DimensionMachineGraph g = DimensionMachineGraph.forDimension(sl);
                    g.connectMachineToRoom(pos, (ChunkPos)room);
                    tile.syncConnectedRoom();
                });
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        MinecraftServer server = level.m_142572_();
        ItemStack mainItem = player.m_21205_();
        if (mainItem.m_41619_() && (blockEntity = level.m_7702_(pos)) instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity machine = (CompactMachineBlockEntity)blockEntity;
            Block block = state.m_60734_();
            if (block instanceof CompactMachineBlock) {
                CompactMachineBlock cmBlock = (CompactMachineBlock)block;
                machine.getConnectedRoom().ifPresent(room -> {
                    RoomSize size = cmBlock.getSize();
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)MachineRoomMenu.makeProvider(server, room, machine.getLevelPosition()), buf -> {
                        buf.m_130064_(pos);
                        buf.m_130059_(LevelBlockPosition.CODEC, (Object)machine.getLevelPosition());
                        buf.m_178341_(room);
                    });
                });
            }
        }
        if (mainItem.m_41720_() == Registration.PERSONAL_SHRINKING_DEVICE.get() && (blockEntity = level.m_7702_(pos)) instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            tile.getConnectedRoom().ifPresentOrElse(room -> {
                try {
                    PlayerUtil.teleportPlayerIntoMachine(level, player, pos);
                }
                catch (MissingDimensionException e) {
                    e.printStackTrace();
                }
            }, () -> this.createAndEnterRoom(player, server, tile));
        }
        return InteractionResult.SUCCESS;
    }

    private void createAndEnterRoom(Player player, MinecraftServer server, CompactMachineBlockEntity tile) {
        try {
            ChunkPos newRoomPos = Rooms.createNew(server, this.size, player.m_142081_());
            tile.setConnectedRoom(newRoomPos);
            PlayerUtil.teleportPlayerIntoRoom(server, player, newRoomPos, true);
            player.getCapability(Capabilities.ROOM_HISTORY).ifPresent(hist -> {
                PreciseDimensionalPosition entry = PreciseDimensionalPosition.fromPlayer(player);
                hist.addHistory(new PlayerRoomHistoryItem(entry, tile.getLevelPosition()));
            });
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.error("Error occurred while generating new room and machine info for first player entry.", (Throwable)e);
        }
        catch (NonexistentRoomException e) {
            CompactMachines.LOGGER.error("Error occurred while generating new room and machine info for first player entry.", (Throwable)e);
        }
    }

    public RoomSize getSize() {
        return this.size;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CompactMachineBlockEntity(pos, state);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean a) {
        MinecraftServer server = level.m_142572_();
        if (level.f_46443_ || server == null) {
            super.m_6810_(oldState, level, pos, newState, a);
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MinecraftServer serv = sl.m_142572_();
            ServerLevel compactDim = serv.m_129880_(Registration.COMPACT_DIMENSION);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CompactMachineBlockEntity) {
                CompactMachineBlockEntity entity = (CompactMachineBlockEntity)blockEntity;
                entity.getConnectedRoom().ifPresent(room -> {
                    DimensionMachineGraph dimGraph = DimensionMachineGraph.forDimension(sl);
                    dimGraph.disconnect(pos);
                    if (compactDim == null) {
                        return;
                    }
                    TunnelConnectionGraph tunnels = TunnelConnectionGraph.forRoom(compactDim, room);
                    tunnels.unregister(pos);
                });
            }
        }
        super.m_6810_(oldState, level, pos, newState, a);
    }
}

