/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel.graph;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.codec.NbtListCollector;
import dev.compactmods.machines.api.location.IDimensionalBlockPosition;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.capability.CapabilityTunnel;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.graph.CMGraphRegistration;
import dev.compactmods.machines.graph.IGraphEdge;
import dev.compactmods.machines.graph.IGraphEdgeType;
import dev.compactmods.machines.graph.IGraphNode;
import dev.compactmods.machines.graph.IGraphNodeType;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.machine.graph.CompactMachineNode;
import dev.compactmods.machines.machine.graph.MachineRoomEdge;
import dev.compactmods.machines.tunnel.graph.TunnelMachineEdge;
import dev.compactmods.machines.tunnel.graph.TunnelMachineInfo;
import dev.compactmods.machines.tunnel.graph.TunnelNode;
import dev.compactmods.machines.tunnel.graph.TunnelTypeEdge;
import dev.compactmods.machines.tunnel.graph.TunnelTypeNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

public class TunnelConnectionGraph
extends SavedData
implements INBTSerializable<CompoundTag> {
    private final MutableValueGraph<IGraphNode, IGraphEdge> graph = ValueGraphBuilder.directed().build();
    private final Map<BlockPos, TunnelNode> tunnels = new HashMap<BlockPos, TunnelNode>();
    private final Map<IDimensionalBlockPosition, CompactMachineNode> machines = new HashMap<IDimensionalBlockPosition, CompactMachineNode>();
    private final Map<ResourceLocation, TunnelTypeNode> tunnelTypes = new HashMap<ResourceLocation, TunnelTypeNode>();

    private TunnelConnectionGraph() {
    }

    private TunnelConnectionGraph(CompoundTag nbt) {
        this();
        this.deserializeNBT(nbt);
    }

    public static TunnelConnectionGraph forRoom(ServerLevel compactDim, ChunkPos room) {
        String key = TunnelConnectionGraph.getDataFilename(room);
        return (TunnelConnectionGraph)compactDim.m_8895_().m_164861_(TunnelConnectionGraph::new, TunnelConnectionGraph::new, key);
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag gData = this.serializeNBT();
        tag.m_128365_("graph", (Tag)gData);
        return tag;
    }

    public static String getDataFilename(ChunkPos room) {
        return "tunnels_" + room.f_45578_ + "_" + room.f_45579_;
    }

    public Optional<IDimensionalBlockPosition> connectedMachine(BlockPos tunnel) {
        if (!this.tunnels.containsKey(tunnel)) {
            return Optional.empty();
        }
        TunnelNode tNode = this.tunnels.get(tunnel);
        return this.graph.successors((Object)tNode).stream().filter(CompactMachineNode.class::isInstance).map(CompactMachineNode.class::cast).findFirst().map(CompactMachineNode::dimpos);
    }

    public boolean registerTunnel(BlockPos tunnelPos, TunnelDefinition type, IDimensionalBlockPosition machine, Direction side) {
        CompactMachineNode machineNode = this.getOrCreateMachineNode(machine);
        TunnelNode tunnelNode = this.getOrCreateTunnelNode(tunnelPos);
        if (this.graph.hasEdgeConnecting((Object)tunnelNode, (Object)machineNode)) {
            CompactMachines.LOGGER.info("Tunnel already registered for machine {} at position {}.", (Object)machine, (Object)tunnelPos);
            return false;
        }
        TunnelTypeNode tunnelTypeNode = this.getOrCreateTunnelTypeNode(type);
        IGraphEdge newTM = (IGraphEdge)this.graph.putEdgeValue((Object)tunnelNode, (Object)machineNode, (Object)new TunnelMachineEdge(side));
        IGraphEdge newTT = (IGraphEdge)this.graph.putEdgeValue((Object)tunnelNode, (Object)tunnelTypeNode, (Object)new TunnelTypeEdge());
        this.m_77762_();
        return true;
    }

    private void createTunnelAndLink(TunnelNode newTunnel, Direction side, CompactMachineNode machNode, TunnelTypeNode typeNode) {
    }

    @Nonnull
    public TunnelNode getOrCreateTunnelNode(BlockPos tunnelPos) {
        if (this.tunnels.containsKey(tunnelPos)) {
            return this.tunnels.get(tunnelPos);
        }
        TunnelNode newTunnel = new TunnelNode(tunnelPos);
        this.tunnels.put(tunnelPos, newTunnel);
        this.graph.addNode((Object)newTunnel);
        this.m_77762_();
        return newTunnel;
    }

    public CompactMachineNode getOrCreateMachineNode(IDimensionalBlockPosition machine) {
        CompactMachineNode node;
        boolean machineRegistered = this.machines.containsKey(machine);
        if (!machineRegistered) {
            node = new CompactMachineNode(machine.dimensionKey(), machine.getBlockPosition());
            this.machines.put(machine, node);
            this.graph.addNode((Object)node);
            this.m_77762_();
        } else {
            node = this.machines.get(machine);
        }
        return node;
    }

    public TunnelTypeNode getOrCreateTunnelTypeNode(TunnelDefinition definition) {
        ResourceLocation id = definition.getRegistryName();
        if (this.tunnelTypes.containsKey(id)) {
            return this.tunnelTypes.get(id);
        }
        TunnelTypeNode newType = new TunnelTypeNode(id);
        this.tunnelTypes.put(id, newType);
        this.graph.addNode((Object)newType);
        this.m_77762_();
        return newType;
    }

    public int size() {
        return this.graph.nodes().size();
    }

    public Stream<TunnelNode> getTunnelNodesByType(TunnelDefinition type) {
        TunnelTypeNode defNode = this.tunnelTypes.get(type.getRegistryName());
        if (defNode == null) {
            return Stream.empty();
        }
        return this.graph.adjacentNodes((Object)defNode).stream().filter(TunnelNode.class::isInstance).map(TunnelNode.class::cast);
    }

    public Set<BlockPos> getTunnelsByType(TunnelDefinition type) {
        return this.getTunnelNodesByType(type).map(TunnelNode::position).map(BlockPos::m_7949_).collect(Collectors.toSet());
    }

    public Optional<Direction> getTunnelSide(TunnelNode node) {
        return this.graph.adjacentNodes((Object)node).stream().filter(CompactMachineNode.class::isInstance).map(mn -> this.graph.edgeValue((Object)node, mn)).filter(Optional::isPresent).map(Optional::get).map(TunnelMachineEdge.class::cast).map(TunnelMachineEdge::side).findFirst();
    }

    public Optional<Direction> getTunnelSide(BlockPos pos) {
        if (!this.tunnels.containsKey(pos)) {
            return Optional.empty();
        }
        TunnelNode node = this.tunnels.get(pos);
        return this.graph.adjacentNodes((Object)node).stream().filter(CompactMachineNode.class::isInstance).map(mn -> this.graph.edgeValue((Object)node, mn)).filter(Optional::isPresent).map(Optional::get).map(TunnelMachineEdge.class::cast).map(TunnelMachineEdge::side).findFirst();
    }

    public Optional<TunnelMachineInfo> getTunnelInfo(BlockPos tunnel) {
        if (!this.tunnels.containsKey(tunnel)) {
            return Optional.empty();
        }
        TunnelNode node = this.tunnels.get(tunnel);
        TunnelTypeNode typeNode = this.graph.successors((Object)node).stream().filter(TunnelTypeNode.class::isInstance).map(TunnelTypeNode.class::cast).findFirst().orElseThrow();
        IDimensionalBlockPosition mach = this.connectedMachine(tunnel).orElseThrow();
        Direction side = this.getTunnelSide(tunnel).orElseThrow();
        ResourceLocation type = typeNode.id();
        return Optional.of(new TunnelMachineInfo(tunnel, type, new LevelBlockPosition(mach), side));
    }

    public Stream<TunnelMachineInfo> tunnels() {
        return this.tunnels.keySet().stream().map(this::getTunnelInfo).filter(Optional::isPresent).map(Optional::get);
    }

    public Stream<IGraphNode> nodes() {
        return this.graph.nodes().stream();
    }

    public CompoundTag serializeNBT() {
        this.cleanupOrphans();
        CompoundTag tag = new CompoundTag();
        HashMap nodeIds = new HashMap();
        IForgeRegistry<IGraphNodeType> nodeReg = CMGraphRegistration.NODE_TYPE_REG.get();
        Codec nodeRegCodec = nodeReg.getCodec().dispatchStable(IGraphNode::getType, IGraphNodeType::codec);
        ListTag nodeList = this.nodes().map(node -> {
            CompoundTag nodeInfo = new CompoundTag();
            DataResult encoded = nodeRegCodec.encodeStart((DynamicOps)NbtOps.f_128958_, node);
            Tag nodeEncoded = (Tag)encoded.getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            UUID id = UUID.randomUUID();
            nodeInfo.m_128362_("id", id);
            nodeInfo.m_128365_("data", nodeEncoded);
            nodeIds.put(node, id);
            return nodeInfo;
        }).collect(NbtListCollector.toNbtList());
        tag.m_128365_("nodes", (Tag)nodeList);
        ListTag edges = new ListTag();
        for (EndpointPair edge : this.graph.edges()) {
            CompoundTag edgeInfo = new CompoundTag();
            IGraphEdge realEdge = (IGraphEdge)this.graph.edgeValue(edge).get();
            Codec<IGraphEdge> codec = realEdge.getEdgeType().codec();
            DataResult encoded = codec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)realEdge);
            Tag edgeEnc = (Tag)encoded.getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            edgeInfo.m_128362_("from", (UUID)nodeIds.get(edge.nodeU()));
            edgeInfo.m_128362_("to", (UUID)nodeIds.get(edge.nodeV()));
            edgeInfo.m_128365_("data", edgeEnc);
            edges.add((Object)edgeInfo);
        }
        tag.m_128365_("edges", (Tag)edges);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (!tag.m_128441_("graph")) {
            return;
        }
        CompoundTag g = tag.m_128469_("graph");
        IForgeRegistry<IGraphNodeType> nodeReg = CMGraphRegistration.NODE_TYPE_REG.get();
        Codec nodeRegCodec = nodeReg.getCodec().dispatchStable(IGraphNode::getType, IGraphNodeType::codec);
        Codec edgeRegCodec = CMGraphRegistration.EDGE_TYPE_REG.get().getCodec().dispatchStable(IGraphEdge::getEdgeType, IGraphEdgeType::codec);
        ListTag nodes = g.m_128437_("nodes", 10);
        HashMap<UUID, IGraphNode> nodeMap = new HashMap<UUID, IGraphNode>(nodes.size());
        if (tag.m_128425_("nodes", 9)) {
            for (Tag nodeNbt : nodes) {
                CompoundTag nt;
                if (!(nodeNbt instanceof CompoundTag) || !(nt = (CompoundTag)nodeNbt).m_128441_("data") || !nt.m_128403_("id")) continue;
                UUID nodeId = nt.m_128342_("id");
                CompoundTag nodeData = nt.m_128469_("data");
                IGraphNode result = (IGraphNode)nodeRegCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)nodeData).getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
                if (result == null) continue;
                try {
                    if (result instanceof CompactMachineNode) {
                        CompactMachineNode m = (CompactMachineNode)result;
                        nodeMap.putIfAbsent(nodeId, m);
                    }
                    if (result instanceof TunnelNode) {
                        TunnelNode t = (TunnelNode)result;
                        TunnelNode tn = this.getOrCreateTunnelNode(t.position());
                        nodeMap.putIfAbsent(nodeId, tn);
                    }
                    if (!(result instanceof TunnelTypeNode)) continue;
                    TunnelTypeNode tt = (TunnelTypeNode)result;
                    TunnelTypeNode ttn = this.getOrCreateTunnelTypeNode(Tunnels.getDefinition(tt.id()));
                    nodeMap.putIfAbsent(nodeId, ttn);
                }
                catch (RuntimeException tt) {}
            }
        }
        if (g.m_128425_("edges", 9)) {
            ListTag edgeTags = g.m_128437_("edges", 10);
            for (Tag edgeTag : edgeTags) {
                CompoundTag edge;
                if (!(edgeTag instanceof CompoundTag) || !(edge = (CompoundTag)edgeTag).m_128441_("data") || !edge.m_128403_("from") || !edge.m_128403_("to")) continue;
                IGraphNode nodeFrom = (IGraphNode)nodeMap.get(edge.m_128342_("from"));
                IGraphNode nodeTo = (IGraphNode)nodeMap.get(edge.m_128342_("to"));
                if (nodeFrom == null || nodeTo == null) continue;
                IGraphEdge edgeData = (IGraphEdge)edgeRegCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)edge.m_128469_("data")).getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
                this.graph.putEdgeValue((Object)nodeFrom, (Object)nodeTo, (Object)edgeData);
            }
        }
    }

    public boolean hasTunnel(BlockPos location) {
        return this.tunnels.containsKey(location);
    }

    public <T> Stream<BlockPos> getTunnelsSupporting(LevelBlockPosition machine, Direction side, Capability<T> capability) {
        CompactMachineNode node = this.machines.get(machine);
        if (node == null) {
            return Stream.empty();
        }
        return this.getTunnelsForSide(machine, side).filter(sided -> this.graph.successors(sided).stream().filter(TunnelTypeNode.class::isInstance).map(TunnelTypeNode.class::cast).anyMatch(ttn -> {
            TunnelDefinition def = Tunnels.getDefinition(ttn.id());
            if (!(def instanceof CapabilityTunnel)) {
                return false;
            }
            CapabilityTunnel tcp = (CapabilityTunnel)((Object)def);
            return tcp.getSupportedCapabilities().contains((Object)capability);
        })).map(TunnelNode::position);
    }

    public Stream<TunnelDefinition> getTypesForSide(LevelBlockPosition machine, Direction side) {
        CompactMachineNode node = this.machines.get(machine);
        if (node == null) {
            return Stream.empty();
        }
        return this.getTunnelsForSide(machine, side).flatMap(tn -> this.graph.successors(tn).stream()).filter(TunnelTypeNode.class::isInstance).map(TunnelTypeNode.class::cast).map(type -> Tunnels.getDefinition(type.id())).distinct();
    }

    public Stream<TunnelNode> getTunnelsForSide(IDimensionalBlockPosition machine, Direction side) {
        CompactMachineNode node = this.machines.get(machine);
        if (node == null) {
            return Stream.empty();
        }
        return this.graph.incidentEdges((Object)node).stream().filter(e -> this.graph.edgeValue(e).map(ed -> {
            TunnelMachineEdge tme;
            return ed instanceof TunnelMachineEdge && (tme = (TunnelMachineEdge)ed).side() == side;
        }).orElse(false)).map(EndpointPair::nodeU).filter(TunnelNode.class::isInstance).map(TunnelNode.class::cast);
    }

    public Stream<Direction> getTunnelSides(TunnelDefinition type) {
        if (!this.tunnelTypes.containsKey(type.getRegistryName())) {
            return Stream.empty();
        }
        return this.getTunnelNodesByType(type).map(this::getTunnelSide).filter(Optional::isPresent).map(Optional::get);
    }

    public void clear() {
        for (CompactMachineNode machine : this.machines.values()) {
            this.graph.removeNode((Object)machine);
        }
        this.machines.clear();
        for (TunnelTypeNode t : this.tunnelTypes.values()) {
            this.graph.removeNode((Object)t);
        }
        this.tunnelTypes.clear();
        for (TunnelNode tun : this.tunnels.values()) {
            this.graph.removeNode((Object)tun);
        }
        this.tunnels.clear();
    }

    public Stream<BlockPos> getMachineTunnels(IDimensionalBlockPosition machine, TunnelDefinition type) {
        return this.getTunnelNodesByType(type).map(TunnelNode::position).filter(position -> this.connectedMachine((BlockPos)position).map(machine::equals).orElse(false)).map(BlockPos::m_7949_);
    }

    public void unregister(BlockPos pos) {
        if (!this.hasTunnel(pos)) {
            return;
        }
        CompactMachines.LOGGER.debug("Unregistering tunnel at {}", (Object)pos);
        TunnelNode existing = this.tunnels.get(pos);
        this.graph.removeNode((Object)existing);
        this.tunnels.remove(pos);
        this.cleanupOrphanedTypes();
        this.cleanupOrphanedMachines();
        this.m_77762_();
    }

    private void cleanupOrphans() {
        this.cleanupOrphanedTunnels();
        this.cleanupOrphanedTypes();
        this.cleanupOrphanedMachines();
    }

    private void cleanupOrphanedTypes() {
        HashSet removedTypes = new HashSet();
        this.tunnelTypes.forEach((type, node) -> {
            if (this.graph.degree(node) == 0) {
                this.graph.removeNode(node);
                removedTypes.add(type);
            }
        });
        if (!removedTypes.isEmpty()) {
            CompactMachines.LOGGER.debug("Removed {} tunnel type nodes during cleanup.", (Object)removedTypes.size());
            removedTypes.forEach(this.tunnelTypes::remove);
            this.m_77762_();
        }
    }

    private void cleanupOrphanedTunnels() {
        HashSet removed = new HashSet();
        this.tunnels.forEach((pos, node) -> {
            if (this.graph.degree(node) == 0) {
                this.graph.removeNode(node);
                removed.add(pos);
            }
        });
        if (!removed.isEmpty()) {
            CompactMachines.LOGGER.debug("Removed {} tunnel nodes during cleanup.", (Object)removed.size());
            removed.forEach(this.tunnels::remove);
            this.m_77762_();
        }
    }

    private void cleanupOrphanedMachines() {
        HashSet removed = new HashSet();
        this.machines.forEach((machine, node) -> {
            if (this.graph.degree(node) == 0) {
                this.graph.removeNode(node);
                removed.add(machine);
            }
        });
        if (!removed.isEmpty()) {
            CompactMachines.LOGGER.debug("Removed {} machine nodes during cleanup.", (Object)removed.size());
            removed.forEach(this.machines::remove);
            this.m_77762_();
        }
    }

    public void rotateTunnel(BlockPos tunnel, Direction newSide) {
        if (!this.tunnels.containsKey(tunnel)) {
            return;
        }
        Optional<IDimensionalBlockPosition> connected = this.connectedMachine(tunnel);
        connected.ifPresent(machine -> {
            if (!this.machines.containsKey(machine)) {
                return;
            }
            TunnelNode t = this.tunnels.get(tunnel);
            CompactMachineNode m = this.machines.get(machine);
            this.graph.removeEdge((Object)t, (Object)m);
            this.graph.putEdgeValue((Object)t, (Object)m, (Object)new TunnelMachineEdge(newSide));
            this.m_77762_();
        });
    }

    public Stream<IDimensionalBlockPosition> getMachines() {
        return this.machines.keySet().stream();
    }

    public Stream<BlockPos> getConnections(IDimensionalBlockPosition machine) {
        if (!this.machines.containsKey(machine)) {
            return Stream.empty();
        }
        CompactMachineNode mNode = this.machines.get(machine);
        return this.graph.incidentEdges((Object)mNode).stream().filter(e -> this.graph.edgeValue(e).orElseThrow() instanceof MachineRoomEdge).map(edge -> {
            Object patt20672$temp = edge.nodeU();
            if (patt20672$temp instanceof TunnelNode) {
                TunnelNode cmn = (TunnelNode)patt20672$temp;
                return cmn;
            }
            Object patt20748$temp = edge.nodeV();
            if (patt20748$temp instanceof TunnelNode) {
                TunnelNode cmn2 = (TunnelNode)patt20748$temp;
                return cmn2;
            }
            return null;
        }).filter(Objects::nonNull).map(TunnelNode::position);
    }

    public boolean hasAnyConnectedTo(IDimensionalBlockPosition machine) {
        return this.getConnections(machine).findAny().isPresent();
    }

    public void rebind(BlockPos tunnel, IDimensionalBlockPosition newMachine, Direction side) {
        CompactMachines.LOGGER.debug("Rebinding tunnel at {} to machine {}", (Object)tunnel, (Object)newMachine);
        TunnelNode tunnelNode = this.getOrCreateTunnelNode(tunnel);
        CompactMachineNode newMachineNode = this.getOrCreateMachineNode(newMachine);
        this.graph.putEdgeValue((Object)tunnelNode, (Object)newMachineNode, (Object)new TunnelMachineEdge(side));
        this.m_77762_();
    }
}

