/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.blocks.modifierblock;

import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.network.GrappleModifierMessage;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityGrappleModifier
extends BlockEntity {
    public HashMap<GrappleCustomization.upgradeCategories, Boolean> unlockedCategories = new HashMap();
    public GrappleCustomization customization = new GrappleCustomization();

    public TileEntityGrappleModifier(BlockPos pos, BlockState state) {
        super(CommonSetup.grappleModifierTileEntityType, pos, state);
    }

    public void unlockCategory(GrappleCustomization.upgradeCategories category) {
        this.unlockedCategories.put(category, true);
        this.sendUpdates();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void setCustomizationClient(GrappleCustomization customization) {
        this.customization = customization;
        CommonSetup.network.sendToServer((Object)new GrappleModifierMessage(this.f_58858_, this.customization));
        this.sendUpdates();
    }

    public void setCustomizationServer(GrappleCustomization customization) {
        this.customization = customization;
        this.sendUpdates();
    }

    private void sendUpdates() {
        this.m_6596_();
    }

    public boolean isUnlocked(GrappleCustomization.upgradeCategories category) {
        return this.unlockedCategories.containsKey((Object)category) && this.unlockedCategories.get((Object)category) != false;
    }

    public void m_183515_(CompoundTag nbtTagCompound) {
        super.m_183515_(nbtTagCompound);
        CompoundTag unlockedNBT = nbtTagCompound.m_128469_("unlocked");
        for (GrappleCustomization.upgradeCategories category : GrappleCustomization.upgradeCategories.values()) {
            String num = String.valueOf(category.toInt());
            boolean unlocked = this.isUnlocked(category);
            unlockedNBT.m_128379_(num, unlocked);
        }
        nbtTagCompound.m_128365_("unlocked", (Tag)unlockedNBT);
        nbtTagCompound.m_128365_("customization", (Tag)this.customization.writeNBT());
    }

    public void m_142466_(CompoundTag parentNBTTagCompound) {
        super.m_142466_(parentNBTTagCompound);
        CompoundTag unlockedNBT = parentNBTTagCompound.m_128469_("unlocked");
        for (GrappleCustomization.upgradeCategories category : GrappleCustomization.upgradeCategories.values()) {
            String num = String.valueOf(category.toInt());
            boolean unlocked = unlockedNBT.m_128471_(num);
            this.unlockedCategories.put(category, unlocked);
        }
        CompoundTag custom = parentNBTTagCompound.m_128469_("customization");
        this.customization.loadNBT(custom);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_183515_(nbtTagCompound);
        int tileEntityType = 42;
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_183515_(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

