/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.AirfrictionController;
import com.yyon.grapplinghook.controllers.ForcefieldController;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.items.EnderStaffItem;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ClientControllerManager {
    public static ClientControllerManager instance;
    public static HashMap<Integer, GrappleController> controllers;
    public HashMap<Integer, Long> enderLaunchTimer = new HashMap();
    public double rocketFuel = 1.0;
    public double rocketIncreaseTick = 0.0;
    public double rocketDecreaseTick = 0.0;
    public int ticksWallRunning = 0;
    boolean prevJumpButton = false;
    int ticksSinceLastOnGround = 0;
    boolean alreadyUsedDoubleJump = false;
    public static HashMap<BlockPos, GrappleController> controllerPos;
    public static long prevRopeJumpTime;

    public ClientControllerManager() {
        instance = this;
    }

    public void onClientTick(Player player) {
        long timer;
        if (player.m_20096_() || controllers.containsKey(player.m_142049_()) && ClientControllerManager.controllers.get((Object)Integer.valueOf((int)player.m_142049_())).controllerId == GrapplemodUtils.GRAPPLEID) {
            this.ticksWallRunning = 0;
        }
        if (this.isWallRunning((Entity)player, Vec.motionVec((Entity)player))) {
            Object controller;
            if (!controllers.containsKey(player.m_142049_()) && ((GrappleController)(controller = this.createControl(GrapplemodUtils.AIRID, -1, player.m_142049_(), player.f_19853_, new Vec(0.0, 0.0, 0.0), null, null))).getWallDirection() == null) {
                ((GrappleController)controller).unattach();
            }
            if (controllers.containsKey(player.m_142049_())) {
                this.ticksSinceLastOnGround = 0;
                this.alreadyUsedDoubleJump = false;
            }
        }
        this.checkDoubleJump();
        this.checkSlide(player);
        this.rocketFuel += this.rocketIncreaseTick;
        try {
            for (GrappleController controller : controllers.values()) {
                controller.doClientTick();
            }
        }
        catch (ConcurrentModificationException e) {
            System.out.println("ConcurrentModificationException caught");
        }
        if (this.rocketFuel > 1.0) {
            this.rocketFuel = 1.0;
        }
        if (player.m_20096_() && this.enderLaunchTimer.containsKey(player.m_142049_()) && (timer = GrapplemodUtils.getTime(player.f_19853_) - this.enderLaunchTimer.get(player.m_142049_())) > 10L) {
            this.resetLauncherTime(player.m_142049_());
        }
    }

    public void checkSlide(Player player) {
        if (ClientSetup.key_slide.m_90857_() && !controllers.containsKey(player.m_142049_()) && this.isSliding((Entity)player, Vec.motionVec((Entity)player))) {
            this.createControl(GrapplemodUtils.AIRID, -1, player.m_142049_(), player.f_19853_, new Vec(0.0, 0.0, 0.0), null, null);
        }
    }

    public void launchPlayer(Player player) {
        long prevtime = this.enderLaunchTimer.containsKey(player.m_142049_()) ? this.enderLaunchTimer.get(player.m_142049_()) : 0L;
        long timer = GrapplemodUtils.getTime(player.f_19853_) - prevtime;
        if (timer > (long)GrappleConfig.getConf().enderstaff.ender_staff_recharge && (player.m_21120_(InteractionHand.MAIN_HAND) != null && (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof EnderStaffItem || player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GrapplehookItem) || player.m_21120_(InteractionHand.OFF_HAND) != null && (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof EnderStaffItem || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof GrapplehookItem))) {
            this.enderLaunchTimer.put(player.m_142049_(), GrapplemodUtils.getTime(player.f_19853_));
            Vec facing = Vec.lookVec((Entity)player);
            GrappleCustomization custom = null;
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GrapplehookItem) {
                custom = ((GrapplehookItem)player.m_21120_(InteractionHand.MAIN_HAND).m_41720_()).getCustomization(player.m_21120_(InteractionHand.MAIN_HAND));
            } else if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof GrapplehookItem) {
                custom = ((GrapplehookItem)player.m_21120_(InteractionHand.OFF_HAND).m_41720_()).getCustomization(player.m_21120_(InteractionHand.OFF_HAND));
            }
            if (!controllers.containsKey(player.m_142049_())) {
                player.m_6853_(false);
                this.createControl(GrapplemodUtils.AIRID, -1, player.m_142049_(), player.f_19853_, new Vec(0.0, 0.0, 0.0), null, custom);
            }
            facing.mult_ip(GrappleConfig.getConf().enderstaff.ender_staff_strength);
            ClientControllerManager.receiveEnderLaunch(player.m_142049_(), facing.x, facing.y, facing.z);
            ClientProxyInterface.proxy.playSound(new ResourceLocation("grapplemod", "enderstaff"), GrappleConfig.getClientConf().sounds.enderstaff_sound_volume * 0.5f);
        }
    }

    public void resetLauncherTime(int playerid) {
        if (this.enderLaunchTimer.containsKey(playerid)) {
            this.enderLaunchTimer.put(playerid, 0L);
        }
    }

    public void updateRocketRegen(double rocket_active_time, double rocket_refuel_ratio) {
        this.rocketDecreaseTick = 0.025 / rocket_active_time;
        this.rocketIncreaseTick = 0.025 / rocket_active_time / rocket_refuel_ratio;
    }

    public double getRocketFunctioning() {
        this.rocketFuel -= this.rocketIncreaseTick;
        this.rocketFuel -= this.rocketDecreaseTick;
        if (this.rocketFuel >= 0.0) {
            return 1.0;
        }
        this.rocketFuel = 0.0;
        return this.rocketIncreaseTick / this.rocketDecreaseTick / 2.0;
    }

    public boolean isWallRunning(Entity entity, Vec motion) {
        if (entity.f_19862_ && !entity.m_20096_() && !entity.m_6047_()) {
            if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6147_()) {
                return false;
            }
            for (ItemStack stack : entity.m_6168_()) {
                double current_speed;
                BlockHitResult raytraceresult;
                Map enchantments;
                if (stack == null || !(enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).containsKey((Object)CommonSetup.wallrunEnchantment)) continue;
                if ((Integer)enchantments.get((Object)CommonSetup.wallrunEnchantment) < 1 || ClientSetup.key_jumpanddetach.m_90857_() || Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() || (raytraceresult = GrapplemodUtils.rayTraceBlocks(entity.f_19853_, Vec.positionVec(entity), Vec.positionVec(entity).add(new Vec(0.0, -1.0, 0.0)))) != null || !((current_speed = Math.sqrt(Math.pow(motion.x, 2.0) + Math.pow(motion.z, 2.0))) >= GrappleConfig.getConf().enchantments.wallrun.wallrun_min_speed)) break;
                return true;
            }
        }
        return false;
    }

    public void checkDoubleJump() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20096_()) {
            this.ticksSinceLastOnGround = 0;
            this.alreadyUsedDoubleJump = false;
        } else {
            ++this.ticksSinceLastOnGround;
        }
        boolean isjumpbuttondown = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        if (!(!isjumpbuttondown || this.prevJumpButton || player.m_20069_() || player.m_20077_() || this.ticksSinceLastOnGround <= 3 || this.alreadyUsedDoubleJump || !this.wearingDoubleJumpEnchant((Entity)player) || controllers.containsKey(player.m_142049_()) && !(controllers.get(player.m_142049_()) instanceof AirfrictionController))) {
            GrappleController controller;
            if (!controllers.containsKey(player.m_142049_())) {
                this.createControl(GrapplemodUtils.AIRID, -1, player.m_142049_(), player.f_19853_, new Vec(0.0, 0.0, 0.0), null, null);
            }
            if ((controller = controllers.get(player.m_142049_())) instanceof AirfrictionController) {
                this.alreadyUsedDoubleJump = true;
                controller.doubleJump();
            }
            ClientProxyInterface.proxy.playDoubleJumpSound(controller.entity);
        }
        this.prevJumpButton = isjumpbuttondown;
    }

    public boolean wearingDoubleJumpEnchant(Entity entity) {
        if (entity instanceof Player && ((Player)entity).m_150110_().f_35935_) {
            return false;
        }
        for (ItemStack stack : entity.m_6168_()) {
            Map enchantments;
            if (stack == null || !(enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).containsKey((Object)CommonSetup.doubleJumpEnchantment) || (Integer)enchantments.get((Object)CommonSetup.doubleJumpEnchantment) < 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isWearingSlidingEnchant(Entity entity) {
        for (ItemStack stack : entity.m_6168_()) {
            Map enchantments;
            if (stack == null || !(enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).containsKey((Object)CommonSetup.slidingEnchantment) || (Integer)enchantments.get((Object)CommonSetup.slidingEnchantment) < 1) continue;
            return true;
        }
        return false;
    }

    public boolean isSliding(Entity entity, Vec motion) {
        if (entity.m_20069_() || entity.m_20077_()) {
            return false;
        }
        if (entity.m_20096_() && ClientSetup.key_slide.m_90857_() && ClientControllerManager.isWearingSlidingEnchant(entity)) {
            double speed;
            GrappleController controller;
            boolean was_sliding = false;
            int id = entity.m_142049_();
            if (controllers.containsKey(id) && (controller = controllers.get(id)) instanceof AirfrictionController) {
                AirfrictionController afc = (AirfrictionController)controller;
                if (afc.wasSliding) {
                    was_sliding = true;
                }
            }
            if ((speed = motion.removeAlong(new Vec(0.0, 1.0, 0.0)).length()) > GrappleConfig.getConf().enchantments.slide.sliding_end_min_speed && (was_sliding || speed > GrappleConfig.getConf().enchantments.slide.sliding_min_speed)) {
                return true;
            }
        }
        return false;
    }

    public GrappleController createControl(int controllerId, int grapplehookEntityId, int playerId, Level world, Vec pos, BlockPos blockPos, GrappleCustomization custom) {
        GrapplehookEntity grapplehookEntity = null;
        Entity grapplehookEntityUncast = world.m_6815_(grapplehookEntityId);
        if (grapplehookEntityUncast != null && grapplehookEntityUncast instanceof GrapplehookEntity) {
            grapplehookEntity = (GrapplehookEntity)grapplehookEntityUncast;
        }
        boolean multi = custom != null && custom.doublehook;
        GrappleController currentcontroller = controllers.get(playerId);
        if (!(currentcontroller == null || multi && currentcontroller.custom != null && currentcontroller.custom.doublehook)) {
            currentcontroller.unattach();
        }
        GrappleController control = null;
        if (controllerId == GrapplemodUtils.GRAPPLEID) {
            if (!multi) {
                control = new GrappleController(grapplehookEntityId, playerId, world, pos, controllerId, custom);
            } else {
                control = controllers.get(playerId);
                boolean created = false;
                if (control != null && control.getClass().equals(GrappleController.class)) {
                    GrappleController c = control;
                    if (control.custom.doublehook && grapplehookEntity != null && grapplehookEntity instanceof GrapplehookEntity) {
                        GrapplehookEntity multiHookEntity = grapplehookEntity;
                        created = true;
                        c.addHookEntity(multiHookEntity);
                        return control;
                    }
                }
                if (!created) {
                    control = new GrappleController(grapplehookEntityId, playerId, world, pos, controllerId, custom);
                }
            }
        } else if (controllerId == GrapplemodUtils.REPELID) {
            control = new ForcefieldController(grapplehookEntityId, playerId, world, pos, controllerId);
        } else if (controllerId == GrapplemodUtils.AIRID) {
            control = new AirfrictionController(grapplehookEntityId, playerId, world, pos, controllerId, custom);
        } else {
            return null;
        }
        if (control == null) {
            return null;
        }
        if (blockPos != null) {
            controllerPos.put(blockPos, control);
        }
        ClientControllerManager.registerController(playerId, control);
        Entity e = world.m_6815_(playerId);
        if (e != null && e instanceof LocalPlayer) {
            LocalPlayer p = (LocalPlayer)e;
            control.receivePlayerMovementMessage(p.f_108618_.f_108566_, p.f_108618_.f_108567_, p.f_108618_.f_108572_, p.f_108618_.f_108573_);
        }
        return control;
    }

    public static void registerController(int entityId, GrappleController controller) {
        if (controllers.containsKey(entityId)) {
            controllers.get(entityId).unattach();
        }
        controllers.put(entityId, controller);
    }

    public static GrappleController unregisterController(int entityId) {
        if (controllers.containsKey(entityId)) {
            GrappleController controller = controllers.get(entityId);
            controllers.remove(entityId);
            BlockPos pos = null;
            for (BlockPos blockpos : controllerPos.keySet()) {
                GrappleController otherController = controllerPos.get(blockpos);
                if (otherController != controller) continue;
                pos = blockpos;
            }
            if (pos != null) {
                controllerPos.remove(pos);
            }
            return controller;
        }
        return null;
    }

    public static void receiveGrappleDetach(int id) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveGrappleDetach();
        }
    }

    public static void receiveGrappleDetachHook(int id, int hookid) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveGrappleDetachHook(hookid);
        }
    }

    public static void receiveEnderLaunch(int id, double x, double y, double z) {
        GrappleController controller = controllers.get(id);
        if (controller != null) {
            controller.receiveEnderLaunch(x, y, z);
        } else {
            System.out.println("Couldn't find controller");
        }
    }

    public void startRocket(Player player, GrappleCustomization custom) {
        GrappleController controller;
        if (!custom.rocket) {
            return;
        }
        if (!controllers.containsKey(player.m_142049_())) {
            controller = this.createControl(GrapplemodUtils.AIRID, -1, player.m_142049_(), player.f_19853_, new Vec(0.0, 0.0, 0.0), null, custom);
        } else {
            controller = controllers.get(player.m_142049_());
            if (controller.custom == null || !controller.custom.rocket) {
                if (controller.custom == null) {
                    controller.custom = custom;
                }
                controller.custom.rocket = true;
                controller.custom.rocket_active_time = custom.rocket_active_time;
                controller.custom.rocket_force = custom.rocket_force;
                controller.custom.rocket_refuel_ratio = custom.rocket_refuel_ratio;
                this.updateRocketRegen(custom.rocket_active_time, custom.rocket_refuel_ratio);
            }
        }
        RocketSound sound = new RocketSound(controller, new SoundEvent(new ResourceLocation("grapplemod", "rocket")), SoundSource.PLAYERS);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    static {
        controllers = new HashMap();
        controllerPos = new HashMap();
        prevRopeJumpTime = 0L;
    }

    public static class RocketSound
    extends AbstractTickableSoundInstance {
        GrappleController controller;
        boolean stopping = false;
        public float changespeed;

        protected RocketSound(GrappleController controller, SoundEvent p_i46532_1_, SoundSource p_i46532_2_) {
            super(p_i46532_1_, p_i46532_2_);
            this.f_119578_ = true;
            this.controller = controller;
            controller.rocket_key = true;
            controller.rocket_on = 1.0;
            this.f_119573_ = this.changespeed = GrappleConfig.getClientConf().sounds.rocket_sound_volume * 0.5f * 0.2f;
            this.f_119579_ = 0;
            this.f_119580_ = SoundInstance.Attenuation.NONE;
            this.f_119582_ = false;
        }

        public void m_7788_() {
            float diff;
            if (!this.controller.rocket_key || !this.controller.attached) {
                this.stopping = true;
            }
            float targetvolume = (float)this.controller.rocket_on * GrappleConfig.getClientConf().sounds.rocket_sound_volume * 0.5f;
            if (this.stopping) {
                targetvolume = 0.0f;
            }
            this.f_119573_ = (diff = Math.abs(targetvolume - this.f_119573_)) > this.changespeed ? (this.f_119573_ += this.changespeed * (float)(this.f_119573_ > targetvolume ? -1 : 1)) : targetvolume;
            if (this.f_119573_ == 0.0f && this.stopping) {
                this.m_119609_();
            }
            this.f_119575_ = this.controller.entity.m_20185_();
            this.f_119576_ = this.controller.entity.m_20186_();
            this.f_119577_ = this.controller.entity.m_20189_();
        }
    }
}

