/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.mehvahdjukaar.selene.map.CustomMapDecoration;
import net.mehvahdjukaar.selene.map.client.DecorationRenderer;
import net.mehvahdjukaar.selene.map.type.IMapDecorationType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;

public class MapDecorationRenderHandler {
    private static final Map<IMapDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends CustomMapDecoration> void bindDecorationRenderer(IMapDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        if (RENDERERS.containsKey(type)) {
            throw new IllegalArgumentException("Duplicate map decoration renderer registration " + type.getId());
        }
        RENDERERS.put(type, renderer);
    }

    public static void bindSimpleRenderer(IMapDecorationType<?, ?> type) {
        ResourceLocation texture = new ResourceLocation(type.getId().m_135827_(), "textures/map/" + type.getId().m_135815_() + ".png");
        MapDecorationRenderHandler.bindDecorationRenderer(type, new DecorationRenderer(texture));
    }

    public static void unbindRenderer(IMapDecorationType<?, ?> type) {
        RENDERERS.remove(type);
    }

    @ApiStatus.Internal
    public static <E extends CustomMapDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return RENDERERS.get(decoration.getType());
    }

    @ApiStatus.Internal
    public static <T extends CustomMapDecoration> boolean render(T decoration, PoseStack matrixStack, MultiBufferSource buffer, MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        DecorationRenderer<T> renderer = MapDecorationRenderHandler.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }
}

