/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.access.Cullable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    private final OcclusionCullingInstance culling;
    private final Minecraft client = Minecraft.m_91087_();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<BlockEntityType<?>> blockEntityWhitelist;
    private final Set<EntityType<?>> entityWhistelist;
    public long lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;

    public CullTask(OcclusionCullingInstance culling, Set<BlockEntityType<?>> blockEntityWhitelist, Set<EntityType<?>> entityWhistelist) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0L;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.culling = culling;
        this.blockEntityWhitelist = blockEntityWhitelist;
        this.entityWhistelist = entityWhistelist;
    }

    @Override
    public void run() {
        while (this.client.m_91396_()) {
            try {
                Vec3 cameraMC;
                Thread.sleep(this.sleepDelay);
                if (!EntityCullingModBase.enabled || this.client.f_91073_ == null || this.client.f_91074_ == null || this.client.f_91074_.f_19797_ <= 10) continue;
                Vec3 vec3 = cameraMC = EntityCullingModBase.instance.config.debugMode ? this.client.f_91074_.m_20299_(this.client.m_91297_()) : this.client.f_91063_.m_109153_().m_90583_();
                if (!this.requestCull && cameraMC.f_82479_ == this.lastPos.x && cameraMC.f_82480_ == this.lastPos.y && cameraMC.f_82481_ == this.lastPos.z) continue;
                long start = System.currentTimeMillis();
                this.requestCull = false;
                this.lastPos.set(cameraMC.f_82479_, cameraMC.f_82480_, cameraMC.f_82481_);
                Vec3d camera = this.lastPos;
                this.culling.resetCache();
                boolean spectator = this.client.f_91074_.m_5833_();
                for (int x = -8; x <= 8; ++x) {
                    block8: for (int z = -8; z <= 8; ++z) {
                        LevelChunk chunk = this.client.f_91073_.m_6325_(this.client.f_91074_.m_146902_().f_45578_ + x, this.client.f_91074_.m_146902_().f_45579_ + z);
                        Iterator iterator = chunk.m_62954_().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Cullable cullable;
                            Map.Entry entry;
                            try {
                                entry = iterator.next();
                            }
                            catch (NullPointerException | ConcurrentModificationException ex) {
                                continue block8;
                            }
                            if (this.blockEntityWhitelist.contains(((BlockEntity)entry.getValue()).m_58903_()) || EntityCullingModBase.instance.isDynamicWhitelisted((BlockEntity)entry.getValue()) || (cullable = (Cullable)entry.getValue()).isForcedVisible()) continue;
                            if (spectator) {
                                cullable.setCulled(false);
                                continue;
                            }
                            BlockPos pos = (BlockPos)entry.getKey();
                            if (!CullTask.closerThan(pos, (Position)cameraMC, 64.0)) continue;
                            AABB boundingBox = EntityCullingModBase.instance.setupAABB((BlockEntity)entry.getValue(), pos);
                            if (boundingBox.m_82362_() > (double)this.hitboxLimit || boundingBox.m_82376_() > (double)this.hitboxLimit || boundingBox.m_82385_() > (double)this.hitboxLimit) {
                                cullable.setCulled(false);
                                continue;
                            }
                            this.aabbMin.set(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_);
                            this.aabbMax.set(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_);
                            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                            cullable.setCulled(!visible);
                        }
                    }
                }
                Entity entity = null;
                Iterator iterable = this.client.f_91073_.m_104735_().iterator();
                while (iterable.hasNext()) {
                    Cullable cullable;
                    try {
                        entity = (Entity)iterable.next();
                    }
                    catch (NullPointerException | ConcurrentModificationException ex) {
                        break;
                    }
                    if (entity == null || !(entity instanceof Cullable) || this.entityWhistelist.contains(entity.m_6095_()) || EntityCullingModBase.instance.isDynamicWhitelisted(entity) || (cullable = (Cullable)entity).isForcedVisible()) continue;
                    if (spectator || entity.m_142038_() || this.isSkippableArmorstand(entity)) {
                        cullable.setCulled(false);
                        continue;
                    }
                    if (!entity.m_20182_().m_82509_((Position)cameraMC, (double)EntityCullingModBase.instance.config.tracingDistance)) {
                        cullable.setCulled(false);
                        continue;
                    }
                    AABB boundingBox = entity.m_6921_();
                    if (boundingBox.m_82362_() > (double)this.hitboxLimit || boundingBox.m_82376_() > (double)this.hitboxLimit || boundingBox.m_82385_() > (double)this.hitboxLimit) {
                        cullable.setCulled(false);
                        continue;
                    }
                    this.aabbMin.set(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_);
                    this.aabbMax.set(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_);
                    boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                    cullable.setCulled(!visible);
                }
                this.lastTime = System.currentTimeMillis() - start;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private boolean isSkippableArmorstand(Entity entity) {
        if (!EntityCullingModBase.instance.config.skipMarkerArmorStands) {
            return false;
        }
        return entity instanceof ArmorStand && ((ArmorStand)entity).m_31677_();
    }

    private static boolean closerThan(BlockPos blockPos, Position position, double d) {
        return CullTask.distSqr(blockPos, position.m_7096_(), position.m_7098_(), position.m_7094_(), true) < d * d;
    }

    private static double distSqr(BlockPos blockPos, double d, double e, double f, boolean bl) {
        double g = bl ? 0.5 : 0.0;
        double h = (double)blockPos.m_123341_() + g - d;
        double i = (double)blockPos.m_123342_() + g - e;
        double j = (double)blockPos.m_123343_() + g - f;
        return h * h + i * i + j * j;
    }
}

