/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.util.UUID;

public abstract class SoundPacket<T extends SoundPacket>
implements Packet<T> {
    protected UUID sender;
    protected byte[] data;
    protected long sequenceNumber;

    public SoundPacket(UUID sender, byte[] data, long sequenceNumber) {
        this.sender = sender;
        this.data = data;
        this.sequenceNumber = sequenceNumber;
    }

    public SoundPacket(UUID sender, short[] data) {
        this.sender = sender;
        this.data = Utils.shortsToBytes(data);
        this.sequenceNumber = -1L;
    }

    public SoundPacket() {
    }

    public byte[] getData() {
        return this.data;
    }

    public UUID getSender() {
        return this.sender;
    }

    public boolean isFromClientAudioChannel() {
        return this.sequenceNumber < 0L;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

