/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.PortableRadarBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PortableRadarBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.DoubleOption searchRadiusOption = new Option.DoubleOption(() -> ((PortableRadarBlockEntity)this).m_58899_(), "searchRadius", 25.0, 5.0, 50.0, 1.0, true);
    private Option.IntOption searchDelayOption = new Option.IntOption(() -> ((PortableRadarBlockEntity)this).m_58899_(), "searchDelay", 4, 4, 10, 1, true);
    private Option.BooleanOption repeatMessageOption = new Option.BooleanOption("repeatMessage", true);
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true);
    private boolean shouldSendNewMessage = true;
    private String lastPlayerName = "";
    private int ticksUntilNextSearch = this.getSearchDelay();

    public PortableRadarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PORTABLE_RADAR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)this.enabledOption.get()).booleanValue() && this.ticksUntilNextSearch-- <= 0) {
            this.ticksUntilNextSearch = this.getSearchDelay();
            ServerPlayer owner = level.m_142572_().m_6846_().m_11255_(this.getOwner().getName());
            AABB area = new AABB(pos).m_82400_(this.getSearchRadius());
            List entities = level.m_6443_(Player.class, area, e -> {
                boolean isNotAllowed = true;
                if (this.isModuleEnabled(ModuleType.ALLOWLIST)) {
                    isNotAllowed = !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)e);
                }
                return !this.getOwner().isOwner((Player)e) && isNotAllowed && !e.m_5833_() && !EntityUtils.isInvisible((LivingEntity)e);
            });
            if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                PortableRadarBlock.togglePowerOutput(level, pos, !entities.isEmpty());
            }
            if (owner != null) {
                for (Player e2 : entities) {
                    if (!this.shouldSendMessage(e2)) continue;
                    MutableComponent attackedName = e2.m_7755_().m_6879_().m_130940_(ChatFormatting.ITALIC);
                    TranslatableComponent text = this.m_8077_() ? Utils.localize("messages.securitycraft:portableRadar.withName", attackedName, this.m_7770_().m_6879_().m_130940_(ChatFormatting.ITALIC)) : Utils.localize("messages.securitycraft:portableRadar.withoutName", attackedName, Utils.getFormattedCoordinates(pos));
                    PlayerUtils.sendMessageToPlayer((Player)owner, (MutableComponent)Utils.localize(((Block)SCContent.PORTABLE_RADAR.get()).m_7705_(), new Object[0]), (MutableComponent)text, ChatFormatting.BLUE);
                    this.setSentMessage();
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            PortableRadarBlock.togglePowerOutput(this.f_58857_, this.f_58858_, false);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("shouldSendNewMessage", this.shouldSendNewMessage);
        tag.m_128359_("lastPlayerName", this.lastPlayerName);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.shouldSendNewMessage = tag.m_128471_("shouldSendNewMessage");
        this.lastPlayerName = tag.m_128461_("lastPlayerName");
    }

    public boolean shouldSendMessage(Player player) {
        if (!player.m_7755_().getString().equals(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.m_7755_().getString();
            this.m_6596_();
        }
        boolean lastPlayerOwns = (Boolean)ConfigHandler.SERVER.enableTeamOwnership.get() != false ? PlayerUtils.areOnSameTeam(this.lastPlayerName, this.getOwner().getName()) : this.lastPlayerName.equals(this.getOwner().getName());
        return (this.shouldSendNewMessage || (Boolean)this.repeatMessageOption.get() != false) && !lastPlayerOwns;
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
        this.m_6596_();
    }

    public double getSearchRadius() {
        return (Double)this.searchRadiusOption.get();
    }

    public int getSearchDelay() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }
}

