/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilteredUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair commonSpec = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Common {
        public final DisallowedItems disallowedItems;
        public final BackpackConfig leatherBackpack;
        public final BackpackConfig ironBackpack;
        public final BackpackConfig goldBackpack;
        public final BackpackConfig diamondBackpack;
        public final BackpackConfig netheriteBackpack;
        public final FilteredUpgradeConfig compactingUpgrade;
        public final FilteredUpgradeConfig advancedCompactingUpgrade;
        public final FilteredUpgradeConfig depositUpgrade;
        public final FilteredUpgradeConfig advancedDepositUpgrade;
        public final FilteredUpgradeConfig feedingUpgrade;
        public final FilteredUpgradeConfig advancedFeedingUpgrade;
        public final FilteredUpgradeConfig filterUpgrade;
        public final FilteredUpgradeConfig advancedFilterUpgrade;
        public final MagnetUpgradeConfig magnetUpgrade;
        public final MagnetUpgradeConfig advancedMagnetUpgrade;
        public final FilteredUpgradeConfig pickupUpgrade;
        public final FilteredUpgradeConfig advancedPickupUpgrade;
        public final FilteredUpgradeConfig refillUpgrade;
        public final FilteredUpgradeConfig restockUpgrade;
        public final FilteredUpgradeConfig advancedRestockUpgrade;
        public final FilteredUpgradeConfig voidUpgrade;
        public final FilteredUpgradeConfig advancedVoidUpgrade;
        public final CookingUpgradeConfig smeltingUpgrade;
        public final CookingUpgradeConfig smokingUpgrade;
        public final CookingUpgradeConfig blastingUpgrade;
        public final AutoCookingUpgradeConfig autoSmeltingUpgrade;
        public final AutoCookingUpgradeConfig autoSmokingUpgrade;
        public final AutoCookingUpgradeConfig autoBlastingUpgrade;
        public final InceptionUpgradeConfig inceptionUpgrade;
        public final EntityBackpackAdditionsConfig entityBackpackAdditions;
        public final ForgeConfigSpec.BooleanValue chestLootEnabled;
        public final ForgeConfigSpec.BooleanValue itemFluidHandlerEnabled;
        public final ForgeConfigSpec.BooleanValue allowOpeningOtherPlayerBackpacks;
        public final FilteredUpgradeConfig toolSwapperUpgrade;
        public final TankUpgradeConfig tankUpgrade;
        public final BatteryUpgradeConfig batteryUpgrade;
        public final StackUpgradeConfig stackUpgrade;
        public final PumpUpgradeConfig pumpUpgrade;
        public final XpPumpUpgradeConfig xpPumpUpgrade;
        public final NerfsConfig nerfsConfig;

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.disallowedItems.setInitialized = false;
            this.stackUpgrade.clearNonStackableItems();
        }

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.disallowedItems = new DisallowedItems(builder);
            this.leatherBackpack = new BackpackConfig(builder, "Leather", 27, 1);
            this.ironBackpack = new BackpackConfig(builder, "Iron", 54, 2);
            this.goldBackpack = new BackpackConfig(builder, "Gold", 81, 3);
            this.diamondBackpack = new BackpackConfig(builder, "Diamond", 108, 5);
            this.netheriteBackpack = new BackpackConfig(builder, "Netherite", 120, 7);
            this.compactingUpgrade = new FilteredUpgradeConfig(builder, "Compacting Upgrade", "compactingUpgrade", 9, 3);
            this.advancedCompactingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Compacting Upgrade", "advancedCompactingUpgrade", 16, 4);
            this.depositUpgrade = new FilteredUpgradeConfig(builder, "Deposit Upgrade", "depositUpgrade", 9, 3);
            this.advancedDepositUpgrade = new FilteredUpgradeConfig(builder, "Advanced Deposit Upgrade", "advancedDepositUpgrade", 16, 4);
            this.feedingUpgrade = new FilteredUpgradeConfig(builder, "Feeding Upgrade", "feedingUpgrade", 9, 3);
            this.advancedFeedingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Feeding Upgrade", "advancedFeedingUpgrade", 16, 4);
            this.filterUpgrade = new FilteredUpgradeConfig(builder, "Filter Upgrade", "filterUpgrade", 9, 3);
            this.advancedFilterUpgrade = new FilteredUpgradeConfig(builder, "Advanced Filter Upgrade", "advancedFilterUpgrade", 16, 4);
            this.magnetUpgrade = new MagnetUpgradeConfig(builder, "Magnet Upgrade", "magnetUpgrade", 9, 3, 3);
            this.advancedMagnetUpgrade = new MagnetUpgradeConfig(builder, "Advanced Magnet Upgrade", "advancedMagnetUpgrade", 16, 4, 5);
            this.pickupUpgrade = new FilteredUpgradeConfig(builder, "Pickup Upgrade", "pickupUpgrade", 9, 3);
            this.advancedPickupUpgrade = new FilteredUpgradeConfig(builder, "Advanced Pickup Upgrade", "advancedPickupUpgrade", 16, 4);
            this.refillUpgrade = new FilteredUpgradeConfig(builder, "Refill Upgrade", "refillUpgrade", 6, 3);
            this.restockUpgrade = new FilteredUpgradeConfig(builder, "Restock Upgrade", "restockUpgrade", 9, 3);
            this.advancedRestockUpgrade = new FilteredUpgradeConfig(builder, "Advanced Restock Upgrade", "advancedRestockUpgrade", 16, 4);
            this.voidUpgrade = new FilteredUpgradeConfig(builder, "Void Upgrade", "voidUpgrade", 9, 3);
            this.advancedVoidUpgrade = new FilteredUpgradeConfig(builder, "Advanced Void Upgrade", "advancedVoidUpgrade", 16, 4);
            this.stackUpgrade = new StackUpgradeConfig(builder);
            this.smeltingUpgrade = CookingUpgradeConfig.getInstance((ForgeConfigSpec.Builder)builder, (String)"Smelting Upgrade", (String)"smeltingUpgrade");
            this.smokingUpgrade = CookingUpgradeConfig.getInstance((ForgeConfigSpec.Builder)builder, (String)"Smoking Upgrade", (String)"smokingUpgrade");
            this.blastingUpgrade = CookingUpgradeConfig.getInstance((ForgeConfigSpec.Builder)builder, (String)"Blasting Upgrade", (String)"blastingUpgrade");
            this.autoSmeltingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smelting Upgrade", "autoSmeltingUpgrade");
            this.autoSmokingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smoking Upgrade", "autoSmokingUpgrade");
            this.autoBlastingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Blasting Upgrade", "autoBlastingUpgrade");
            this.inceptionUpgrade = new InceptionUpgradeConfig(builder);
            this.toolSwapperUpgrade = new FilteredUpgradeConfig(builder, "Tool Swapper Upgrade", "toolSwapperUpgrade", 8, 4);
            this.tankUpgrade = new TankUpgradeConfig(builder);
            this.batteryUpgrade = new BatteryUpgradeConfig(builder);
            this.pumpUpgrade = new PumpUpgradeConfig(builder);
            this.xpPumpUpgrade = new XpPumpUpgradeConfig(builder);
            this.entityBackpackAdditions = new EntityBackpackAdditionsConfig(builder);
            this.nerfsConfig = new NerfsConfig(builder);
            this.chestLootEnabled = builder.comment("Turns on/off loot added to various vanilla chest loot tables").define("chestLootEnabled", true);
            this.itemFluidHandlerEnabled = builder.comment("Turns on/off item fluid handler of backpack in its item form. There are some dupe bugs caused by default fluid handling implementation that manifest when backpack is drained / filled in its item form in another mod's tank and the only way to prevent them is disallowing drain/fill in item form altogether").define("itemFluidHandlerEnabled", true);
            this.allowOpeningOtherPlayerBackpacks = builder.comment("Determines whether player can right click on backpack that another player is wearing to open it. If off will turn off that capability for everyone and remove related settings from backpack.").define("allowOpeningOtherPlayerBackpacks", true);
            builder.pop();
        }

        public static class DisallowedItems {
            private final ForgeConfigSpec.ConfigValue<List<String>> disallowedItemsList;
            private boolean setInitialized = false;
            private Set<Item> disallowedItemsSet = null;

            DisallowedItems(ForgeConfigSpec.Builder builder) {
                this.disallowedItemsList = builder.comment("List of items that are not allowed to be put in backpacks - e.g. \"minecraft:shulker_box\"").define("disallowedItems", new ArrayList());
            }

            public boolean isItemDisallowed(Item item) {
                if (!COMMON_SPEC.isLoaded()) {
                    return true;
                }
                if (!this.setInitialized) {
                    this.loadDisallowedSet();
                }
                return this.disallowedItemsSet.contains(item);
            }

            private void loadDisallowedSet() {
                this.disallowedItemsSet = new HashSet<Item>();
                for (String disallowedItemName : (List)this.disallowedItemsList.get()) {
                    ResourceLocation registryName = new ResourceLocation(disallowedItemName);
                    if (!ForgeRegistries.ITEMS.containsKey(registryName)) continue;
                    this.disallowedItemsSet.add((Item)ForgeRegistries.ITEMS.getValue(registryName));
                }
            }
        }

        public static class BackpackConfig {
            public final ForgeConfigSpec.IntValue inventorySlotCount;
            public final ForgeConfigSpec.IntValue upgradeSlotCount;

            public BackpackConfig(ForgeConfigSpec.Builder builder, String backpackPrefix, int inventorySlotCountDefault, int upgradeSlotCountDefault) {
                builder.comment(backpackPrefix + " Backpack Settings").push(backpackPrefix.toLowerCase(Locale.ENGLISH) + "Backpack");
                this.inventorySlotCount = builder.comment("Number of inventory slots in the backpack").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 144);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the backpack").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }
        }

        public static class InceptionUpgradeConfig {
            public final ForgeConfigSpec.BooleanValue upgradesUseInventoriesOfBackpacksInBackpack;
            public final ForgeConfigSpec.BooleanValue upgradesInContainedBackpacksAreFunctional;

            public InceptionUpgradeConfig(ForgeConfigSpec.Builder builder) {
                builder.comment("Inception Upgrade Settings").push("inceptionUpgrade");
                this.upgradesUseInventoriesOfBackpacksInBackpack = builder.comment("Allows / Disallows backpack upgrades to work with inventories of Backpacks in the Backpack with Inception Upgrade").define("upgradesUseInventoriesOfBackpacksInBackpack", true);
                this.upgradesInContainedBackpacksAreFunctional = builder.comment("Allows / Disallows upgrades to be functional even when they are in Backpacks in the inventory of Backpack with Inception Upgrade").define("upgradesInContainedBackpacksAreFunctional", true);
                builder.pop();
            }
        }

        public static class EntityBackpackAdditionsConfig {
            private static final String REGISTRY_NAME_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)";
            private static final String ENTITY_LOOT_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)\\|(null|[a-z1-9_.-]+:[a-z1-9/_.-]+)";
            public final ForgeConfigSpec.DoubleValue chance;
            public final ForgeConfigSpec.BooleanValue addLoot;
            public final ForgeConfigSpec.BooleanValue buffWithPotionEffects;
            public final ForgeConfigSpec.BooleanValue buffHealth;
            public final ForgeConfigSpec.BooleanValue equipWithArmor;
            public final ForgeConfigSpec.BooleanValue playJukebox;
            public final ForgeConfigSpec.BooleanValue dropToFakePlayers;
            public final ForgeConfigSpec.DoubleValue backpackDropChance;
            public final ForgeConfigSpec.DoubleValue lootingChanceIncreasePerLevel;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityLootTableList;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> discBlockList;
            @Nullable
            private Map<EntityType<?>, ResourceLocation> entityLootTables = null;

            public EntityBackpackAdditionsConfig(ForgeConfigSpec.Builder builder) {
                builder.comment("Settings for Spawning Entities with Backpack").push("entityBackpackAdditions");
                this.chance = builder.comment("Chance of an entity spawning with Backpack").defineInRange("chance", 0.01, 0.0, 1.0);
                this.addLoot = builder.comment("Turns on/off addition of loot into backpacks").define("addLoot", true);
                this.buffWithPotionEffects = builder.comment("Turns on/off buffing the entity that wears backpack with potion effects. These are scaled based on how much loot is added.").define("buffWithPotionEffects", true);
                this.buffHealth = builder.comment("Turns on/off buffing the entity that wears backpack with additional health. Health is scaled based on backpack tier the mob wears.").define("buffHealth", true);
                this.equipWithArmor = builder.comment("Turns on/off equiping the entity that wears backpack with armor. What armor material and how enchanted is scaled based on backpack tier the mob wears.").define("equipWithArmor", true);
                this.entityLootTableList = builder.comment("Map of entities that can spawn with backpack and related loot tables (if adding a loot is enabled) in format of \"EntityRegistryName|LootTableName\"").defineList("entityLootTableList", this::getDefaultEntityLootTableList, mapping -> ((String)mapping).matches(ENTITY_LOOT_MATCHER));
                this.discBlockList = builder.comment("List of music discs that are not supposed to be played by entities").defineList("discBlockList", this::getDefaultDiscBlockList, mapping -> ((String)mapping).matches(REGISTRY_NAME_MATCHER));
                this.playJukebox = builder.comment("Turns on/off a chance that the entity that wears backpack gets jukebox upgrade and plays a music disc.").define("playJukebox", true);
                this.dropToFakePlayers = builder.comment("Determines whether backpack drops to fake players if killed by them in addition to real ones that it always drops to").define("dropToFakePlayers", false);
                this.backpackDropChance = builder.comment("Chance of mob dropping backpack when killed by player").defineInRange("backpackDropChance", 0.085, 0.0, 1.0);
                this.lootingChanceIncreasePerLevel = builder.comment("Chance increase per looting level of mob dropping backpack").defineInRange("lootingChanceIncreasePerLevel", 0.01, 0.0, 0.2);
                builder.pop();
            }

            public Optional<ResourceLocation> getLootTableName(EntityType<?> entityType) {
                if (this.entityLootTables == null) {
                    this.initEntityLootTables();
                }
                return Optional.ofNullable(this.entityLootTables.get(entityType));
            }

            public boolean canWearBackpack(EntityType<?> entityType) {
                if (this.entityLootTables == null) {
                    this.initEntityLootTables();
                }
                return this.entityLootTables.containsKey(entityType);
            }

            private void initEntityLootTables() {
                this.entityLootTables = new HashMap();
                for (String mapping : (List)this.entityLootTableList.get()) {
                    String[] entityLoot = mapping.split("\\|");
                    if (entityLoot.length < 2) continue;
                    String entityRegistryName = entityLoot[0];
                    String lootTableName = entityLoot[1];
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityRegistryName));
                    if (entityType == null) continue;
                    this.entityLootTables.put(entityType, lootTableName.equals("null") ? null : new ResourceLocation(lootTableName));
                }
            }

            private List<String> getDefaultDiscBlockList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("botania:record_gaia_1");
                ret.add("botania:record_gaia_2");
                return ret;
            }

            private List<String> getDefaultEntityLootTableList() {
                return this.getDefaultEntityLootMapping().entrySet().stream().map(e -> ((EntityType)e.getKey()).getRegistryName() + "|" + e.getValue()).collect(Collectors.toList());
            }

            private Map<EntityType<?>, ResourceLocation> getDefaultEntityLootMapping() {
                LinkedHashMap mapping = new LinkedHashMap();
                mapping.put(EntityType.f_20558_, BuiltInLootTables.f_78764_);
                mapping.put(EntityType.f_20562_, BuiltInLootTables.f_78695_);
                mapping.put(EntityType.f_20566_, BuiltInLootTables.f_78741_);
                mapping.put(EntityType.f_20568_, BuiltInLootTables.f_78689_);
                mapping.put(EntityType.f_20458_, BuiltInLootTables.f_78764_);
                mapping.put(EntityType.f_20511_, BuiltInLootTables.f_78699_);
                mapping.put(EntityType.f_20512_, BuiltInLootTables.f_78697_);
                mapping.put(EntityType.f_20513_, BuiltInLootTables.f_78696_);
                mapping.put(EntityType.f_20524_, BuiltInLootTables.f_78742_);
                mapping.put(EntityType.f_20481_, BuiltInLootTables.f_78688_);
                mapping.put(EntityType.f_20491_, BuiltInLootTables.f_78689_);
                mapping.put(EntityType.f_20493_, BuiltInLootTables.f_78689_);
                mapping.put(EntityType.f_20495_, BuiltInLootTables.f_78692_);
                mapping.put(EntityType.f_20497_, BuiltInLootTables.f_78760_);
                mapping.put(EntityType.f_20501_, BuiltInLootTables.f_78742_);
                mapping.put(EntityType.f_20530_, BuiltInLootTables.f_78745_);
                mapping.put(EntityType.f_20531_, BuiltInLootTables.f_78698_);
                return mapping;
            }
        }

        public static class NerfsConfig {
            public final ForgeConfigSpec.BooleanValue tooManyBackpacksSlowness;
            public final ForgeConfigSpec.IntValue maxNumberOfBackpacks;
            public final ForgeConfigSpec.DoubleValue slownessLevelsPerAdditionalBackpack;

            public NerfsConfig(ForgeConfigSpec.Builder builder) {
                builder.push("nerfs");
                this.tooManyBackpacksSlowness = builder.comment("Determines if too many backpacks in player's inventory cause slowness to the player").define("tooManyBackpacksSlowness", false);
                this.maxNumberOfBackpacks = builder.comment("Maximum number of backpacks in player's inventory that will not cause slowness").defineInRange("maxNumberOfBackpacks", 3, 1, 27);
                this.slownessLevelsPerAdditionalBackpack = builder.comment("Ratio of slowness levels per every backpack above the maximum number allowed. (number of backpacks above the max gets multiplied by this number and ceiled)").defineInRange("slownessLevelsPerAdditionalBackpack", 1.0, 0.1, 5.0);
                builder.pop();
            }
        }
    }
}

