/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import snownee.kiwi.loader.Platform;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.compat.sereneseasons.SereneSeasonsCompat;

public class ModUtil {
    public static boolean terraforged;
    public static boolean sereneseasons;

    public static void init() {
        sereneseasons = Platform.isModLoaded((String)"sereneseasons");
        if (sereneseasons) {
            SnowRealMagic.LOGGER.info("SereneSeasons detected. Overriding melting behavior.");
        }
    }

    public static boolean shouldMelt(Level world, BlockPos pos) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (world.m_45517_(LightLayer.BLOCK, pos) >= 10) {
            return true;
        }
        Holder biome = world.m_204166_(pos);
        if (sereneseasons && SereneSeasonsCompat.shouldMelt(world, pos, (Holder<Biome>)biome)) {
            return true;
        }
        return ModUtil.snowMeltsInWarmBiomes((Holder<Biome>)biome) && !((Biome)biome.m_203334_()).m_47519_((LevelReader)world, pos) && world.m_45527_(pos);
    }

    public static boolean snowMeltsInWarmBiomes(Holder<Biome> biome) {
        return SnowCommonConfig.snowMeltsInWarmBiomes;
    }

    public static boolean iceMeltsInWarmBiomes(Biome biome) {
        return sereneseasons;
    }

    public static boolean coldEnoughToSnow(Level level, BlockPos pos, Holder<Biome> biome) {
        if (sereneseasons) {
            return SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
        }
        return ((Biome)biome.m_203334_()).m_198904_(pos);
    }
}

