/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathcompass.world.item;

import com.mojang.serialization.DynamicOps;
import fuzs.deathcompass.capability.DeathTrackerCapability;
import fuzs.deathcompass.registry.ModRegistry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeathCompassItem
extends Item
implements Vanishable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();

    public DeathCompassItem(Item.Properties p_40718_) {
        super(p_40718_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41782_()) {
            Component component = this.getDistanceComponent(player, itemstack.m_41783_());
            player.m_5661_(component, true);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    private Component getDistanceComponent(Player source, CompoundTag tag) {
        Optional<ResourceKey<Level>> lastDeathDimension = DeathCompassItem.getLastDeathDimension(tag);
        if (lastDeathDimension.isPresent() && lastDeathDimension.get() != source.f_19853_.m_46472_()) {
            return new TranslatableComponent("death.message.distance.dimension");
        }
        BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LastDeathPos"));
        double distance = source.m_20182_().m_82554_(new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()));
        if (distance < 3.0) {
            return new TranslatableComponent("death.message.distance.close");
        }
        return new TranslatableComponent("death.message.distance.blocks", new Object[]{(int)distance});
    }

    public static Optional<ResourceKey<Level>> getLastDeathDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_("LastDeathDimension")).result();
    }

    public static Optional<ItemStack> createDeathCompass(Player player) {
        DeathTrackerCapability capability;
        LazyOptional optional = player.getCapability(ModRegistry.DEATH_TRACKER_CAPABILITY);
        if (optional.isPresent() && (capability = (DeathTrackerCapability)optional.orElseThrow(IllegalStateException::new)).hasLastDeathData()) {
            ItemStack itemstack = new ItemStack((ItemLike)ModRegistry.DEATH_COMPASS_ITEM.get(), 1);
            itemstack.m_41714_((Component)new TranslatableComponent("item.deathcompass.death_compass").m_7220_((Component)new TranslatableComponent("item.deathcompass.death_compass.player", new Object[]{player.m_5446_()})));
            CompoundTag compoundtag = itemstack.m_41782_() ? itemstack.m_41783_() : new CompoundTag();
            itemstack.m_41751_(compoundtag);
            DeathCompassItem.addLastDeathTags(capability.getLastDeathDimension(), capability.getLastDeathPosition(), capability.getLastDeathDate(), compoundtag);
            return Optional.of(itemstack);
        }
        return Optional.empty();
    }

    private static void addLastDeathTags(ResourceKey<Level> lastDeathDimension, BlockPos lastDeathPosition, long lastDeathDate, CompoundTag p_40735_) {
        p_40735_.m_128365_("LastDeathPos", (Tag)NbtUtils.m_129224_((BlockPos)lastDeathPosition));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, lastDeathDimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_40731_ -> p_40735_.m_128365_("LastDeathDimension", p_40731_));
        p_40735_.m_128356_("LastDeathDate", lastDeathDate);
    }

    public void m_7373_(ItemStack p_4itemStack457_, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (p_4itemStack457_.m_41782_()) {
            long lastDeathDate;
            CompoundTag tag = p_4itemStack457_.m_41783_();
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LastDeathPos"));
            tooltip.add((Component)new TranslatableComponent("item.deathcompass.death_compass.tooltip.position", new Object[]{new TextComponent(String.valueOf(blockpos.m_123341_())).m_130940_(ChatFormatting.GRAY), new TextComponent(String.valueOf(blockpos.m_123342_())).m_130940_(ChatFormatting.GRAY), new TextComponent(String.valueOf(blockpos.m_123343_())).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GOLD));
            Optional<ResourceKey<Level>> lastDeathDimension = DeathCompassItem.getLastDeathDimension(tag);
            if (lastDeathDimension.isPresent()) {
                tooltip.add((Component)new TranslatableComponent("item.deathcompass.death_compass.tooltip.dimension", new Object[]{new TextComponent(lastDeathDimension.get().m_135782_().toString()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GOLD));
            }
            if ((lastDeathDate = tag.m_128454_("LastDeathDate")) > 0L) {
                String date = DATE_FORMAT.format(new Date(lastDeathDate));
                tooltip.add((Component)new TranslatableComponent("item.deathcompass.death_compass.tooltip.date", new Object[]{new TextComponent(date).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GOLD));
            }
        }
    }
}

